/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.register;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.register.ExternalFormulaCatlog;
import kd.fi.bcm.business.formula.register.ExternalFormulaConfig;
import kd.fi.bcm.business.formula.register.ExternalFormulaServiceConfig;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.DataCollectLogEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.msservice.MsServiceHelper;

public class ExternalFormulaLoader {
    private static ExternalFormulaLoader loader;
    private static Object lock;
    private static WatchLogger log;

    private ExternalFormulaLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalFormulaLoader getInstance() {
        if (loader != null) {
            return loader;
        }
        Object object = lock;
        synchronized (object) {
            if (loader != null) {
                return loader;
            }
            loader = new ExternalFormulaLoader();
        }
        return loader;
    }

    public List<ExternalFormulaConfig> loadExternalFormulaConfig() {
        return (List)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)"externalFormulaConfig", () -> {
            log.startWatch();
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"bcm_formularegister", (String)"id,cloudid,appid,service,method,classpath", (QFilter[])QFilter.of((String)"isenable=?", (Object[])new Object[]{"1"}).toArray());
            Set<Long> formulaIds = colls.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
            Map<Object, DynamicObject> data = this.getFormulaBackUpData(formulaIds);
            ArrayList<ExternalFormulaConfig> configs = new ArrayList<ExternalFormulaConfig>();
            ArrayList<DynamicObject> updataBackUpData = new ArrayList<DynamicObject>(colls.size());
            for (DynamicObject dyna : colls) {
                ExternalFormulaConfig config;
                String cloudId = dyna.getString("cloudid");
                String appId = dyna.getString("appid");
                String serviceName = dyna.getString("service");
                String methodName = dyna.getString("method");
                String clazzPath = dyna.getString("classpath");
                Long formulaId = dyna.getLong("id");
                DynamicObject backupDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_formulabackup");
                backupDy.set("appid", (Object)appId);
                backupDy.set("id", (Object)formulaId);
                try {
                    String json = "";
                    json = StringUtils.isNotEmpty((String)clazzPath) ? (String)MsServiceHelper.invokeBizServiceByGivenClassPath((String)cloudId, (String)appId, (String)clazzPath, (String)serviceName, (String)methodName, (Object[])new Object[0]) : (String)MsServiceHelper.invokeService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[0]);
                    backupDy.set("backupdata", (Object)json);
                    updataBackUpData.add(backupDy);
                    config = this.getConfigFormJson(json, clazzPath);
                    if (config == null) continue;
                    configs.add(config);
                }
                catch (Exception e) {
                    try {
                        this.regiestErrorLog(appId);
                        log.error(String.format("loadExternalFormulaConfig failed,cloudId::%s, appId::%s, serviceName::%s, methodName::%s", cloudId, appId, serviceName, methodName), (Throwable)e);
                        if (data.get(formulaId) == null || (config = this.getConfigFormJson(data.get(formulaId).getString("backupdata"), clazzPath)) == null) continue;
                        configs.add(config);
                    }
                    catch (Exception ex) {
                        log.error(String.format("loadExternalFormulaConfig failed,cloudId::%s, appId::%s, serviceName::%s, methodName::%s", cloudId, appId, serviceName, methodName), (Throwable)e);
                    }
                }
            }
            this.updataFormulaBackUpData(updataBackUpData);
            log.info("loaded external formula config ");
            return configs;
        });
    }

    private Map<Object, DynamicObject> getFormulaBackUpData(Set<Long> formulaIds) {
        Map data = BusinessDataServiceHelper.loadFromCache((Object[])formulaIds.toArray(), (String)"bcm_formulabackup");
        return data;
    }

    private ExternalFormulaConfig getConfigFormJson(String json, String clazzPath) {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        Map jsonArr = (Map)JSON.parseObject((String)json, Map.class);
        Pair<List<ExternalFormulaCatlog>, ExternalFormulaServiceConfig> catlog = this.parseFormulaCatlogConfig((String)jsonArr.get("formula_catalog_list"));
        List<Map> formulas = this.parseFormulaConfig((String)jsonArr.get("formula_def_list"));
        ExternalFormulaConfig config = new ExternalFormulaConfig();
        config.setCatlogs((List)catlog.p1);
        config.setServiceConfig((ExternalFormulaServiceConfig)catlog.p2);
        ((ExternalFormulaServiceConfig)catlog.p2).setClazzPath(clazzPath);
        config.setFormulas(formulas);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updataFormulaBackUpData(List<DynamicObject> data) {
        block18: {
            if (data.isEmpty()) {
                return;
            }
            try (DLock lock = DLock.create((String)"loaded external formula config ");){
                try {
                    if (!lock.tryLock(5000L)) break block18;
                    try {
                        Set ids = data.stream().map(s -> s.get("id")).collect(Collectors.toSet());
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_formulabackup"), (Object[])ids.toArray());
                        SaveServiceHelper.save((DynamicObject[])data.toArray(new DynamicObject[0]));
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (Throwable e) {
                    log.error(String.format("loaded external formula config %s", e.getMessage()));
                }
            }
        }
    }

    private void regiestErrorLog(String appId) {
        DynamicObject error = BusinessDataServiceHelper.newDynamicObject((String)"bcm_datacollectlog");
        error.set("model", (Object)0L);
        error.set("collecttime", (Object)TimeServiceHelper.now());
        String errorMsg = String.format(ResManager.loadKDString((String)"%s \u5e94\u7528\u516c\u5f0f\u6ce8\u518c\u5931\u8d25\uff0c\u8bf7\u5728\u6267\u884c\u65e5\u5fd7\u5217\u8868\u9875\u9762\u91cd\u65b0\u6ce8\u518c\u3002", (String)"ExternalFormulaLoader_1", (String)"fi-bcm-business", (Object[])new Object[0]), appId);
        error.set("error", (Object)errorMsg);
        error.set("type", (Object)Character.valueOf(DataCollectLogEnum.ERROR.index));
        error.set("logtype", (Object)InvFormulaLogTypeEnum.ReoprtFormulaLog.getLogType());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{error});
    }

    public ExternalFormulaServiceConfig getFormulaServiceConfig(String formulaName) {
        List<ExternalFormulaConfig> configs = this.loadExternalFormulaConfig();
        for (ExternalFormulaConfig cfg : configs) {
            if (!cfg.containsFormula(formulaName)) continue;
            return cfg.getServiceConfig();
        }
        throw new RuntimeException(String.format("not found formula [%s] service", formulaName));
    }

    public Map getFormulaConfig(String formulaName) {
        List<ExternalFormulaConfig> configs = this.loadExternalFormulaConfig();
        for (ExternalFormulaConfig cfg : configs) {
            if (!cfg.containsFormula(formulaName)) continue;
            return cfg.getFormulaByName(formulaName);
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"%s \u516c\u5f0f\u4e0d\u5b58\u5728\uff0c\u5982\u4e3a\u4e8c\u5f00\u516c\u5f0f\uff0c\u8bf7\u5728\u6267\u884c\u65e5\u5fd7\u5217\u8868\u9875\u9762\u91cd\u65b0\u6ce8\u518c\u3002", (String)"ExternalFormulaLoader_2", (String)"fi-bcm-business", (Object[])new Object[0]), formulaName);
        throw new RuntimeException(errorMsg);
    }

    private Pair<List<ExternalFormulaCatlog>, ExternalFormulaServiceConfig> parseFormulaCatlogConfig(String json) {
        ExternalFormulaServiceConfig service = new ExternalFormulaServiceConfig();
        Map catlogMap = (Map)JSON.parseObject((String)json, Map.class);
        List items = (List)catlogMap.get("catalogs");
        ArrayList<ExternalFormulaCatlog> catlogs = new ArrayList<ExternalFormulaCatlog>(items.size());
        for (Object item : items) {
            Map map = (Map)item;
            catlogs.add(ExternalFormulaCatlog.of((String)map.get("name"), (String)map.get("number")));
        }
        Map serviceCfg = (Map)catlogMap.get("mservice");
        service.setCloudId((String)serviceCfg.get("cloudId"));
        service.setAppId((String)serviceCfg.get("appId"));
        service.setService((String)serviceCfg.get("service"));
        service.setMethod((String)serviceCfg.get("method"));
        service.setBatchMethod((String)serviceCfg.get("batchMethod"));
        return Pair.onePair(catlogs, (Object)service);
    }

    private List<Map> parseFormulaConfig(String json) {
        List formulas = JSON.parseArray((String)json, Map.class);
        return formulas;
    }

    static {
        lock = new Object();
        log = BcmLogFactory.getWatchLogInstance((boolean)false, ExternalFormulaLoader.class);
    }
}

