/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.register;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.util.MapInitHelper;

public class FormulaConfig {
    public static final String formula_catalog_path = "bcmformula/rpt_formulas_catalog_list.json";
    public static final String formula_list_path = "bcmformula/rpt_formulas_list.json";
    public static final String formula_rptinv_list_path = "bcmformula/rptinv_formulas_list.json";
    public static final String formula_inv_list_path = "bcmformula/inv_formulas_list.json";
    public static final String formula_comadjust_path = "bcmformula/comadjust_formulas_list.json";
    private static FormulaConfig instance = new FormulaConfig();
    private List<Map<String, String>> catalogList = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> formulaList = new ArrayList<Map<String, String>>();
    private Map<String, List<String>> formulaParamMap = new HashMap<String, List<String>>(16);
    private Set<String> internalFormulaSet = new HashSet<String>();

    public static FormulaConfig getInstance() {
        return instance;
    }

    private FormulaConfig() {
        this.readConfig();
    }

    public List<Map<String, String>> getCatalogList() {
        return this.catalogList;
    }

    public List<Map<String, String>> getFormulaList() {
        return this.formulaList;
    }

    public Map<String, List<String>> getFormulaParamMap() {
        return this.formulaParamMap;
    }

    public Set<String> getFormulaNumberSet() {
        HashSet<String> numbers = new HashSet<String>(16);
        for (Map<String, String> map : this.formulaList) {
            numbers.add(map.get("number").toLowerCase(Locale.ENGLISH));
        }
        return numbers;
    }

    private void readConfig() {
        this.readInnerConfig();
        this.readExternalConfig();
    }

    public void redoReadConfig() {
        this.formulaList.clear();
        this.catalogList.clear();
        this.readConfig();
    }

    private void readInnerConfig() {
        List<Map> formulaCatalogs = ResourcesLoaderUtil.getMapListFromResources(formula_catalog_path);
        for (Map formulaCatalog : formulaCatalogs) {
            String number = (String)formulaCatalog.get("number");
            String name = (String)formulaCatalog.get("name");
            this.catalogList.add(MapInitHelper.ofMap((Object)"number", (Object)number, (Object)"name", (Object)name));
        }
        List<Map> formulas = ResourcesLoaderUtil.getMapListFromResources(formula_list_path);
        this.readFormula(formulas, true);
        formulas = ResourcesLoaderUtil.getMapListFromResources(formula_inv_list_path);
        this.readFormula(formulas, true);
    }

    private void readExternalConfig() {
        ExternalFormulaLoader.getInstance().loadExternalFormulaConfig().forEach(cfg -> {
            cfg.getCatlogs().forEach(c -> this.catalogList.add(MapInitHelper.ofMap((Object)"number", (Object)c.getNumber(), (Object)"name", (Object)c.getName())));
            this.readFormula(cfg.getFormulas(), false);
        });
    }

    private void readFormula(List<Map> formulas, boolean isInternalFormula) {
        for (Map formula : formulas) {
            String number = (String)formula.get("number");
            String catalog = (String)formula.get("catalog");
            String name = (String)formula.get("name");
            String description = (String)formula.get("description");
            String isSupportedBatch = String.valueOf(formula.get("isSupportedBatch"));
            String isSupportFloat = String.valueOf(formula.get("floatParam") != null);
            this.formulaList.add(MapInitHelper.ofMap((Object)"number", (Object)number, (Object)"catalog", (Object)catalog, (Object)"name", (Object)name, (Object)"description", (Object)description, (Object)"isSupportedBatch", (Object)isSupportedBatch, (Object)"isSupportFloat", (Object)isSupportFloat));
            if (isInternalFormula) {
                this.internalFormulaSet.add(number.toUpperCase(Locale.ENGLISH));
            }
            if (!(formula.get("param") instanceof JSONArray)) continue;
            JSONArray params = (JSONArray)formula.get("param");
            List paramNumbers = params.stream().map(e -> ((JSONObject)e).get((Object)"number").toString()).collect(Collectors.toList());
            this.formulaParamMap.put(number.toLowerCase(), paramNumbers);
        }
    }

    public boolean isInternalFormula(String formulaName) {
        return this.internalFormulaSet.contains(formulaName.toUpperCase(Locale.ENGLISH));
    }
}

