/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.register;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.formula.calculate.CURRPERIODCalculate;
import kd.fi.bcm.business.formula.calculate.CURRYEARCalculate;
import kd.fi.bcm.business.formula.calculate.ExcRateCalculate;
import kd.fi.bcm.business.formula.calculate.GETRATECalculate;
import kd.fi.bcm.business.formula.calculate.GetDimAttrCalculate;
import kd.fi.bcm.business.formula.calculate.ICalculateHandle;
import kd.fi.bcm.business.formula.calculate.NewRptInfoCalculate;
import kd.fi.bcm.business.formula.calculate.PeriodCalculate;
import kd.fi.bcm.business.formula.calculate.RefCalculate;
import kd.fi.bcm.business.formula.calculate.VCalculate;
import kd.fi.bcm.business.formula.calculate.VDataCalculate;
import kd.fi.bcm.business.formula.calculate.VDataFormula;
import kd.fi.bcm.business.formula.calculate.VDmCalculate;
import kd.fi.bcm.business.formula.calculate.VSDataCalculate;
import kd.fi.bcm.business.formula.calculate.VSDataFormula;
import kd.fi.bcm.business.formula.calculate.XGetColSum;
import kd.fi.bcm.business.formula.calculate.XGetColSumCalculate;
import kd.fi.bcm.business.formula.calculate.XSumByAreaCalculate;
import kd.fi.bcm.business.formula.calculate.adjust.ADJCalculate;
import kd.fi.bcm.business.formula.calculate.adjust.GetJLEntryCalculate;
import kd.fi.bcm.business.formula.calculate.chk.LENCalculate;
import kd.fi.bcm.business.formula.calculate.chk.XCalculate;
import kd.fi.bcm.business.formula.calculate.cvt.CvtCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.ABSCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.ANDCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.AreaRefCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.CONCATCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.IFCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.IFERRORCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.LEFTCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.MAXCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.MIDCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.MINCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.MonthCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.NUMBERVALUECalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.ORCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.RIGHTCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.ROUNDCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.ReferenceCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.SumCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.SumIfCalculate;
import kd.fi.bcm.business.formula.calculate.excelformula.YearCalculate;
import kd.fi.bcm.business.formula.calculate.external.ExternalFormulaCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VDmExCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VDmvCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VDsCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VDsExCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VSDmExCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VSDmvCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VSDsCalculate;
import kd.fi.bcm.business.formula.calculate.fidm.VSDsExCalculate;
import kd.fi.bcm.business.formula.calculate.innertrade.DvbCalculate;
import kd.fi.bcm.business.formula.calculate.innertrade.LyvCalculate;
import kd.fi.bcm.business.formula.calculate.innertrade.MfCalculate;
import kd.fi.bcm.business.formula.calculate.innertrade.PnCalculate;
import kd.fi.bcm.business.formula.calculate.inv.BnCalculate;
import kd.fi.bcm.business.formula.calculate.inv.DEspCalculate;
import kd.fi.bcm.business.formula.calculate.inv.EspCalculate;
import kd.fi.bcm.business.formula.calculate.inv.GetInvActCalculate;
import kd.fi.bcm.business.formula.calculate.inv.GetInvPerCalculate;
import kd.fi.bcm.business.formula.calculate.inv.GevCalculate;
import kd.fi.bcm.business.formula.calculate.inv.InvCalculate;
import kd.fi.bcm.business.formula.calculate.inv.InvSpecExprCalculate;
import kd.fi.bcm.business.formula.calculate.inv.PCalculate;
import kd.fi.bcm.business.formula.model.ANDFormula;
import kd.fi.bcm.business.formula.model.CURRPERIODFormula;
import kd.fi.bcm.business.formula.model.CURRYEARFormula;
import kd.fi.bcm.business.formula.model.ExcRateFormula;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.GetDimAttrFormula;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.NewRptInfoFormula;
import kd.fi.bcm.business.formula.model.PeriodFormula;
import kd.fi.bcm.business.formula.model.RefFormula;
import kd.fi.bcm.business.formula.model.VDmFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.model.XSumByAreaFormula;
import kd.fi.bcm.business.formula.model.adjust.ADJFormula;
import kd.fi.bcm.business.formula.model.adjust.GetJLEntryFormula;
import kd.fi.bcm.business.formula.model.chk.LENFormula;
import kd.fi.bcm.business.formula.model.chk.XFormula;
import kd.fi.bcm.business.formula.model.cvt.CvtFormula;
import kd.fi.bcm.business.formula.model.excelformula.ABSFormula;
import kd.fi.bcm.business.formula.model.excelformula.AreaRefFormula;
import kd.fi.bcm.business.formula.model.excelformula.CONCATFormula;
import kd.fi.bcm.business.formula.model.excelformula.GETRATEFormula;
import kd.fi.bcm.business.formula.model.excelformula.IFERRORFormula;
import kd.fi.bcm.business.formula.model.excelformula.IFFormula;
import kd.fi.bcm.business.formula.model.excelformula.LEFTFormula;
import kd.fi.bcm.business.formula.model.excelformula.MAXFormula;
import kd.fi.bcm.business.formula.model.excelformula.MIDFormula;
import kd.fi.bcm.business.formula.model.excelformula.MINFormula;
import kd.fi.bcm.business.formula.model.excelformula.MonthFormula;
import kd.fi.bcm.business.formula.model.excelformula.NUMBERVALUEFormula;
import kd.fi.bcm.business.formula.model.excelformula.ORFormula;
import kd.fi.bcm.business.formula.model.excelformula.RIGHTFormula;
import kd.fi.bcm.business.formula.model.excelformula.ROUNDFormula;
import kd.fi.bcm.business.formula.model.excelformula.ReferenceFormula;
import kd.fi.bcm.business.formula.model.excelformula.SumFormula;
import kd.fi.bcm.business.formula.model.excelformula.SumIfFormula;
import kd.fi.bcm.business.formula.model.excelformula.YearFormula;
import kd.fi.bcm.business.formula.model.external.ExternalFormula;
import kd.fi.bcm.business.formula.model.fidm.VDmExFormula;
import kd.fi.bcm.business.formula.model.fidm.VDmvFormula;
import kd.fi.bcm.business.formula.model.fidm.VDsExFormula;
import kd.fi.bcm.business.formula.model.fidm.VDsFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDmExFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDmvFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDsExFormula;
import kd.fi.bcm.business.formula.model.fidm.VSDsFormula;
import kd.fi.bcm.business.formula.model.innertrade.DvbFormula;
import kd.fi.bcm.business.formula.model.innertrade.LyvFormula;
import kd.fi.bcm.business.formula.model.innertrade.MfFormula;
import kd.fi.bcm.business.formula.model.innertrade.PnFormula;
import kd.fi.bcm.business.formula.model.inv.BnFormula;
import kd.fi.bcm.business.formula.model.inv.DEspFormula;
import kd.fi.bcm.business.formula.model.inv.EspFormula;
import kd.fi.bcm.business.formula.model.inv.GetInvActFormula;
import kd.fi.bcm.business.formula.model.inv.GetInvPerFormula;
import kd.fi.bcm.business.formula.model.inv.GevFormula;
import kd.fi.bcm.business.formula.model.inv.InvFormula;
import kd.fi.bcm.business.formula.model.inv.Inv_SpecExprFormula;
import kd.fi.bcm.business.formula.model.inv.PFormula;
import kd.fi.bcm.business.formula.register.ExternalFormulaCatlog;
import kd.fi.bcm.business.formula.register.ExternalFormulaConfig;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;
import kd.fi.bcm.business.formula.util.FormulaUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.exception.NotificationException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class FormulaRegister {
    private final Map<String, Pair<Class<? extends ICalculateHandle<?>>, Class<? extends IFormula>>> registers = new ConcurrentHashMap();
    private final List<String> excelNotSupportFormulas = new Vector<String>();
    private static final Map<String, FormulaRegister> instances = new ConcurrentHashMap<String, FormulaRegister>();
    private static final ReentrantLock lock = new ReentrantLock();
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(FormulaRegister.class);
    private static List<String> preRegisterFormula = new ArrayList<String>(Arrays.asList("acct", "acctcf", "acctage"));

    private FormulaRegister() {
        this.excelNotSupportFormulas.addAll(preRegisterFormula);
        this.initRegister();
    }

    private void initRegister() {
        this.innerRegister("V", VCalculate.class, VFormula.class);
        this.innerRegister("EXCRATE", ExcRateCalculate.class, ExcRateFormula.class);
        this.innerRegister("ADJ", ADJCalculate.class, ADJFormula.class);
        this.innerRegister(FormulaEnum.Inv.name().toUpperCase(Locale.ENGLISH), InvCalculate.class, InvFormula.class);
        this.innerRegister(FormulaEnum.Esp.name().toUpperCase(Locale.ENGLISH), EspCalculate.class, EspFormula.class);
        this.innerRegister(FormulaEnum.Bn.name().toUpperCase(Locale.ENGLISH), BnCalculate.class, BnFormula.class);
        this.innerRegister(FormulaEnum.Desp.name().toUpperCase(Locale.ENGLISH), DEspCalculate.class, DEspFormula.class);
        this.innerRegister(FormulaEnum.Getinvper.name().toUpperCase(Locale.ENGLISH), GetInvPerCalculate.class, GetInvPerFormula.class);
        this.innerRegister(FormulaEnum.Getinvact.name().toUpperCase(Locale.ENGLISH), GetInvActCalculate.class, GetInvActFormula.class);
        this.innerRegister("CVT", CvtCalculate.class, CvtFormula.class);
        this.innerRegister("IF", IFCalculate.class, IFFormula.class);
        this.innerRegister("OR", ORCalculate.class, ORFormula.class);
        this.innerRegister("AND", ANDCalculate.class, ANDFormula.class);
        this.innerRegister("ABS", ABSCalculate.class, ABSFormula.class);
        this.innerRegister("ROUND", ROUNDCalculate.class, ROUNDFormula.class);
        this.innerRegister("REF", RefCalculate.class, RefFormula.class);
        this.innerRegister("CELLREF", ReferenceCalculate.class, ReferenceFormula.class);
        this.innerRegister("AreaRef", AreaRefCalculate.class, AreaRefFormula.class);
        this.innerRegister("SUM", SumCalculate.class, SumFormula.class);
        this.innerRegister("SUMIF", SumIfCalculate.class, SumIfFormula.class);
        this.innerRegister("MONTH", MonthCalculate.class, MonthFormula.class);
        this.innerRegister("YEAR", YearCalculate.class, YearFormula.class);
        this.innerRegister("NEWRPTINFO", NewRptInfoCalculate.class, NewRptInfoFormula.class);
        this.innerRegister("MID", MIDCalculate.class, MIDFormula.class);
        this.innerRegister("IFERROR", IFERRORCalculate.class, IFERRORFormula.class);
        this.innerRegister("CURRYEAR", CURRYEARCalculate.class, CURRYEARFormula.class);
        this.innerRegister("CURRPERIOD", CURRPERIODCalculate.class, CURRPERIODFormula.class);
        this.innerRegister("GETRATE", GETRATECalculate.class, GETRATEFormula.class);
        this.innerRegister("V_DM", VDmCalculate.class, VDmFormula.class);
        this.innerRegister("GET_DIM_ATTR", GetDimAttrCalculate.class, GetDimAttrFormula.class);
        this.innerRegister(FormulaEnum.P.name(), PCalculate.class, PFormula.class);
        this.innerRegister(FormulaEnum.Gev.name(), GevCalculate.class, GevFormula.class);
        this.innerRegister(FormulaEnum.Lyv.name(), LyvCalculate.class, LyvFormula.class);
        this.innerRegister(FormulaEnum.Dvb.name(), DvbCalculate.class, DvbFormula.class);
        this.innerRegister(FormulaEnum.Mf.name(), MfCalculate.class, MfFormula.class);
        this.innerRegister(FormulaEnum.Pn.name(), PnCalculate.class, PnFormula.class);
        this.innerRegister("V_DM_V", VDmvCalculate.class, VDmvFormula.class);
        this.innerRegister("VS_DM_V", VSDmvCalculate.class, VSDmvFormula.class);
        this.innerRegister("V_DM_EX", VDmExCalculate.class, VDmExFormula.class);
        this.innerRegister("VS_DM_EX", VSDmExCalculate.class, VSDmExFormula.class);
        this.innerRegister("VS_DS", VSDsCalculate.class, VSDsFormula.class);
        this.innerRegister("V_DS", VDsCalculate.class, VDsFormula.class);
        this.innerRegister("V_DS_EX", VDsExCalculate.class, VDsExFormula.class);
        this.innerRegister("VS_DS_EX", VSDsExCalculate.class, VSDsExFormula.class);
        this.innerRegister("V_DATA", VDataCalculate.class, VDataFormula.class);
        this.innerRegister("VS_DATA", VSDataCalculate.class, VSDataFormula.class);
        this.innerRegister("X", XCalculate.class, XFormula.class);
        this.innerRegister("GETJLENTRY", GetJLEntryCalculate.class, GetJLEntryFormula.class);
        this.innerRegister("NUMBERVALUE", NUMBERVALUECalculate.class, NUMBERVALUEFormula.class);
        this.innerRegister("PERIOD", PeriodCalculate.class, PeriodFormula.class);
        this.innerRegister("LEN", LENCalculate.class, LENFormula.class);
        this.innerRegister("XSUMBYAREA", XSumByAreaCalculate.class, XSumByAreaFormula.class);
        this.innerRegister("INV_SPECEXPR", InvSpecExprCalculate.class, Inv_SpecExprFormula.class);
        this.innerRegister("XGETCOLSUM", XGetColSumCalculate.class, XGetColSum.class);
        if (ConfigServiceHelper.getGlobalBoolParam("isTPEnableExcelFormula")) {
            this.registerNewExcelFormulas();
        }
        this.externalFormulaResister();
    }

    private void registerNewExcelFormulas() {
        this.innerRegister("MIN", MINCalculate.class, MINFormula.class);
        this.innerRegister("MAX", MAXCalculate.class, MAXFormula.class);
        this.innerRegister("LEFT", LEFTCalculate.class, LEFTFormula.class);
        this.innerRegister("RIGHT", RIGHTCalculate.class, RIGHTFormula.class);
        this.innerRegister("CONCAT", CONCATCalculate.class, CONCATFormula.class);
    }

    private void unRegisterNewExcelFormulas() {
        FormulaRegister.unRegister("MIN");
        FormulaRegister.unRegister("MAX");
        FormulaRegister.unRegister("LEFT");
        FormulaRegister.unRegister("RIGHT");
        FormulaRegister.unRegister("CONCAT");
    }

    public void externalFormulaResister() {
        ExternalFormulaLoader.getInstance().loadExternalFormulaConfig().forEach(cfg -> cfg.getAllFormulaNames().forEach(f -> this.innerRegister((String)f, (Class<? extends ICalculateHandle<?>>)ExternalFormulaCalculate.class, (Class<? extends IFormula>)ExternalFormula.class)));
        List<ExternalFormulaConfig> configs = ExternalFormulaLoader.getInstance().loadExternalFormulaConfig();
        this.genFormulamultilinguals(configs);
    }

    private void innerRegister(String formulaName, Class<? extends ICalculateHandle<?>> handleClazz, Class<? extends IFormula> modelClazz) {
        if (this.registers.containsKey(FormulaRegister.toLowerCase(formulaName))) {
            return;
        }
        this.registers.put(FormulaRegister.toLowerCase(formulaName), Pair.onePair(handleClazz, modelClazz));
        try {
            if (!modelClazz.newInstance().isExcelSupport() && !this.excelNotSupportFormulas.contains(FormulaRegister.toLowerCase(formulaName))) {
                this.excelNotSupportFormulas.add(FormulaRegister.toLowerCase(formulaName));
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDBizException(String.format("new instance class %s fail,cause:%s", modelClazz.getName(), e.getMessage()));
        }
    }

    private static FormulaRegister getInstance() {
        return instances.computeIfAbsent(CacheKeyUtil.getAcctId(), k -> new FormulaRegister());
    }

    public static void reExternalFormulaResister() {
        GlobalCacheServiceHelper.getCommonCache().invalidateByKeys(new String[]{"externalFormulaConfig", "getRptFormulaList", "getRptShowFxPlanelFormulaList"});
        FormulaRegister.getInstance().externalFormulaResister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genFormulamultilinguals(List<ExternalFormulaConfig> configs) {
        block20: {
            try (DLock lock = DLock.create((String)"bcm_formulamultilingual");){
                if (!lock.tryLock(3000L)) break block20;
                try {
                    HashMap<String, String> catalogMap = new HashMap<String, String>(16);
                    for (ExternalFormulaConfig config : configs) {
                        for (ExternalFormulaCatlog catlog : config.getCatlogs()) {
                            catalogMap.put(catlog.getNumber(), catlog.getName());
                        }
                    }
                    QFilter qf = new QFilter("paramnumber", "in", catalogMap.keySet());
                    DynamicObjectCollection catalogs = QueryServiceHelper.query((String)"bcm_formulamultilingual", (String)"paramnumber", (QFilter[])qf.toArray());
                    Set catalogNumbers = catalogs.stream().map(catalog -> catalog.getString("paramnumber")).collect(Collectors.toSet());
                    ArrayList formulamultilinguals = new ArrayList(16);
                    catalogMap.keySet().stream().filter(catalog -> !catalogNumbers.contains(catalog)).forEach(catalog -> {
                        String catalogName = (String)catalogMap.get(catalog);
                        formulamultilinguals.add(FormulaUtils.genFormulamuDy(catalog, catalogName));
                    });
                    HashMap formulaParamsMap = new HashMap(16);
                    configs.stream().filter(cfg -> cfg.getFormulas().size() > 0).forEach(cfg -> cfg.getFormulas().forEach(formula -> formulaParamsMap.put(((String)formula.get("number")).toLowerCase(Locale.ENGLISH), formula)));
                    QFilter qFilter = new QFilter("number", "in", formulaParamsMap.keySet());
                    DynamicObjectCollection formualNumDys = QueryServiceHelper.query((String)"bcm_formulamultilingual", (String)"number", (QFilter[])qFilter.toArray());
                    Set numbers = formualNumDys.stream().map(f -> f.getString("number")).collect(Collectors.toSet());
                    formulaParamsMap.keySet().stream().filter(fnumber -> !numbers.contains(fnumber)).forEach(f -> {
                        Map formula = (Map)formulaParamsMap.get(f);
                        formulamultilinguals.addAll(FormulaUtils.genFormulamultilinguals(formula));
                    });
                    if (formulamultilinguals.size() > 0) {
                        BusinessDataWriter.save((IDataEntityType)((DynamicObject)formulamultilinguals.get(0)).getDataEntityType(), (Object[])formulamultilinguals.toArray());
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public static void register(String formulaName, Class<? extends ICalculateHandle<?>> handleClazz, Class<? extends IFormula> modelClazz) {
        FormulaRegister.getInstance().innerRegister(formulaName, handleClazz, modelClazz);
    }

    public static void unRegister(String formulaName) {
        FormulaRegister.getInstance().registers.remove(FormulaRegister.toLowerCase(formulaName));
    }

    public static Class<? extends ICalculateHandle<?>> getCalculateClazz(String formulaName) {
        Pair<Class<? extends ICalculateHandle<?>>, Class<? extends IFormula>> classPair = FormulaRegister.getInstance().registers.get(FormulaRegister.toLowerCase(formulaName));
        if (classPair != null) {
            return (Class)classPair.p1;
        }
        FormulaRegister.check(formulaName);
        return (Class)FormulaRegister.getInstance().registers.get((Object)FormulaRegister.toLowerCase((String)formulaName)).p1;
    }

    public static Class<? extends IFormula> getFormulaModelClazz(String formulaName) {
        Pair<Class<? extends ICalculateHandle<?>>, Class<? extends IFormula>> classPair = FormulaRegister.getInstance().registers.get(FormulaRegister.toLowerCase(formulaName));
        if (classPair != null) {
            return (Class)classPair.p2;
        }
        FormulaRegister.check(formulaName);
        return (Class)FormulaRegister.getInstance().registers.get((Object)FormulaRegister.toLowerCase((String)formulaName)).p2;
    }

    private static void check(String formulaName) {
        if (!FormulaRegister.existFormula(formulaName)) {
            Object regiesterTag = GlobalCacheServiceHelper.getCommonCache().getIfPresent("regiesterTag");
            if (regiesterTag == null) {
                try {
                    lock.lock();
                    if (!FormulaRegister.existFormula(formulaName) && (regiesterTag = GlobalCacheServiceHelper.getCommonCache().getIfPresent("regiesterTag")) == null) {
                        GlobalCacheServiceHelper.getCommonCache().replaceCache("regiesterTag", (Object)true);
                        FormulaRegister.reExternalFormulaResister();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            if (!FormulaRegister.existFormula(formulaName)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"%s \u516c\u5f0f\u4e0d\u5b58\u5728\uff0c\u5982\u4e3a\u4e8c\u5f00\u516c\u5f0f\uff0c\u8bf7\u5728\u6267\u884c\u65e5\u5fd7\u5217\u8868\u9875\u9762\u91cd\u65b0\u6ce8\u518c\u3002", (String)"ExternalFormulaLoader_2", (String)"fi-bcm-business", (Object[])new Object[0]), formulaName);
                throw new NotificationException(errorMsg);
            }
        }
    }

    private static boolean existFormula(String formulaName) {
        return FormulaRegister.getInstance().registers.containsKey(FormulaRegister.toLowerCase(formulaName));
    }

    private static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static List<String> getRegistFormula() {
        return new ArrayList<String>(FormulaRegister.getInstance().registers.keySet());
    }

    public static List<String> getExcelNotSupportFormulas() {
        return FormulaRegister.getInstance().excelNotSupportFormulas;
    }

    public static void changeInnerRegisterFormulas(boolean isEnable) {
        if (isEnable) {
            FormulaRegister.getInstance().registerNewExcelFormulas();
        } else {
            FormulaRegister.getInstance().unRegisterNewExcelFormulas();
        }
    }
}

