/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.rptformula;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bcm.business.formula.rptformula.IFormula;
import kd.fi.bcm.business.formula.rptformula.RptDateFormula;
import kd.fi.bcm.business.formula.rptformula.RptInfoFormula;
import kd.fi.bcm.business.formula.rptformula.YearPeriodRPTFormula;

public class RptFormulaContext {
    private IFormula formula;
    private String express;
    private Long templateId;
    private String groupId;
    private DynamicObject period;
    private DynamicObject year;
    private DynamicObject report;

    public RptFormulaContext(String express, Long templateId, String groupId) {
        this.express = express;
        this.templateId = templateId;
        this.groupId = groupId;
        switch (express.substring(0, express.indexOf(40)).toLowerCase(Locale.ENGLISH)) {
            case "rptdate": {
                this.formula = new RptDateFormula();
                break;
            }
            case "rptinfo": {
                this.formula = new RptInfoFormula();
                break;
            }
        }
    }

    public RptFormulaContext(String express, DynamicObject year, DynamicObject period, DynamicObject report) {
        this.express = express;
        this.period = period;
        this.year = year;
        this.report = report;
        if ("rptdate".equals(express.substring(0, express.indexOf(40)).toLowerCase(Locale.ENGLISH))) {
            this.formula = new YearPeriodRPTFormula();
        }
    }

    public <T> T getResult() {
        if (this.formula instanceof YearPeriodRPTFormula) {
            return this.formula.getResult(this.express, this.year, this.period, this.report);
        }
        return this.formula.getResult(this.express, this.templateId, this.groupId);
    }
}

