/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;

public class FormulaUtils {
    public static final List<String> PARAMSLIST = Arrays.asList("catalog", "name", "description", "param");
    private static final String ZHCN = "zh_CN";

    public static List<DynamicObject> genFormulamultilinguals(Map<String, Object> formula) {
        ArrayList<DynamicObject> formulamultilinguals = new ArrayList<DynamicObject>(10);
        String formulaNumber = ((String)formula.get("number")).toLowerCase(Locale.ENGLISH);
        for (String number : PARAMSLIST) {
            if (number.equals("param")) {
                JSONArray paramArray = (JSONArray)formula.get(number);
                for (Object param : paramArray) {
                    formulamultilinguals.addAll(FormulaUtils.genFormulamuDys(formulaNumber, (JSONObject)param));
                }
                continue;
            }
            formulamultilinguals.add(FormulaUtils.genFormulamuDy(formulaNumber, number, (String)formula.get(number)));
        }
        return formulamultilinguals;
    }

    public static DynamicObject genFormulamuDy(String formulaNumber, String paramNumber, String value) {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_formulamultilingual");
        dy.set("number", (Object)formulaNumber);
        dy.set("name", (Object)new LocaleString(ZHCN, value));
        dy.set("paramnumber", (Object)String.join((CharSequence)".", formulaNumber, paramNumber));
        return dy;
    }

    public static DynamicObject genFormulamuDy(String paramNumber, String value) {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_formulamultilingual");
        dy.set("number", (Object)" ");
        dy.set("name", (Object)new LocaleString(ZHCN, value));
        dy.set("paramnumber", (Object)paramNumber);
        return dy;
    }

    public static List<DynamicObject> genFormulamuDys(String formulaNumber, JSONObject value) {
        ArrayList<DynamicObject> formulamultilinguals = new ArrayList<DynamicObject>(10);
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_formulamultilingual");
        dy.set("number", (Object)formulaNumber);
        String pnumber = value.getString("number");
        String pname = value.getString("name");
        dy.set("paramnumber", (Object)String.join((CharSequence)".", formulaNumber, String.join((CharSequence)".", pnumber, "name")));
        dy.set("name", (Object)new LocaleString(ZHCN, pname));
        formulamultilinguals.add(dy);
        JSONObject items = value.getJSONObject("items");
        if (items != null) {
            items.keySet().forEach(key -> formulamultilinguals.add(FormulaUtils.genFormulamuDy(formulaNumber, String.join((CharSequence)".", pnumber, "items", key), items.getString(key))));
        }
        return formulamultilinguals;
    }

    public static <T> T getModelData(ICalContext ctx, ParamList paramList, String modelNum) {
        String rowKey = FormulaUtils.getRowKey(paramList);
        return FormulaUtils.getModelData(ctx, rowKey, modelNum);
    }

    public static <T> T getModelData(ICalContext ctx, String rowKey, String modelNum) {
        Map rowData;
        Map intrData = (Map)ctx.getProperty("INTR_FORMULA_CONTEXT_DATA");
        if (intrData != null && (rowData = (Map)intrData.get(rowKey)) != null) {
            return (T)rowData.get(modelNum);
        }
        return null;
    }

    public static String getRowKey(ParamList paramList) {
        return ((ParamItem)paramList.get(paramList.size() - 1)).toString();
    }
}

