/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.formula.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.formula.VDataFormulaServiceHelper;
import kd.fi.bcm.business.formula.calculate.VDataFormula;
import kd.fi.bcm.business.formula.calculate.VSDataFormula;
import kd.fi.bcm.business.formula.enums.DataSourceTypeEnum;
import kd.fi.bcm.business.formula.enums.EPMDataTypeEnum;
import kd.fi.bcm.business.formula.enums.MetaDataTypeEnum;
import kd.fi.bcm.business.formula.enums.VDataTypeEnum;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.integration.model.IntegrateProperty;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.vo.ColumnInfoVo;
import kd.fi.bcm.business.vo.EPMDataDetailVo;
import kd.fi.bcm.business.vo.EPMDataVo;
import kd.fi.bcm.business.vo.EbDimVo;
import kd.fi.bcm.business.vo.VDataDimNodeVo;
import kd.fi.bcm.business.vo.VDataEBVo;
import kd.fi.bcm.business.vo.VDataFilterVo;
import kd.fi.bcm.business.vo.VDataFormulaVo;
import kd.fi.bcm.business.vo.VDataIntegrateVo;
import kd.fi.bcm.business.vo.VDataPropertyVo;
import kd.fi.bcm.business.vo.VDataRowVo;
import kd.fi.bcm.business.vo.VDataVoucherVo;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.util.AnalysisFormulaUtil;
import org.apache.commons.lang.StringUtils;

public class VDataFormulaUtils {
    public static final String FORM_BCM_SINGLEFORMULA = "bcm_singleformula";
    public static final String FORM_BCM_MULFORMULA = "bcm_multiformula";
    public static final String FORM_BCM_FORMULASELECT = "bcm_formulaselect";
    public static final String FORM_BCM_FORMULAPREVIEW = "bcm_formulapreview";
    public static final String SHOW_DIMS = "SHOW_DIMS";
    public static final String SHOW_DIM_NUM_MAP = "SHOW_DIM_NUM_MAP";
    public static final String FORMULA_CUR = "$Cur";
    public static final String FLOAT_INFO = "FLOAT_INFO";
    public static final String SOURCE = "source";
    public static final String ISEXT = "isext";
    public static final String NUMBER = "number";
    public static final String SHOW_NUMBER = "shownumber";
    public static final String ID = "id";
    public static final String ISC_TYPE = "metadatatype";
    public static final String F_MONEY = "FMoney";
    public static final String RETURN_VALUE = "returnvalue";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ENTRYENTITY_TYPE = "type";
    public static final String DIM = "dim";
    public static final String NAME = "name";
    public static final String INTEGRATE = "integrate";
    public static final String PROPERTY = "property";
    public static final String EXT = "ext";
    public static final String MULTI_F7 = "MultiF7_";
    public static final String SOURCEENTITY = "SourceEntity";
    public static final String SE = "SE";
    public static final String SCOPE = "scope";
    public static final String LEFT_BRACKET = "{";
    public static final String RIGHT_BRACKET = "}";
    public static final String MIN_LEFT_BRACKET = "(";
    public static final String MIN_RIGHT_BRACKET = ")";
    public static final String C_LEFT_BRACKET = "[";
    public static final String C_RIGHT_BRACKET = "]";
    public static final String ENTRYENTITY_DIM = "dim";
    public static final String ENTRYENTITY_CONDITION = "condition";
    protected static final String ENTRYENTITY_ISFLOAT = "isfloat";
    protected static final String ENTRYENTITY_MAPPING = "mapping";
    public static final String ENTRYENTITY_VALUE = "fieldvalue";
    public static final String V_DATA = "V_DATA";
    public static final String PREVIEW_FORMULA = "PREVIEW_FORMULA";
    public static final String FormulaMsService = "FormulaMsService";
    public static final String DEF_CONDITION = "radiogroupfield";
    public static final String ROOT = "Root";
    public static final String NONE = "None";
    public static final String ISAPPEAR = "isappear";
    public static final List<String> SYSTEM_KEYS = Arrays.asList("{", "}", "[", "]", ".", ",", "\"", "*");
    public static final List<String> OPERATOR_KEYS = Arrays.asList("<", ">", "=", "<>", ">=", "<=", "%");
    private static final Map<String, String> signs = new HashMap<String, String>(){
        {
            this.put("=", "=");
            this.put(">", ">");
            this.put("<", "<");
            this.put(">=", ">=");
            this.put("<=", "<=");
            this.put("<>", "!=");
            this.put("%", "like");
            this.put("", "in");
            this.put("in", "in");
        }
    };
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(VDataFormulaUtils.class);
    public static final String SHORTNUMBER = "shortnumber";
    public static final String PROP_ENTRYENTITY = "prop_entryentity";
    public static final String PROP_NAME = "prop_name";
    public static final String PROP_LABEL = "prop_label";
    public static final String DATA_TYPE = "data_type";
    public static final String DATA_SCHEMA = "data_schema";

    public static Map<String, Set<String>> getFloatDimensionScope(TemplateModel templateModel, int row, int col) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashMap map = new HashMap(16);
        Map numberMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)templateModel.getModelId()));
        numberMap.forEach((k, v) -> map.put(v, (String)k));
        if (templateModel != null && StringUtils.isNotEmpty((String)templateModel.getData())) {
            SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)templateModel.getData());
            BasePointInfo info = null;
            block0: for (PositionInfo positionInfo : spreadManager.getAreaManager().getPostionInfoSet()) {
                String spreadArea = positionInfo.getAreaRange();
                String position = ExcelUtils.xy2Pos((int)col, (int)row);
                if (!SpreadAreaUtil.isInArea((String)(position + ":" + position), (String)spreadArea)) continue;
                for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                    int maxcol;
                    boolean isDirectHoriz = basePointInfo.isDirectHoriz();
                    int minrow = isDirectHoriz ? ExcelUtils.pos2Y((String)positionInfo.getStartPosition()) : ExcelUtils.pos2Y((String)basePointInfo.getDynaRange().split(":")[0]);
                    int maxrow = isDirectHoriz ? ExcelUtils.pos2Y((String)positionInfo.getAreaRange().split(":")[1]) : ExcelUtils.pos2Y((String)basePointInfo.getDynaRange().split(":")[1]);
                    int mincol = isDirectHoriz ? ExcelUtils.pos2X((String)basePointInfo.getDynaRange().split(":")[0]) : ExcelUtils.pos2X((String)positionInfo.getStartPosition());
                    int n = maxcol = isDirectHoriz ? ExcelUtils.pos2X((String)basePointInfo.getDynaRange().split(":")[1]) : ExcelUtils.pos2X((String)positionInfo.getAreaRange().split(":")[1]);
                    if (mincol > col || minrow > row || maxcol < col || maxrow < row) continue;
                    info = basePointInfo;
                    break block0;
                }
            }
            if (info != null) {
                long modelId = templateModel.getModelId();
                for (BasePointInnerLineInfo in : info.getBasePointInnerLineInfo()) {
                    HashSet<String> numbers = new HashSet<String>(16);
                    if (!in.isFloated()) continue;
                    List scope = in.getDynaMembScopes();
                    if (scope.isEmpty()) {
                        AnalysisFormulaUtil.setDefaultScope(modelId, in, scope);
                    }
                    for (DynaMembScopeInfo scinfo : scope) {
                        String number = scinfo.getMember().getNumber();
                        if (!FORMULA_CUR.equals(number)) {
                            long memberId = scinfo.getMember().getId();
                            String uqCode = scinfo.getMember().getDimension().getUqCode();
                            new MembRangeItem(uqCode, (Long)memberId, number, scinfo.getRangeId(), scinfo.isCustom(), (Object)modelId).matchItems(c -> numbers.add(c.number));
                            continue;
                        }
                        numbers.add(number);
                    }
                    result.put(map.getOrDefault(in.getDimension().getNumber(), in.getDimension().getNumber()), numbers);
                }
            }
        }
        return result;
    }

    public static VDataFormulaVo parseFormulaFromView(IFormView formView, boolean singleFormula, Map<String, String> ctxMap) {
        String defaultCondition;
        List<VDataRowVo> conditionVos;
        VDataTypeEnum vDataTypeEnum;
        String modelNum;
        String type = (String)formView.getModel().getValue(SOURCE);
        DataSourceTypeEnum sourceTypeEnum = DataSourceTypeEnum.getByType(type);
        String extNum = null;
        boolean isAgg = false;
        ArrayList<String> returnFields = new ArrayList<String>(16);
        ArrayList<String> txtFields = new ArrayList<String>(16);
        DynamicObject[] fieldRows = ((EntryGrid)formView.getControl(ENTRYENTITY)).getEntryData().getDataEntitys();
        switch (Objects.requireNonNull(sourceTypeEnum)) {
            case MERGE_MODEL: {
                modelNum = ((DynamicObject)formView.getModel().getValue(sourceTypeEnum.getMark())).getString(SHOW_NUMBER);
                boolean isExt = (Boolean)formView.getModel().getValue(ISEXT);
                if (isExt) {
                    vDataTypeEnum = VDataTypeEnum.CM_ETX;
                    extNum = ((DynamicObject)formView.getModel().getValue("extmodel")).getString(NUMBER);
                    if (singleFormula) {
                        returnFields.add(formView.getModel().getValue(RETURN_VALUE).toString());
                    } else {
                        returnFields.addAll(formView.getModel().getEntryEntity(ENTRYENTITY).stream().filter(d -> d.getBoolean(ISAPPEAR) && d.getString(ENTRYENTITY_VALUE).endsWith(EXT)).map(d -> d.getString(ENTRYENTITY_VALUE).split("\\|")[0]).collect(Collectors.toList()));
                    }
                } else {
                    vDataTypeEnum = VDataTypeEnum.CM;
                    returnFields.add(F_MONEY);
                }
                conditionVos = VDataFormulaUtils.getVDataRowVos(formView, fieldRows, vDataTypeEnum, singleFormula, MemberReader.findModelNumberByShowNum((String)modelNum));
                break;
            }
            case RPT_MODEL: {
                modelNum = ((DynamicObject)formView.getModel().getValue(sourceTypeEnum.getMark())).getString(SHOW_NUMBER);
                vDataTypeEnum = VDataTypeEnum.RPT;
                returnFields.add(F_MONEY);
                conditionVos = VDataFormulaUtils.getVDataRowVos(formView, fieldRows, vDataTypeEnum, singleFormula, MemberReader.findModelNumberByShowNum((String)modelNum));
                break;
            }
            case EB_MODEL: {
                modelNum = ((DynamicObject)formView.getModel().getValue(sourceTypeEnum.getMark())).getString(SHOW_NUMBER);
                vDataTypeEnum = VDataTypeEnum.EB;
                returnFields.add(F_MONEY);
                extNum = ((DynamicObject)formView.getModel().getValue("ebmodelsel")).getString(NUMBER);
                conditionVos = VDataFormulaUtils.getVDataRowVos(formView, fieldRows, vDataTypeEnum, singleFormula, modelNum);
                break;
            }
            case ISC_METADATA: {
                String field;
                DynamicObject[] rows;
                vDataTypeEnum = VDataTypeEnum.ISC;
                extNum = ((DynamicObject)formView.getModel().getValue(sourceTypeEnum.getMark())).getString(NUMBER);
                modelNum = formView.getModel().getValue(ISC_TYPE) == null ? "" : formView.getModel().getValue(ISC_TYPE).toString();
                conditionVos = VDataFormulaUtils.getVDataRowVos(formView, fieldRows, vDataTypeEnum, singleFormula, null);
                if (singleFormula) {
                    returnFields.add(formView.getModel().getValue(RETURN_VALUE).toString());
                    break;
                }
                Set metricFields = new HashSet(16);
                String metricFieldStr = formView.getPageCache().getBigObject("metricField");
                if (StringUtils.isNotBlank((String)metricFieldStr)) {
                    metricFields = (Set)SerializationUtils.deSerializeFromBase64((String)metricFieldStr);
                }
                for (DynamicObject row : rows = ((EntryGrid)formView.getControl(ENTRYENTITY)).getEntryData().getDataEntitys()) {
                    field = row.getString(ENTRYENTITY_VALUE).split("\\|")[0];
                    if (!row.getBoolean(ISAPPEAR)) continue;
                    if (metricFields.contains(field)) {
                        returnFields.add(field);
                        continue;
                    }
                    txtFields.add(field);
                }
                break;
            }
            case EPM_DATAMANAGE: {
                String field;
                DynamicObject[] rows;
                vDataTypeEnum = VDataTypeEnum.EPM;
                extNum = formView.getModel().getValue(DataSourceTypeEnum.EPM_DATAMANAGE.getMark()).toString();
                modelNum = EPMDataTypeEnum.getByValue(formView.getModel().getValue("epmtype").toString()).getType();
                conditionVos = VDataFormulaUtils.getVDataRowVos(formView, fieldRows, vDataTypeEnum, singleFormula, null);
                if (singleFormula) {
                    returnFields.add(formView.getModel().getValue(RETURN_VALUE).toString());
                    break;
                }
                Set metricFields = new HashSet(16);
                String metricFieldStr = formView.getPageCache().getBigObject("metricField");
                if (StringUtils.isNotBlank((String)metricFieldStr)) {
                    metricFields = (Set)SerializationUtils.deSerializeFromBase64((String)metricFieldStr);
                }
                for (DynamicObject row : rows = ((EntryGrid)formView.getControl(ENTRYENTITY)).getEntryData().getDataEntitys()) {
                    field = row.getString(ENTRYENTITY_VALUE).split("\\|")[0];
                    if (!row.getBoolean(ISAPPEAR)) continue;
                    if (metricFields.contains(field)) {
                        returnFields.add(field);
                        continue;
                    }
                    txtFields.add(field);
                }
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u6765\u6e90\u9009\u9879\u662f\u5426\u6b63\u786e\u3002", (String)"VDataFormulaUtils_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        String string = formView.getControl(DEF_CONDITION) == null ? ROOT : (defaultCondition = "1".equals(formView.getModel().getValue(DEF_CONDITION).toString()) ? NONE : ROOT);
        if (!singleFormula) {
            isAgg = (Boolean)formView.getModel().getValue("is_sum");
        }
        if (ctxMap != null && !ctxMap.isEmpty()) {
            for (VDataRowVo conditionVo : conditionVos) {
                MultiF7Results f7Results;
                if (!(conditionVo instanceof VDataDimNodeVo) || (f7Results = ((VDataDimNodeVo)conditionVo).getMultiF7Results()) == null) continue;
                f7Results.getList().forEach(result -> {
                    if (ctxMap.containsKey(conditionVo.getDimNum())) {
                        result.setNumber((String)ctxMap.get(conditionVo.getDimNum()));
                    }
                });
            }
        }
        return new VDataFormulaVo(singleFormula, vDataTypeEnum, modelNum, extNum, defaultCondition, conditionVos, returnFields, txtFields, isAgg);
    }

    private static List<VDataRowVo> getVDataRowVos(IFormView formView, DynamicObject[] fieldRows, VDataTypeEnum vDataTypeEnum, boolean isSingleFormula, String cube) {
        ArrayList<VDataRowVo> vDataRowVos = new ArrayList<VDataRowVo>(fieldRows.length);
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (vDataTypeEnum == VDataTypeEnum.RPT || vDataTypeEnum == VDataTypeEnum.CM || vDataTypeEnum == VDataTypeEnum.CM_ETX) {
            MemberReader.getDimensionShortNumber2NumberMap((String)cube).forEach((k, v) -> map.put((String)v, (String)k));
            map.put(SOURCEENTITY, SE);
        } else if (vDataTypeEnum == VDataTypeEnum.EB) {
            List<EbDimVo> ebDimVos = VDataFormulaServiceHelper.getDim(cube, ((DynamicObject)formView.getModel().getValue("ebmodelsel")).getString(NUMBER));
            ebDimVos.forEach(ebDimVo -> map.put(ebDimVo.getNumber(), ebDimVo.getShortNumber()));
        }
        for (DynamicObject fieldRow : fieldRows) {
            VDataRowVo vDataRowVo;
            String nodeId = fieldRow.getString(ENTRYENTITY_VALUE);
            String dimNum = fieldRow.getString(ENTRYENTITY_VALUE).split("\\|")[0];
            if (vDataTypeEnum == VDataTypeEnum.ISC) {
                vDataRowVo = new VDataIntegrateVo();
                vDataRowVo.setNumber(dimNum);
                vDataRowVo.setCondition(fieldRow.getString(ENTRYENTITY_CONDITION));
            } else if (vDataTypeEnum == VDataTypeEnum.EPM) {
                vDataRowVo = new VDataVoucherVo();
                vDataRowVo.setNumber(dimNum);
                vDataRowVo.setCondition(fieldRow.getString(ENTRYENTITY_CONDITION));
            } else if (vDataTypeEnum == VDataTypeEnum.EB) {
                vDataRowVo = new VDataEBVo();
                vDataRowVo.setNumber(map.getOrDefault(dimNum, dimNum));
                vDataRowVo.setDimNum(dimNum);
                vDataRowVo.setCondition(fieldRow.getString(ENTRYENTITY_CONDITION));
                if (nodeId.endsWith("|name") || nodeId.endsWith("|number")) {
                    ((VDataEBVo)vDataRowVo).setProperty(nodeId.split("\\|")[1]);
                }
            } else if (nodeId.endsWith("|dim")) {
                vDataRowVo = new VDataDimNodeVo();
                vDataRowVo.setNumber(map.getOrDefault(dimNum, dimNum));
                vDataRowVo.setDimNum(dimNum);
                if (fieldRow.getBoolean(ENTRYENTITY_ISFLOAT)) {
                    vDataRowVo.setCondition("@" + fieldRow.getDynamicObject(ENTRYENTITY_MAPPING).getString(NUMBER));
                } else {
                    String cache = formView.getPageCache().get(MULTI_F7 + fieldRow.getString(ENTRYENTITY_VALUE));
                    vDataRowVo.setCondition(cache);
                    ((VDataDimNodeVo)vDataRowVo).setMultiF7Results(VDataFormulaUtils.transCacheToObj(cache));
                }
            } else if (nodeId.endsWith("|name") || nodeId.endsWith("|number") || nodeId.endsWith("|property")) {
                vDataRowVo = new VDataPropertyVo();
                vDataRowVo.setNumber(map.getOrDefault(dimNum, dimNum));
                vDataRowVo.setDimNum(dimNum);
                ((VDataPropertyVo)vDataRowVo).setProperty(fieldRow.getString(ENTRYENTITY_VALUE).split("\\|")[1]);
                vDataRowVo.setCondition(fieldRow.getString(ENTRYENTITY_CONDITION));
            } else {
                vDataRowVo = new VDataIntegrateVo();
                vDataRowVo.setNumber(dimNum);
                vDataRowVo.setCondition(fieldRow.getString(ENTRYENTITY_CONDITION));
            }
            if (isSingleFormula) {
                vDataRowVo.setFloat(fieldRow.getBoolean(ENTRYENTITY_ISFLOAT));
            } else {
                vDataRowVo.setShow(fieldRow.getBoolean(ISAPPEAR));
            }
            if (fieldRow.getBoolean(ENTRYENTITY_ISFLOAT)) {
                vDataRowVo.setFloat(true);
                long modelId = (Long)formView.getFormShowParameter().getCustomParam("KEY_MODEL_ID");
                HashMap numToShort = new HashMap(16);
                Map curMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
                curMap.forEach((k, v) -> numToShort.put(v, (String)k));
                vDataRowVo.setFloatMapping(numToShort.getOrDefault(fieldRow.getDynamicObject(ENTRYENTITY_MAPPING).getString(NUMBER), fieldRow.getDynamicObject(ENTRYENTITY_MAPPING).getString(NUMBER)));
            }
            vDataRowVos.add(vDataRowVo);
        }
        return vDataRowVos;
    }

    public static String getReturnField(IFormView formView, boolean singleFormula) {
        String type = (String)formView.getModel().getValue(SOURCE);
        DataSourceTypeEnum sourceTypeEnum = DataSourceTypeEnum.getByType(type);
        String appear = "";
        if (sourceTypeEnum != null) {
            switch (sourceTypeEnum) {
                case MERGE_MODEL: {
                    if (((Boolean)formView.getModel().getValue(ISEXT)).booleanValue()) {
                        if (singleFormula) {
                            appear = formView.getModel().getValue(RETURN_VALUE).toString();
                            break;
                        }
                        appear = formView.getModel().getEntryEntity(ENTRYENTITY).stream().filter(d -> d.getBoolean(ISAPPEAR) && d.getString(ENTRYENTITY_VALUE).endsWith(EXT)).map(d -> d.getString(ENTRYENTITY_VALUE).split("\\|")[0]).collect(Collectors.joining(","));
                        break;
                    }
                    appear = F_MONEY;
                    break;
                }
                case RPT_MODEL: 
                case EB_MODEL: {
                    appear = F_MONEY;
                    break;
                }
                case ISC_METADATA: 
                case EPM_DATAMANAGE: {
                    if (singleFormula) {
                        appear = formView.getModel().getValue(RETURN_VALUE).toString();
                        break;
                    }
                    Set metricFields = new HashSet(16);
                    String metricFieldStr = formView.getPageCache().getBigObject("metricField");
                    if (StringUtils.isNotBlank((String)metricFieldStr)) {
                        metricFields = (Set)SerializationUtils.deSerializeFromBase64((String)metricFieldStr);
                    }
                    DynamicObject[] rows = ((EntryGrid)formView.getControl(ENTRYENTITY)).getEntryData().getDataEntitys();
                    ArrayList<String> apperCols = new ArrayList<String>(16);
                    for (DynamicObject row : rows) {
                        String field = row.getString(ENTRYENTITY_VALUE).split("\\|")[0];
                        if (!row.getBoolean(ISAPPEAR) || !metricFields.contains(field)) continue;
                        apperCols.add(field);
                    }
                    appear = String.join((CharSequence)",", apperCols);
                    break;
                }
            }
        }
        return appear;
    }

    public static Object getDataResult(String previewFormula) {
        Map res = (Map)DispatchServiceHelper.invokeBizService((String)"epm", (String)"far", (String)FormulaMsService, (String)"getResult", (Object[])new Object[]{previewFormula});
        if (res.get("ret") instanceof Boolean && !((Boolean)res.get("ret")).booleanValue()) {
            throw new KDBizException(res.get("msg") == null ? ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38\u3002", (String)"VDataFormulaUtils_3", (String)"fi-bcm-business", (Object[])new Object[0]) : res.get("msg").toString());
        }
        return res.get("result");
    }

    public static Object getDataResultWithTip(String previewFormula, IFormView formView) {
        Map res = (Map)DispatchServiceHelper.invokeBizService((String)"epm", (String)"far", (String)FormulaMsService, (String)"getResult", (Object[])new Object[]{previewFormula});
        if (res.get("ret") instanceof Boolean && !((Boolean)res.get("ret")).booleanValue()) {
            formView.showTipNotification(res.get("msg") == null ? ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38\u3002", (String)"VDataFormulaUtils_3", (String)"fi-bcm-business", (Object[])new Object[0]) : res.get("msg").toString());
        }
        return res.get("result");
    }

    public static VDataFormulaVo parseFormula(String formula) {
        Pair<String, List<IFormula>> pair = null;
        VDataFormulaVo formulaVo = null;
        try {
            ExpressParser parser = new ExpressParser();
            pair = parser.parse(formula, new EncoderService());
        }
        catch (Exception ex) {
            log.error("vdata formula parse error:" + formula);
        }
        if (pair != null) {
            ArrayList formulas = new ArrayList((Collection)pair.p2);
            for (IFormula iformula : formulas) {
                String model;
                String source;
                ParamList paramList;
                if (iformula instanceof VDataFormula) {
                    paramList = iformula.getParamList();
                    source = ((ParamItem)paramList.get(0)).toString();
                    model = ((ParamItem)paramList.get(1)).toString();
                    String defaultValue = ((ParamItem)paramList.get(2)).toString();
                    String condition = ((ParamItem)paramList.get(3)).toString();
                    String returnValue = ((ParamItem)paramList.get(4)).toString();
                    formulaVo = VDataFormulaUtils.parseVDataParam(source, model, defaultValue, condition, returnValue);
                    continue;
                }
                if (!(iformula instanceof VSDataFormula)) continue;
                paramList = iformula.getParamList();
                source = ((ParamItem)paramList.get(0)).toString();
                model = ((ParamItem)paramList.get(1)).toString();
                String condition = ((ParamItem)paramList.get(2)).toString();
                String back1 = ((ParamItem)paramList.get(3)).toString();
                String back2 = ((ParamItem)paramList.get(4)).toString();
                boolean agg = Boolean.parseBoolean(((ParamItem)paramList.get(5)).toString());
                formulaVo = VDataFormulaUtils.parseVSDataParam(source, model, condition, back1, back2, agg);
            }
        }
        return formulaVo;
    }

    public static VDataFormulaVo parseVDataParam(String type, String modelNum, String defaultCon, String condition, String returnField) {
        VDataTypeEnum vDataTypeEnum = VDataTypeEnum.getVDataTypeByType(type);
        String selModelNum = modelNum;
        String extNum = "";
        if (modelNum.contains(",")) {
            selModelNum = modelNum.split(",")[0];
            extNum = modelNum.substring(modelNum.indexOf(",") + 1);
        }
        List<VDataRowVo> conditionVos = VDataFormulaUtils.getConditionVo(vDataTypeEnum, selModelNum, extNum, condition);
        List<String> fields = Arrays.asList(returnField.split(","));
        return new VDataFormulaVo(true, vDataTypeEnum, selModelNum, extNum, defaultCon, conditionVos, fields, Collections.emptyList(), false);
    }

    public static VDataFormulaVo parseVSDataParam(String type, String modelNum, String condition, String backNum, String backExt, boolean agg) {
        VDataTypeEnum vDataTypeEnum = VDataTypeEnum.getVDataTypeByType(type);
        String selModelNum = modelNum;
        String extNum = "";
        if (modelNum.contains(",")) {
            selModelNum = modelNum.split(",")[0];
            extNum = modelNum.substring(modelNum.indexOf(",") + 1);
        }
        List<VDataRowVo> propertyVo = VDataFormulaUtils.getVsRowVo(vDataTypeEnum, selModelNum, extNum, condition, backNum, backExt);
        return new VDataFormulaVo(false, vDataTypeEnum, selModelNum, extNum, null, propertyVo, VDataFormulaUtils.getStrList(backNum), VDataFormulaUtils.getStrList(backExt), agg);
    }

    private static List<VDataRowVo> getVsRowVo(VDataTypeEnum vDataTypeEnum, String modelNum, String extNum, String filterStr, String backNum, String backExt) {
        ArrayList<VDataRowVo> propertyVos = new ArrayList<VDataRowVo>(10);
        Map<String, String> filterChunks = VDataFormulaUtils.resolveFilterChunks(filterStr);
        Map<String, ColumnInfoVo> colsMapInfo = VDataFormulaUtils.getColumnMap(vDataTypeEnum, modelNum, extNum);
        Set<String> returnFields = VDataFormulaUtils.getStrSet(backNum);
        returnFields.addAll(VDataFormulaUtils.getStrSet(backExt));
        for (Map.Entry<String, String> entry : filterChunks.entrySet()) {
            VDataRowVo vDataRowVo;
            String sourcePrefix = entry.getKey();
            String sourceSuffix = entry.getValue();
            Pair<String, String> propertyPrefix = VDataFormulaUtils.getPropertyPrefix(vDataTypeEnum, sourcePrefix);
            ColumnInfoVo columnInfoVo = colsMapInfo.get(propertyPrefix.p1);
            if (columnInfoVo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38\u3002", (String)"VDataFormulaUtils_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (VDataTypeEnum.ISC == vDataTypeEnum) {
                VDataIntegrateVo rowVo = new VDataIntegrateVo();
                rowVo.setNumber((String)propertyPrefix.p1);
                rowVo.setCondition(StringUtils.substringBetween((String)sourceSuffix, (String)LEFT_BRACKET, (String)RIGHT_BRACKET));
                rowVo.setFilters(VDataFormulaUtils.getDatasetFilterVos(sourceSuffix));
                rowVo.setShow(returnFields.contains(propertyPrefix.p1));
                propertyVos.add(rowVo);
                continue;
            }
            if (vDataTypeEnum == VDataTypeEnum.EPM) {
                vDataRowVo = new VDataVoucherVo();
                vDataRowVo.setNumber((String)propertyPrefix.p1);
                vDataRowVo.setCondition(StringUtils.substringBetween((String)sourceSuffix, (String)LEFT_BRACKET, (String)RIGHT_BRACKET));
                ((VDataVoucherVo)vDataRowVo).setFilters(VDataFormulaUtils.getDatasetFilterVos(sourceSuffix));
                vDataRowVo.setShow(returnFields.contains(propertyPrefix.p1));
                propertyVos.add(vDataRowVo);
                continue;
            }
            if (vDataTypeEnum == VDataTypeEnum.EB) {
                vDataRowVo = new VDataEBVo();
                vDataRowVo.setNumber(columnInfoVo.getShortNumber());
                vDataRowVo.setDimNum(columnInfoVo.getNumber());
                vDataRowVo.setCondition(sourceSuffix);
                if (!((String)propertyPrefix.p1).equals(propertyPrefix.p2)) {
                    ((VDataEBVo)vDataRowVo).setProperty((String)propertyPrefix.p2);
                }
                propertyVos.add(vDataRowVo);
                continue;
            }
            if (VDataFormulaUtils.isProperty(sourcePrefix, columnInfoVo)) {
                propertyVos.add(VDataFormulaUtils.getPropertyVo(sourceSuffix, propertyPrefix, modelNum));
                continue;
            }
            propertyVos.add(VDataFormulaUtils.buildDim(sourcePrefix, sourceSuffix, modelNum));
        }
        return propertyVos;
    }

    private static List<String> getStrList(String str) {
        ArrayList<String> result = new ArrayList<String>(16);
        if (StringUtils.isBlank((String)str)) {
            return result;
        }
        result.addAll(Arrays.asList(str.split(",")));
        return result;
    }

    private static Set<String> getStrSet(String str) {
        HashSet<String> result = new HashSet<String>(16);
        if (StringUtils.isBlank((String)str)) {
            return result;
        }
        result.addAll(Arrays.asList(str.split(",")));
        return result;
    }

    public static List<VDataRowVo> getConditionVo(VDataTypeEnum vDataTypeEnum, String modelNum, String extNum, String filterStr) {
        ArrayList<VDataRowVo> propertyVos = new ArrayList<VDataRowVo>(10);
        Map<String, String> filterChunks = VDataFormulaUtils.resolveFilterChunks(filterStr);
        Map<String, ColumnInfoVo> colsMapInfo = VDataFormulaUtils.getColumnMap(vDataTypeEnum, modelNum, extNum);
        for (Map.Entry<String, String> entry : filterChunks.entrySet()) {
            String cond;
            VDataRowVo rowVo;
            String sourcePrefix = entry.getKey();
            String sourceSuffix = entry.getValue();
            Pair<String, String> propertyPrefix = VDataFormulaUtils.getPropertyPrefix(vDataTypeEnum, sourcePrefix);
            ColumnInfoVo columnInfoVo = colsMapInfo.get(propertyPrefix.p1);
            if (columnInfoVo == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"VDataFormulaUtils_2", (String)"fi-bcm-business", (Object[])new Object[0]), propertyPrefix.p1));
            }
            if (VDataTypeEnum.ISC == vDataTypeEnum || VDataTypeEnum.EPM == vDataTypeEnum) {
                rowVo = VDataTypeEnum.ISC == vDataTypeEnum ? new VDataIntegrateVo() : new VDataVoucherVo();
                rowVo.setNumber((String)propertyPrefix.p1);
                cond = VDataFormulaUtils.replaceQuotation(sourceSuffix);
                rowVo.setCondition(cond);
                rowVo.setFloat(sourceSuffix.contains("@"));
                if (rowVo.isFloat()) {
                    rowVo.setFloatMapping(StringUtils.remove((String)sourceSuffix, (String)"@"));
                }
                if (rowVo instanceof VDataIntegrateVo) {
                    ((VDataIntegrateVo)rowVo).setFilters(VDataFormulaUtils.getDatasetFilterVos(sourceSuffix));
                }
                propertyVos.add(rowVo);
                continue;
            }
            if (VDataTypeEnum.EB == vDataTypeEnum) {
                rowVo = new VDataEBVo();
                rowVo.setNumber(columnInfoVo.getShortNumber());
                rowVo.setDimNum(columnInfoVo.getNumber());
                cond = VDataFormulaUtils.replaceQuotation(sourceSuffix);
                rowVo.setCondition(cond);
                rowVo.setFloat(sourceSuffix.contains("@"));
                if (rowVo.isFloat()) {
                    rowVo.setFloatMapping(StringUtils.remove((String)sourceSuffix, (String)"@"));
                }
                if (VDataFormulaUtils.isProperty(sourcePrefix, columnInfoVo)) {
                    ((VDataEBVo)rowVo).setProperty((String)propertyPrefix.p2);
                }
                propertyVos.add(rowVo);
                continue;
            }
            if (VDataFormulaUtils.isProperty(sourcePrefix, columnInfoVo)) {
                VDataRowVo vDataRowVo = VDataFormulaUtils.getPropertyVo(sourceSuffix, propertyPrefix, modelNum);
                vDataRowVo.setCondition(VDataFormulaUtils.replaceQuotation(sourceSuffix));
                propertyVos.add(vDataRowVo);
                continue;
            }
            propertyVos.add(VDataFormulaUtils.buildDim(sourcePrefix, sourceSuffix, modelNum));
        }
        return propertyVos;
    }

    private static Map<String, ColumnInfoVo> getColumnMap(VDataTypeEnum vDataTypeEnum, String modelNum, String extNum) {
        HashMap<String, ColumnInfoVo> map = new HashMap<String, ColumnInfoVo>(16);
        switch (vDataTypeEnum) {
            case CM: 
            case RPT: {
                Map shortMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberByShowNum((String)modelNum));
                for (Map.Entry entry : shortMap.entrySet()) {
                    map.put((String)entry.getKey(), new ColumnInfoVo((String)entry.getValue(), (String)entry.getKey(), MemberReader.getEntityNumberByDim((String)modelNum, (String)((String)entry.getValue()))));
                    map.put((String)entry.getValue(), new ColumnInfoVo((String)entry.getValue(), (String)entry.getKey(), MemberReader.getEntityNumberByDim((String)modelNum, (String)((String)entry.getValue()))));
                }
                break;
            }
            case EB: {
                List<EbDimVo> ebDimVos = VDataFormulaServiceHelper.getDim(modelNum, extNum);
                for (EbDimVo ebDimVo : ebDimVos) {
                    map.put(ebDimVo.getNumber(), new ColumnInfoVo(ebDimVo.getNumber(), ebDimVo.getShortNumber(), ebDimVo.getMemberModel()));
                    map.put(ebDimVo.getShortNumber(), new ColumnInfoVo(ebDimVo.getNumber(), ebDimVo.getShortNumber(), ebDimVo.getMemberModel()));
                }
                break;
            }
            case ISC: {
                for (IntegrateProperty item : VDataFormulaUtils.getMetadataProperty(modelNum, extNum)) {
                    map.put(item.getPropNumber(), new ColumnInfoVo(null, item.getPropLabel(), item.getPropNumber(), null, null, "3"));
                    if (CollectionUtil.isEmpty(item.getChildPropertyList())) continue;
                    for (IntegrateProperty child : item.getChildPropertyList()) {
                        map.put(child.getPropNumber(), new ColumnInfoVo(null, child.getPropLabel(), child.getPropNumber(), null, null, "3"));
                    }
                }
                break;
            }
            case EPM: {
                EPMDataVo epmDataModel = VDataFormulaServiceHelper.getEPMDataModel(extNum, modelNum);
                for (EPMDataDetailVo detail : epmDataModel.getDetails()) {
                    map.put(detail.getField(), new ColumnInfoVo(NumberUtils.isNumber((String)detail.getId()) ? LongUtil.toLong((Object)detail.getId()) : 0L, detail.getLabel(), detail.getField(), null, null, "5"));
                }
                break;
            }
            case CM_ETX: {
                ExtendsModel extendsModel;
                Map shortMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberByShowNum((String)modelNum));
                for (Map.Entry entry : shortMap.entrySet()) {
                    map.put((String)entry.getKey(), new ColumnInfoVo((String)entry.getValue(), (String)entry.getKey(), MemberReader.getEntityNumberByDim((String)modelNum, (String)((String)entry.getValue()))));
                    map.put((String)entry.getValue(), new ColumnInfoVo((String)entry.getValue(), (String)entry.getKey(), MemberReader.getEntityNumberByDim((String)modelNum, (String)((String)entry.getValue()))));
                    if (!"Entity".equals(entry.getValue())) continue;
                    map.put(SE, new ColumnInfoVo((String)entry.getValue(), (String)entry.getKey(), MemberReader.getEntityNumberByDim((String)modelNum, (String)((String)entry.getValue()))));
                    map.put(SOURCEENTITY, new ColumnInfoVo((String)entry.getValue(), (String)entry.getKey(), MemberReader.getEntityNumberByDim((String)modelNum, (String)((String)entry.getValue()))));
                }
                String selectFields = ID;
                QFBuilder qfBuilder = new QFBuilder(NUMBER, "=", (Object)extNum).add("model", "=", (Object)MemberReader.findModelIdByShowNum((String)modelNum));
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)selectFields, (QFilter[])qfBuilder.toArray());
                ExtendsModel extendsModel2 = extendsModel = query.isEmpty() ? null : new ExtendsModel(((DynamicObject)query.get(0)).getLong(ID));
                if (extendsModel == null) break;
                extendsModel.getExtFieldEntry().forEach(ext -> map.put(ext.getExtField().getNumber(), new ColumnInfoVo(ext.getExtField().getNumber(), ext.getExtField().getNumber(), "bcm_structofextend")));
            }
        }
        return map;
    }

    private static VDataDimNodeVo buildDim(String sourcePrefix, String sourceSuffix, String modelNum) {
        String handlePrefix = VDataFormulaUtils.getDecodeStr(sourcePrefix);
        String handleSuffix = VDataFormulaUtils.handleExpression(sourceSuffix);
        String selModelNum = MemberReader.findModelNumberByShowNum((String)modelNum);
        VDataDimNodeVo dimVo = VDataFormulaUtils.getDimVo(handlePrefix, handleSuffix, selModelNum);
        dimVo.setCondition(handleSuffix);
        if (handleSuffix.startsWith(LEFT_BRACKET) && handleSuffix.endsWith(RIGHT_BRACKET)) {
            handleSuffix = handleSuffix.substring(1, handleSuffix.length() - 1);
        }
        String[] splits = handleSuffix.split(",");
        MultiF7Results f7Results = new MultiF7Results();
        for (String temp : splits) {
            String[] split = temp.split("\\.");
            RangeEnum rangeItem = RangeEnum.VALUE_10;
            String value = split[0];
            if (value.contains("@")) {
                dimVo.setFloat(true);
                dimVo.setFloatMapping(value.substring(value.indexOf("@") + 1));
                continue;
            }
            MultiF7Result mp = new MultiF7Result();
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)selModelNum, (String)dimVo.getDimNum(), (String)value);
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                dimVo.setCondition(value);
                continue;
            }
            mp.setId(node.getId());
            mp.setName(node.getName());
            mp.setScope(rangeItem.getValue());
            mp.setNumber(node.getNumber());
            f7Results.addMultiResultSet(mp);
        }
        dimVo.setMultiF7Results(f7Results);
        return dimVo;
    }

    private static String removeSquareBrackets(String key) {
        return key.replaceAll("^\\[|]$", "");
    }

    private static String handleExpression(String suffix) {
        StringBuilder sb = new StringBuilder();
        boolean inSquareBrackets = false;
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (c == '\\' && i < suffix.length() - 1) {
                sb.append(suffix.charAt(++i));
                continue;
            }
            if (c == '[') {
                inSquareBrackets = true;
                continue;
            }
            if (c == ']') {
                inSquareBrackets = false;
                continue;
            }
            if (c == ',' && !inSquareBrackets) {
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String getDecodeStr(String key) {
        String removeSquareBrackets = VDataFormulaUtils.removeSquareBrackets(key);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < removeSquareBrackets.length(); ++i) {
            char c = removeSquareBrackets.charAt(i);
            if (c == '\\' && i < removeSquareBrackets.length() - 1) {
                sb.append(removeSquareBrackets.charAt(++i));
                continue;
            }
            if (SYSTEM_KEYS.contains(String.valueOf(c))) continue;
            sb.append(removeSquareBrackets.charAt(i));
        }
        return sb.toString();
    }

    private static boolean isProperty(String key, ColumnInfoVo columnInfoVo) {
        if (key.startsWith(C_LEFT_BRACKET) && key.endsWith(C_RIGHT_BRACKET)) {
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (c == '\\') {
                    ++i;
                    continue;
                }
                if (c != '.') continue;
                return true;
            }
        }
        return columnInfoVo.getCustom() != null && (columnInfoVo.getCustom().equals("2") || columnInfoVo.getCustom().equals("3"));
    }

    private static List<VDataFilterVo> getDatasetFilterVos(String sourceSuffix) {
        ArrayList<VDataFilterVo> filterVos = new ArrayList<VDataFilterVo>(12);
        sourceSuffix = VDataFormulaUtils.dealSourceSuffix(sourceSuffix);
        List<Pair<String, String>> conditions = VDataFormulaUtils.handleConditions(sourceSuffix);
        for (Pair<String, String> condition : conditions) {
            if (!StringUtils.isNotEmpty((String)((String)condition.p1))) continue;
            if (StringUtils.isEmpty((String)((String)condition.p2))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38\u3002", (String)"VDataFormulaUtils_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            filterVos.add(new VDataFilterVo((String)condition.p2, (String)condition.p1));
        }
        return filterVos;
    }

    public static String dealSourceSuffix(String sourceSuffix) {
        if (sourceSuffix.trim().startsWith(LEFT_BRACKET) && sourceSuffix.trim().endsWith(RIGHT_BRACKET)) {
            sourceSuffix = sourceSuffix.substring(1, sourceSuffix.length() - 1);
            StringBuilder sb = new StringBuilder();
            sb.append(LEFT_BRACKET);
            boolean isIn = false;
            for (int i = 0; i < sourceSuffix.length() - 1; ++i) {
                String cur = String.valueOf(sourceSuffix.charAt(i));
                String next = String.valueOf(sourceSuffix.charAt(i + 1));
                if (!(!OPERATOR_KEYS.contains(cur) || OPERATOR_KEYS.contains(next) && OPERATOR_KEYS.contains(cur + next) || isIn)) {
                    isIn = true;
                    sb.append(cur);
                    continue;
                }
                if (isIn && !OPERATOR_KEYS.contains(next)) {
                    if (SYSTEM_KEYS.contains(cur) || OPERATOR_KEYS.contains(cur)) {
                        sb.append("\\").append(cur);
                        continue;
                    }
                    sb.append(cur);
                    continue;
                }
                if (isIn && cur.equals(",")) {
                    isIn = false;
                    sb.append(",");
                    continue;
                }
                sb.append(cur);
            }
            sb.append(sourceSuffix.charAt(sourceSuffix.length() - 1));
            sb.append(RIGHT_BRACKET);
            sourceSuffix = sb.toString();
        }
        return sourceSuffix;
    }

    public static List<Pair<String, String>> handleConditions(String suffix) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Pair<String, String>> filters = new ArrayList<Pair<String, String>>(12);
        boolean inSquareBrackets = false;
        boolean singleFilters = true;
        if (suffix.startsWith(LEFT_BRACKET) && suffix.endsWith(RIGHT_BRACKET)) {
            singleFilters = false;
        }
        String calType = "";
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (c == '\\' && i < suffix.length() - 1) {
                sb.append(suffix.charAt(++i));
                continue;
            }
            if (c == '{') {
                inSquareBrackets = true;
                continue;
            }
            if (c == '}') {
                inSquareBrackets = false;
                continue;
            }
            if (OPERATOR_KEYS.contains(String.valueOf(c)) && inSquareBrackets) {
                calType = String.valueOf(c);
                if (i >= suffix.length() - 1 || !OPERATOR_KEYS.contains(String.valueOf(suffix.charAt(i + 1)))) continue;
                VDataFormulaUtils.checkNextOperateKey(String.valueOf(c), String.valueOf(suffix.charAt(i + 1)));
                calType = calType + String.valueOf(suffix.charAt(++i));
                continue;
            }
            if (c == ',' && (inSquareBrackets || singleFilters)) {
                filters.add((Pair<String, String>)new Pair((Object)sb.toString(), (Object)signs.get(calType)));
                calType = "";
                sb.setLength(0);
                continue;
            }
            if (SYSTEM_KEYS.contains(String.valueOf(c))) continue;
            sb.append(c);
        }
        if (sb.length() > 0) {
            filters.add((Pair<String, String>)new Pair((Object)sb.toString(), (Object)signs.get(calType)));
        }
        return filters;
    }

    private static void checkNextOperateKey(String pre, String next) {
        if (StringUtils.equals((String)pre, (String)next)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38\u3002", (String)"VDataFormulaUtils_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!OPERATOR_KEYS.contains(pre + next)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38\u3002", (String)"VDataFormulaUtils_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private static VDataRowVo getPropertyVo(String sourceSuffix, Pair<String, String> propertyPrefix, String modelNum) {
        VDataPropertyVo propertyVo = new VDataPropertyVo();
        String selModelNum = MemberReader.findModelNumberByShowNum((String)modelNum);
        List<VDataFilterVo> filterVos = VDataFormulaUtils.getDatasetFilterVos(sourceSuffix);
        HashMap numhSortMap = new HashMap(10);
        Map shortMap = MemberReader.getDimensionShortNumber2NumberMap((String)selModelNum);
        shortMap.forEach((k, v) -> numhSortMap.put(v, k));
        propertyVo.setNumber((String)numhSortMap.getOrDefault(propertyPrefix.p1, propertyPrefix.p1));
        propertyVo.setDimNum((String)shortMap.getOrDefault(propertyPrefix.p1, propertyPrefix.p1));
        propertyVo.setFilters(filterVos);
        propertyVo.setProperty((String)propertyPrefix.p2);
        return propertyVo;
    }

    private static VDataDimNodeVo getDimVo(String prefix, String handleSuffix, String modelNum) {
        VDataDimNodeVo dimNodeVo = new VDataDimNodeVo();
        HashMap numhSortMap = new HashMap(10);
        Map shortMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
        shortMap.forEach((k, v) -> numhSortMap.put(v, (String)k));
        if (SE.equals(prefix)) {
            dimNodeVo.setNumber(SE);
            dimNodeVo.setDimNum("Entity");
        } else {
            dimNodeVo.setNumber(numhSortMap.getOrDefault(prefix, prefix));
            dimNodeVo.setDimNum(shortMap.getOrDefault(prefix, prefix));
        }
        if (handleSuffix.startsWith("@")) {
            dimNodeVo.setFloat(true);
            dimNodeVo.setFloatMapping(handleSuffix.substring(1, handleSuffix.length()));
        }
        return dimNodeVo;
    }

    public static Pair<String, String> getPropertyPrefix(VDataTypeEnum vDataTypeEnum, String prefix) {
        String preDimNum = "";
        String tailFields = "";
        boolean inSQ = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (c == '\\' && i < prefix.length() - 1) {
                sb.append(prefix.charAt(++i));
                continue;
            }
            if (c == '[') {
                inSQ = true;
                continue;
            }
            if (c == ']') {
                inSQ = false;
                continue;
            }
            if (c == '.' && inSQ) {
                preDimNum = sb.toString();
                continue;
            }
            if (SYSTEM_KEYS.contains(String.valueOf(c))) continue;
            sb.append(prefix.charAt(i));
        }
        if (sb.length() > preDimNum.length()) {
            tailFields = sb.substring(preDimNum.length());
        }
        if (StringUtils.isEmpty((String)preDimNum)) {
            preDimNum = tailFields;
        } else if (VDataTypeEnum.ISC == vDataTypeEnum) {
            String field = preDimNum + "." + tailFields;
            return Pair.onePair((Object)field, (Object)field);
        }
        return new Pair((Object)preDimNum, (Object)tailFields);
    }

    public static Map<String, String> resolveFilterChunks(String filterStr) {
        String realFilterStr = filterStr.replaceAll("^\"|\"$", "");
        LinkedHashMap<String, String> chunkMaps = new LinkedHashMap<String, String>(12);
        char[] charArray = realFilterStr.toCharArray();
        int len = charArray.length;
        StringBuilder sb = new StringBuilder();
        StringBuilder head = new StringBuilder();
        StringBuilder tail = new StringBuilder();
        boolean inSquareBrackets = false;
        boolean inCurlyBraces = false;
        for (int i = 0; i < len; ++i) {
            char c = charArray[i];
            if (c == '\\' && i < len - 1) {
                StringBuilder var10000 = sb.append(c);
                var10000.append(charArray[++i]);
                continue;
            }
            if (c == '{') {
                sb.append(c);
                inCurlyBraces = true;
                continue;
            }
            if (c == '}') {
                sb.append(c);
                inCurlyBraces = false;
                continue;
            }
            if (c == '[') {
                sb.append(c);
                inSquareBrackets = true;
                continue;
            }
            if (c == ']') {
                sb.append(c);
                inSquareBrackets = false;
                continue;
            }
            if (c == '.' && !inCurlyBraces && !inSquareBrackets) {
                head.append((CharSequence)sb);
                continue;
            }
            if (c == ',' && !inCurlyBraces && !inSquareBrackets) {
                boolean notEmpty = head.capacity() > 0;
                chunkMaps.put(notEmpty ? head.toString() : sb.toString(), notEmpty ? tail.append(sb.substring(head.toString().length())).toString() : tail.toString());
                sb.setLength(0);
                head.setLength(0);
                tail.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            boolean notEmpty = head.capacity() > 0;
            chunkMaps.put(notEmpty ? head.toString() : sb.toString(), notEmpty ? tail.append(sb.substring(head.toString().length())).toString() : tail.toString());
        }
        return chunkMaps;
    }

    public static long getModelId(IFormView formView) {
        String type = (String)formView.getModel().getValue(SOURCE);
        DataSourceTypeEnum sourceTypeEnum = DataSourceTypeEnum.getByType(type);
        if (sourceTypeEnum == null) {
            return 0L;
        }
        return ((DynamicObject)formView.getModel().getValue(sourceTypeEnum.getMark())).getLong(ID);
    }

    public static MultiF7Results transCacheToObj(String cache) {
        MultiF7Results multiF7Results = new MultiF7Results();
        if (!StringUtils.isBlank((String)cache)) {
            List list = SerializationUtils.fromJsonStringToList((String)cache, Map.class);
            for (Map map : list) {
                MultiF7Result mp = new MultiF7Result();
                mp.setId(Long.parseLong((String)map.get(ID)));
                mp.setName((String)map.get(NAME));
                mp.setScope(Integer.parseInt((String)map.get(SCOPE)));
                mp.setNumber((String)map.get(NUMBER));
                multiF7Results.addMultiResultSet(mp);
            }
        }
        return multiF7Results;
    }

    public static List<IntegrateProperty> getMetadataProperty(String metadataType, String schemaNumber) {
        if (StringUtils.isBlank((String)metadataType) || StringUtils.isBlank((String)schemaNumber)) {
            return Collections.EMPTY_LIST;
        }
        DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)schemaNumber)});
        if (integrateObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"%s\u5173\u8054\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"VDataFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[]{schemaNumber}));
        }
        DynamicObjectCollection entryentityCollection = integrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
        ArrayList integratePropertyList = Lists.newArrayListWithExpectedSize((int)entryentityCollection.size());
        ArrayList nodeExistFields = Lists.newArrayListWithExpectedSize((int)5);
        IntegrateProperty integrateProperty = null;
        for (DynamicObject propEntryEntity : entryentityCollection) {
            String propName = propEntryEntity.getString(PROP_NAME);
            String propLabel = propEntryEntity.getString(PROP_LABEL);
            String propDataType = propEntryEntity.getString(DATA_TYPE);
            String propDataSchema = propEntryEntity.getString(DATA_SCHEMA);
            if ("REF".equals(propDataType) && MetaDataTypeEnum.ENTITY.getType().equals(metadataType)) {
                DynamicObject childIntegrateObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)propDataSchema)});
                if (childIntegrateObject != null) {
                    DynamicObjectCollection childEntryentityCollection = childIntegrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
                    ArrayList childIntegratePropertyList = Lists.newArrayListWithExpectedSize((int)childEntryentityCollection.size());
                    childEntryentityCollection.forEach(childPropEntryEntity -> {
                        String childPropName = childPropEntryEntity.getString(PROP_NAME);
                        String childPropLabel = childPropEntryEntity.getString(PROP_LABEL);
                        String childPropDataType = childPropEntryEntity.getString(DATA_TYPE);
                        String childdPropDataSchema = childPropEntryEntity.getString(DATA_SCHEMA);
                        String childField = propName + "." + childPropName;
                        IntegrateProperty childIntegrateProperty = new IntegrateProperty(childField, childPropLabel, childPropDataType, childdPropDataSchema, null);
                        childIntegratePropertyList.add(childIntegrateProperty);
                    });
                    integrateProperty = new IntegrateProperty(propName, propLabel, propDataType, propDataSchema, childIntegratePropertyList);
                } else {
                    nodeExistFields.add(propLabel);
                    integrateProperty = new IntegrateProperty(propName, propLabel, propDataType, propDataSchema, null);
                }
            } else {
                integrateProperty = new IntegrateProperty(propName, propLabel, propDataType, propDataSchema, null);
            }
            integratePropertyList.add(integrateProperty);
        }
        if (!nodeExistFields.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"%s\u5173\u8054\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"VDataFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[]{((Object)nodeExistFields).toString()}));
        }
        return integratePropertyList;
    }

    public static VDataFormulaVo transferMultiRow(VDataFormulaVo vDataFormulaVo, Map<String, JSONArray> dimMap) {
        if (vDataFormulaVo.isSingleFormula() && vDataFormulaVo.getColumnVos().stream().noneMatch(VDataRowVo::isFloat)) {
            return vDataFormulaVo;
        }
        List<String> returnFields = vDataFormulaVo.getReturnFields();
        ArrayList<VDataRowVo> rows = new ArrayList<VDataRowVo>(10);
        ArrayList<String> backExt = new ArrayList<String>(10);
        for (VDataRowVo columnVo : vDataFormulaVo.getColumnVos()) {
            if (columnVo.isFloat() && dimMap.containsKey(columnVo.getFloatMapping())) {
                VDataIntegrateVo integrateVo = new VDataIntegrateVo();
                integrateVo.setNumber(columnVo.getNumber());
                integrateVo.setShow(columnVo.isShow());
                JSONArray mems = dimMap.get(columnVo.getFloatMapping());
                if (mems == null) continue;
                List memList = (List)JSONArray.toJavaObject((JSON)mems, List.class);
                String conditionStr = String.join((CharSequence)",", memList);
                if (StringUtils.isEmpty((String)conditionStr)) {
                    integrateVo.setCondition(columnVo.getCondition());
                } else {
                    integrateVo.setCondition(conditionStr);
                }
                rows.add(integrateVo);
                backExt.add(columnVo.getNumber());
                continue;
            }
            rows.add(columnVo);
        }
        return new VDataFormulaVo(false, vDataFormulaVo.getType(), vDataFormulaVo.getModelNum(), vDataFormulaVo.getExtNum(), null, rows, returnFields, backExt, true);
    }

    public static String replaceQuotation(String sourceSuffix) {
        String sub = sourceSuffix;
        if (sourceSuffix.contains(LEFT_BRACKET) && sourceSuffix.contains(RIGHT_BRACKET)) {
            sub = StringUtils.substringBetween((String)sourceSuffix, (String)LEFT_BRACKET, (String)RIGHT_BRACKET);
        }
        return sub.replaceAll("\"\"", "\"");
    }

    public static void hasPermission(VDataFormulaVo vDataFormulaVo) {
        if (vDataFormulaVo.getType() == VDataTypeEnum.CM || vDataFormulaVo.getType() == VDataTypeEnum.CM_ETX || vDataFormulaVo.getType() == VDataTypeEnum.RPT) {
            Long modelId = MemberReader.findModelIdByShowNum((String)vDataFormulaVo.getModelNum());
            if (modelId == null || modelId == 0L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb%s\u4e0d\u5b58\u5728", (String)"VDataFormulaPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[]{vDataFormulaVo.getModelNum()}), new Object[0]));
            }
            if (vDataFormulaVo.getType() == VDataTypeEnum.CM || vDataFormulaVo.getType() == VDataTypeEnum.CM_ETX) {
                HashSet<Long> ids = new HashSet<Long>(16);
                ids.addAll(MemberPermHelper.getLimitedModelListByUser());
                ids.addAll(BcmFunPermissionHelper.getRoleModel(Long.parseLong(RequestContext.get().getUserId()), "bcm_model", ApplicationTypeEnum.CM, "bcm_templatelist", "47150e89000000ac"));
                if (!ids.contains(modelId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb%s\u65e0\u6743", (String)"VDataFormulaPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[]{vDataFormulaVo.getModelNum()}), new Object[0]));
                }
            } else if (vDataFormulaVo.getType() == VDataTypeEnum.RPT) {
                HashSet<Long> ids = new HashSet<Long>(16);
                ids.addAll(MemberPermHelper.getLimitedModelListByUser());
                ids.addAll(BcmFunPermissionHelper.getRoleModel(Long.parseLong(RequestContext.get().getUserId()), "bcm_model", ApplicationTypeEnum.RPT, "bcm_templatelist", "47150e89000000ac"));
                if (!ids.contains(modelId)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb%s\u65e0\u6743", (String)"VDataFormulaPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[]{vDataFormulaVo.getModelNum()}), new Object[0]));
                }
            }
        }
    }
}

