/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.adjust;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.innertrade.report.IntrEntityHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustICContext {
    private Long modelId;
    private Long mergeOrgId;
    private String mergeOrgNumber;
    private String mergeOrgLongNumber;
    private Long yearId;
    private Long periodId;
    private Long scenarioId;
    private Long currencyId;
    private List<Long> processIds;
    private List<Long> tmpIds;
    private boolean existAuditTrail;
    private boolean existChangeType;
    private boolean isSpptdatasort;
    private boolean isSpptmultrule;
    private boolean existsMyCompanyDim;
    private Map<String, Pair<Long, String>> sortedOrgByChangeType = new HashMap<String, Pair<Long, String>>(16);
    private Map<String, DynamicObject> allDims = new HashMap<String, DynamicObject>(16);
    private Map<Long, DynamicObject> tmplInfo = new HashMap<Long, DynamicObject>(16);
    private Pair<Long, String> model;
    private Pair<Long, String> scenario;
    private Pair<Long, String> year;
    private Pair<Long, String> period;
    private Pair<Long, String> currency;
    private Tuple<Long, String, String> entity;
    private Consumer<Integer> taskConsumer;
    private String executeSourceType = "-1";
    private HashBasedTable<Long, Long, Set<Pair<String, String>>> lockStageSchemes = HashBasedTable.create();
    private Multimap<Long, Long> unAutoAdjustLock = HashMultimap.create();

    public AdjustICContext(Long modelId, Long mergeOrgId, Long yearId, Long periodId, Long scenarioId, Long currencyId, List<Long> tmpIds, String executeSourceType) {
        this.modelId = modelId;
        this.mergeOrgId = mergeOrgId;
        this.yearId = yearId;
        this.periodId = periodId;
        this.scenarioId = scenarioId;
        this.currencyId = currencyId;
        this.tmpIds = tmpIds;
        this.executeSourceType = executeSourceType;
    }

    public AdjustICContext(Long modelId, Long mergeOrgId, Long yearId, Long periodId, Long scenarioId, Long currencyId, List<Long> tmpIds, List<Long> processIds, String executeSourceType) {
        this.modelId = modelId;
        this.mergeOrgId = mergeOrgId;
        this.yearId = yearId;
        this.periodId = periodId;
        this.scenarioId = scenarioId;
        this.currencyId = currencyId;
        this.tmpIds = tmpIds;
        this.processIds = processIds;
        this.executeSourceType = executeSourceType;
    }

    public void init() {
        this.initTemplateInfo();
        this.initModeInfo();
        this.initAllDims();
        this.initEntityVersion();
    }

    private void initTemplateInfo() {
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number,name,usage", (QFilter[])new QFilter[]{new QFilter("id", "in", this.tmpIds)});
        this.tmplInfo = docs.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
    }

    private void initEntityVersion() {
        String modelCubeNumber = MemberReader.findModelNumberById((Object)this.model.p1);
        Map<String, Set<Long>> orgByChangeType = IntrEntityHelper.getSortEntity(this.modelId, this.scenarioId, this.yearId, this.periodId, (Pair<String, String>)Pair.onePair((Object)this.entity.p2, (Object)this.entity.p3));
        orgByChangeType.forEach((num, orgIdList) -> {
            if (!orgIdList.isEmpty()) {
                IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelCubeNumber, (String)"Entity", (long)((Long)orgIdList.iterator().next()));
                this.sortedOrgByChangeType.put((String)num, (Pair<Long, String>)Pair.onePair((Object)orgNode.getId(), (Object)orgNode.getLongNumber()));
            }
        });
    }

    private void initModeInfo() {
        QFilter modelFilter = new QFilter("id", "=", (Object)this.modelId);
        DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,number,shownumber,isspptmultrule, isspptdatasort, defineddim", (QFilter[])new QFilter[]{modelFilter});
        this.existAuditTrail = MemberReader.isExistAuditTrailDimension((long)model.getLong("id"));
        this.existChangeType = MemberReader.isExistChangeTypeDimension((long)model.getLong("id"));
        this.isSpptdatasort = model.getBoolean("isspptdatasort");
        this.isSpptmultrule = model.getBoolean("isspptmultrule");
        this.existsMyCompanyDim = DimensionServiceHelper.existsMyCompanyDim(model.getLong("id"));
        IDNumberTreeNode orgMember = MemberReader.findMemberById((long)this.modelId, (String)"bcm_entitymembertree", (Long)this.mergeOrgId);
        if (orgMember.getId() == -1L) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u672a\u627e\u5230\u7ec4\u7ec7\u6210\u5458\uff1a%s", (String)"AdjustICContext_01", (String)"fi-bcm-business", (Object[])new Object[0]), this.mergeOrgId));
        }
        this.mergeOrgNumber = orgMember.getNumber();
        this.mergeOrgLongNumber = orgMember.getLongNumber();
        this.entity = new Tuple((Object)this.mergeOrgId, (Object)this.mergeOrgNumber, (Object)this.mergeOrgLongNumber);
        this.model = Pair.onePair((Object)this.modelId, (Object)model.getString("shownumber"));
        IDNumberTreeNode scenNode = MemberReader.findMemberById((long)this.modelId, (String)"bcm_scenemembertree", (Long)this.scenarioId);
        this.scenario = Pair.onePair((Object)scenNode.getId(), (Object)scenNode.getNumber());
        IDNumberTreeNode fyNode = MemberReader.findMemberById((long)this.modelId, (String)"bcm_fymembertree", (Long)this.yearId);
        this.year = Pair.onePair((Object)fyNode.getId(), (Object)fyNode.getNumber());
        IDNumberTreeNode periodNode = MemberReader.findMemberById((long)this.modelId, (String)"bcm_periodmembertree", (Long)this.periodId);
        this.period = Pair.onePair((Object)periodNode.getId(), (Object)periodNode.getNumber());
        IDNumberTreeNode curNode = MemberReader.findMemberById((long)this.modelId, (String)"bcm_currencymembertree", (Long)this.currencyId);
        this.currency = Pair.onePair((Object)curNode.getId(), (Object)curNode.getNumber());
    }

    private void initAllDims() {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", (Object)this.getModelId()).toArray(), (String)"dseq");
        this.allDims = dims.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e));
    }

    public Map<String, DynamicObject> getAllDims() {
        return this.allDims;
    }

    public void setAllDims(Map<String, DynamicObject> allDims) {
        this.allDims = allDims;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public boolean isExistAuditTrail() {
        return this.existAuditTrail;
    }

    public void setExistAuditTrail(boolean existAuditTrail) {
        this.existAuditTrail = existAuditTrail;
    }

    public boolean isExistChangeType() {
        return this.existChangeType;
    }

    public void setExistChangeType(boolean existChangeType) {
        this.existChangeType = existChangeType;
    }

    public boolean isSpptdatasort() {
        return this.isSpptdatasort;
    }

    public void setSpptdatasort(boolean spptdatasort) {
        this.isSpptdatasort = spptdatasort;
    }

    public boolean isSpptmultrule() {
        return this.isSpptmultrule;
    }

    public void setSpptmultrule(boolean spptmultrule) {
        this.isSpptmultrule = spptmultrule;
    }

    public boolean isExistsMyCompanyDim() {
        return this.existsMyCompanyDim;
    }

    public void setExistsMyCompanyDim(boolean existsMyCompanyDim) {
        this.existsMyCompanyDim = existsMyCompanyDim;
    }

    public Long getMergeOrgId() {
        return this.mergeOrgId;
    }

    public void setMergeOrgId(Long mergeOrgId) {
        this.mergeOrgId = mergeOrgId;
    }

    public String getMergeOrgNumber() {
        return this.mergeOrgNumber;
    }

    public void setMergeOrgNumber(String mergeOrgNumber) {
        this.mergeOrgNumber = mergeOrgNumber;
    }

    public String getMergeOrgLongNumber() {
        return this.mergeOrgLongNumber;
    }

    public void setMergeOrgLongNumber(String mergeOrgLongNumber) {
        this.mergeOrgLongNumber = mergeOrgLongNumber;
    }

    public Long getYearId() {
        return this.yearId;
    }

    public void setYearId(Long yearId) {
        this.yearId = yearId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Map<String, Pair<Long, String>> getSortedOrgByChangeType() {
        return this.sortedOrgByChangeType;
    }

    public void setSortedOrgByChangeType(Map<String, Pair<Long, String>> sortedOrgByChangeType) {
        this.sortedOrgByChangeType = sortedOrgByChangeType;
    }

    public Long getScenarioId() {
        return this.scenarioId;
    }

    public void setScenarioId(Long scenarioId) {
        this.scenarioId = scenarioId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Pair<Long, String> getModel() {
        return this.model;
    }

    public void setModel(Pair<Long, String> model) {
        this.model = model;
    }

    public Pair<Long, String> getScenario() {
        return this.scenario;
    }

    public void setScenario(Pair<Long, String> scenario) {
        this.scenario = scenario;
    }

    public Pair<Long, String> getYear() {
        return this.year;
    }

    public void setYear(Pair<Long, String> year) {
        this.year = year;
    }

    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    public void setPeriod(Pair<Long, String> period) {
        this.period = period;
    }

    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    public void setCurrency(Pair<Long, String> currency) {
        this.currency = currency;
    }

    public Tuple<Long, String, String> getEntity() {
        return this.entity;
    }

    public void setEntity(Tuple<Long, String, String> entity) {
        this.entity = entity;
    }

    public List<Long> getTmpIds() {
        return this.tmpIds;
    }

    public void setTmpIds(List<Long> tmpIds) {
        this.tmpIds = tmpIds;
    }

    public Map<Long, DynamicObject> getTmplInfo() {
        return this.tmplInfo;
    }

    public void setTmplInfo(Map<Long, DynamicObject> tmplInfo) {
        this.tmplInfo = tmplInfo;
    }

    public List<Long> getProcessIds() {
        return this.processIds;
    }

    public Consumer<Integer> getTaskConsumer() {
        return this.taskConsumer;
    }

    public void setTaskConsumer(Consumer<Integer> taskConsumer) {
        this.taskConsumer = taskConsumer;
    }

    public String getExecuteSourceType() {
        return this.executeSourceType;
    }

    public HashBasedTable<Long, Long, Set<Pair<String, String>>> getLockStageSchemes() {
        return this.lockStageSchemes;
    }

    public Multimap<Long, Long> getUnAutoAdjustLock() {
        return this.unAutoAdjustLock;
    }

    public void setUnAutoAdjustLock(Multimap<Long, Long> unAutoAdjustLock) {
        this.unAutoAdjustLock = unAutoAdjustLock;
    }
}

