/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.adjust;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.innertrade.adjust.AdjustICContext;
import kd.fi.bcm.business.innertrade.adjust.AdjustRecordService;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.IntrRecordAddition;
import kd.fi.bcm.business.papertemplate.filterchain.filter.OrgAssignFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.StatusFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.VersionFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.YearPeriodFilter;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.util.BcmTransferException;

public class AdjustRecordHelper {
    public static Map<String, String> generateAdjustInfo(Long modelId, Long templateId, Long scenarioId, Long yearId, Long periodId, Long currencyId, Long mergeOrgId, List<Long> processIds, Consumer<Integer> taskConsumer, String executeSourceType) {
        AdjustICContext ac = new AdjustICContext(modelId, mergeOrgId, yearId, periodId, scenarioId, currencyId, Lists.newArrayList((Object[])new Long[]{templateId}), processIds, executeSourceType);
        ac.setTaskConsumer(taskConsumer);
        return new AdjustRecordService(ac).generateAdjustInfo();
    }

    public static Map<String, String> generateAdj4SmartMerge(Long modelId, Long scenarioId, Long yearId, Long periodId, Long currencyId, Long mergeOrgId, Long processId) {
        PaperTmplChainFilter filter = new PaperTmplChainFilter(modelId, PaperTemplateTypeEnum.INNERTRADE, true);
        filter.addFilter(new VersionFilter(yearId, periodId)).addFilter(new OrgAssignFilter(Sets.newHashSet((Object[])new Long[]{mergeOrgId}))).addFilter(new SceneFilter(scenarioId)).addFilter(new YearPeriodFilter(yearId, periodId)).addFilter(new StatusFilter(true)).addFilter(new IntrRecordAddition(null, Sets.newHashSet((Object[])new Long[]{mergeOrgId}), scenarioId, yearId, periodId));
        Set<Long> tmplIds = filter.doFilter(null);
        if (!CollectionUtils.isEmpty(tmplIds)) {
            AdjustICContext ac = new AdjustICContext(modelId, mergeOrgId, yearId, periodId, scenarioId, currencyId, new ArrayList<Long>(tmplIds), processId == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Long[]{processId}), "0");
            Map<String, String> result = new AdjustRecordService(ac).generateAdjustInfo();
            if (result != null && "-1".equals(result.get("code"))) {
                throw new BcmTransferException(result.get("message"));
            }
            return result;
        }
        return null;
    }
}

