/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.adjust;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.check.AdjustBalanceCheckService;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingService;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.allinone.util.AllInOneUtils;
import kd.fi.bcm.business.innertrade.adjust.AdjustICContext;
import kd.fi.bcm.business.innertrade.adjust.AdjustReportData;
import kd.fi.bcm.business.innertrade.adjust.AdjustTmplSetting;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.adjust.AdjustBuilder;
import kd.fi.bcm.common.adjust.AdjustHeadDyn;
import kd.fi.bcm.common.adjust.IAdjustEntry;
import kd.fi.bcm.common.adjust.IAdjustHead;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustDataSortRuleEnum;
import kd.fi.bcm.common.enums.adjust.AdjustLinkCreateEnum;
import kd.fi.bcm.common.enums.adjust.LinkAdjustMappingEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.NumberUtil;

public class AdjustRecordService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AdjustRecordService.class.getClass());
    private static final String BN_FUN = "Bn()";
    private AdjustICContext ac;
    private Set<String> commonDims = Sets.newHashSet((Object[])new String[]{PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM});
    private AdjustBalanceCheckService adjustBalanceCheckService;
    private final List<String> CHECK_DIM = Lists.newArrayList((Object[])new String[]{"account", "changetype", "datasort", "multigaap", "dim1", "dim2", "dim3", "dim4", "dim5", "dim6"});

    public AdjustRecordService(AdjustICContext adjustICContext) {
        this.ac = adjustICContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> generateAdjustInfo() {
        log.startWatch();
        HashMap<String, String> result = new HashMap<String, String>(16);
        IDNumberTreeNode orgMember = MemberReader.findMemberById((long)this.ac.getModelId(), (String)"bcm_entitymembertree", (Long)this.ac.getMergeOrgId());
        int count = 0;
        try {
            this.checkOrgPeriodOpen(orgMember.getNumber());
            boolean isQuoteLocked = MergeControlHelper.isQuoteLocked(this.ac.getModelId(), this.ac.getScenarioId(), this.ac.getYearId(), this.ac.getPeriodId(), this.ac.getMergeOrgId());
            if (isQuoteLocked) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u5408\u5e76\u7ec4\u7ec7\u5728\u65b0\u60c5\u666f\u4e0b\u672a\u5f00\u542f\u7ec4\u7ec7\u7248\u672c\u5316\uff0c\u4e0d\u80fd\u751f\u6210\u62b5\u9500\u5206\u5f55\uff1a%s", (String)"AdjustRecordService_6", (String)"fi-bcm-business", (Object[])new Object[0]), orgMember.getNumber()));
            }
            this.ac.init();
            QFilter qFilter = new QFilter("model", "=", (Object)this.ac.getModelId());
            qFilter.and(new QFilter("templateid", "in", this.ac.getTmpIds()));
            qFilter.and(new QFilter("status", "=", (Object)"1"));
            if (!CollectionUtils.isEmpty(this.ac.getProcessIds())) {
                qFilter.and(new QFilter("process", "in", this.ac.getProcessIds()));
            }
            Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_adjsetting").getAllFields().keySet();
            fields = new HashSet(fields);
            fields.add("entryentity.seq");
            Map<Long, List<DynamicObject>> adjsettingMap = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_adjsetting", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{qFilter})).collect(Collectors.groupingBy(d -> d.getLong("templateid")));
            HashMap<Long, List<DynamicObject>> adjsettingAllMap = new HashMap<Long, List<DynamicObject>>(16);
            adjsettingMap.forEach((id, list) -> adjsettingAllMap.put((Long)id, new ArrayList(list)));
            int tmplCount = this.ac.getTmpIds().size();
            for (Long tmpId : this.ac.getTmpIds()) {
                try {
                    List<DynamicObject> adjsettings = adjsettingMap.get(tmpId);
                    if (adjsettings == null || adjsettings.isEmpty()) continue;
                    log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u521d\u59cb\u5316AdjustICContext\u8017\u65f6", orgMember.getNumber()));
                    this.removeSettingAndDelAdjust(tmpId, adjsettings);
                    log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u5220\u9664\u5386\u53f2\u5206\u5f55\u8017\u65f6", orgMember.getNumber()));
                    this.freshProcess(25 / tmplCount);
                    List<AdjustTmplSetting> tempSettingList = this.changeDynamicObjectToEntity(adjsettings);
                    log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u521d\u59cb\u5316\u6a21\u7248\u8017\u65f6", orgMember.getNumber()));
                    this.freshProcess(50 / tmplCount);
                    List<AdjustReportData> adjustReportData = this.generateAdjustDataBytmpl(tempSettingList, tmpId);
                    log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u51c6\u5907\u5206\u5f55\u6570\u636e\u8017\u65f6", orgMember.getNumber()));
                    this.freshProcess(75 / tmplCount);
                    int adjCount = this.saveAdjustInfo(tmpId, adjustReportData);
                    log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u4fdd\u5b58\u5b8c\u5206\u5f55\u6570\u636e\u8017\u65f6", orgMember.getNumber()));
                    this.freshProcess(100 / tmplCount);
                    count += adjCount;
                }
                catch (Exception e) {
                    DynamicObject templateInfo = IntrTemplateHelper.getTemplateInfo(this.ac.getModelId(), tmpId);
                    String message = e.getMessage();
                    if (templateInfo != null && "0".equals(this.ac.getExecuteSourceType())) {
                        message = String.format("%s %s %s", templateInfo.getString("number"), templateInfo.getString("name"), message);
                    }
                    if ("0".equals(this.ac.getExecuteSourceType())) {
                        log.error(String.format("\u7ec4\u7ec7 %s \u751f\u6210\u5206\u5f55\u53d1\u751f\u9519\u8bef\uff1a%s", orgMember.getNumber(), message));
                        continue;
                    }
                    throw new KDBizException(message);
                }
            }
            result.put("code", "0");
            result.put("message", this.getResultMessage(count, adjsettingAllMap));
            log.infoEnd(String.format(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u6761\u5206\u5f55\u3002", (String)"AdjustRecordHelper_01", (String)"fi-bcm-business", (Object[])new Object[0]), count));
        }
        catch (Exception e) {
            log.error(String.format("\u7ec4\u7ec7 %s\uff0c\u751f\u6210\u5206\u5f55\u53d1\u751f\u9519\u8bef,\n%s", orgMember.getNumber(), ThrowableHelper.toString((Exception)e)));
            result.put("code", "-1");
            result.put("message", String.format(ResManager.loadKDString((String)"\u751f\u6210\u5206\u5f55\u5931\u8d25\uff1a%s", (String)"AdjustRecordHelper_03", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            this.freshProcess(100);
        }
        return result;
    }

    private String getResultMessage(int count, Map<Long, List<DynamicObject>> adjsettingMap) {
        StringBuilder sb = new StringBuilder(String.format(ResManager.loadKDString((String)"\u6210\u529f\u751f\u6210%s\u6761\u5206\u5f55\u3002", (String)"AdjustRecordHelper_01", (String)"fi-bcm-business", (Object[])new Object[0]), count));
        if (!this.ac.getLockStageSchemes().isEmpty()) {
            this.ac.getLockStageSchemes().cellSet().forEach(cell -> {
                DynamicObject tmplInfo = this.ac.getTmplInfo().get(cell.getRowKey());
                Optional<DynamicObject> optional = ((List)adjsettingMap.get(cell.getRowKey())).stream().filter(e -> ((Long)cell.getColumnKey()).equals(e.getLong("id"))).findFirst();
                if (optional.isPresent() && tmplInfo != null) {
                    sb.append("\n");
                    sb.append(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u6a21\u677f%1$s(%2$s)\u5206\u5f55\u8bbe\u7f6e%3$s(%4$s)\u5982\u4e0b\u5206\u9636\u6bb5\u8bbe\u7f6e\u5df2\u9501\u5b9a:%5$s\uff0c\u5bf9\u5e94\u7684\u5206\u5f55\u4e0d\u80fd\u5220\u9664\u6216\u5ba1\u6838\u3002", (String)"AdjustRecordService_11", (String)"fi-bcm-business", (Object[])new Object[0]), tmplInfo.getString("name"), tmplInfo.getString("number"), optional.get().getString("name"), optional.get().getString("number"), String.join((CharSequence)",", ((Set)cell.getValue()).stream().map(p -> String.format("%s(%s)", p.p1, p.p2)).collect(Collectors.toSet()))));
                }
            });
        }
        if (!this.ac.getUnAutoAdjustLock().isEmpty()) {
            HashSet settingName = new HashSet(16);
            this.ac.getUnAutoAdjustLock().forEach((tId, sId) -> {
                DynamicObject tmplInfo = this.ac.getTmplInfo().get(tId);
                Optional<DynamicObject> optional = ((List)adjsettingMap.get(tId)).stream().filter(e -> sId.equals(e.getLong("id"))).findFirst();
                if (optional.isPresent() && tmplInfo != null) {
                    settingName.add(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u6a21\u677f%1$s(%2$s)\u5206\u5f55\u8bbe\u7f6e%3$s(%4$s)", (String)"AdjustRecordService_12", (String)"fi-bcm-business", (Object[])new Object[0]), tmplInfo.getString("name"), tmplInfo.getString("number"), optional.get().getString("name"), optional.get().getString("number")));
                }
            });
            if (!settingName.isEmpty()) {
                sb.append("\n");
                sb.append(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u5206\u5f55\u8bbe\u7f6e\u751f\u6210\u7684\u5206\u5f55\u5b58\u5728\u624b\u5de5\u4fee\u6539\uff0c\u5bf9\u5e94\u5206\u5f55\u8bbe\u7f6e\u4e0d\u80fd\u91cd\u65b0\u751f\u6210\u5206\u5f55\uff1a%s\u3002", (String)"AdjustRecordService_13", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", settingName)));
            }
        }
        return sb.toString();
    }

    private void removeSettingAndDelAdjust(Long tmpId, List<DynamicObject> adjsettings) {
        Map<Long, Pair<Boolean, Pair<Set<Long>, Set<Long>>>> pairMap = this.getAdjustInfo(adjsettings.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
        HashSet<Long> needDeleteAdjustIds = new HashSet<Long>(16);
        Iterator<DynamicObject> it = adjsettings.iterator();
        while (it.hasNext()) {
            DynamicObject setting = it.next();
            Pair<Boolean, Pair<Set<Long>, Set<Long>>> setPair = pairMap.get(setting.getLong("id"));
            if (setPair != null) {
                if (((Boolean)setPair.p1).booleanValue()) {
                    it.remove();
                    this.ac.getUnAutoAdjustLock().put((Object)tmpId, (Object)setting.getLong("id"));
                } else if (this.checkLockAdjust(setting, (Set)((Pair)setPair.p2).p2)) {
                    it.remove();
                } else {
                    needDeleteAdjustIds.addAll((Collection)((Pair)setPair.p2).p1);
                }
            }
            if (needDeleteAdjustIds.isEmpty()) continue;
            this.deleteAdjustInfo(needDeleteAdjustIds);
        }
    }

    private void freshProcess(int percent) {
        if (this.ac.getTaskConsumer() != null) {
            this.ac.getTaskConsumer().accept(percent);
        }
    }

    private Map<Long, Pair<Boolean, Pair<Set<Long>, Set<Long>>>> getAdjustInfo(Set<Long> adjSettingIds) {
        HashMap<Long, Pair<Boolean, Pair<Set<Long>, Set<Long>>>> result = new HashMap<Long, Pair<Boolean, Pair<Set<Long>, Set<Long>>>>(16);
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_linkadjust_mapping", (String)"elim.id,elim.sourcetype,elim.status,linkid", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.ac.getModelId()), new QFilter("biztype", "=", (Object)LinkAdjustMappingEnum.INTER_TRADE_ADJSETTING.getBizType()), new QFilter("elim.year", "=", (Object)this.ac.getYearId()), new QFilter("elim.scenario", "=", (Object)this.ac.getScenarioId()), new QFilter("elim.period", "=", (Object)this.ac.getPeriodId()), new QFilter("elim.entity", "=", (Object)this.ac.getMergeOrgId()), new QFilter("linkid", "in", adjSettingIds)});
        if (mappings != null && !mappings.isEmpty()) {
            Map<Long, List<DynamicObject>> mappingMap = mappings.stream().collect(Collectors.groupingBy(e -> e.getLong("linkid")));
            mappingMap.forEach((adjSettingId, list) -> {
                HashSet<Long> autoAdjustIds = new HashSet<Long>(16);
                HashSet<Long> auditAdjustIds = new HashSet<Long>(16);
                boolean isLock = false;
                for (DynamicObject m : list) {
                    if (m.getInt("elim.sourcetype") == ElimRptAdjSourceTypeEnum.AUTO.getValue()) {
                        autoAdjustIds.add(m.getLong("elim.id"));
                        if (!RptAdjustStatusEnum.AUDIT.status().equals(m.getString("elim.status"))) continue;
                        auditAdjustIds.add(m.getLong("elim.id"));
                        continue;
                    }
                    isLock = true;
                }
                result.put((Long)adjSettingId, (Pair<Boolean, Pair<Set<Long>, Set<Long>>>)Pair.onePair((Object)isLock, (Object)Pair.onePair(autoAdjustIds, auditAdjustIds)));
            });
        }
        return result;
    }

    private boolean checkLockAdjust(DynamicObject setting, Set<Long> adjustIds) {
        if (CollectionUtils.isEmpty(adjustIds)) {
            return false;
        }
        Map<Long, HashBasedTable<Long, Long, List<String>>> checkResult = AdjustOperationHelper.batchCheckOlapDataLockByLinkIds(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613-\u5220\u9664\u5206\u5f55", (String)"AdjustRecordService_10", (String)"fi-bcm-business", (Object[])new Object[0]), new AdjustOperationContext(this.ac.getModelId(), this.ac.getScenarioId(), this.ac.getYearId(), this.ac.getPeriodId()), adjustIds, pair -> {
            HashSet pairSet = (HashSet)this.ac.getLockStageSchemes().get((Object)setting.getLong("templateid"), (Object)setting.getLong("id"));
            if (pairSet == null) {
                pairSet = new HashSet((Collection)pair.p2);
            } else {
                pairSet.addAll((Collection)pair.p2);
            }
            this.ac.getLockStageSchemes().put((Object)setting.getLong("templateid"), (Object)setting.getLong("id"), pairSet);
            return "";
        });
        if (!checkResult.isEmpty()) {
            log.error("\u7ef4\u5ea6\u7ec4\u7ec7\u5df2\u88ab\u9501\u5b9a\uff0ccheckResult\uff1a" + checkResult);
            return true;
        }
        return false;
    }

    private void deleteAdjustInfo(Set<Long> adjustIds) {
        OperationResult operationResult = AdjustClearServiceHelper.batchDeleteAutoAdjust("innertrade:AdjustRecordServicedeleteAdjustInfo", this.ac.getModelId(), this.ac.getScenarioId(), this.ac.getYearId(), this.ac.getPeriodId(), new ArrayList<Long>(adjustIds));
        if (!operationResult.isSuccess()) {
            log.error(String.format("deleteAdjustInfo error, Message: %1$s   AllErrorInfo :%2$s ", operationResult.getMessage(), operationResult.getAllErrorInfo().toString()));
            throw new KDBizException(String.format("AdjustClearServiceHelper.batchDeleteAutoAdjust :Message:%1$s   AllErrorInfo :%2$s ", operationResult.getMessage(), operationResult.getAllErrorInfo().toString()));
        }
    }

    private List<AdjustTmplSetting> changeDynamicObjectToEntity(List<DynamicObject> adjsettings) {
        ArrayList<AdjustTmplSetting> result = new ArrayList<AdjustTmplSetting>(16);
        for (DynamicObject dy : adjsettings) {
            AdjustTmplSetting adjustTmplSetting = new AdjustTmplSetting();
            adjustTmplSetting.setId(dy.getLong("id"));
            adjustTmplSetting.setModelId(dy.getLong("model.id"));
            adjustTmplSetting.setTemplateId(dy.getLong("templateid"));
            DynamicObject tmplDyn = this.ac.getTmplInfo().get(dy.getLong("templateid"));
            if (tmplDyn != null) {
                adjustTmplSetting.setTemplateNumber(tmplDyn.getString("number"));
            }
            adjustTmplSetting.setScenarioId(this.ac.getScenarioId());
            adjustTmplSetting.setStatus(dy.getString("status"));
            adjustTmplSetting.setNumber(dy.getString("number"));
            adjustTmplSetting.setName(dy.getString("name"));
            adjustTmplSetting.setBusinessType(dy.getString("businesstype"));
            adjustTmplSetting.setJournalType(dy.getString("journaltype"));
            adjustTmplSetting.setProcessId(dy.getLong("process.id"));
            adjustTmplSetting.setDescription(dy.getString("description"));
            adjustTmplSetting.setYearId(this.ac.getYearId());
            adjustTmplSetting.setPeriodId(this.ac.getPeriodId());
            adjustTmplSetting.setMergeOrgId(this.ac.getMergeOrgId());
            adjustTmplSetting.setCurrencyId(this.ac.getCurrencyId());
            adjustTmplSetting.setLinkageType(dy.getInt("islinkage"));
            adjustTmplSetting.setAdjustCatalogId(dy.getLong("adjustcatalog.id"));
            HashSet<AdjustTmplSetting.Entry> entrySet = new HashSet<AdjustTmplSetting.Entry>(16);
            DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
            if (entryentity != null && entryentity.size() > 0) {
                for (DynamicObject entry : entryentity) {
                    AdjustTmplSetting.Entry tmplEntry = new AdjustTmplSetting.Entry();
                    tmplEntry.setId(entry.getLong("id"));
                    tmplEntry.setAccount(entry.getLong("accountdyn.id"));
                    tmplEntry.setAccountNum(entry.getString("accountdyn.number"));
                    tmplEntry.setAccountType(entry.getString("accountclasstype"));
                    tmplEntry.setAudittrail(entry.getLong("audittraildyn.id"));
                    tmplEntry.setAudittrailNum(entry.getString("audittraildyn.number"));
                    tmplEntry.setAudittrailType(entry.getString("audittrailclasstype"));
                    tmplEntry.setDim1(entry.getLong("dim1dyn.id"));
                    tmplEntry.setDim1Num(entry.getString("dim1dyn.number"));
                    tmplEntry.setDim1Type(entry.getString("dim1classtype"));
                    tmplEntry.setDim2(entry.getLong("dim2dyn.id"));
                    tmplEntry.setDim2Num(entry.getString("dim2dyn.number"));
                    tmplEntry.setDim2Type(entry.getString("dim2classtype"));
                    tmplEntry.setDim3(entry.getLong("dim3dyn.id"));
                    tmplEntry.setDim3Num(entry.getString("dim3dyn.number"));
                    tmplEntry.setDim3Type(entry.getString("dim3classtype"));
                    tmplEntry.setDim4(entry.getLong("dim4dyn.id"));
                    tmplEntry.setDim4Num(entry.getString("dim4dyn.number"));
                    tmplEntry.setDim4Type(entry.getString("dim4classtype"));
                    tmplEntry.setDim5(entry.getLong("dim5dyn.id"));
                    tmplEntry.setDim5Num(entry.getString("dim5dyn.number"));
                    tmplEntry.setDim5Type(entry.getString("dim5classtype"));
                    tmplEntry.setDim6(entry.getLong("dim6dyn.id"));
                    tmplEntry.setDim6Num(entry.getString("dim6dyn.number"));
                    tmplEntry.setDim6Type(entry.getString("dim6classtype"));
                    tmplEntry.setDatasort(entry.getLong("datasortdyn.id"));
                    tmplEntry.setDatasortNum(entry.getString("datasortdyn.number"));
                    tmplEntry.setDatasortType(entry.getString("datasortclasstype"));
                    tmplEntry.setMultigaap(entry.getLong("multigaapdyn.id"));
                    tmplEntry.setMultigaapNum(entry.getString("multigaapdyn.number"));
                    tmplEntry.setMultigaapType(entry.getString("multigaapclasstype"));
                    tmplEntry.setChangetype(entry.getLong("changetypedyn.id"));
                    tmplEntry.setChangetypeNum(entry.getString("changetypedyn.number"));
                    tmplEntry.setChangetypeType(entry.getString("changetypeclasstype"));
                    tmplEntry.setEntity(entry.getString("entity"));
                    tmplEntry.setMycompany(entry.getString("mycompany"));
                    tmplEntry.setOpcompany(entry.getString("opcompany"));
                    String filed = StringUtils.isNotEmpty((String)entry.getString("debit")) ? entry.getString("debit") : entry.getString("credit");
                    tmplEntry.setDebit(entry.getString("debit"));
                    tmplEntry.setCredit(entry.getString("credit"));
                    tmplEntry.setBn(BN_FUN.equals(filed));
                    tmplEntry.setFieldIds(Sets.newHashSet());
                    tmplEntry.setSeq(entry.getInt("seq"));
                    if (BN_FUN.equals(filed)) {
                        adjustTmplSetting.setAudittrailId(tmplEntry.getAudittrail());
                        adjustTmplSetting.setDatasortId(tmplEntry.getDatasort());
                        adjustTmplSetting.setMultigaapId(tmplEntry.getMultigaap());
                    } else {
                        HashSet<String> fieldSet = new HashSet<String>(16);
                        fieldSet.add(filed);
                        tmplEntry.setFieldIds(fieldSet);
                    }
                    entrySet.add(tmplEntry);
                }
            }
            adjustTmplSetting.setEntryCol(entrySet);
            result.add(adjustTmplSetting);
        }
        return result;
    }

    private List<AdjustReportData> generateAdjustDataBytmpl(List<AdjustTmplSetting> tempSettingList, Long tmpId) {
        IDNumberTreeNode yearNode = MemberReader.findMemberById((long)((Long)this.ac.getModel().p1), (String)"bcm_fymembertree", (Long)((Long)this.ac.getYear().p1));
        IDNumberTreeNode periodNode = MemberReader.findMemberById((long)((Long)this.ac.getModel().p1), (String)"bcm_periodmembertree", (Long)((Long)this.ac.getPeriod().p1));
        Map<String, String> cusDimMap = this.ac.getAllDims().values().stream().filter(e -> !e.getBoolean("issysdimension")).collect(Collectors.toMap(k -> k.getString("fieldmapped"), v -> v.getString("number")));
        IntrMergeParam param = new IntrMergeParam(this.ac.getModel(), tmpId, this.ac.getEntity(), this.ac.getScenario(), this.ac.getYear(), this.ac.getPeriod(), this.ac.getCurrency());
        IntrTable intrTable = QueryIntrDataHelper.queryIntrDataByParam(param);
        ArrayList<AdjustReportData> result = new ArrayList<AdjustReportData>(16);
        if (intrTable != null && intrTable.getRows() != null && intrTable.getRows().size() > 0) {
            Map<String, String> fieldIdNumMap = intrTable.getHead().stream().collect(Collectors.toMap(e -> e.getId() == null ? e.getNumber() : e.getId().toString(), IntrField::getNumber, (e1, e2) -> e2));
            for (IntrRow row : intrTable.getRows()) {
                if (row.getData().get("INTR_001") == null || !StringUtils.isNotEmpty((String)((String)row.getData().get("INTR_001")))) continue;
                String salerOrgNum = row.getData().get(IntrConstant.FIELD_ORG_NUMBER).toString();
                String buyerOrgNum = row.getData().get(IntrConstant.FIELD_IC_NUMBER).toString();
                String businessType = row.getData().get("INTR_001").toString();
                Set settings = tempSettingList.stream().filter(e -> e.getBusinessType().equals(businessType)).collect(Collectors.toSet());
                for (AdjustTmplSetting adjustTmplSetting : settings) {
                    AdjustReportData reportData = new AdjustReportData(adjustTmplSetting);
                    reportData.setRow(row);
                    reportData.setSalerOrgId(this.findOrgIdByNum(salerOrgNum));
                    reportData.setSalerOrgNumber(salerOrgNum);
                    reportData.setBuyerOrgId(this.findOrgIdByNum(buyerOrgNum));
                    reportData.setBuyerOrgNumber(buyerOrgNum);
                    reportData.setAdjname(String.format("%s(%s)_%s_%s", adjustTmplSetting.getName(), businessType, yearNode.getName(), periodNode.getName()));
                    reportData.setReportRowId(row.getId());
                    reportData.setAccount(row.getData().get("Account") == null ? "" : row.getData().get("Account").toString());
                    reportData.setAudittrail(row.getData().get("AuditTrail") == null ? "" : row.getData().get("AuditTrail").toString());
                    reportData.setDim1(cusDimMap.containsKey("dim1") && row.getData().get(cusDimMap.get("dim1")) != null ? row.getData().get(cusDimMap.get("dim1")).toString() : "");
                    reportData.setDim2(cusDimMap.containsKey("dim2") && row.getData().get(cusDimMap.get("dim2")) != null ? row.getData().get(cusDimMap.get("dim2")).toString() : "");
                    reportData.setDim3(cusDimMap.containsKey("dim3") && row.getData().get(cusDimMap.get("dim3")) != null ? row.getData().get(cusDimMap.get("dim3")).toString() : "");
                    reportData.setDim4(cusDimMap.containsKey("dim4") && row.getData().get(cusDimMap.get("dim4")) != null ? row.getData().get(cusDimMap.get("dim4")).toString() : "");
                    reportData.setDim5(cusDimMap.containsKey("dim5") && row.getData().get(cusDimMap.get("dim5")) != null ? row.getData().get(cusDimMap.get("dim5")).toString() : "");
                    reportData.setDim6(cusDimMap.containsKey("dim6") && row.getData().get(cusDimMap.get("dim6")) != null ? row.getData().get(cusDimMap.get("dim6")).toString() : "");
                    reportData.setDatasort(row.getData().get("DataSort") == null ? "" : row.getData().get("DataSort").toString());
                    reportData.setMultigaap(row.getData().get("MultiGAAP") == null ? "" : row.getData().get("MultiGAAP").toString());
                    reportData.setChangetype(row.getData().get("ChangeType") == null ? "" : row.getData().get("ChangeType").toString());
                    ArrayList<AdjustReportData.Entry> entries = new ArrayList<AdjustReportData.Entry>(16);
                    Set<AdjustTmplSetting.Entry> tmplEntrySet = adjustTmplSetting.getEntryCol();
                    tmplEntrySet.forEach(tmplEntry -> {
                        AdjustReportData.Entry entryData = new AdjustReportData.Entry((AdjustTmplSetting.Entry)tmplEntry);
                        if (!tmplEntry.isBn() && tmplEntry.getFieldIds() != null && tmplEntry.getFieldIds().stream().findFirst().isPresent()) {
                            String fieldId = (String)tmplEntry.getFieldIds().stream().findFirst().get();
                            Object amount = row.getData().getOrDefault(fieldIdNumMap.get(fieldId), BigDecimal.ZERO);
                            if (!NumberUtil.isNumeric((String)amount.toString())) {
                                amount = BigDecimal.ZERO;
                            }
                            if (StringUtils.isNotEmpty((String)tmplEntry.getDebit())) {
                                entryData.setDebitAmount(new BigDecimal(amount.toString()));
                            } else {
                                entryData.setCreditAmount(new BigDecimal(amount.toString()));
                            }
                        }
                        entries.add(entryData);
                    });
                    if (entries.size() > 0) {
                        reportData.setEntries(entries);
                    }
                    if (reportData.getEntries() == null || reportData.getEntries().size() <= 0) continue;
                    result.add(reportData);
                }
            }
        }
        return result;
    }

    private Long findOrgIdByNum(String orgNum) {
        Pair<Long, String> pair = this.ac.getSortedOrgByChangeType().get(orgNum);
        if (pair != null && (Long)pair.p1 != -1L) {
            return (Long)pair.p1;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u751f\u6210\u5206\u5f55\u7684\u7ec4\u7ec7\uff1a%s", (String)"AdjustRecordHelper_06", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
    }

    private int saveAdjustInfo(Long tmpId, List<AdjustReportData> reportDataList) {
        if (reportDataList == null || reportDataList.size() == 0) {
            return 0;
        }
        ArrayList adjustLingMapping = new ArrayList(16);
        HashMap adjustToSettingMap = new HashMap(16);
        HashMap<Long, List> adjusts = new HashMap<Long, List>(16);
        reportDataList.forEach(e -> adjusts.computeIfAbsent(e.getTmplSetting().getId(), k -> new ArrayList(16)).add(e));
        AdjustBuilder adjustBuilder = new AdjustBuilder(this.ac.getModelId().longValue(), this.ac.getScenarioId().longValue(), this.ac.getYearId().longValue(), this.ac.getPeriodId().longValue(), AdjustHeadDyn::new);
        adjustBuilder.setCodeRuleFunc(String[]::new);
        adjusts.forEach((tmpSettingId, reportDatas) -> {
            if (!reportDatas.isEmpty()) {
                this.buildAdjust((AdjustBuilder<IAdjustHead>)adjustBuilder, (List<AdjustReportData>)reportDatas);
                if (!CollectionUtils.isEmpty((Collection)adjustBuilder.getCurrent().getEntrys())) {
                    DynamicObject head = (DynamicObject)adjustBuilder.getCurrent().getData();
                    this.genLinkAdjustMapping(this.ac.getModelId(), ((AdjustReportData)reportDatas.get(0)).getTmplSetting().getId(), LinkAdjustMappingEnum.INTER_TRADE_ADJSETTING.getBizType(), head, adjustLingMapping);
                    adjustToSettingMap.put(adjustBuilder.getCurrent().getId(), ((AdjustReportData)reportDatas.get(0)).getTmplSetting().getId());
                    for (AdjustReportData reportData : reportDatas) {
                        this.genLinkAdjustMapping(this.ac.getModelId(), reportData.getReportRowId(), LinkAdjustMappingEnum.INTER_TRADE_EXTDATA.getBizType(), head, adjustLingMapping);
                    }
                }
            }
        });
        Pair adjustPair = adjustBuilder.buildDynamic();
        if (!((Collection)adjustPair.p1).isEmpty()) {
            AdjustOperationHelper.batchSetNumbers("bcm_rptadjust", new ArrayList<DynamicObject>((Collection)adjustPair.p1));
            List<Long> elimDynaPks = ((Collection)adjustPair.p1).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            List<Long> autoLinkElimDynaPks = ((Collection)adjustPair.p1).stream().filter(e -> AdjustLinkCreateEnum.AUTOCREATEADJUST.getStatus().equals(e.getString("linkcreatetype"))).map(e -> e.getLong("id")).collect(Collectors.toList());
            try (TXHandle tx = TX.required();){
                try {
                    DynamicObject elim = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
                    SaveServiceHelper.save((IDataEntityType)elim.getDynamicObjectType(), (Object[])((Collection)adjustPair.p1).toArray(new Object[0]));
                    DynamicObject elimdata = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata");
                    Object[] elimDatas = (DynamicObject[])((Map)adjustPair.p2).values().stream().flatMap(e -> e.stream()).toArray(DynamicObject[]::new);
                    AdjustConvertUtil.batchResetSeq(Arrays.asList(elimDatas), true, AdjustDataSortRuleEnum.GROUPSEQ_SORT);
                    SaveServiceHelper.save((IDataEntityType)elimdata.getDynamicObjectType(), (Object[])elimDatas);
                    DynamicObject mapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_linkadjust_mapping");
                    SaveServiceHelper.save((IDataEntityType)mapping.getDynamicObjectType(), (Object[])adjustLingMapping.toArray(new Object[0]));
                    HashMap<Long, Long> linkAdjustMap = new HashMap<Long, Long>(16);
                    if (autoLinkElimDynaPks.size() > 0) {
                        LinkageMappingService.newObject(autoLinkElimDynaPks, EntrySourceEnum.CHECKLINKAGECREATE).buildAutoElimLinkage();
                        DynamicObjectCollection linkDyns = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id,linkagelinksource", (QFilter[])new QFilter("linkagelinksource", "in", elimDynaPks).toArray());
                        if (!CollectionUtils.isEmpty((Collection)linkDyns)) {
                            for (DynamicObject linkDyn : linkDyns) {
                                elimDynaPks.add(linkDyn.getLong("id"));
                                linkAdjustMap.put(linkDyn.getLong("id"), linkDyn.getLong("linkagelinksource"));
                            }
                        }
                    }
                    HashMap<Long, Set> adjustLockInfo = new HashMap<Long, Set>(16);
                    HashSet lockAdjustIds = new HashSet(16);
                    AdjustOperationHelper.batchCheckOlapDataLockByIds(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613-\u751f\u6210\u5206\u5f55", (String)"AdjustRecordService_9", (String)"fi-bcm-business", (Object[])new Object[0]), new AdjustOperationContext(this.ac.getModelId(), this.ac.getScenarioId(), this.ac.getYearId(), this.ac.getPeriodId()), elimDynaPks, pair -> {
                        Long adjustId = ((IDynamicObjectModel)pair.p1).getBaseDataId("adjust");
                        lockAdjustIds.add(adjustId);
                        linkAdjustMap.entrySet().stream().filter(e -> ((Long)e.getKey()).equals(adjustId) || ((Long)e.getValue()).equals(adjustId)).forEach(e -> {
                            lockAdjustIds.add(e.getKey());
                            lockAdjustIds.add(e.getValue());
                        });
                        Long sourceAdjustId = linkAdjustMap.getOrDefault(adjustId, adjustId);
                        HashSet set = (HashSet)adjustLockInfo.get(sourceAdjustId);
                        if (set == null) {
                            set = new HashSet((Collection)pair.p2);
                        } else {
                            set.addAll((Collection)pair.p2);
                        }
                        adjustLockInfo.put(sourceAdjustId, set);
                        return "";
                    });
                    adjustLockInfo.forEach((adjustId, set) -> {
                        Long settingId = (Long)adjustToSettingMap.get(adjustId);
                        HashSet pairSet = (HashSet)this.ac.getLockStageSchemes().get((Object)tmpId, (Object)settingId);
                        if (pairSet == null) {
                            pairSet = new HashSet(set);
                        } else {
                            pairSet.addAll(set);
                        }
                        this.ac.getLockStageSchemes().put((Object)tmpId, (Object)settingId, pairSet);
                    });
                    elimDynaPks.removeAll(lockAdjustIds);
                    if (!elimDynaPks.isEmpty()) {
                        AdjustCheckServiceHelper.doSysToMdd(this.ac.getModelId(), this.ac.getScenarioId(), this.ac.getYearId(), this.ac.getPeriodId(), elimDynaPks, true);
                    }
                }
                catch (Throwable t) {
                    tx.markRollback();
                    log.error("--AdjustRecordService.saveAdjustInfo--:\n" + ThrowableHelper.toString((Throwable)t));
                    throw new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0]);
                }
            }
        }
        return ((Collection)adjustPair.p1).size();
    }

    public Map<String, String> batchQueryElimNumber(List<AdjustReportData> reportDataList) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        reportDataList.forEach(r -> result.put(this.ac.getMergeOrgNumber() + "&" + r.getTmplSetting().getId(), null));
        int nullSize = result.size();
        if (nullSize > 0) {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_intrreportentity");
            dy.set("createtime", (Object)TimeServiceHelper.now());
            String[] number = CodeRuleServiceHelper.getBatchNumber((String)"bcm_intrreportentity", (DynamicObject)dy, null, (int)nullSize);
            if (number == null || number.length != nullSize) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"CheckRecordHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ArrayList keys = Lists.newArrayList(result.keySet());
            for (int i = 0; i < nullSize; ++i) {
                result.put((String)keys.get(i), number[i]);
            }
        }
        return result;
    }

    private void buildAdjustHeader(AdjustReportData reportData, IAdjustHead adjustHead) {
        AdjustTmplSetting tmplSetting = reportData.getTmplSetting();
        adjustHead.setStatus(RptAdjustStatusEnum.SAVE);
        adjustHead.setName(reportData.getAdjname());
        adjustHead.set("audittrail", (Object)tmplSetting.getAudittrailId());
        adjustHead.setBalancetype(BalanceTypeEnum.BALANCE);
        if (tmplSetting.getLinkageType() == 1) {
            adjustHead.setLinkcreatetype(AdjustLinkCreateEnum.AUTOCREATEADJUST);
        } else if (tmplSetting.getLinkageType() == 0) {
            adjustHead.setLinkcreatetype(AdjustLinkCreateEnum.MANUALCREATEADJUST);
        } else {
            adjustHead.setLinkcreatetype(AdjustLinkCreateEnum.COMMONADJUST);
        }
        adjustHead.setDescription(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5e95\u7a3f\u751f\u6210(%1$s)(%2$s)", (String)"AdjustRecordHelper_09", (String)"fi-bcm-business", (Object[])new Object[0]), tmplSetting.getTemplateNumber(), tmplSetting.getNumber()));
        adjustHead.setEntity(tmplSetting.getMergeOrgId());
        IDNumberTreeNode processMember = MemberReader.findProcessMemberById((String)MemberReader.findModelNumberById((Object)tmplSetting.getModelId()), (Long)tmplSetting.getProcessId());
        adjustHead.setBussnesstype(BusinessTypeEnum.searchByProcessNumber((String)processMember.getNumber()));
        adjustHead.set("journaltype", (Object)tmplSetting.getJournalType());
        adjustHead.set("checkstatus", (Object)"1");
        adjustHead.isMultiplecurrency(false);
        adjustHead.setSourceType(ElimRptAdjSourceTypeEnum.AUTO);
        adjustHead.set("entrysource", (Object)"0");
        adjustHead.set("linkagelinksource", (Object)0);
        adjustHead.set("templatecatalog", (Object)tmplSetting.getAdjustCatalogId());
        int seq = 0;
        adjustHead.addCommonPageMemberDim(Long.valueOf(this.ac.getAllDims().get(PresetConstant.FY_DIM).getLong("id")), tmplSetting.getYearId(), Integer.valueOf(seq++));
        adjustHead.addCommonPageMemberDim(Long.valueOf(this.ac.getAllDims().get(PresetConstant.PERIOD_DIM).getLong("id")), tmplSetting.getPeriodId(), Integer.valueOf(seq++));
        adjustHead.addCommonPageMemberDim(Long.valueOf(this.ac.getAllDims().get(PresetConstant.SCENE_DIM).getLong("id")), this.ac.getScenarioId(), Integer.valueOf(seq++));
        adjustHead.addCommonPageMemberDim(Long.valueOf(this.ac.getAllDims().get(PresetConstant.PROCESS_DIM).getLong("id")), tmplSetting.getProcessId(), Integer.valueOf(seq++));
        adjustHead.addCommonPageMemberDim(Long.valueOf(this.ac.getAllDims().get(PresetConstant.CURRENCY_DIM).getLong("id")), tmplSetting.getCurrencyId(), Integer.valueOf(seq++));
        int seqspread = 0;
        for (String dim : this.ac.getAllDims().keySet()) {
            if (this.commonDims.contains(dim)) continue;
            adjustHead.addSpreadMemberDim(Long.valueOf(this.ac.getAllDims().get(dim).getLong("id")), Integer.valueOf(seqspread++));
        }
    }

    private void genLinkAdjustMapping(Long modelId, Long linkId, String bizType, DynamicObject elimInfo, List<DynamicObject> AdjustLingMapping) {
        DynamicObject rowDataMapping = BusinessDataServiceHelper.newDynamicObject((String)"bcm_linkadjust_mapping");
        rowDataMapping.set("model", (Object)modelId);
        rowDataMapping.set("linkid", (Object)linkId);
        rowDataMapping.set("elim", (Object)elimInfo);
        rowDataMapping.set("biztype", (Object)bizType);
        AdjustLingMapping.add(rowDataMapping);
    }

    private void buildAdjust(AdjustBuilder<IAdjustHead> adjustBuilder, List<AdjustReportData> reportDatas) {
        ArrayList needDeleteAdjustReportData = new ArrayList(16);
        Map<String, String> dimNumbers = this.ac.getAllDims().values().stream().collect(Collectors.toMap(k -> k.getBoolean("issysdimension") ? k.getString("number").toLowerCase() : k.getString("fieldmapped").toLowerCase(), v -> v.getString("number")));
        adjustBuilder.newAdjustHead(adjustHead -> {
            this.buildAdjustHeader((AdjustReportData)reportDatas.get(0), (IAdjustHead)adjustHead);
            adjustHead.getId();
        });
        HashMap<String, Pair> bnMap = new HashMap<String, Pair>(16);
        AtomicInteger group = new AtomicInteger(1);
        for (AdjustReportData reportData : reportDatas) {
            reportData.getEntries().sort(Comparator.comparing(e -> e.getTmplSettingEntry().getSeq()));
            String groupNum = "G" + group.getAndIncrement();
            AtomicBoolean addEntrySuccess = new AtomicBoolean(true);
            for (AdjustReportData.Entry entryData : reportData.getEntries()) {
                if (!addEntrySuccess.get()) continue;
                if (entryData.getTmplSettingEntry().isBn()) {
                    bnMap.putIfAbsent(groupNum, Pair.onePair((Object)reportData, (Object)entryData));
                }
                if (entryData.getDebitAmount().compareTo(BigDecimal.ZERO) == 0 && entryData.getCreditAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                adjustBuilder.addEntry(groupNum, (head, entry) -> {
                    if (!this.buildAdjustEntry((IAdjustHead)head, (IAdjustEntry)entry, reportData, entryData, dimNumbers)) {
                        head.getEntrys().removeIf(e -> e.getGroupNum().equals(entry.getGroupNum()));
                        needDeleteAdjustReportData.add(reportData);
                        addEntrySuccess.set(false);
                    }
                });
            }
        }
        if (this.adjustBalanceCheckService == null) {
            this.adjustBalanceCheckService = new AdjustBalanceCheckService(this.ac.getModelId());
        }
        Pair adjust = adjustBuilder.getCurrent().genDynamic();
        boolean isNoBalance = this.adjustBalanceCheckService.computeIfNoBalance(BalanceTypeEnum.BALANCE, (DynamicObject)adjust.p1, (Collection)adjust.p2, e -> {
            Pair pair = (Pair)bnMap.get(e.getGroupKey());
            if (pair == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u8bbe\u7f6e\u672a\u914d\u7f6e\u5e73\u8861\u6570\u3002", (String)"AdjustReportData_01", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            AdjustReportData.Entry entry = (AdjustReportData.Entry)pair.p2;
            AdjustReportData reportData = (AdjustReportData)pair.p1;
            Long bnAccountId = this.getMemberIdBySign(reportData, entry.getTmplSettingEntry(), "account", dimNumbers);
            boolean isDcBn = DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(MemberReader.findMemberById((long)reportData.getTmplSetting().getModelId(), (String)"bcm_accountmembertree", (Long)bnAccountId).getProperty("drcrdirect"));
            BigDecimal diffSum = e.getDiffSum();
            if (isDcBn) {
                if (StringUtils.isNotEmpty((String)entry.getTmplSettingEntry().getCredit())) {
                    entry.setCreditAmount(diffSum);
                } else {
                    entry.setDebitAmount(diffSum.negate());
                }
            } else if (StringUtils.isNotEmpty((String)entry.getTmplSettingEntry().getDebit())) {
                entry.setDebitAmount(diffSum.negate());
            } else {
                entry.setCreditAmount(diffSum);
            }
            List rows = e.getRows();
            DynamicObject dy = (DynamicObject)rows.get(rows.size() - 1);
            String groupnum = dy.getString("groupnum");
            adjustBuilder.addEntry(groupnum, (head, adjustData) -> {
                if (this.buildAdjustEntry((IAdjustHead)head, (IAdjustEntry)adjustData, reportData, entry, dimNumbers)) {
                    this.adjustBalanceCheckService.resetAdjustDataMoneyRedirect(adjustData.genDynamic());
                } else {
                    head.getEntrys().removeIf(en -> en.getGroupNum().equals(groupnum));
                    needDeleteAdjustReportData.add(reportData);
                }
            });
        });
        reportDatas.removeAll(needDeleteAdjustReportData);
    }

    private boolean buildAdjustEntry(IAdjustHead head, IAdjustEntry entry, AdjustReportData reportData, AdjustReportData.Entry entryData, Map<String, String> dimNumbers) {
        AdjustTmplSetting.Entry tmplSettingEntry = entryData.getTmplSettingEntry();
        entry.setAudittrailId(this.getMemberIdBySign(reportData, tmplSettingEntry, "audittrail", dimNumbers));
        entry.setEntity(this.getOrgIdByDimType(PresetConstant.ENTITY_DIM, reportData, entryData));
        entry.setMerge(reportData.getTmplSetting().getMergeOrgId().longValue());
        entry.setMyCompanyId(this.getOrgIdByDimType(PresetConstant.MYCOMPANY_DIM, reportData, entryData));
        entry.setInternalCompanyId(this.getOrgIdByDimType(PresetConstant.INTERNALCOMPANY_DIM, reportData, entryData).longValue());
        entry.setAccountId(this.getMemberIdBySign(reportData, tmplSettingEntry, "account", dimNumbers));
        entry.setChangeTypeId(this.getMemberIdBySign(reportData, tmplSettingEntry, "changetype", dimNumbers));
        entry.setCurrencyId(reportData.getTmplSetting().getCurrencyId());
        entry.setMultigaapId(this.getMemberIdBySign(reportData, tmplSettingEntry, "multigaap", dimNumbers));
        entry.setDataSort(this.getMemberIdBySign(reportData, tmplSettingEntry, "datasort", dimNumbers));
        entry.setDim1(this.getMemberIdBySign(reportData, tmplSettingEntry, "dim1", dimNumbers).longValue());
        entry.setDim2(this.getMemberIdBySign(reportData, tmplSettingEntry, "dim2", dimNumbers).longValue());
        entry.setDim3(this.getMemberIdBySign(reportData, tmplSettingEntry, "dim3", dimNumbers).longValue());
        entry.setDim4(this.getMemberIdBySign(reportData, tmplSettingEntry, "dim4", dimNumbers).longValue());
        entry.setDim5(this.getMemberIdBySign(reportData, tmplSettingEntry, "dim5", dimNumbers).longValue());
        entry.setDim6(this.getMemberIdBySign(reportData, tmplSettingEntry, "dim6", dimNumbers).longValue());
        entry.setDescription(reportData.getTmplSetting().getName());
        entry.setEntrySource(EntrySourceEnum.CHECKAUTOCREATE);
        entry.set("checkrecordentry", (Object)tmplSettingEntry.getId());
        entry.set("dseq", (Object)tmplSettingEntry.getSeq());
        entry.setDebit(entryData.getDebitAmount());
        entry.setCredit(entryData.getCreditAmount());
        return this.checkAdjust(entry.genDynamic(), dimNumbers, reportData, tmplSettingEntry);
    }

    private boolean checkAdjust(DynamicObject dyn, Map<String, String> dimNumbers, AdjustReportData reportData, AdjustTmplSetting.Entry tmplSettingEntry) {
        String modelNum = MemberReader.findModelNumberById((Object)this.ac.getModelId());
        for (String dimNum : this.CHECK_DIM) {
            if (!dimNumbers.containsKey(dimNum)) continue;
            long memberId = dyn.getLong(dimNum);
            IDNumberTreeNode node = MemberReader.findMemberById((long)this.ac.getModelId(), (String)MemberReader.getEntityNumberByDim((String)modelNum, (String)dimNumbers.get(dimNum)), (Long)memberId);
            if ("account".equals(dimNum)) {
                boolean isaccountoffset;
                boolean bl = isaccountoffset = node.getProperty("accountpart.isaccountoffset") != null && Boolean.parseBoolean(node.getProperty("accountpart.isaccountoffset").toString());
                if (IDNumberTreeNode.NotFoundTreeNode != node && node.isLeaf() && isaccountoffset && StorageTypeEnum.getRealStorageEnumIndexs().contains(node.getStorageType().getOIndex())) continue;
                log.error(String.format("\u5206\u5f55\u660e\u7ec6\u88ab\u79fb\u9664\uff0c\u79d1\u76ee\u4e0d\u7b26\u5408\u5b58\u50a8\u6216\u8005\u4e0d\u5171\u4eab\u7684\u62b5\u6d88\u660e\u7ec6\u8282\u70b9\uff0c\u5f53\u524d\u503c\uff1a%s_%s_%s_%s_%s\uff0c\u5206\u5f55\u8bbe\u7f6e\u7f16\u7801\uff1a%s\uff0c\u4e1a\u52a1\u7c7b\u578b\uff1a%s\uff0c\u5206\u5f55\u660e\u7ec6\u8bbe\u7f6e\uff1a%s", node.getNumber(), node.getName(), node.isLeaf(), isaccountoffset, node.getStorageType(), reportData.getTmplSetting().getNumber(), reportData.getTmplSetting().getBusinessType(), tmplSettingEntry));
                return false;
            }
            if (IDNumberTreeNode.NotFoundTreeNode != node && node.isLeaf() && StorageTypeEnum.getRealStorageEnumIndexs().contains(node.getStorageType().getOIndex())) continue;
            log.error(String.format("\u5206\u5f55\u660e\u7ec6\u88ab\u79fb\u9664\uff0c%s\u4e0d\u7b26\u5408\u5b58\u50a8\u6216\u8005\u4e0d\u5171\u4eab\u7684\u660e\u7ec6\u8282\u70b9\uff0c\u5f53\u524d\u503c\uff1a%s_%s_%s_%s\uff0c\u5206\u5f55\u8bbe\u7f6e\u7f16\u7801\uff1a%s\uff0c\u4e1a\u52a1\u7c7b\u578b\uff1a%s\uff0c\u5206\u5f55\u660e\u7ec6\u8bbe\u7f6e\uff1a%s", node.getNumber(), node.getName(), node.isLeaf(), node.getStorageType(), dimNumbers.get(dimNum), reportData.getTmplSetting().getNumber(), reportData.getTmplSetting().getBusinessType(), tmplSettingEntry));
            return false;
        }
        return true;
    }

    private Long getMemberIdBySign(AdjustReportData reportData, AdjustTmplSetting.Entry entrySetting, String sign, Map<String, String> dimNumbers) {
        Long id = 0L;
        if (!dimNumbers.containsKey(sign)) {
            return id;
        }
        Map<String, Object> data = reportData.getRow().getData();
        String modelNumber = MemberReader.findModelNumberById((Object)this.ac.getModelId());
        String dimNumber = dimNumbers.get(sign);
        if ("account".equals(sign)) {
            String accountNum = entrySetting.getAccountNum();
            id = entrySetting.isLinkDim(entrySetting.getAccountType()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(accountNum, "").toString()).getId() : ("$Cur".equals(accountNum) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getAccount()).getId() : entrySetting.getAccount());
        } else if ("audittrail".equals(sign)) {
            String atNum = entrySetting.getAudittrailNum();
            id = entrySetting.isLinkDim(entrySetting.getAudittrailType()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(atNum, "").toString()).getId() : ("$Cur".equals(atNum) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getAudittrail()).getId() : entrySetting.getAudittrail());
        } else if ("dim1".equals(sign)) {
            String dim1Num = entrySetting.getDim1Num();
            id = entrySetting.isLinkDim(entrySetting.getDim1Type()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(dim1Num, "").toString()).getId() : ("$Cur".equals(dim1Num) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getDim1()).getId() : entrySetting.getDim1());
        } else if ("dim2".equals(sign)) {
            String dim2Num = entrySetting.getDim2Num();
            id = entrySetting.isLinkDim(entrySetting.getDim2Type()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(dim2Num, "").toString()).getId() : ("$Cur".equals(dim2Num) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getDim2()).getId() : entrySetting.getDim2());
        } else if ("dim3".equals(sign)) {
            String dim3Num = entrySetting.getDim3Num();
            id = entrySetting.isLinkDim(entrySetting.getDim3Type()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(dim3Num, "").toString()).getId() : ("$Cur".equals(dim3Num) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getDim3()).getId() : entrySetting.getDim3());
        } else if ("dim4".equals(sign)) {
            String dim4Num = entrySetting.getDim4Num();
            id = entrySetting.isLinkDim(entrySetting.getDim4Type()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(dim4Num, "").toString()).getId() : ("$Cur".equals(dim4Num) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getDim4()).getId() : entrySetting.getDim4());
        } else if ("dim5".equals(sign)) {
            String dim5Num = entrySetting.getDim5Num();
            id = entrySetting.isLinkDim(entrySetting.getDim5Type()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(dim5Num, "").toString()).getId() : ("$Cur".equals(dim5Num) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getDim5()).getId() : entrySetting.getDim5());
        } else if ("dim6".equals(sign)) {
            String dim6Num = entrySetting.getDim6Num();
            id = entrySetting.isLinkDim(entrySetting.getDim6Type()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(dim6Num, "").toString()).getId() : ("$Cur".equals(dim6Num) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getDim6()).getId() : entrySetting.getDim6());
        } else if ("datasort".equals(sign)) {
            String dsNum = entrySetting.getDatasortNum();
            id = entrySetting.isLinkDim(entrySetting.getDatasortType()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(dsNum, "").toString()).getId() : ("$Cur".equals(dsNum) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getDatasort()).getId() : entrySetting.getDatasort());
        } else if ("multigaap".equals(sign)) {
            String mtNum = entrySetting.getMultigaapNum();
            id = entrySetting.isLinkDim(entrySetting.getMultigaapType()) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(mtNum, "").toString()).getId() : ("$Cur".equals(mtNum) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getMultigaap()).getId() : entrySetting.getMultigaap());
        } else if ("changetype".equals(sign)) {
            String cgNum = entrySetting.getChangetypeNum();
            if (entrySetting.isLinkDim(entrySetting.getChangetypeType())) {
                id = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)data.getOrDefault(cgNum, "").toString()).getId();
            } else {
                Long l = id = "$Cur".equals(cgNum) ? MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)reportData.getChangetype()).getId() : entrySetting.getChangetype();
            }
        }
        if ((id == null || id == 0L || id == -1L) && dimNumbers.containsKey(sign)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u8bbe\u7f6e[%1$s]\u7b2c%2$s\u884c[%3$s]\u7ef4\u5ea6\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5177\u4f53\u6210\u5458\u3002", (String)"AdjustRecordService_5", (String)"fi-bcm-business", (Object[])new Object[0]), reportData.getTmplSetting().getNumber(), entrySetting.getSeq(), dimNumber));
        }
        if (id == null) {
            id = 0L;
        }
        return id;
    }

    private Long getOrgIdByDimType(String dimType, AdjustReportData reportData, AdjustReportData.Entry entryData) {
        if (PresetConstant.ENTITY_DIM.equals(dimType)) {
            String entityType = entryData.getTmplSettingEntry().getEntity();
            return "1".equals(entityType) ? reportData.getBuyerOrgId() : reportData.getSalerOrgId();
        }
        if (PresetConstant.MYCOMPANY_DIM.equals(dimType)) {
            if (this.ac.isExistsMyCompanyDim()) {
                String myCompanyType = entryData.getTmplSettingEntry().getMycompany();
                String myCompanyNum = "3".equals(myCompanyType) ? "MCNone" : ("1".equals(myCompanyType) ? reportData.getBuyerOrgNumber() : reportData.getSalerOrgNumber());
                IDNumberTreeNode mycompany = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.ac.getModelId()), (String)DimTypesEnum.MYCOMPANY.getNumber(), (String)myCompanyNum);
                if (mycompany.getId() == -1L) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7\u7ef4\u5ea6\u672a\u627e\u5230\u6210\u5458\uff1a%s", (String)"AdjustRecordHelper_07", (String)"fi-bcm-business", (Object[])new Object[0]), myCompanyNum));
                }
                return mycompany.getId();
            }
            return 0L;
        }
        if (PresetConstant.INTERNALCOMPANY_DIM.equals(dimType)) {
            String icCompanyType = entryData.getTmplSettingEntry().getOpcompany();
            String myCompanyNum = "1".equals(icCompanyType) ? reportData.getBuyerOrgNumber() : ("2".equals(icCompanyType) ? reportData.getSalerOrgNumber() : "ICNone");
            IDNumberTreeNode icMember = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.ac.getModelId()), (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)myCompanyNum);
            if (icMember.getId() == -1L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u7ef4\u5ea6\u672a\u627e\u5230\u6210\u5458\uff1a%s", (String)"AdjustRecordHelper_08", (String)"fi-bcm-business", (Object[])new Object[0]), myCompanyNum));
            }
            return icMember.getId();
        }
        return 0L;
    }

    private DynamicObject getCommonDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("comdimension", (Object)dimid);
        dynaObj.set("commembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private DynamicObject getSpreadDimDynamicObject(DynamicObjectType objType, Long dimid, Long membid, int seq) {
        DynamicObject dynaObj = new DynamicObject(objType);
        dynaObj.set("spreaddimension", (Object)dimid);
        dynaObj.set("spreadmembid", (Object)membid);
        dynaObj.set("seq", (Object)seq);
        return dynaObj;
    }

    private void checkOrgPeriodOpen(String orgNum) {
        boolean periodManage = ConfigServiceHelper.getBoolParam(this.ac.getModelId(), "CM012");
        if (periodManage) {
            Pair<Boolean, Boolean> periodStatusPair = PeriodSettingHelper.batchSelectPeriodStatusOpenbyUntreated(this.ac.getModelId(), orgNum, this.ac.getScenarioId(), this.ac.getYearId(), this.ac.getPeriodId());
            if (!((Boolean)periodStatusPair.p1).booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7 %s \u6ca1\u6709\u5f00\u542f\u6570\u636e\u671f\u95f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AdjustRecordService_2", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
            }
            if (!((Boolean)periodStatusPair.p2).booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u5f00\u542f\u8c03\u6574\u5206\u5f55\u671f\u95f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AdjustRecordService_3", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
            }
        }
        if (AllInOneUtils.isSubmitted(this.ac.getModelId(), orgNum, this.ac.getScenarioId(), this.ac.getYearId(), this.ac.getPeriodId())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u7ec4\u7ec7\u201c%s\u201d\u5bf9\u5e94\u7684\u667a\u80fd\u5408\u5e76\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u5df2\u63d0\u4ea4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AdjustRecordService_4", (String)"fi-bcm-business", (Object[])new Object[0]), orgNum));
        }
    }
}

