/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.adjust;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.innertrade.adjust.AdjustRecordHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class IntrAdjustTask
extends AbstractTask {
    private static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(IntrAdjustTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        String actioning = ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u5206\u5f55", (String)"IntrAdjustTask_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        this.feedbackProgress(0, actioning, null);
        List reportIds = (List)ObjectSerialUtil.deSerializedBytes((String)param.get("reportIds").toString());
        List processIds = (List)ObjectSerialUtil.deSerializedBytes((String)param.get("processIds").toString());
        String message = (String)param.get("message");
        boolean isFormList = param.get("isFormList") != null && (Boolean)param.get("isFormList") != false;
        try {
            if (this.isStop()) {
                this.stop();
            }
            Map<Long, DynamicObject> reportMap = QueryServiceHelper.query((String)"bcm_intrreportentity", (String)"id,model.id,papertemplate.id,papertemplate.number,papertemplate.name,entity.id,entity.number,entity.name,scenario.id,year.id,period.id,currency.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)reportIds)}).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (e1, e2) -> e1));
            StringBuilder allMessage = new StringBuilder();
            int count = 0;
            boolean isSuccess = true;
            for (Long reportId : reportIds) {
                DynamicObject report = reportMap.get(reportId);
                if (report == null) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("success", "false");
                    result.put("data", false);
                    result.put("message", ResManager.loadKDString((String)"\u5e95\u7a3f\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u5e95\u7a3f\u3002", (String)"IntrAdjustTask_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                    this.feedbackCustomdata(result);
                    return;
                }
                int finalCount = count;
                Consumer<Integer> taskConsumer = percent -> this.feedbackProgress((100 * finalCount + percent) / reportIds.size(), actioning, null);
                Map<String, String> result = AdjustRecordHelper.generateAdjustInfo(report.getLong("model.id"), report.getLong("papertemplate.id"), report.getLong("scenario.id"), report.getLong("year.id"), report.getLong("period.id"), report.getLong("currency.id"), report.getLong("entity.id"), processIds, taskConsumer, isFormList ? "2" : "1");
                if (!"0".equals(result.get("code"))) {
                    isSuccess = false;
                }
                if (isFormList) {
                    allMessage.append(report.getString("entity.number")).append(" ").append(report.getString("entity.name")).append(" ").append(report.getString("papertemplate.number")).append(" ").append(report.getString("papertemplate.name")).append(" ").append(result.get("message")).append("\n");
                } else {
                    allMessage.append(result.get("message"));
                }
                ++count;
            }
            if (!StringUtils.isBlank((CharSequence)message)) {
                allMessage.append(message);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", "true");
            result.put("data", isSuccess);
            result.put("message", allMessage);
            this.feedbackCustomdata(result);
        }
        catch (Exception e) {
            logger.error("\u5185\u90e8\u4ea4\u6613\u751f\u6210\u5206\u5f55\u5f02\u5e38\uff0creportIds=" + reportIds + "\uff0c", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        finally {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"IntrAdjustTask_3", (String)"fi-bcm-business", (Object[])new Object[0]), null);
        }
    }
}

