/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.innertrade.MfFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.innertrade.model.IntrCheckParam;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.report.IntrEntityHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.EncoderService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IntrMergeContext
implements Serializable {
    private static final long serialVersionUID = 1252181652882863825L;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(IntrMergeContext.class);
    private IntrMergeParam param;
    private Pair<Long, String> currency;
    private Pair<String, String> tmpInfo;
    private Pair<Long, String> sellerExtModel;
    private Pair<Long, String> buyerExtModel;
    private Pair<Long, String> mergeExtModel;
    private IntrCheckParam intrCheckParam = new IntrCheckParam();
    private List<String> mergeFields = new ArrayList<String>(16);
    private List<String> joinKeys = new ArrayList<String>(16);
    private List<String> mergeUniqueKeys = new ArrayList<String>(16);
    private List<String> buyerUniqueKeys = new ArrayList<String>(16);
    private List<String> sellerUniqueKeys = new ArrayList<String>(16);
    private List<IntrField> sellerFieldList = new ArrayList<IntrField>(16);
    private List<IntrField> buyerFieldList = new ArrayList<IntrField>(16);
    private List<IntrField> mergeFieldList = new ArrayList<IntrField>(16);
    private List<IntrField> formulaFieldList = new ArrayList<IntrField>(16);
    private Map<String, IntrField> sellerFieldMap = new HashMap<String, IntrField>(16);
    private Map<String, IntrField> buyerFieldMap = new HashMap<String, IntrField>(16);
    private Map<String, IntrField> mergeFieldMap = new HashMap<String, IntrField>(16);
    private boolean isCsl = false;
    private boolean isHaveLyvFormula = false;
    private boolean isHaveESPFormula = false;
    private String entityHolding = null;
    private Map<String, String> shareholderMap = new HashMap<String, String>(16);
    private Map<String, Map<String, BigDecimal>> espKvMapCache = new HashMap<String, Map<String, BigDecimal>>(16);
    private Map<String, FourTuple<String, String, String, Long>> leafEntitys = new HashMap<String, FourTuple<String, String, String, Long>>(16);

    public IntrMergeContext(IntrMergeParam param) {
        this.param = param;
        this.initTemplateInfo();
        this.initCurrency();
        if (!this.isCsl) {
            this.initSellerField();
            this.initBuyerField();
        }
        this.initMergeField();
        if (!this.isCsl) {
            this.initJoinField();
            this.initLeafEntity();
        }
    }

    private void initTemplateInfo() {
        String selectFields = "id,number,name,usage,seller.id,seller.number,purchaser.id,purchaser.number,mergenode.id,mergenode.number,mfformula";
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.param.getTemplateId())});
        this.tmpInfo = Pair.onePair((Object)template.getString("number"), (Object)template.getString("name"));
        this.sellerExtModel = Pair.onePair((Object)template.getLong("seller.id"), (Object)template.getString("seller.number"));
        this.buyerExtModel = Pair.onePair((Object)template.getLong("purchaser.id"), (Object)template.getString("purchaser.number"));
        this.mergeExtModel = Pair.onePair((Object)template.getLong("mergenode.id"), (Object)template.getString("mergenode.number"));
        this.intrCheckParam.setMfFormulaText(template.getString("mfformula"));
        this.isCsl = "1".equalsIgnoreCase(template.getString("usage"));
    }

    private void initCurrency() {
        if (CurrencyEnum.EC.getNumber().equals(this.param.getCurrency().p2) || CurrencyEnum.DC.getNumber().equals(this.param.getCurrency().p2)) {
            DynamicObject dyn = OrgCurrencyServiceHelper.getCurrencyDynById((Long)this.param.getEntity().p1, (Long)this.param.getYear().p1, (Long)this.param.getPeriod().p1);
            this.currency = Pair.onePair((Object)dyn.getLong("id"), (Object)dyn.getString("number"));
        } else {
            this.currency = this.param.getCurrency();
        }
        if (this.currency == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u8d22\u5e74\uff1a%2$s\uff0c\u671f\u95f4\uff1a%3$s \u627e\u4e0d\u5230%4$s\u5e01\u79cd\u3002", (String)"IntrMergeContext_0", (String)"fi-bcm-business", (Object[])new Object[0]), this.param.getEntity().p2, this.param.getYear().p2, this.param.getPeriod().p2, this.param.getCurrency().p2));
        }
    }

    private void initSellerField() {
        this.sellerFieldList = QueryIntrDataHelper.queryBuyerOrSellerFields((Long)this.sellerExtModel.p1);
        if (CollectionUtils.isEmpty(this.sellerFieldList)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9500\u552e\u65b9\u7684\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\uff0c\u6a21\u578b\u7f16\u7801\uff1a%s\u3002", (String)"IntrMergeContext_1", (String)"fi-bcm-business", (Object[])new Object[0]), this.sellerExtModel.p2));
        }
        this.sellerFieldMap = this.sellerFieldList.stream().collect(Collectors.toMap(IntrField::getNumber, e -> e));
        this.log.info(String.format("\u9500\u552e\u65b9\u7684\u5b57\u6bb5\uff1a%s", this.sellerFieldList));
    }

    private void initBuyerField() {
        this.buyerFieldList = QueryIntrDataHelper.queryBuyerOrSellerFields((Long)this.buyerExtModel.p1);
        if (CollectionUtils.isEmpty(this.buyerFieldList)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u91c7\u8d2d\u65b9\u7684\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\uff0c\u6a21\u578b\u7f16\u7801\uff1a%s\u3002", (String)"IntrMergeContext_2", (String)"fi-bcm-business", (Object[])new Object[0]), this.buyerExtModel.p2));
        }
        this.buyerFieldMap = this.buyerFieldList.stream().collect(Collectors.toMap(IntrField::getNumber, e -> e));
        this.log.info(String.format("\u91c7\u8d2d\u65b9\u7684\u5b57\u6bb5\uff1a%s", this.buyerFieldList));
    }

    private void initMergeField() {
        DynamicObject entity;
        this.mergeFieldList = QueryIntrDataHelper.queryMergeFieldsForMerge(this.param.getTemplateId());
        if (CollectionUtils.isEmpty(this.mergeFieldList)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5408\u5e76\u65b9\u7684\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\uff0c\u6a21\u677f\u7f16\u7801\uff1a%s\u3002", (String)"IntrMergeContext_3", (String)"fi-bcm-business", (Object[])new Object[0]), this.tmpInfo.p1));
        }
        this.mergeFieldMap = this.mergeFieldList.stream().collect(Collectors.toMap(IntrField::getNumber, e -> e));
        this.formulaFieldList = this.mergeFieldList.stream().filter(item -> !kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)item.getFormula())).sorted(Comparator.comparing(IntrField::getFormulaSeq)).collect(Collectors.toList());
        this.mergeUniqueKeys = this.mergeFieldList.stream().filter(IntrField::isUnique).map(IntrField::getNumber).collect(Collectors.toList());
        for (IntrField field : this.formulaFieldList) {
            if (StringUtils.contains((CharSequence)field.getFormula(), (CharSequence)FormulaEnum.Lyv.getCode())) {
                this.isHaveLyvFormula = true;
            }
            if (!StringUtils.contains((CharSequence)field.getFormula(), (CharSequence)FormulaEnum.Esp.getCode())) continue;
            this.isHaveESPFormula = true;
        }
        if (this.isHaveESPFormula && (entity = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id, number,ctrlorg.number", (QFilter[])new QFilter[]{new QFilter("id", "=", this.param.getEntity().p1)})) != null) {
            this.entityHolding = entity.getString("ctrlorg.number");
        }
        this.initIntrCheckParam();
        this.log.info(String.format("\u5408\u5e76\u65b9\u7684\u5b57\u6bb5\uff1a%s", this.mergeFieldList));
    }

    private void initJoinField() {
        Set sellerFileds = this.getSellerFieldList().stream().map(IntrField::getNumber).collect(Collectors.toSet());
        this.mergeFields = this.mergeFieldList.stream().filter(item -> item.isJoinKey() || "INTR_001".equals(item.getNumber())).map(IntrField::getNumber).collect(Collectors.toList());
        this.joinKeys = this.mergeFields.stream().filter(sellerFileds::contains).collect(Collectors.toList());
        this.sellerUniqueKeys.addAll(this.joinKeys);
        this.buyerUniqueKeys.addAll(this.mergeFields);
        this.log.info(String.format("\u9500\u552e\u65b9\u7684\u552f\u4e00\u5b57\u6bb5\uff1a%s", this.sellerUniqueKeys));
        this.log.info(String.format("\u91c7\u8d2d\u65b9\u7684\u552f\u4e00\u5b57\u6bb5\uff1a%s", this.buyerUniqueKeys));
        this.log.info(String.format("\u9500\u552e\u65b9\u548c\u91c7\u8d2d\u65b9\u7684\u5173\u8054\u5b57\u6bb5\uff1a%s", this.joinKeys));
    }

    private void initLeafEntity() {
        Map<String, Set<Long>> orgByChangeType = IntrEntityHelper.getSortEntity((Long)this.param.getModel().p1, (Long)this.param.getScenario().p1, (Long)this.param.getYear().p1, (Long)this.param.getPeriod().p1, (Pair<String, String>)Pair.onePair((Object)this.param.getEntity().p2, (Object)this.param.getEntity().p3));
        for (Map.Entry<String, Set<Long>> kv : orgByChangeType.entrySet()) {
            IDNumberTreeNode orgNode;
            if (kv.getValue().isEmpty() || !(orgNode = BcmThreadCache.findNodeById((String)this.param.getModelNumber(), (String)"Entity", (long)kv.getValue().iterator().next())).isLeaf()) continue;
            this.leafEntitys.put(kv.getKey(), (FourTuple<String, String, String, Long>)new FourTuple((Object)orgNode.getName(), (Object)orgNode.getLongNumber(), (Object)orgNode.getCurrency(), (Object)orgNode.getId()));
        }
        if (DebugServiceHelper.isDebugModel()) {
            this.log.info(String.format("\u53c2\u4e0e\u8fd0\u7b97\u7684\u53f6\u5b50\u8282\u70b9\u96c6\u5408\uff1a%s", this.leafEntitys.keySet()));
        }
    }

    private void initIntrCheckParam() {
        if (StringUtils.isBlank((CharSequence)this.intrCheckParam.getMfFormulaText())) {
            return;
        }
        this.intrCheckParam.setBisNum("INTR_001");
        MfFormula formula = null;
        try {
            Pair<String, List<IFormula>> pair = new ExpressParser().parse(this.intrCheckParam.getMfFormulaText(), new EncoderService());
            formula = (MfFormula)((List)pair.p2).get(0);
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        if (formula != null) {
            ParamList paramList = formula.getParamList();
            this.intrCheckParam.setFillBisType(((ParamItem)paramList.get(0)).getParam().toString().replace("\"", ""));
            this.intrCheckParam.setSellFieldNum(((ParamItem)paramList.get(2)).getParam().toString().split("@")[1].replace("\"", ""));
            this.intrCheckParam.setBuyFieldNum(((ParamItem)paramList.get(3)).getParam().toString().split("@")[1].replace("\"", ""));
        }
    }

    public IntrMergeParam getParam() {
        return this.param;
    }

    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    public Pair<Long, String> getSellerExtModel() {
        return this.sellerExtModel;
    }

    public Pair<Long, String> getBuyerExtModel() {
        return this.buyerExtModel;
    }

    public Pair<Long, String> getMergeExtModel() {
        return this.mergeExtModel;
    }

    public List<String> getJoinKeys() {
        return this.joinKeys;
    }

    public List<IntrField> getSellerFieldList() {
        return this.sellerFieldList;
    }

    public List<IntrField> getBuyerFieldList() {
        return this.buyerFieldList;
    }

    public List<IntrField> getMergeFieldList() {
        return this.mergeFieldList;
    }

    public List<IntrField> getFormulaFieldList() {
        return this.formulaFieldList;
    }

    public Map<String, FourTuple<String, String, String, Long>> getLeafEntitys() {
        return this.leafEntitys;
    }

    public List<String> getBuyerUniqueKeys() {
        return this.buyerUniqueKeys;
    }

    public List<String> getSellerUniqueKeys() {
        return this.sellerUniqueKeys;
    }

    public List<String> getMergeFields() {
        return this.mergeFields;
    }

    public IntrCheckParam getIntrCheckParam() {
        return this.intrCheckParam;
    }

    public Map<String, IntrField> getMergeFieldMap() {
        return this.mergeFieldMap;
    }

    public Map<String, Map<String, BigDecimal>> getEspKvMapCache() {
        return this.espKvMapCache;
    }

    public Map<String, IntrField> getSellerFieldMap() {
        return this.sellerFieldMap;
    }

    public Map<String, IntrField> getBuyerFieldMap() {
        return this.buyerFieldMap;
    }

    public boolean isHaveLyvFormula() {
        return this.isHaveLyvFormula;
    }

    public boolean isHaveESPFormula() {
        return this.isHaveESPFormula;
    }

    public String getEntityHolding() {
        return this.entityHolding;
    }

    public Map<String, String> getShareholderMap() {
        return this.shareholderMap;
    }

    public boolean isCsl() {
        return this.isCsl;
    }

    public List<String> getMergeUniqueKeys() {
        return this.mergeUniqueKeys;
    }
}

