/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.common.IntrConstant;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class IntrTable {
    private List<IntrField> head;
    private List<IntrRow> rows;
    private Integer maxRow;

    public IntrTable(List<IntrField> head, List<IntrRow> rows) {
        this.head = head;
        this.rows = rows;
    }

    public IntrTable(List<IntrField> head, DynamicObjectCollection dynArr) {
        this.head = head;
        ArrayList<IntrRow> rows = new ArrayList<IntrRow>(dynArr.size());
        if (dynArr != null) {
            this.maxRow = dynArr.size();
            dynArr.forEach(item -> {
                HashMap<String, Object> row = new HashMap<String, Object>(head.size());
                Boolean isDiff = Boolean.FALSE;
                for (IntrField field : head) {
                    row.put(field.getNumber(), item.get(field.getBoundField()));
                    if (!"INTR_000".equals(field.getNumber()) || !IntrConstant.getDiffText().equals(item.get(field.getBoundField()))) continue;
                    isDiff = Boolean.TRUE;
                }
                Integer rowNum = null;
                if (StringUtils.isNotBlank((CharSequence)item.getString("sid")) && StringUtils.isNotEmpty((CharSequence)StringUtils.substringAfter((String)item.getString("sid"), (String)"AIT_")) && (rowNum = NumberUtils.createInteger((String)StringUtils.substringAfter((String)item.getString("sid"), (String)"AIT_"))) > this.maxRow) {
                    this.maxRow = rowNum;
                }
                rows.add(new IntrRow(item.getLong("id"), isDiff, row, rowNum));
            });
        }
        this.rows = rows;
    }

    public Object getCell(int row, String field) {
        if (row > this.rows.size()) {
            return null;
        }
        return this.rows.get(row).getData().get(field);
    }

    public List<IntrField> getHead() {
        return this.head;
    }

    public void setHead(List<IntrField> head) {
        this.head = head;
    }

    public List<IntrRow> getRows() {
        return this.rows;
    }

    public void setRows(List<IntrRow> rows) {
        this.rows = rows;
    }

    public Integer getMaxRow() {
        return this.maxRow;
    }
}

