/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class IntrBizRuleHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, IntrBizRuleHelper.class);
    private static final String SPLIT_SYMBOL = "_";

    public static void test() {
        String showNum = "scytest";
        String dataModelNum = "LR001";
        String entityNum = "GA";
        String sceneNum = "MRpt";
        String yearNum = "FY2021";
        String periodNum = "M_M01";
        String currencyNum = "CNY";
        QFBuilder qb = new QFBuilder();
        qb.add("modelnumber", "=", (Object)showNum);
        qb.add("datamodel", "=", (Object)dataModelNum);
        qb.add("org", "=", (Object)entityNum);
        qb.add("scenario", "=", (Object)sceneNum);
        qb.add("year", "=", (Object)yearNum);
        qb.add("period", "=", (Object)periodNum);
        qb.add("currency", "=", (Object)currencyNum);
        qb.add("extendsgroup", "=", (Object)IntrReportHelper.getGroupNumByModelNum((long)MemberReader.findModelIdByShowNum((String)showNum), dataModelNum));
        qb.add("process", "=", (Object)"ADJ");
        qb.add("audittrail", "=", (Object)"EntityInput");
        Map dbDataMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_extenddata_bus", (QFilter[])qb.toArray());
        Collection dbDatas = dbDataMap.values();
        DynamicObject newData2 = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)dbDatas.stream().findFirst().get()), (boolean)false, (boolean)true);
        newData2.set("id", null);
        newData2.set("numext4", (Object)1.5);
        dbDatas.add(newData2);
        Map dimValueMap = MapInitHelper.ofMap((Object)PresetConstant.ENTITY_DIM, (Object)entityNum, (Object)PresetConstant.SCENE_DIM, (Object)sceneNum, (Object)PresetConstant.FY_DIM, (Object)yearNum, (Object)PresetConstant.PERIOD_DIM, (Object)periodNum, (Object)PresetConstant.CURRENCY_DIM, (Object)currencyNum);
        List<DynamicObject> doc = IntrBizRuleHelper.processIntrData((List)dbDatas, 1630325573656009823L, dimValueMap, "LR001", 1630325573656009806L);
        SaveServiceHelper.save((DynamicObject[])doc.toArray(new DynamicObject[0]));
    }

    public static List<DynamicObject> processIntrData(List<DynamicObject> datas, Long modelId, Map<String, String> dimValueMap, String extModelNum, Long templateId) {
        ArrayList<DynamicObject> emptyList = new ArrayList<DynamicObject>(1);
        if (CollectionUtil.isEmpty(datas)) {
            return emptyList;
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String modelShowNum = MemberReader.findModelSNumberById((Object)modelId);
        if (StringUtils.isBlank((CharSequence)modelNum)) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u4f53\u7cfb\u4fe1\u606f\uff0c\u4f53\u7cfbid=%s", (String)"IntrBizRuleHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), modelId));
            return emptyList;
        }
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)dimValueMap.get(PresetConstant.ENTITY_DIM));
        if (IDNumberTreeNode.NotFoundTreeNode == orgNode) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f\uff0c\u7ec4\u7ec7number=%s", (String)"IntrBizRuleHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), dimValueMap.get(PresetConstant.ENTITY_DIM)));
            return emptyList;
        }
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelNum, (String)dimValueMap.get(PresetConstant.SCENE_DIM));
        if (IDNumberTreeNode.NotFoundTreeNode == sceneNode) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u60c5\u666f\u4fe1\u606f\uff0c\u60c5\u666fnumber=%s", (String)"IntrBizRuleHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), dimValueMap.get(PresetConstant.SCENE_DIM)));
            return emptyList;
        }
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)modelNum, (String)dimValueMap.get(PresetConstant.FY_DIM));
        if (IDNumberTreeNode.NotFoundTreeNode == yearNode) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u8d22\u5e74\u4fe1\u606f\uff0c\u8d22\u5e74number=%s", (String)"IntrBizRuleHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), dimValueMap.get(PresetConstant.FY_DIM)));
            return emptyList;
        }
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNum, (String)dimValueMap.get(PresetConstant.PERIOD_DIM));
        if (IDNumberTreeNode.NotFoundTreeNode == periodNode) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u671f\u95f4\u4fe1\u606f\uff0c\u671f\u95f4number=%s", (String)"IntrBizRuleHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), dimValueMap.get(PresetConstant.PERIOD_DIM)));
            return emptyList;
        }
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)dimValueMap.get(PresetConstant.CURRENCY_DIM));
        if (IDNumberTreeNode.NotFoundTreeNode == currencyNode) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5e01\u79cd\u4fe1\u606f\uff0c\u5e01\u79cdnumber=%s", (String)"IntrBizRuleHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), dimValueMap.get(PresetConstant.CURRENCY_DIM)));
            return emptyList;
        }
        DynamicObject extModelDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)extModelNum)});
        if (extModelDyn == null) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u62d3\u5c55\u7ef4\u6a21\u578b\u4fe1\u606f\uff0c\u62d3\u5c55\u7ef4\u6a21\u578bnumber=%s", (String)"IntrBizRuleHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), extModelNum));
            return emptyList;
        }
        DynamicObject template = IntrTemplateHelper.getTemplateInfo(modelId, templateId);
        if (template == null) {
            logger.error(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6a21\u677f\u4fe1\u606f\uff0c\u6a21\u677fid=%s", (String)"IntrBizRuleHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), templateId));
            return emptyList;
        }
        Map<String, IDNumberTreeNode> effectNodes = IntrReportHelper.getSellerBuyerEntity(modelId, (Tuple<Long, String, String>)Tuple.create((Object)orgNode.getId(), (Object)orgNode.getNumber(), (Object)orgNode.getLongNumber()), SimpleItem.newOne(sceneNode.getId(), sceneNode.getNumber()), SimpleItem.newOne(yearNode.getId(), yearNode.getNumber()), SimpleItem.newOne(periodNode.getId(), periodNode.getNumber()), null);
        Map<String, IntrTplDimScope> dimScopeMap = IntrTemplateHelper.getDimScope(templateId);
        List<IntrField> fields = QueryIntrDataHelper.queryMergeFieldsForMerge(templateId);
        Map<String, IntrField> fieldMap = fields.stream().collect(Collectors.toMap(IntrField::getNumber, e -> e));
        List<String> uniqueFileds = IntrReportHelper.getUniqueFields(fields, template.getString("usage")).stream().map(IntrField::getBoundField).collect(Collectors.toList());
        List reqFileds = fields.stream().filter(IntrField::isRequired).collect(Collectors.toList());
        datas.removeIf(e -> {
            String msg = IntrReportHelper.checkIntrData(modelNum, effectNodes, orgNode.getLongNumber(), fieldMap, reqFileds, e, dimScopeMap);
            if (!StringUtils.isBlank((CharSequence)msg)) {
                logger.error(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u552f\u4e00key\uff1a%1$s\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"IntrBizRuleHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), IntrBizRuleHelper.getUniqueKey(e, uniqueFileds), msg));
                return true;
            }
            return false;
        });
        if (CollectionUtil.isEmpty(datas)) {
            return emptyList;
        }
        HashSet<Long> deleteIds = new HashSet<Long>(16);
        Map<String, DynamicObject> sourceDataMap = datas.stream().collect(Collectors.toMap(k -> IntrBizRuleHelper.getUniqueKey(k, uniqueFileds), v -> v, (e1, e2) -> IntrBizRuleHelper.selectData(e1, e2, deleteIds)));
        DynamicObjectCollection dbDatas = QueryIntrDataHelper.queryMergeData(modelShowNum, extModelNum, orgNode.getNumber(), sceneNode.getNumber(), yearNode.getNumber(), periodNode.getNumber(), currencyNode.getNumber(), sourceDataMap.values().stream().map(e -> e.getLong("id")).filter(e -> e != 0L).collect(Collectors.toSet()));
        if (CollectionUtil.isEmpty((Collection)dbDatas)) {
            return new ArrayList<DynamicObject>(sourceDataMap.values());
        }
        for (DynamicObject dbData : dbDatas) {
            DynamicObject newData = sourceDataMap.get(IntrBizRuleHelper.getUniqueKey(dbData, uniqueFileds));
            if (newData == null) continue;
            IntrBizRuleHelper.selectData(dbData, newData, deleteIds);
        }
        if (!CollectionUtil.isEmpty(deleteIds)) {
            logger.error(String.format(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u6267\u884c\u89c4\u5219\uff0c\u552f\u4e00\u952e\u51b2\u7a81\uff0c\u9700\u8981\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"IntrBizRuleHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]), deleteIds.size()));
            DeleteServiceHelper.delete((String)"bcm_extenddata_bus", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
        }
        if (!CollectionUtil.isEmpty(deleteIds) || !sourceDataMap.isEmpty()) {
            IntrReportHelper.clearSpread(modelId, templateId, orgNode.getId(), sceneNode.getId(), yearNode.getId(), periodNode.getId(), currencyNode.getId());
        }
        return new ArrayList<DynamicObject>(sourceDataMap.values());
    }

    private static DynamicObject selectData(DynamicObject oldData, DynamicObject newData, Set<Long> deleteIds) {
        long oid = oldData.getLong("id");
        if (oid != 0L) {
            deleteIds.add(oid);
        }
        return newData;
    }

    private static String getUniqueKey(DynamicObject sourceData, List<String> uniqueKeys) {
        ArrayList uks = new ArrayList(16);
        uniqueKeys.forEach(field -> {
            Object value = sourceData.get(field);
            String valueStr = null;
            valueStr = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toString() : (value == null ? "" : value.toString());
            uks.add(valueStr);
        });
        return String.join((CharSequence)SPLIT_SYMBOL, uks);
    }
}

