/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ScenarioMemberEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;
import org.apache.commons.lang3.StringUtils;

public class IntrCalculateFormulaHelper {
    private static final Set<String> INTR_FORMULA = Sets.newHashSet((Object[])new String[]{FormulaEnum.Gev.getCode(), FormulaEnum.Lyv.getCode(), FormulaEnum.Dvb.getCode(), FormulaEnum.Pn.getCode(), FormulaEnum.Mf.getCode()});

    public static Map<Integer, List<IntrField>> handleFormula(IntrMergeContext ctx) throws Exception {
        for (IntrField field : ctx.getFormulaFieldList()) {
            Expression expression = IntrCalculateFormulaHelper.walkExpress(ExcelFormulaPaserHelper.parse((String)field.getFormula()), fun -> {
                if (fun instanceof FunctionExpr) {
                    String funcName = ((FunctionExpr)fun).getFuncionName();
                    if (FormulaEnum.Esp.getCode().equalsIgnoreCase(funcName)) {
                        fun = IntrCalculateFormulaHelper.handleEsp((FunctionExpr)fun, ctx);
                    } else if (INTR_FORMULA.stream().anyMatch(e -> e.equalsIgnoreCase(funcName))) {
                        fun = IntrCalculateFormulaHelper.handleIntrFun((FunctionExpr)fun, ctx);
                    }
                }
                return fun;
            });
            field.setFormula(expression.toString());
        }
        return ctx.getFormulaFieldList().stream().collect(Collectors.groupingBy(IntrField::getFormulaSeq, () -> new TreeMap(Comparator.naturalOrder()), Collectors.toList()));
    }

    public static Expression walkExpress(Expression expr, Function<Expression, Expression> fDeal) {
        if (expr instanceof BinaryOperationExpr) {
            ((BinaryOperationExpr)expr).setLeft(IntrCalculateFormulaHelper.walkExpress(((BinaryOperationExpr)expr).getLeft(), fDeal));
            ((BinaryOperationExpr)expr).setRight(IntrCalculateFormulaHelper.walkExpress(((BinaryOperationExpr)expr).getRight(), fDeal));
        } else if (expr instanceof UnaryOperationExpr) {
            ((UnaryOperationExpr)expr).setOperand(IntrCalculateFormulaHelper.walkExpress(((UnaryOperationExpr)expr).getOperand(), fDeal));
        } else {
            if (expr instanceof FunctionExpr) {
                List params = ((FunctionExpr)expr).getParameters();
                for (int i = 0; i < params.size(); ++i) {
                    Object childExpr = params.get(i);
                    if (!(childExpr instanceof Expression)) continue;
                    params.set(i, IntrCalculateFormulaHelper.walkExpress((Expression)childExpr, fDeal));
                }
            }
            expr = fDeal.apply(expr);
        }
        return expr;
    }

    private static Expression handleIntrFun(FunctionExpr fun, IntrMergeContext ctx) {
        List paramList = fun.getParameters();
        if (FormulaEnum.Dvb.getCode().equalsIgnoreCase(fun.getFuncionName())) {
            StringExpr param = null;
            param = ctx.getIntrCheckParam() == null || StringUtils.isBlank((CharSequence)ctx.getIntrCheckParam().getBuyFieldNum()) ? new StringExpr("") : new StringExpr(String.format("%s@%s", ctx.getBuyerExtModel().p2, ctx.getIntrCheckParam().getBuyFieldNum()));
            if (paramList.size() >= 2) {
                paramList.set(1, param);
            } else {
                paramList.add(param);
            }
        }
        paramList.add(new StringExpr("####ROW_KEY####"));
        fun.setParameters(paramList);
        return fun;
    }

    private static Expression handleEsp(FunctionExpr fun, IntrMergeContext ctx) {
        List paramList = fun.getParameters();
        if (StringUtils.isBlank((CharSequence)IntrCalculateFormulaHelper.handelParam(paramList.get(2)))) {
            paramList.set(2, new StringExpr((String)ctx.getParam().getScenario().p2));
        }
        paramList.set(5, new StringExpr("####SHAREHOLDER####"));
        paramList.set(6, new StringExpr("####INVEST####"));
        String fyNum = IntrCalculateFormulaHelper.handelParam(paramList.get(3));
        String periodNum = IntrCalculateFormulaHelper.handelParam(paramList.get(4));
        if ("CurrentYear".equals(fyNum) || StringUtils.isBlank((CharSequence)fyNum)) {
            paramList.set(3, new StringExpr((String)ctx.getParam().getYear().p2));
        }
        if ("CurrentPeriod".equals(periodNum) || StringUtils.isBlank((CharSequence)periodNum)) {
            paramList.set(4, new StringExpr((String)ctx.getParam().getPeriod().p2));
        }
        if ("LastYear".equals(fyNum) || "LastPeriod".equals(periodNum)) {
            Tuple<Long, Long> yearAndPeriod = IntrCalculateFormulaHelper.cvtPeriodAndYear((Long)ctx.getParam().getModel().p1, (Long)ctx.getParam().getScenario().p1, (Long)ctx.getParam().getYear().p1, (Long)ctx.getParam().getPeriod().p1, fyNum, periodNum);
            paramList.set(3, new StringExpr(MemberReader.findFyMemberById((Long)((Long)ctx.getParam().getModel().p1), (Long)((Long)yearAndPeriod.item1)).getNumber()));
            paramList.set(4, new StringExpr(MemberReader.findPeriodMemberById((Long)((Long)ctx.getParam().getModel().p1), (Long)((Long)yearAndPeriod.item2)).getNumber()));
        }
        fun.setParameters(paramList);
        return fun;
    }

    private static Tuple<Long, Long> cvtPeriodAndYear(long modelId, long scenarioId, long yearId, long periodId, String yearNum, String periodNum) {
        int periodOffset = 0;
        int yearOffset = 0;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String scenarioNum = MemberReader.findScenaMemberById((String)modelNum, (Long)scenarioId).getNumber();
        if (!kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)yearNum) && !yearNum.equals("CurrentYear")) {
            if (yearNum.equals("LastYear")) {
                yearOffset = -1;
            } else {
                IDNumberTreeNode yearMemberByNum = MemberReader.findFyMemberByNum((String)modelNum, (String)yearNum);
                yearId = yearMemberByNum.getId();
            }
        }
        if (!kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)periodNum) && !periodNum.equals("CurrentPeriod")) {
            if (periodNum.equals("LastPeriod")) {
                periodOffset = -1;
            } else {
                IDNumberTreeNode periodMemberByNum = MemberReader.findPeriodMemberByNum((String)modelNum, (String)periodNum);
                periodId = periodMemberByNum.getId();
            }
        }
        if (periodOffset == 0 && yearOffset == 0) {
            return Tuple.create((Object)yearId, (Object)periodId);
        }
        return PeriodUtils.getPeriodByOffset((long)modelId, (ScenarioMemberEnum)ScenarioMemberEnum.getMemberByNumber((String)scenarioNum), (long)yearId, (long)periodId, (int)yearOffset, (int)periodOffset);
    }

    protected static String handelParam(Object p) {
        return p == null ? "" : p.toString().trim().replace("\"", "");
    }
}

