/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.check.helper.EntityServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.QFBuilder;

public class IntrEntityHelper {
    public static Map<String, Set<Long>> getSortEntity(Long modelId, Long scenarioId, Long yearId, Long periodId, Pair<String, String> mergeEntity) {
        String modelCubeNumber = MemberReader.findModelNumberById((Object)modelId);
        Set<String> noMerge = MergeControlHelper.getNoMergeByNumber(modelId, scenarioId, yearId, periodId);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        QFilter qFilter = new QFilter("isinnerorg", "=", (Object)Boolean.TRUE);
        if (!ConfigServiceHelper.isHwApp()) {
            qFilter.or("isleaf", "=", (Object)Boolean.FALSE);
        }
        qfBuilder.add(qFilter);
        qfBuilder.add("isexchangerate", "=", (Object)Boolean.FALSE);
        QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)((String)mergeEntity.p2 + "!%")).or("longnumber", "=", mergeEntity.p2).or("longnumber", "in", EntityServiceHelper.getParentLongNumber((String)mergeEntity.p2));
        qfBuilder.add(longnumberFilter);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, longnumber, number,isleaf", (QFilter[])qfBuilder.toArray());
        if (noMerge != null && noMerge.size() > 0) {
            noMerge.removeIf(num -> ((String)mergeEntity.p2).contains(num + "!") || ((String)mergeEntity.p2).endsWith((String)num));
            doc.removeIf(e -> noMerge.stream().anyMatch(num -> e.getString("longnumber").contains(num + "!") || e.getString("longnumber").endsWith((String)num)));
        }
        CheckUtil.filterInnerInternalCompany(modelId, scenarioId, yearId, periodId, doc);
        IDNumberTreeNode yearMember = MemberReader.findMemberById((long)modelId, (String)"bcm_fymembertree", (Long)yearId);
        FilterOrgStructParam orgParam = new FilterOrgStructParam((long)modelId, (long)scenarioId, yearMember.getNumber(), (long)periodId);
        orgParam.setFrom(FilterOrgStructParam.FROM_CHECKELIM);
        orgParam.setOpenSortedDictionary(true);
        Map<Long, String> effectiveOrgMap = EntityVersioningUtil.filterEffectiveOrgByMergeStruct(orgParam, doc.stream().map(p -> p.getLong("id")).collect(Collectors.toList()));
        return EntityVersioningUtil.sortOrgByChangeType(modelCubeNumber, (String)mergeEntity.p1, effectiveOrgMap.keySet(), orgParam.getSortedDictionary());
    }

    public static boolean checkCommonParentEntity(String commontEntity, String longNum1, String longNum2) {
        if (commontEntity == null || longNum1 == null || longNum2 == null) {
            return false;
        }
        return commontEntity.equals(IntrEntityHelper.getCommonParentEntity(longNum1, longNum2));
    }

    public static String getCommonParentEntity(String longNum1, String longNum2) {
        String[] split1 = longNum1.split("!");
        String[] split2 = longNum2.split("!");
        int length = Math.min(split2.length, split1.length);
        ArrayList<String> comParent = new ArrayList<String>(length - 1);
        for (int i = 0; i < length && split1[i].equals(split2[i]); ++i) {
            comParent.add(split1[i]);
        }
        int start = comParent.size();
        if (length == start && start > 1) {
            comParent.remove(comParent.size() - 1);
        }
        return String.join((CharSequence)"!", comParent);
    }
}

