/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrMergeContext;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrMergeResult;
import kd.fi.bcm.business.innertrade.model.IntrReportData;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.report.IntrMergeService;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.papertemplate.PaperTemplateRuleHelper;
import kd.fi.bcm.business.papertemplate.filterchain.PaperTmplChainFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.IntrRecordAddition;
import kd.fi.bcm.business.papertemplate.filterchain.filter.OrgAssignFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.SceneFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.StatusFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.VersionFilter;
import kd.fi.bcm.business.papertemplate.filterchain.filter.YearPeriodFilter;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.innertrade.IntrReportStatusEnum;
import kd.fi.bcm.common.enums.innertrade.IntrRptGenTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateRuleTypeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections4.CollectionUtils;

public class IntrMergeHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, IntrMergeHelper.class);

    public static IntrMergeResult generateData(IntrMergeParam param) {
        try {
            log.startWatch();
            IntrMergeContext ctx = new IntrMergeContext(param);
            log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u521d\u59cb\u5316context\u8017\u65f6", param.getEntity()));
            IntrMergeResult result = new IntrMergeService(ctx).generate();
            log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u751f\u6210\u5e95\u7a3f\u6570\u636emerge\u65b9\u6cd5\u8017\u65f6", param.getEntity()));
            log.infoEnd(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u751f\u6210\u5e95\u7a3f\u6570\u636e\u603b\u8017\u65f6", param.getEntity()));
            return result;
        }
        catch (Throwable t) {
            String displayMessage = ThrowableHelper.toString((Throwable)t);
            log.error(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u751f\u6210\u5e95\u7a3f\u6570\u636e\u53d1\u751f\u9519\u8bef\u3002", param.getEntity()), t);
            if (t instanceof KDBizException) {
                displayMessage = t.getMessage();
            }
            return IntrMergeResult.fail(displayMessage);
        }
    }

    public static void generate4SmartMerge(Long userId, SimpleItem modelItem, SimpleItem sceneItem, SimpleItem yearItem, SimpleItem periodItem, SimpleItem entityItem) {
        Long entityId;
        Long modelId = (Long)modelItem.getId();
        String modelNum = modelItem.getNumber();
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNum, (Long)(entityId = (Long)entityItem.getId()));
        if (orgNode.isLeaf()) {
            return;
        }
        String modelShowlNum = MemberReader.findModelSNumberById((Object)modelId);
        Pair model = Pair.onePair((Object)modelId, (Object)modelShowlNum);
        Pair<Long, String> scene = SimpleItem.toPair(sceneItem);
        Pair<Long, String> year = SimpleItem.toPair(yearItem);
        Pair<Long, String> period = SimpleItem.toPair(periodItem);
        Pair entity = Pair.onePair((Object)entityId, (Object)entityItem.getNumber());
        Long ecId = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)orgNode.getCurrency()).getId();
        Pair currency = Pair.onePair((Object)ecId, (Object)orgNode.getCurrency());
        PaperTmplChainFilter filter = new PaperTmplChainFilter((Long)model.p1, PaperTemplateTypeEnum.INNERTRADE, true);
        filter.addFilter(new OrgAssignFilter(Sets.newHashSet((Object[])new Long[]{(Long)entity.p1}))).addFilter(new VersionFilter((Long)year.p1, (Long)period.p1)).addFilter(new SceneFilter((Long)scene.p1)).addFilter(new YearPeriodFilter((Long)year.p1, (Long)period.p1)).addFilter(new StatusFilter(true)).addFilter(new IntrRecordAddition(null, Sets.newHashSet((Object[])new Long[]{(Long)entity.p1}), (Long)scene.p1, (Long)year.p1, (Long)period.p1));
        QFilter qf = new QFilter("model", "=", model.p1);
        qf.and(new QFilter("id", "in", filter.doFilter(null)));
        DynamicObjectCollection tmpls = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number,name,usage", (QFilter[])new QFilter[]{qf});
        if (tmpls == null || tmpls.isEmpty()) {
            return;
        }
        Tuple orgTupl = Tuple.create((Object)orgNode.getId(), (Object)orgNode.getNumber(), (Object)orgNode.getLongNumber());
        log.info(String.format("\u7ec4\u7ec7\u201c%s\u201d\u8fd0\u884c\u667a\u80fd\u5408\u5e76\uff0c\u9700\u8981\u8fd0\u7b97\u7684\u6a21\u677f\u6570\u91cf\uff1a%s", orgTupl.p2, tmpls.size()));
        for (DynamicObject tmpl : tmpls) {
            TXHandle tx = TX.required();
            Throwable throwable = null;
            try {
                try {
                    DynamicObject report = IntrReportHelper.getReportInfo((Long)model.p1, tmpl.getLong("id"), (Long)entity.p1, (Long)scene.p1, (Long)year.p1, (Long)period.p1, (Long)currency.p1);
                    if (report != null && IntrRptGenTypeEnum.MANUAL.value.equals(report.getString("gentype"))) {
                        if (IntrReportStatusEnum.REPORTED.value.equals(report.getString("reportstatus"))) continue;
                        IntrReportHelper.updateStatus(userId, report.getLong("id"), IntrReportStatusEnum.REPORTED.value, "0");
                        continue;
                    }
                    if (report != null && IntrReportStatusEnum.REPORTED.value.equals(report.getString("reportstatus"))) {
                        log.info(String.format("\u7ec4\u7ec7\u201c%s\u201d\u8fd0\u884c\u667a\u80fd\u5408\u5e76\uff0c\u7531\u4e8e\u6a21\u677f\u201c%s\u201d\u7684\u5e95\u7a3f\u72b6\u6001\u5df2\u63d0\u4ea4\uff0c\u81ea\u52a8\u6267\u884c\u6253\u56de\u5e95\u7a3f\u3002", orgTupl.p2, tmpl.getString("number")));
                        IntrReportHelper.updateStatus(userId, report.getLong("id"), IntrReportStatusEnum.REJECTED.value, "0");
                    }
                    IntrMergeParam param = new IntrMergeParam((Pair<Long, String>)model, tmpl.getLong("id"), (Tuple<Long, String, String>)orgTupl, scene, year, period, (Pair<Long, String>)currency);
                    param.setModelNumber(modelNum);
                    param.setSmartMerge(Boolean.TRUE);
                    IntrMergeResult result = null;
                    if ("1".equals(tmpl.getString("usage"))) {
                        Map dimValueMap = MapInitHelper.ofMap((Object)PresetConstant.ENTITY_DIM, (Object)entityId, (Object)PresetConstant.SCENE_DIM, (Object)scene.p1, (Object)PresetConstant.FY_DIM, (Object)year.p1, (Object)PresetConstant.PERIOD_DIM, (Object)period.p1, (Object)PresetConstant.CURRENCY_DIM, (Object)currency.p1, (Object)PresetConstant.PROCESS_DIM, (Object)MemberReader.findProcessMemberByNum((String)modelNum, (String)"ADJ").getId());
                        PaperTemplateRuleHelper.execBizRule(modelId, tmpl.getLong("id"), dimValueMap, PaperTemplateRuleTypeEnum.EXECWHENOPEN, BizRuleExecuteTypeEnum.INTR_ONLY, null);
                        result = IntrMergeHelper.caculateData(param, QueryIntrDataHelper.queryIntrDataByParam(param).getRows());
                    } else {
                        result = IntrMergeHelper.generateData(param);
                    }
                    if (!result.isSuccess()) {
                        log.error(String.format("\u7ec4\u7ec7\u201c%s\u201d\u8fd0\u884c\u667a\u80fd\u5408\u5e76\uff0c\u6a21\u677f\u201c%s\u201c\u8fd0\u884c\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", orgTupl.p2, tmpl.getString("number"), result.getMessage()));
                        throw new KDBizException(result.getMessage());
                    }
                    IntrReportData rptData = new IntrReportData(userId, tmpl.getLong("id"), (Pair<Long, String>)model, (Tuple<Long, String, String>)orgTupl, scene, year, period, (Pair<Long, String>)currency, " ", " ", result.getTable());
                    rptData.setType(IntrRptGenTypeEnum.AUTO);
                    Long rptId = IntrReportHelper.saveReport(rptData);
                    if (report == null) {
                        report = BusinessDataServiceHelper.loadSingleFromCache((Object)rptId, (String)"bcm_intrreportentity", (String)"id,reportstatus,currency.id");
                    }
                    IntrReportHelper.updateStatus(userId, report.getLong("id"), IntrReportStatusEnum.REPORTED.value, "0");
                }
                catch (Exception e) {
                    tx.markRollback();
                    log.error(String.format("\u7ec4\u7ec7\u201c%s\u201d\u8fd0\u884c\u667a\u80fd\u5408\u5e76\uff0c\u6a21\u677f\u201c%s\u201c\u8fd0\u884c\u51fa\u9519\u3002", orgTupl.p2, tmpl.getString("number")), (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    public static IntrMergeResult caculateData(IntrMergeParam param, List<IntrRow> allRowData) {
        try {
            log.startWatch();
            IntrMergeContext ctx = new IntrMergeContext(param);
            if (CollectionUtils.isEmpty(allRowData)) {
                return IntrMergeResult.success(new IntrTable(ctx.getMergeFieldList(), allRowData));
            }
            log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u521d\u59cb\u5316context\u8017\u65f6", param.getEntity()));
            IntrMergeService service = new IntrMergeService(ctx);
            service.setMergeTable(new IntrTable(ctx.getMergeFieldList(), allRowData));
            IntrMergeResult result = service.caculate4CslReport();
            log.info(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u5e95\u7a3f\u5f55\u5165\u7684\u516c\u5f0f\u8ba1\u7b97\u8017\u65f6", param.getEntity()));
            log.infoEnd(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u5e95\u7a3f\u5f55\u5165\u7684\u516c\u5f0f\u8ba1\u7b97\u603b\u8017\u65f6", param.getEntity()));
            return result;
        }
        catch (Throwable t) {
            String displayMessage = ThrowableHelper.toString((Throwable)t);
            log.error(String.format("\u7ec4\u7ec7\uff1a%s\uff0c\u5e95\u7a3f\u5f55\u5165\u7684\u516c\u5f0f\u8ba1\u7b97\u53d1\u751f\u9519\u8bef\u3002", param.getEntity()), t);
            if (t instanceof KDBizException) {
                displayMessage = t.getMessage();
            }
            return IntrMergeResult.fail(displayMessage);
        }
    }
}

