/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.carry.CarryServiceHelper;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.extend.ExtConvertBaseUnit;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeContext;
import kd.fi.bcm.business.innertrade.model.IntrMergeResult;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.report.IntrCalculateFormulaHelper;
import kd.fi.bcm.business.innertrade.report.IntrEntityHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.serviceHelper.ExtConvertServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;

public class IntrMergeService {
    public static final String TYPE_MERGE = "merge";
    public static final String TYPE_BUY = "buy";
    public static final String TYPE_SELL = "sell";
    public static final String SPLIT_SYMBOL = "_";
    protected WatchLogger log;
    private final IntrMergeContext ctx;
    private IntrTable sellerTable;
    private IntrTable buyerTable;
    private IntrTable mergeTable;
    Map<String, List<IntrRow>> lastMergeMap = new HashMap<String, List<IntrRow>>(16);

    public IntrMergeService(IntrMergeContext ctx) {
        this.log = BcmLogFactory.getWatchLogInstance(this.getClass());
        this.ctx = ctx;
    }

    public IntrMergeResult generate() {
        this.prepareData();
        this.generateData();
        this.formatMergeData();
        return IntrMergeResult.success(this.mergeTable);
    }

    public IntrMergeResult caculate4CslReport() {
        if (this.ctx.isHaveLyvFormula()) {
            this.log.info("\u5b58\u5728\u53d6\u4e0a\u671f\u6570\u7684\u516c\u5f0f\uff0c\u9700\u8981\u83b7\u53d6\u4e0a\u671f\u6570\u3002");
            this.lastMergeMap = this.getLastMergeData(this.ctx.getMergeUniqueKeys());
        }
        if (this.ctx.isHaveESPFormula()) {
            Set<String> sellNums = this.mergeTable.getRows().stream().map(item -> item.getData().get(IntrConstant.FIELD_ORG_NUMBER).toString()).collect(Collectors.toSet());
            this.log.info("\u5b58\u5728ESP\u516c\u5f0f\uff0c\u9700\u8981\u521d\u59cb\u5316\u6295\u8d44\u5355\u4f4d\u4fe1\u606f\u3002");
            this.initShareholderMap(sellNums);
        }
        try {
            this.calculateFormula(null, null, this.mergeTable.getRows(), null);
        }
        catch (Exception e) {
            this.log.error("\u516c\u5f0f\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)1)), new Object[0]);
        }
        this.formatMergeData();
        return IntrMergeResult.success(this.mergeTable);
    }

    private void formatMergeData() {
        for (IntrRow row : this.mergeTable.getRows()) {
            Map<String, Object> item = row.getData();
            for (IntrField field : this.mergeTable.getHead()) {
                if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(field.getDataType()) && row.getData().get(field.getNumber()) == null) {
                    row.getData().put(field.getNumber(), BigDecimal.ZERO);
                }
                if (this.ctx.getParam().isSmartMerge() || !"F7".equals(field.getShowType())) continue;
                item.put(field.getNumber(), this.getEntityInfo(field, item.get(field.getNumber())));
            }
        }
    }

    private kd.fi.bcm.common.Pair<Object, String> getEntityInfo(IntrField field, Object value) {
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)this.ctx.getParam().getModelNumber(), (String)((String)field.getDimInfo().p2), (String)value.toString());
        return kd.fi.bcm.common.Pair.onePair((Object)value, (Object)node.getName());
    }

    private void prepareData() {
        this.doConvert();
        Set<String> orgNums = this.ctx.getLeafEntitys().keySet();
        DynamicObjectCollection sellerDataDyn = QueryIntrDataHelper.querySellerOrBuyerData((String)this.ctx.getParam().getModel().p2, (String)this.ctx.getSellerExtModel().p2, (String)this.ctx.getParam().getScenario().p2, (String)this.ctx.getParam().getYear().p2, (String)this.ctx.getParam().getPeriod().p2, (String)this.ctx.getCurrency().p2, orgNums);
        this.log.info(String.format("\u4f53\u7cfb\uff1a%s\uff0c\u62d3\u5c55\u7ef4\uff1a%s\uff0c\u7ec4\u7ec7\uff1a%s\uff0c\u60c5\u666f\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u5e01\u79cd\uff1a%s\uff0c\u53c2\u4e0e\u8fd0\u7b97\u7684\u9500\u552e\u65b9\u6570\u636e\u6761\u6570\uff1a%s\u6761", this.ctx.getParam().getModel().p2, this.ctx.getSellerExtModel().p2, orgNums, this.ctx.getParam().getScenario().p2, this.ctx.getParam().getYear().p2, this.ctx.getParam().getPeriod().p2, this.ctx.getCurrency().p2, sellerDataDyn.size()));
        List<IntrRow> sellerRows = this.convertToTable(this.ctx.getSellerFieldList(), sellerDataDyn, TYPE_SELL);
        this.log.info(String.format("\u8fc7\u6ee4\u540e\u7684\u9500\u552e\u65b9\u6570\u636e\u6761\u6570\uff1a%s\u6761", sellerRows.size()));
        DynamicObjectCollection buyerDataDyn = QueryIntrDataHelper.querySellerOrBuyerData((String)this.ctx.getParam().getModel().p2, (String)this.ctx.getBuyerExtModel().p2, (String)this.ctx.getParam().getScenario().p2, (String)this.ctx.getParam().getYear().p2, (String)this.ctx.getParam().getPeriod().p2, (String)this.ctx.getCurrency().p2, orgNums);
        this.log.info(String.format("\u4f53\u7cfb\uff1a%s\uff0c\u62d3\u5c55\u7ef4\uff1a%s\uff0c\u7ec4\u7ec7\uff1a%s\uff0c\u60c5\u666f\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u5e01\u79cd\uff1a%s\uff0c\u53c2\u4e0e\u8fd0\u7b97\u7684\u91c7\u8d2d\u65b9\u6570\u636e\u6761\u6570\uff1a%s\u6761", this.ctx.getParam().getModel().p2, this.ctx.getBuyerExtModel().p2, orgNums, this.ctx.getParam().getScenario().p2, this.ctx.getParam().getYear().p2, this.ctx.getParam().getPeriod().p2, this.ctx.getCurrency().p2, buyerDataDyn.size()));
        List<IntrRow> buyerRows = this.convertToTable(this.ctx.getBuyerFieldList(), buyerDataDyn, TYPE_BUY);
        this.log.info(String.format("\u8fc7\u6ee4\u540e\u7684\u91c7\u8d2d\u65b9\u6570\u636e\u6761\u6570\uff1a%s\u6761", buyerRows.size()));
        this.sellerTable = this.combineData(this.ctx.getSellerFieldList(), sellerRows.stream().collect(Collectors.groupingBy(item -> this.getUniqueKey((IntrRow)item, this.ctx.getSellerUniqueKeys()))));
        this.buyerTable = this.combineData(this.ctx.getBuyerFieldList(), buyerRows.stream().collect(Collectors.groupingBy(item -> this.getReverseUniqueKey((IntrRow)item, this.ctx.getBuyerUniqueKeys()))));
        if (this.ctx.isHaveLyvFormula()) {
            this.log.info("\u5b58\u5728\u53d6\u4e0a\u671f\u6570\u7684\u516c\u5f0f\uff0c\u9700\u8981\u83b7\u53d6\u4e0a\u671f\u6570\u3002");
            this.lastMergeMap = this.getLastMergeData(this.ctx.getBuyerUniqueKeys());
        }
        if (this.ctx.isHaveESPFormula()) {
            this.log.info("\u5b58\u5728ESP\u516c\u5f0f\uff0c\u9700\u8981\u521d\u59cb\u5316\u6295\u8d44\u5355\u4f4d\u4fe1\u606f\u3002");
            HashSet<String> allSellNum = new HashSet<String>(16);
            for (IntrRow row : this.sellerTable.getRows()) {
                allSellNum.add(row.getData().get(IntrConstant.FIELD_ORG_NUMBER).toString());
            }
            for (IntrRow row : this.buyerTable.getRows()) {
                allSellNum.add(row.getData().get(IntrConstant.FIELD_IC_NUMBER).toString());
            }
            this.initShareholderMap(allSellNum);
        }
        DynamicObjectCollection mergeDataDyn = QueryIntrDataHelper.queryMergeData((String)this.ctx.getParam().getModel().p2, (String)this.ctx.getMergeExtModel().p2, (String)this.ctx.getParam().getEntity().p2, (String)this.ctx.getParam().getScenario().p2, (String)this.ctx.getParam().getYear().p2, (String)this.ctx.getParam().getPeriod().p2, (String)this.ctx.getCurrency().p2);
        this.log.info(String.format("\u4f53\u7cfb\uff1a%s\uff0c\u62d3\u5c55\u7ef4\uff1a%s\uff0c\u7ec4\u7ec7\uff1a%s\uff0c\u60c5\u666f\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u5e01\u79cd\uff1a%s\uff0c\u53c2\u4e0e\u8fd0\u7b97\u7684\u5408\u5e76\u65b9\u6570\u636e\u6761\u6570\uff1a%s\u6761", this.ctx.getParam().getModel().p2, this.ctx.getMergeExtModel().p2, this.ctx.getParam().getEntity().p2, this.ctx.getParam().getScenario().p2, this.ctx.getParam().getYear().p2, this.ctx.getParam().getPeriod().p2, this.ctx.getCurrency().p2, mergeDataDyn.size()));
        this.mergeTable = new IntrTable(this.ctx.getMergeFieldList(), this.convertToTable(this.ctx.getMergeFieldList(), mergeDataDyn, TYPE_MERGE));
        this.log.info(String.format("\u8fc7\u6ee4\u540e\u7684\u5408\u5e76\u65b9\u6570\u636e\u6761\u6570\uff1a%s\u6761", this.mergeTable.getRows().size()));
    }

    private void doConvert() {
        BaseData baseData = new BaseData((Long)this.ctx.getParam().getModel().p1, this.ctx.getParam().getScenario(), this.ctx.getParam().getYear(), this.ctx.getParam().getPeriod());
        ArrayList extModels = Lists.newArrayList((Object[])new SimpleVo[]{SimpleVo.newOne((String)this.ctx.getSellerExtModel().p2, (Long)this.ctx.getSellerExtModel().p1), SimpleVo.newOne((String)this.ctx.getBuyerExtModel().p2, (Long)this.ctx.getBuyerExtModel().p1)});
        List<ExtConvertBaseUnit> convertBaseUnits = this.ctx.getLeafEntitys().entrySet().stream().filter(e -> !((String)this.ctx.getCurrency().p2).equalsIgnoreCase((String)((FourTuple)e.getValue()).item3)).map(kv -> new ExtConvertBaseUnit(baseData, SimpleVo.newOne((String)kv.getKey(), (Long)((FourTuple)kv.getValue()).item4), "ERpt", (String)((FourTuple)kv.getValue()).item3, (String)this.ctx.getCurrency().p2, extModels)).collect(Collectors.toList());
        ExtConvertServiceHelper.convertExtModel(convertBaseUnits);
    }

    private void initShareholderMap(Set<String> allSellNum) {
        if (CollectionUtils.isEmpty(allSellNum)) {
            return;
        }
        QFilter modelQf = new QFilter("model", "=", this.ctx.getParam().getModel().p1);
        modelQf.and("investeecompany.number", "in", allSellNum);
        modelQf.and("iscontrol", "=", (Object)"1");
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bcm_invsharerela", (String)"shareholder.number,investeecompany.number", (QFilter[])new QFilter[]{modelQf});
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DynamicObject doc : list) {
                String investeecompany = doc.getString("investeecompany.number");
                if (this.ctx.getShareholderMap().containsKey(investeecompany)) continue;
                this.ctx.getShareholderMap().put(investeecompany, doc.getString("shareholder.number"));
            }
        }
    }

    private IntrTable combineData(List<IntrField> fieldList, Map<String, List<IntrRow>> rows) {
        ArrayList<IntrRow> result = new ArrayList<IntrRow>(16);
        for (Map.Entry<String, List<IntrRow>> kv : rows.entrySet()) {
            HashMap<String, Object> data = new HashMap<String, Object>(fieldList.size());
            for (IntrField field : fieldList) {
                boolean isSameValue = false;
                boolean isUniqueKey = this.ctx.getBuyerUniqueKeys().contains(field.getNumber());
                boolean isDigital = IntrConstant.DIGITAL_DATA_TYPE.contains(field.getDataType());
                if (!isUniqueKey && !isDigital) {
                    isSameValue = kv.getValue().stream().map(item -> item.getData().get(field.getNumber())).distinct().count() == 1L;
                }
                for (IntrRow item2 : kv.getValue()) {
                    if (isUniqueKey || isSameValue) {
                        data.put(field.getNumber(), item2.getData().get(field.getNumber()));
                        continue;
                    }
                    if (!IntrConstant.DIGITAL_DATA_TYPE.contains(field.getDataType())) continue;
                    data.put(field.getNumber(), this.getBigDecimalValue(data.get(field.getNumber())).add(this.getBigDecimalValue(item2.getData().get(field.getNumber()))));
                }
            }
            result.add(new IntrRow(data));
        }
        return new IntrTable(fieldList, result);
    }

    private BigDecimal getBigDecimalValue(Object value) {
        return value == null ? BigDecimal.ZERO : NumberUtils.createBigDecimal((String)value.toString());
    }

    private List<IntrRow> convertToTable(List<IntrField> fieldList, DynamicObjectCollection dataDyns, String type) {
        ArrayList<IntrRow> rows = new ArrayList<IntrRow>(16);
        for (DynamicObject dyn : dataDyns) {
            boolean isCollect = TYPE_MERGE.equals(type) ? true : this.filterData(dyn, type);
            if (!isCollect) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(this.ctx.getSellerFieldList().size());
            Boolean isDiff = Boolean.FALSE;
            for (IntrField field : fieldList) {
                data.put(field.getNumber(), dyn.get(field.getBoundField()));
                if (!TYPE_MERGE.equals(type) || !"INTR_000".equals(field.getNumber()) || !IntrConstant.getDiffText().equals(dyn.get(field.getBoundField()))) continue;
                isDiff = Boolean.TRUE;
            }
            rows.add(new IntrRow(dyn.getLong("id"), isDiff, data));
        }
        return rows;
    }

    private boolean filterData(DynamicObject dyn, String type) {
        if (TYPE_BUY.equals(type) && StringUtils.isBlank((CharSequence)dyn.getString(this.ctx.getMergeFieldMap().get("INTR_001").getBoundField()))) {
            return false;
        }
        FourTuple<String, String, String, Long> orgInfo = this.ctx.getLeafEntitys().get(dyn.get(IntrConstant.FIELD_ORG_NUMBER).toString());
        return IntrEntityHelper.checkCommonParentEntity((String)this.ctx.getParam().getEntity().p3, (String)orgInfo.item2, (String)this.ctx.getLeafEntitys().get((Object)dyn.get((String)IntrConstant.FIELD_IC_NUMBER).toString()).item2);
    }

    private void generateData() {
        HashMap<String, IntrRow> sellerDataMap = new HashMap<String, IntrRow>(16);
        TreeSet<String> allKey = new TreeSet<String>();
        for (IntrRow row : this.sellerTable.getRows()) {
            String sellerKey = this.getUniqueKey(row, this.ctx.getJoinKeys());
            sellerDataMap.put(sellerKey, row);
            allKey.add(sellerKey);
        }
        Map<String, List<IntrRow>> buyerDataMap = this.buyerTable.getRows().stream().collect(Collectors.groupingBy(item -> this.getReverseUniqueKey((IntrRow)item, this.ctx.getJoinKeys())));
        allKey.addAll(buyerDataMap.keySet());
        ArrayListMultimap diffRowMap = ArrayListMultimap.create();
        ArrayList<IntrRow> mergeData = new ArrayList<IntrRow>(16);
        ArrayListMultimap mergeMap = ArrayListMultimap.create();
        HashMap<String, IntrRow> balanceMap = new HashMap<String, IntrRow>();
        for (String joinKey : allKey) {
            IntrRow diffRow;
            List<IntrRow> buyerRows = buyerDataMap.get(joinKey);
            IntrRow sellerRow = (IntrRow)sellerDataMap.get(joinKey);
            if (buyerRows != null) {
                for (IntrRow row : buyerRows) {
                    HashMap<String, Object> mergeItem = new HashMap<String, Object>(16);
                    for (IntrField field : this.ctx.getMergeFieldList()) {
                        if (!field.isJoinKey() && !"INTR_001".equals(field.getNumber())) continue;
                        this.initMergeFieldValue(sellerRow, row, mergeItem, field);
                    }
                    IntrRow mergeRow = new IntrRow(mergeItem);
                    mergeMap.put((Object)this.getUniqueKey(mergeRow, this.ctx.getBuyerUniqueKeys()), (Object)mergeRow);
                    mergeData.add(mergeRow);
                }
                diffRow = this.calculateMergeFormula(sellerRow, buyerRows);
                if (diffRow == null) continue;
                mergeData.add(diffRow);
                mergeMap.put((Object)this.getUniqueKey(diffRow, this.ctx.getBuyerUniqueKeys()), (Object)diffRow);
                balanceMap.put(joinKey, this.getBalanceRow(diffRow));
                diffRowMap.put((Object)this.getUniqueKey(diffRow, this.ctx.getJoinKeys()), (Object)diffRow);
                continue;
            }
            if (sellerRow == null) continue;
            if (StringUtils.isNotBlank((CharSequence)this.ctx.getIntrCheckParam().getMfFormulaText())) {
                diffRow = this.calculateMergeFormula((IntrRow)sellerDataMap.get(joinKey), null);
                if (diffRow == null) continue;
                mergeData.add(diffRow);
                mergeMap.put((Object)this.getUniqueKey(diffRow, this.ctx.getBuyerUniqueKeys()), (Object)diffRow);
                balanceMap.put(joinKey, this.getBalanceRow(diffRow));
                diffRowMap.put((Object)this.getUniqueKey(diffRow, this.ctx.getJoinKeys()), (Object)diffRow);
                continue;
            }
            HashMap<String, Object> mapRow = new HashMap<String, Object>();
            mapRow.put("INTR_001", IntrConstant.getBisNoDiffType());
            IntrRow mergeRow = new IntrRow(mapRow);
            this.initUniqueKeyValue(sellerRow, buyerRows, mergeRow);
            mergeData.add(mergeRow);
            mergeMap.put((Object)this.getUniqueKey(mergeRow, this.ctx.getBuyerUniqueKeys()), (Object)mergeRow);
        }
        int index = this.ctx.getBuyerUniqueKeys().indexOf(this.ctx.getIntrCheckParam().getBuyFieldNum());
        if (CollectionUtils.isNotEmpty(this.mergeTable.getRows())) {
            Map<String, List<IntrRow>> oldMergeMap = this.mergeTable.getRows().stream().collect(Collectors.groupingBy(item -> this.getUniqueKey((IntrRow)item, this.ctx.getBuyerUniqueKeys())));
            for (String unKey : mergeMap.keySet()) {
                List<IntrRow> oldRows = null;
                Iterator iterator = mergeMap.get((Object)unKey).iterator();
                while (iterator.hasNext()) {
                    IntrRow row;
                    if (index >= 0 & (row = (IntrRow)iterator.next()).isDiffRow()) {
                        String specialOldUnKey = this.getSpecialOldUnKey(row);
                        oldRows = oldMergeMap.get(specialOldUnKey);
                    } else {
                        oldRows = oldMergeMap.get(unKey);
                    }
                    if (!CollectionUtils.isNotEmpty(oldRows)) continue;
                    Optional<IntrRow> matchRow = oldRows.stream().filter(item -> row.isDiffRow() == item.isDiffRow()).findFirst();
                    matchRow.ifPresent(temp -> {
                        for (IntrField field : this.ctx.getMergeFieldList()) {
                            if (field.isReadOnly()) continue;
                            row.getData().put(field.getNumber(), temp.getData().get(field.getNumber()));
                        }
                    });
                }
            }
        }
        try {
            this.calculateFormula(sellerDataMap, buyerDataMap, mergeData, balanceMap);
        }
        catch (Exception e) {
            this.log.error("\u516c\u5f0f\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)1)), new Object[0]);
        }
        this.mergeTable.setRows(mergeData);
    }

    private void calculateFormula(Map<String, IntrRow> sellerDataMap, Map<String, List<IntrRow>> buyerDataMap, List<IntrRow> mergeData, Map<String, IntrRow> balanceMap) throws Exception {
        Map<Integer, List<IntrField>> seqFormulaMap = IntrCalculateFormulaHelper.handleFormula(this.ctx);
        HashMap<String, Map<String, Object>> ctxDataMap = new HashMap<String, Map<String, Object>>(16);
        TreeMap allSeqFormulaMap = new TreeMap(Comparator.naturalOrder());
        for (int i = 0; i < mergeData.size(); ++i) {
            IntrRow mergeRow2 = mergeData.get(i);
            Map<String, Object> rowContextData = this.getRowContextData(sellerDataMap, buyerDataMap, mergeRow2, balanceMap);
            ctxDataMap.put(IntrConstant.getRowKey((int)i), rowContextData);
            kd.fi.bcm.common.Pair<String, String> invest = this.getInvestRelation((Map)rowContextData.get(this.ctx.getSellerExtModel().p2), mergeRow2, this.ctx.getEntityHolding());
            for (Map.Entry<Integer, List<IntrField>> kv : seqFormulaMap.entrySet()) {
                List fourTuples = allSeqFormulaMap.computeIfAbsent(kv.getKey(), k -> new ArrayList(16));
                for (IntrField field : kv.getValue()) {
                    String newFormula = field.getFormula().replaceAll("####ROW_KEY####", IntrConstant.getRowKey((int)i)).replaceAll("####SHAREHOLDER####", (String)invest.p1).replaceAll("####INVEST####", (String)invest.p2);
                    fourTuples.add(Tuple.create((Object)i, (Object)field, (Object)newFormula));
                }
            }
        }
        CalContext calContext = new CalContext(this.ctx.getParam().getModelNumber(), (Long)this.ctx.getParam().getModel().p1, (Long)this.ctx.getParam().getYear().p1, (Long)this.ctx.getParam().getPeriod().p1, (Long)this.ctx.getParam().getScenario().p1);
        calContext.setProperty("INTR_FORMULA_CONTEXT_DATA", ctxDataMap);
        if (this.ctx.isHaveESPFormula()) {
            calContext.setProperty("espKvMapCache", this.ctx.getEspKvMapCache());
            calContext.setProperty("scenario", this.ctx.getParam().getScenario().p2);
            calContext.setProperty("year", this.ctx.getParam().getYear().p2);
            calContext.setProperty("period", this.ctx.getParam().getPeriod().p2);
        }
        CalculateService calculateService = new CalculateService(calContext);
        calculateService.setLog(Boolean.FALSE);
        for (Map.Entry kv : allSeqFormulaMap.entrySet()) {
            ArrayList<kd.fi.bcm.common.Pair> calRes = new ArrayList<kd.fi.bcm.common.Pair>(16);
            for (Tuple tuple : (List)kv.getValue()) {
                calRes.add(kd.fi.bcm.common.Pair.onePair((Object)tuple, (Object)calculateService.addCalculateExpress((String)tuple.p3)));
            }
            calculateService.batchCalculate();
            for (kd.fi.bcm.common.Pair item : calRes) {
                Object value = this.dealValue(calculateService.evalExpress((ExpressStatus)item.p2), (IntrField)((Tuple)item.p1).p2);
                mergeData.get((Integer)((Tuple)item.p1).p1).getData().put(((IntrField)((Tuple)item.p1).p2).getNumber(), value);
                Map calMergeDataMap = (Map)((Map)ctxDataMap.get(IntrConstant.getRowKey((int)((Integer)((Tuple)item.p1).p1)))).get(this.ctx.getMergeExtModel().p2);
                calMergeDataMap.put(((IntrField)((Tuple)item.p1).p2).getNumber(), value);
            }
            calculateService.clear();
        }
        mergeData.parallelStream().forEach(mergeRow -> {
            if (mergeRow.isDiffRow() && StringUtils.isNotEmpty((CharSequence)this.ctx.getIntrCheckParam().getBuyFieldNum())) {
                mergeRow.getData().put(this.ctx.getIntrCheckParam().getBuyFieldNum(), BigDecimal.ZERO);
            }
        });
    }

    private Object dealValue(Object value, IntrField field) {
        if (value instanceof Exception) {
            this.log.error(String.format("%s \u516c\u5f0f\u8ba1\u7b97\u5f02\u5e38: %s", field.getName(), value));
            return null;
        }
        if (BCMConstant.Zero == value && !IntrConstant.DB_DIGITAL_DATA_TYPE.contains(field.getDataType())) {
            value = null;
        }
        if (value != null) {
            if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(field.getDataType()) && !NumberUtils.isCreatable((String)value.toString())) {
                value = BigDecimal.ZERO;
            }
            if (DataTypeEnum.DATETP.getOIndex().equals(field.getDataType()) && DateTimeUtils.getOADateStr((String)value.toString(), null) == null) {
                value = null;
            }
        }
        if (DebugServiceHelper.isDebugModel()) {
            this.log.info(String.format("%s \u516c\u5f0f\u8ba1\u7b97: %s", field.getName(), value));
        }
        return value;
    }

    private Map<String, Object> getRowContextData(Map<String, IntrRow> sellerDataMap, Map<String, List<IntrRow>> buyerDataMap, IntrRow mergeRow, Map<String, IntrRow> balanceMap) {
        HashMap<String, Object> reulst = new HashMap<String, Object>(16);
        IntrRow sellerRow = null;
        List<IntrRow> buyerRows = null;
        IntrRow balanceRow = null;
        if (!this.ctx.isCsl()) {
            String joinKey = this.getUniqueKey(mergeRow, this.ctx.getJoinKeys());
            sellerRow = sellerDataMap != null ? sellerDataMap.get(joinKey) : null;
            buyerRows = buyerDataMap != null ? buyerDataMap.get(joinKey) : null;
            balanceRow = balanceMap != null ? balanceMap.get(joinKey) : null;
        }
        String uniqueKey = this.getUniqueKey(mergeRow, this.ctx.isCsl() ? this.ctx.getMergeUniqueKeys() : this.ctx.getBuyerUniqueKeys());
        IntrRow buyerRow = null;
        if (buyerRows != null && !buyerRows.isEmpty()) {
            buyerRow = buyerRows.stream().filter(row -> mergeRow.isDiffRow() == row.isDiffRow()).filter(row -> this.getReverseUniqueKey((IntrRow)row, this.ctx.getBuyerUniqueKeys()).equals(uniqueKey)).findFirst().orElse(null);
        }
        IntrRow lastMergeRow = null;
        if (this.lastMergeMap != null && this.lastMergeMap.containsKey(uniqueKey)) {
            lastMergeRow = this.lastMergeMap.get(uniqueKey).stream().filter(item -> mergeRow.isDiffRow() == item.isDiffRow()).findFirst().orElse(null);
        }
        ArrayList<HashMap<String, Object>> sellerMapRows = new ArrayList<HashMap<String, Object>>(16);
        HashMap<String, Object> sellerMapRow = new HashMap<String, Object>(16);
        if (Objects.nonNull(sellerRow)) {
            this.convertMapRow(sellerRow, sellerMapRow);
        }
        sellerMapRows.add(sellerMapRow);
        HashMap<String, Object> buyerMapRow = new HashMap<String, Object>(16);
        if (Objects.nonNull(buyerRow)) {
            this.convertMapRow(buyerRow, buyerMapRow);
        }
        ArrayList<Map<String, Object>> buyerMapRows = new ArrayList<Map<String, Object>>(16);
        if (Objects.nonNull(buyerRows)) {
            buyerRows.forEach(e -> {
                HashMap<String, Object> mapRow = new HashMap<String, Object>(e.getData().size());
                this.convertMapRow((IntrRow)e, (Map<String, Object>)mapRow);
                buyerMapRows.add(mapRow);
            });
        }
        HashMap<String, Object> mergeMapRow = new HashMap<String, Object>(16);
        this.convertMapRow(mergeRow, mergeMapRow);
        if (Objects.nonNull(balanceRow)) {
            buyerMapRows.add(balanceRow.getData());
            if (Objects.isNull(buyerRow) && IntrConstant.getDiffText().equals(mergeRow.getData().get("INTR_000"))) {
                buyerMapRow.putAll(balanceRow.getData());
            }
        }
        reulst.put((String)this.ctx.getSellerExtModel().p2, sellerMapRow);
        reulst.put((String)this.ctx.getBuyerExtModel().p2, buyerMapRow);
        reulst.put((String)this.ctx.getBuyerExtModel().p2 + "_list", buyerMapRows);
        reulst.put((String)this.ctx.getMergeExtModel().p2, mergeMapRow);
        reulst.put((String)this.ctx.getSellerExtModel().p2 + "_list", sellerMapRows);
        reulst.put("INTR_FORMULA_LAST_MERGEROW", lastMergeRow);
        return reulst;
    }

    private String getSpecialOldUnKey(IntrRow row) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.putAll(row.getData());
        data.put(this.ctx.getIntrCheckParam().getBuyFieldNum(), BigDecimal.ZERO.stripTrailingZeros());
        IntrRow specialRow = new IntrRow(row.getId(), row.isDiffRow(), data);
        return this.getUniqueKey(specialRow, this.ctx.getBuyerUniqueKeys());
    }

    private IntrRow getBalanceRow(IntrRow diffRow) {
        HashMap<String, Object> balanceData = new HashMap<String, Object>(1);
        balanceData.put(this.ctx.getIntrCheckParam().getBuyFieldNum(), diffRow.getData().get(this.ctx.getIntrCheckParam().getBuyFieldNum()));
        return new IntrRow(balanceData);
    }

    private Map<String, List<IntrRow>> getLastMergeData(List<String> uniqueKeys) {
        Pair<Long, String> lastCarry = CarryServiceHelper.getEntityCarryLast((Long)this.ctx.getParam().getModel().p1, (Long)this.ctx.getParam().getScenario().p1, (Long)this.ctx.getParam().getYear().p1, (Long)this.ctx.getParam().getPeriod().p1, (Long)this.ctx.getParam().getEntity().p1);
        if (lastCarry == null || ((Long)lastCarry.getLeft()).equals(0L) || ((String)lastCarry.getRight()).equals("")) {
            this.log.error(String.format("year=%s,period=%s,\u627e\u4e0d\u5230\u4e0a\u671f\u8d22\u5e74\u671f\u95f4\uff0c\u6240\u9009\u8d22\u5e74\u53ef\u80fd\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u6ca1\u6709\u4e0a\u671f\u3002", this.ctx.getParam().getYear(), this.ctx.getParam().getPeriod()));
            return new HashMap<String, List<IntrRow>>(1);
        }
        String extModel = (String)this.ctx.getMergeExtModel().p2;
        IDNumberTreeNode yearNode = MemberReader.findFyMemberByNum((String)this.ctx.getParam().getModelNumber(), (String)((String)lastCarry.getRight()));
        if (IDNumberTreeNode.NotFoundTreeNode == yearNode) {
            this.log.error(String.format("modelNum=%s,yearNum=%s,Memberreader\u627e\u4e0d\u5230\u6570\u636e\u3002", this.ctx.getParam().getModelNumber(), lastCarry.getRight()));
            return new HashMap<String, List<IntrRow>>(1);
        }
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((Long)((Long)this.ctx.getParam().getModel().p1), (Long)((Long)lastCarry.getLeft()));
        if (IDNumberTreeNode.NotFoundTreeNode == periodNode) {
            this.log.error(String.format("modelId=%s,periodId=%s,Memberreader\u627e\u4e0d\u5230\u6570\u636e\u3002", this.ctx.getParam().getModel().p1, lastCarry.getLeft()));
            return new HashMap<String, List<IntrRow>>(1);
        }
        try {
            DynamicObject versionTmpl = IntrTemplateHelper.getVerionTemplateInfo((Long)this.ctx.getParam().getModel().p1, yearNode.getId(), (Long)lastCarry.getLeft(), this.ctx.getParam().getTemplateId());
            extModel = versionTmpl.getString("mergenode.number");
        }
        catch (Exception e) {
            this.log.error("\u67e5\u627e\u6709\u6548\u7248\u672c\u7684\u6a21\u677f\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
        }
        DynamicObjectCollection mergeDataDyn = QueryIntrDataHelper.queryMergeData((String)this.ctx.getParam().getModel().p2, extModel, (String)this.ctx.getParam().getEntity().p2, (String)this.ctx.getParam().getScenario().p2, yearNode.getNumber(), periodNode.getNumber(), (String)this.ctx.getCurrency().p2);
        this.log.info(String.format("\u4f53\u7cfb\uff1a%s\uff0c\u62d3\u5c55\u7ef4\uff1a%s\uff0c\u7ec4\u7ec7\uff1a%s\uff0c\u60c5\u666f\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u5e01\u79cd\uff1a%s\uff0c\u4e0a\u671f\u5408\u5e76\u65b9\u6570\u636e\u6761\u6570\uff1a%s\u6761", this.ctx.getParam().getModel().p2, extModel, this.ctx.getParam().getEntity().p2, this.ctx.getParam().getScenario().p2, yearNode.getNumber(), periodNode.getNumber(), this.ctx.getCurrency().p2, mergeDataDyn.size()));
        return this.convertToTable(this.ctx.getMergeFieldList(), mergeDataDyn, TYPE_MERGE).stream().collect(Collectors.groupingBy(item -> this.getUniqueKey((IntrRow)item, uniqueKeys)));
    }

    private IntrRow calculateMergeFormula(IntrRow sellerRow, List<IntrRow> buyerRows) {
        BigDecimal diffValue;
        if (sellerRow == null && buyerRows == null || StringUtils.isEmpty((CharSequence)this.ctx.getIntrCheckParam().getMfFormulaText())) {
            return null;
        }
        BigDecimal buySum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(buyerRows)) {
            for (IntrRow buyerRow : buyerRows) {
                BigDecimal temp = (BigDecimal)buyerRow.getData().get(this.ctx.getIntrCheckParam().getBuyFieldNum());
                if (temp == null) continue;
                buySum = buySum.add(temp);
            }
        }
        BigDecimal sellValue = BigDecimal.ZERO;
        if (sellerRow != null && sellerRow.getData().get(this.ctx.getIntrCheckParam().getSellFieldNum()) != null) {
            sellValue = (BigDecimal)sellerRow.getData().get(this.ctx.getIntrCheckParam().getSellFieldNum());
        }
        if ((diffValue = sellValue.subtract(buySum)).compareTo(BigDecimal.ZERO) != 0) {
            HashMap<String, Object> mapRow = new HashMap<String, Object>();
            mapRow.put(this.ctx.getIntrCheckParam().getBisNum(), this.ctx.getIntrCheckParam().getFillBisType());
            mapRow.put(this.ctx.getIntrCheckParam().getBuyFieldNum(), diffValue);
            mapRow.put("INTR_000", IntrConstant.getDiffText());
            IntrRow mergeRow = new IntrRow(mapRow);
            mergeRow.setDiffRow(true);
            this.initUniqueKeyValue(sellerRow, buyerRows, mergeRow);
            return mergeRow;
        }
        return null;
    }

    private void initUniqueKeyValue(IntrRow sellerRow, List<IntrRow> buyerRows, IntrRow mergeRow) {
        for (String key : this.ctx.getBuyerUniqueKeys()) {
            Object value;
            if ("INTR_001".equals(key) || "INTR_000".equals(key) || this.ctx.getIntrCheckParam().getBuyFieldNum() != null && this.ctx.getIntrCheckParam().getBuyFieldNum().equals(key)) continue;
            Object object = value = sellerRow != null ? sellerRow.getData().get(key) : null;
            if (Objects.isNull(value) && buyerRows != null && !buyerRows.isEmpty()) {
                IntrRow intrRow = buyerRows.get(0);
                value = IntrConstant.FIELD_ORG_NUMBER.equalsIgnoreCase(key) ? intrRow.getData().get(IntrConstant.FIELD_IC_NUMBER) : (IntrConstant.FIELD_IC_NUMBER.equalsIgnoreCase(key) ? intrRow.getData().get(IntrConstant.FIELD_ORG_NUMBER) : intrRow.getData().get(key));
            }
            mergeRow.getData().put(key, value);
        }
    }

    private void initMergeFieldValue(IntrRow sellerRow, IntrRow buyerRow, Map<String, Object> mergeData, IntrField field) {
        Object value = null;
        if (sellerRow != null && sellerRow.getData().containsKey(field.getNumber())) {
            value = sellerRow.getData().get(field.getNumber());
        }
        if (value == null && buyerRow != null && buyerRow.getData().containsKey(field.getNumber())) {
            value = IntrConstant.FIELD_ORG_NUMBER.equals(field.getNumber()) ? buyerRow.getData().get(IntrConstant.FIELD_IC_NUMBER) : (IntrConstant.FIELD_IC_NUMBER.equals(field.getNumber()) ? buyerRow.getData().get(IntrConstant.FIELD_ORG_NUMBER) : buyerRow.getData().get(field.getNumber()));
        }
        if (value != null) {
            mergeData.put(field.getNumber(), value);
        }
    }

    private String getUniqueKey(IntrRow row, List<String> uniqueKeys) {
        ArrayList uks = new ArrayList(16);
        uniqueKeys.forEach(field -> uks.add(this.getDefaultValue(row.getData(), (String)field).toString()));
        return String.join((CharSequence)SPLIT_SYMBOL, uks);
    }

    private Object getDefaultValue(Map<String, Object> dataMap, String field) {
        if (dataMap != null && dataMap.get(field) != null) {
            Object value = dataMap.get(field);
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).stripTrailingZeros();
            }
            return value;
        }
        Object defaultValue = "";
        IntrField intrField = this.ctx.getMergeFieldMap().get(field);
        if (intrField != null && IntrConstant.DB_DIGITAL_DATA_TYPE.contains(intrField.getDataType())) {
            defaultValue = BigDecimal.ZERO.stripTrailingZeros();
        }
        return defaultValue;
    }

    private String getReverseUniqueKey(IntrRow row, List<String> uniqueKeys) {
        Map<String, Object> item = row.getData();
        ArrayList uks = new ArrayList(16);
        uniqueKeys.forEach(field -> {
            if (IntrConstant.FIELD_ORG_NUMBER.equals(field) || IntrConstant.FIELD_IC_NUMBER.equals(field)) {
                if (IntrConstant.FIELD_ORG_NUMBER.equals(field)) {
                    uks.add(item.getOrDefault(IntrConstant.FIELD_IC_NUMBER, "").toString());
                }
                if (IntrConstant.FIELD_IC_NUMBER.equals(field)) {
                    uks.add(item.getOrDefault(IntrConstant.FIELD_ORG_NUMBER, "").toString());
                }
            } else {
                uks.add(this.getDefaultValue(item, (String)field).toString());
            }
        });
        return String.join((CharSequence)SPLIT_SYMBOL, uks);
    }

    private void convertMapRow(IntrRow intrRow, Map<String, Object> mapRow) {
        mapRow.putAll(intrRow.getData());
    }

    private kd.fi.bcm.common.Pair<String, String> getInvestRelation(Map<String, Object> sellerMapRow, IntrRow mergeRow, String holdingEntiy) {
        String sellOrgNum = (String)sellerMapRow.get(IntrConstant.FIELD_ORG_NUMBER);
        String shareholder = "";
        String investeecompany = "";
        if (StringUtils.isEmpty((CharSequence)sellOrgNum)) {
            sellOrgNum = (String)mergeRow.getData().get(IntrConstant.FIELD_ORG_NUMBER);
        }
        if (sellOrgNum.equals(holdingEntiy)) {
            kd.fi.bcm.common.Pair invest = kd.fi.bcm.common.Pair.onePair((Object)shareholder, (Object)investeecompany);
            return invest;
        }
        if (this.ctx.getShareholderMap().get(sellOrgNum) != null) {
            shareholder = this.ctx.getShareholderMap().get(sellOrgNum);
            investeecompany = sellOrgNum;
        }
        kd.fi.bcm.common.Pair invest = kd.fi.bcm.common.Pair.onePair((Object)shareholder, (Object)investeecompany);
        return invest;
    }

    public IntrTable getMergeTable() {
        return this.mergeTable;
    }

    public void setMergeTable(IntrTable mergeTable) {
        this.mergeTable = mergeTable;
    }
}

