/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrReportData;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.innertrade.report.IntrEntityHelper;
import kd.fi.bcm.business.innertrade.report.IntrMergeHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.innertrade.report.QueryIntrDataHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.enums.innertrade.IntrReportStatusEnum;
import kd.fi.bcm.common.enums.innertrade.IntrRptGenTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class IntrReportHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, IntrReportHelper.class);
    public static final String BASE_FIELD = "id,reportstatus,gentype,currency.id,completer,completetime,commitor,committime,firstcommittime,committimes,sendbacker,sendbacktime,sendbacktimes,creator,createtime,modifier,modifytime";
    private static final String SPLIT_SYMBOL = "_";
    public static final String DIM_SEPARATOR = "|";

    public static DynamicObject getReportBaseInfo(Long modelId, Long templateId, Long entityId, Long scenarioId, Long yearId, Long periodId, Long currencyId) {
        Long realCurrencyId = (Long)IntrReportHelper.getRealCurrencyId((Long)modelId, (Long)entityId, (Long)currencyId).p1;
        return IntrReportHelper.getReport(modelId, templateId, entityId, scenarioId, yearId, periodId, realCurrencyId, BASE_FIELD);
    }

    public static DynamicObject getReportInfo(Long modelId, Long templateId, Long entityId, Long scenarioId, Long yearId, Long periodId, Long currencyId) {
        Long realCurrencyId = (Long)IntrReportHelper.getRealCurrencyId((Long)modelId, (Long)entityId, (Long)currencyId).p1;
        String selectFileds = "id,reportstatus,gentype,currency.id,completer,completetime,commitor,committime,firstcommittime,committimes,sendbacker,sendbacktime,sendbacktimes,creator,createtime,modifier,modifytime,spreadjson,data";
        return IntrReportHelper.getReport(modelId, templateId, entityId, scenarioId, yearId, periodId, realCurrencyId, selectFileds);
    }

    public static Pair<Long, String> getRealCurrencyId(Long modelId, Long entityId, Long currencyId) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberById((String)modelNum, (Long)currencyId);
        if (CurrencyEnum.EC.getNumber().equals(currencyNode.getNumber()) || CurrencyEnum.DC.getNumber().equals(currencyNode.getNumber())) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNum, (Long)entityId);
            currencyNode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)orgNode.getCurrency());
        }
        return Pair.onePair((Object)currencyNode.getId(), (Object)currencyNode.getNumber());
    }

    private static Long getEntityBaseId(Long modelId, Long entityId) {
        return MemberReader.change2BaseMember((String)MemberReader.findModelNumberById((Object)modelId), (Long)entityId);
    }

    public static DynamicObject getCurrencyDyn(Long modelId, Long currencyId) {
        QFilter numberFilter = new QFilter("id", "=", (Object)currencyId);
        QFilter modelFilter = new QFilter("model.id", "=", (Object)modelId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{numberFilter, modelFilter});
    }

    public static Long saveReport(IntrReportData rptData) {
        String selectFileds = "id,reportstatus,gentype,currency.id,completer,completetime,commitor,committime,firstcommittime,committimes,sendbacker,sendbacktime,sendbacktimes,creator,createtime,modifier,modifytime,spreadjson,data";
        Pair<Long, String> realCurrency = IntrReportHelper.getRealCurrencyId((Long)rptData.getModel().p1, (Long)rptData.getEntity().p1, (Long)rptData.getCurrency().p1);
        DynamicObject rpt = IntrReportHelper.getReport((Long)rptData.getModel().p1, rptData.getTemplateId(), (Long)rptData.getEntity().p1, (Long)rptData.getScenario().p1, (Long)rptData.getYear().p1, (Long)rptData.getPeriod().p1, (Long)realCurrency.p1, selectFileds);
        Date now = new Date();
        if (rpt == null) {
            rpt = BusinessDataServiceHelper.newDynamicObject((String)"bcm_intrreportentity");
            rpt.set("model", rptData.getModel().p1);
            rpt.set("papertemplate", (Object)rptData.getTemplateId());
            rpt.set("entity", (Object)IntrReportHelper.getEntityBaseId((Long)rptData.getModel().p1, (Long)rptData.getEntity().p1));
            rpt.set("scenario", rptData.getScenario().p1);
            rpt.set("year", rptData.getYear().p1);
            rpt.set("period", rptData.getPeriod().p1);
            rpt.set("currency", realCurrency.p1);
            rpt.set("creator", (Object)rptData.getActionUserId());
            rpt.set("createtime", (Object)now);
            rpt.set("modifier", (Object)rptData.getActionUserId());
            rpt.set("modifytime", (Object)now);
        } else {
            rpt.set("modifier", (Object)rptData.getActionUserId());
            rpt.set("modifytime", (Object)now);
        }
        rpt.set("reportstatus", (Object)IntrReportStatusEnum.EDITING.value);
        rpt.set("gentype", (Object)rptData.getType().value);
        rpt.set("spreadjson", (Object)rptData.getSpreadJson());
        rpt.set("data", (Object)rptData.getSpreadManager());
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)rptData.getTemplateId(), (String)"bcm_papertemplate", (String)"id,mergenode.number,usage");
                IntrReportHelper.setIntrRowOldId(rptData, template);
                IntrReportHelper.deleteExtData((String)rptData.getModel().p2, (String)rptData.getEntity().p2, (String)rptData.getScenario().p2, (String)rptData.getYear().p2, (String)rptData.getPeriod().p2, (String)realCurrency.p2, template.getString("mergenode.number"));
                IntrReportHelper.saveExtModelData(rptData, (String)realCurrency.p2, template.getString("mergenode.number"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpt});
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("--\u4fdd\u5b58\u5185\u90e8\u4ea4\u6613\u62a5\u8868\u6570\u636e\u51fa\u9519--", t);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%s", (String)"IntrReportHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), t.getMessage()));
            }
        }
        return rpt.getLong("id");
    }

    private static void setIntrRowOldId(IntrReportData rptData, DynamicObject template) {
        if (rptData.getTable().getRows() != null && !rptData.getTable().getRows().isEmpty()) {
            HashMap oldIdMap = new HashMap(16);
            List<IntrField> uniqueFields = IntrReportHelper.getUniqueFields(rptData.getTable().getHead(), template.getString("usage"));
            Pair<Long, String> realCurrency = IntrReportHelper.getRealCurrencyId((Long)rptData.getModel().p1, (Long)rptData.getEntity().p1, (Long)rptData.getCurrency().p1);
            IntrMergeParam param = new IntrMergeParam(rptData.getModel(), template.getLong("id"), rptData.getEntity(), rptData.getScenario(), rptData.getYear(), rptData.getPeriod(), realCurrency);
            IntrTable intrTable = QueryIntrDataHelper.queryIntrDataByParam(param);
            if (intrTable != null && intrTable.getRows() != null && !intrTable.getRows().isEmpty()) {
                intrTable.getRows().forEach(r -> {
                    ArrayList key = new ArrayList(16);
                    uniqueFields.forEach(f -> {
                        Object v = r.getData().get(f.getNumber());
                        String valueStr = v instanceof BigDecimal ? ((BigDecimal)v).stripTrailingZeros().toString() : (v == null ? "" : v.toString());
                        key.add(valueStr);
                    });
                    oldIdMap.put(String.join((CharSequence)"#", key), r.getId());
                });
            }
            if (!oldIdMap.isEmpty()) {
                rptData.getTable().getRows().forEach(r -> {
                    ArrayList key = new ArrayList(16);
                    uniqueFields.forEach(f -> {
                        Object v = r.getData().get(f.getNumber());
                        key.add(v == null ? "" : v.toString());
                    });
                    r.setId((Long)oldIdMap.get(String.join((CharSequence)"#", key)));
                });
            }
        }
    }

    private static void saveExtModelData(IntrReportData rptData, String currencyNum, String mergeExtNum) throws ParseException {
        List<IntrField> head = rptData.getTable().getHead();
        List<IntrRow> rows = rptData.getTable().getRows();
        List<DynamicObject> dynDatas = IntrReportHelper.getExtDataDyn((String)rptData.getModel().p2, (String)rptData.getEntity().p2, (String)rptData.getScenario().p2, (String)rptData.getYear().p2, (String)rptData.getPeriod().p2, currencyNum, mergeExtNum, head, rows);
        SaveServiceHelper.save((DynamicObject[])dynDatas.toArray(new DynamicObject[0]));
    }

    private static List<DynamicObject> getExtDataDyn(String modelNum, String entityNum, String sceneNum, String yearNum, String periodNum, String currencyNum, String mergeExtNum, List<IntrField> head, List<IntrRow> rows) throws ParseException {
        ArrayList<DynamicObject> dynDatas = new ArrayList<DynamicObject>(rows.size());
        String groupNum = IntrReportHelper.getGroupNumByModelNum((long)MemberReader.findModelIdByShowNum((String)modelNum), mergeExtNum);
        for (IntrRow row : rows) {
            Map<String, Object> data = row.getData();
            DynamicObject extData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_extenddata_bus");
            if (row.getId() != null) {
                extData.set("id", (Object)row.getId());
            }
            extData.set("modelnumber", (Object)modelNum);
            extData.set("scenario", (Object)sceneNum);
            extData.set("year", (Object)yearNum);
            extData.set("period", (Object)periodNum);
            extData.set("currency", (Object)currencyNum);
            extData.set("datamodel", (Object)mergeExtNum);
            extData.set("extendsgroup", (Object)groupNum);
            extData.set("process", (Object)"ADJ");
            extData.set("audittrail", (Object)"EntityInput");
            extData.set("org", (Object)entityNum);
            if (row.getRowNumber() != null) {
                extData.set("sid", (Object)("AIT_" + row.getRowNumber()));
            }
            for (IntrField field : head) {
                Object value = data.get(field.getNumber());
                if (value != null && (DataTypeEnum.DATETP.getOIndex().equals(field.getDataType()) || DataTypeEnum.DATETP.getOIndex().equals(field.getEunmDataType()))) {
                    value = DateTimeUtils.parseStrDate((String)value.toString());
                }
                extData.set(field.getBoundField(), value);
            }
            dynDatas.add(extData);
        }
        return dynDatas;
    }

    public static DynamicObject getReport(Long modelId, Long templateId, Long entityId, Long scenarioId, Long yearId, Long periodId, Long currencyId, String selectFileds) {
        QFBuilder qf = new QFBuilder();
        qf.add("papertemplate", "=", (Object)templateId);
        qf.add("entity", "=", (Object)IntrReportHelper.getEntityBaseId(modelId, entityId));
        qf.add("scenario", "=", (Object)scenarioId);
        qf.add("year", "=", (Object)yearId);
        qf.add("period", "=", (Object)periodId);
        qf.add("currency", "=", (Object)currencyId);
        return BusinessDataServiceHelper.loadSingle((String)"bcm_intrreportentity", (String)selectFileds, (QFilter[])qf.toArray());
    }

    public static void updateStatus(Long actionUserId, Long reportId, String status, String executeSourceType) {
        String selectFields = "id,reportstatus,gentype,currency.id,completer,completetime,commitor,committime,firstcommittime,committimes,sendbacker,sendbacktime,sendbacktimes,creator,createtime,modifier,modifytime,model.id,papertemplate.id,entity.id,scenario.id,year.id,period.id,currency.id";
        Date now = new Date();
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"bcm_intrreportentity", (String)selectFields);
        try (TXHandle tx = TX.required();){
            try {
                if (IntrReportStatusEnum.COMPLETE.value.equals(status)) {
                    report.set("completer", (Object)actionUserId);
                    report.set("completetime", (Object)now);
                }
                if (IntrReportStatusEnum.REPORTED.value.equals(status)) {
                    if (report.getDate("firstcommittime") == null) {
                        report.set("firstcommittime", (Object)now);
                    }
                    report.set("commitor", (Object)actionUserId);
                    report.set("committime", (Object)now);
                    report.set("committimes", (Object)(report.getInt("committimes") + 1));
                }
                if (IntrReportStatusEnum.REJECTED.value.equals(status)) {
                    report.set("sendbacker", (Object)actionUserId);
                    report.set("sendbacktime", (Object)now);
                    report.set("sendbacktimes", (Object)(report.getInt("sendbacktimes") + 1));
                }
                report.set("reportstatus", (Object)status);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("\u66f4\u65b0\u5185\u90e8\u4ea4\u6613\u62a5\u8868\u72b6\u6001\u51fa\u9519\u3002", t);
                throw new KDBizException(t, new ErrorCode("", t.getMessage()), new Object[0]);
            }
        }
    }

    public static void resetTable(IntrMergeParam param) {
        if (param.getModel() == null || param.getTemplateId() == null || param.getEntity() == null || param.getScenario() == null || param.getYear() == null || param.getPeriod() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6574\u8868\u91cd\u7f6e\u53c2\u6570\u4e0d\u5168\uff0c\u91cd\u7f6e\u5931\u8d25\u3002", (String)"IntrReportHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)param.getTemplateId(), (String)"bcm_papertemplate", (String)"id,mergenode.number");
        try (TXHandle tx = TX.required();){
            try {
                IntrReportHelper.deleteReport((Long)param.getModel().p1, param.getTemplateId(), param.getEntityStorageId(), (Long)param.getScenario().p1, (Long)param.getYear().p1, (Long)param.getPeriod().p1);
                IntrReportHelper.deleteAllCurrencyExtData((String)param.getModel().p2, (String)param.getEntity().p2, (String)param.getScenario().p2, (String)param.getYear().p2, (String)param.getPeriod().p2, template.getString("mergenode.number"));
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("\u6574\u8868\u91cd\u7f6e\u51fa\u9519\u3002", t);
                throw new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0]);
            }
        }
    }

    public static void deleteReport(Long modelId, Long templateId, Long entityId, Long sceneId, Long yearId, Long periodId) {
        QFBuilder rqf = new QFBuilder();
        rqf.add("model", "=", (Object)modelId);
        rqf.add("papertemplate", "=", (Object)templateId);
        rqf.add("entity", "=", (Object)IntrReportHelper.getEntityBaseId(modelId, entityId));
        rqf.add("scenario", "=", (Object)sceneId);
        rqf.add("year", "=", (Object)yearId);
        rqf.add("period", "=", (Object)periodId);
        DeleteServiceHelper.delete((String)"bcm_intrreportentity", (QFilter[])rqf.toArray());
    }

    public static void deleteAllCurrencyExtData(String modelNum, String entityNum, String sceneNum, String yearNum, String periodNum, String dataModel) {
        IntrReportHelper.deleteExtData(modelNum, entityNum, sceneNum, yearNum, periodNum, null, dataModel);
    }

    public static void deleteExtData(String modelNum, String entityNum, String sceneNum, String yearNum, String periodNum, String currencyNum, String dataModel) {
        QFBuilder qf = new QFBuilder();
        qf.add("modelnumber", "=", (Object)modelNum);
        qf.add("org", "=", (Object)entityNum);
        qf.add("scenario", "=", (Object)sceneNum);
        qf.add("year", "=", (Object)yearNum);
        qf.add("period", "=", (Object)periodNum);
        if (StringUtils.isNotBlank((CharSequence)currencyNum)) {
            qf.add("currency", "=", (Object)currencyNum);
        }
        qf.add("datamodel", "=", (Object)dataModel);
        qf.add("extendsgroup", "=", (Object)IntrReportHelper.getGroupNumByModelNum((long)MemberReader.findModelIdByShowNum((String)modelNum), dataModel));
        qf.add("process", "=", (Object)"ADJ");
        qf.add("audittrail", "=", (Object)"EntityInput");
        DeleteServiceHelper.delete((String)"bcm_extenddata_bus", (QFilter[])qf.toArray());
    }

    public static DynamicObject getExtReport(Long modelId, Long tmplId, Long entityId, Long sceneId, Long yearId, Long periodId) {
        DynamicObject dyn = OrgCurrencyServiceHelper.getCurrencyDynById(entityId, yearId, periodId);
        QFilter qf = new QFilter("model", "=", (Object)modelId).and("fyear", "=", (Object)yearId).and("period", "=", (Object)periodId).and("scene", "=", (Object)sceneId).and("currency", "=", (Object)dyn.getLong("id")).and("entity", "=", (Object)entityId).and("template", "=", (Object)tmplId);
        DynamicObject rpt = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_reportentity", (String)"id,modifier.id", (QFilter[])qf.toArray());
        if (rpt == null || rpt.getLong("modifier.id") == 0L) {
            log.error(String.format("\u4f53\u7cfbID\uff1a%s\uff0c\u6a21\u677fID\uff1a%s\uff0c\u7ec4\u7ec7ID\uff1a%s\uff0c\u60c5\u666fID\uff1a%s\uff0c\u8d22\u5e74ID\uff1a%s\uff0c\u671f\u95f4ID\uff1a%s\uff0c\u5e01\u79cdID\uff1a%s\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u62a5\u8868\u4fee\u6539\u4eba\u3002", modelId, tmplId, entityId, sceneId, yearId, periodId, dyn.getLong("id")));
            return null;
        }
        return rpt;
    }

    public static Map<String, IDNumberTreeNode> getSellerBuyerEntity(Long modelId, Tuple<Long, String, String> entity, SimpleItem scene, SimpleItem year, SimpleItem period, String search) {
        HashMap<String, IDNumberTreeNode> reulst = new HashMap<String, IDNumberTreeNode>(16);
        String modelCubeNumber = MemberReader.findModelNumberById((Object)modelId);
        Map<String, Set<Long>> orgByChangeType = IntrEntityHelper.getSortEntity(modelId, (Long)scene.getId(), (Long)year.getId(), (Long)period.getId(), (Pair<String, String>)Pair.onePair((Object)entity.p2, (Object)entity.p3));
        for (Map.Entry<String, Set<Long>> kv : orgByChangeType.entrySet()) {
            IDNumberTreeNode orgNode;
            if (kv.getValue().isEmpty() || !(orgNode = BcmThreadCache.findNodeById((String)modelCubeNumber, (String)"Entity", (long)kv.getValue().iterator().next())).isLeaf()) continue;
            if (StringUtils.isNotBlank((CharSequence)search)) {
                if (!orgNode.getNumber().contains(search) && !orgNode.getName().contains(search)) continue;
                reulst.put(orgNode.getNumber(), orgNode);
                continue;
            }
            reulst.put(orgNode.getNumber(), orgNode);
        }
        return reulst;
    }

    public static void copyRptData(long modelId, long userId, Long sceneId, Long targetYearId, Long targetPeriodId, Long sourceYearId, Long sourcePeriodId, Multimap<Pair<Long, Long>, IDNumberTreeNode> tmplOrgs) {
        String modelShowNumber = MemberReader.findModelSNumberById((Object)modelId);
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)sceneId);
        IDNumberTreeNode targetYearNode = MemberReader.findFyMemberById((String)modelNumber, (Long)targetYearId);
        IDNumberTreeNode targetPeriodNode = MemberReader.findPeriodMemberById((String)modelNumber, (Long)targetPeriodId);
        IDNumberTreeNode sourceYearNode = MemberReader.findFyMemberById((String)modelNumber, (Long)sourceYearId);
        IDNumberTreeNode sourcePeriodNode = MemberReader.findPeriodMemberById((String)modelNumber, (Long)sourcePeriodId);
        for (Pair tmplPair : tmplOrgs.keySet()) {
            Long sourceTmplId = (Long)tmplPair.p1;
            Long targetTmplId = (Long)tmplPair.p2;
            DynamicObject sourceTmplInfo = IntrTemplateHelper.getTemplateInfo(modelId, sourceTmplId);
            DynamicObject targetTmplInfo = IntrTemplateHelper.getTemplateInfo(modelId, targetTmplId);
            Map<String, IntrTplDimScope> dimScopeMap = IntrTemplateHelper.getDimScope(targetTmplId);
            List<IntrField> targetFields = QueryIntrDataHelper.queryMergeFieldsForCsl(targetTmplId);
            Map<String, IntrField> targetFieldMap = targetFields.stream().collect(Collectors.toMap(IntrField::getNumber, e -> e));
            List<IntrField> targetRequiedFields = targetFields.stream().filter(IntrField::isRequired).collect(Collectors.toList());
            List<String> targetUniqueFields = targetFields.stream().filter(IntrField::isUnique).map(IntrField::getBoundField).collect(Collectors.toList());
            Set targetBoundFields = targetFields.stream().map(IntrField::getBoundField).collect(Collectors.toSet());
            List<IntrField> sourceFields = QueryIntrDataHelper.queryMergeFieldsForCsl(sourceTmplId);
            Set needSetNullField = sourceFields.stream().map(IntrField::getBoundField).filter(item -> !targetBoundFields.contains(item)).collect(Collectors.toSet());
            int distance = IntrReportHelper.getDistanceDiffence(sourceTmplInfo, targetTmplInfo);
            for (IDNumberTreeNode orgNode : tmplOrgs.get((Object)tmplPair)) {
                Map<String, IDNumberTreeNode> effectNodes = IntrReportHelper.getSellerBuyerEntity(modelId, (Tuple<Long, String, String>)Tuple.create((Object)orgNode.getId(), (Object)orgNode.getNumber(), (Object)orgNode.getLongNumber()), SimpleItem.newOne(sceneNode.getId(), sceneNode.getNumber()), SimpleItem.newOne(targetYearNode.getId(), targetYearNode.getNumber()), SimpleItem.newOne(targetPeriodNode.getId(), targetPeriodNode.getNumber()), null);
                IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)orgNode.getCurrency());
                DynamicObject targetRpt = IntrReportHelper.getReportInfo(modelId, targetTmplId, orgNode.getBaseTreeNode().getId(), sceneId, targetYearId, targetPeriodId, currencyNode.getId());
                Date now = new Date();
                if (targetRpt == null) {
                    targetRpt = BusinessDataServiceHelper.newDynamicObject((String)"bcm_intrreportentity");
                    targetRpt.set("model", (Object)modelId);
                    targetRpt.set("papertemplate", (Object)targetTmplId);
                    targetRpt.set("entity", (Object)orgNode.getBaseTreeNode().getId());
                    targetRpt.set("scenario", (Object)sceneId);
                    targetRpt.set("year", (Object)targetYearId);
                    targetRpt.set("period", (Object)targetPeriodId);
                    targetRpt.set("currency", (Object)currencyNode.getId());
                    targetRpt.set("creator", (Object)userId);
                    targetRpt.set("createtime", (Object)now);
                }
                targetRpt.set("modifier", (Object)userId);
                targetRpt.set("modifytime", (Object)now);
                targetRpt.set("reportstatus", (Object)IntrReportStatusEnum.EDITING.value);
                targetRpt.set("gentype", (Object)IntrRptGenTypeEnum.MANUAL.value);
                targetRpt.set("spreadjson", null);
                targetRpt.set("data", null);
                DynamicObjectCollection sourceExtDatas = QueryIntrDataHelper.queryMergeData(modelShowNumber, sourceTmplInfo.getString("mergenode.number"), orgNode.getNumber(), sceneNode.getNumber(), sourceYearNode.getNumber(), sourcePeriodNode.getNumber(), orgNode.getCurrency());
                ArrayList<IntrRow> targetRows = new ArrayList<IntrRow>(16);
                HashSet<String> distinctKey = new HashSet<String>(16);
                int i = 1;
                int targetYstart = SpreadAreaUtil.getRangModel((String)targetTmplInfo.getString("areapoint")).getY_start();
                for (DynamicObject sourceData : sourceExtDatas) {
                    if (IntrReportHelper.checkData(modelNumber, effectNodes, orgNode.getLongNumber(), targetFieldMap, targetRequiedFields, targetUniqueFields, distinctKey, sourceData, dimScopeMap)) {
                        DynamicObject targetData = (DynamicObject)OrmUtils.clone((IDataEntityBase)sourceData, (boolean)false, (boolean)true);
                        targetData.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                        int rowNum = 0;
                        rowNum = StringUtils.isNotBlank((CharSequence)sourceData.getString("sid")) ? NumberUtils.createInteger((String)StringUtils.substringAfter((String)sourceData.getString("sid"), (String)"AIT_")) + distance : targetYstart + i;
                        targetData.set("sid", (Object)("AIT_" + rowNum));
                        targetData.set("year", (Object)targetYearNode.getNumber());
                        targetData.set("period", (Object)targetPeriodNode.getNumber());
                        targetData.set("datamodel", (Object)targetTmplInfo.getString("mergenode.number"));
                        for (String nullField : needSetNullField) {
                            targetData.set(nullField, null);
                        }
                        targetRows.add(new IntrRow(targetFields, targetData));
                    }
                    ++i;
                }
                TXHandle tx = TX.required();
                Throwable throwable = null;
                try {
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetRpt});
                        IntrReportHelper.deleteExtData(modelShowNumber, orgNode.getNumber(), sceneNode.getNumber(), targetYearNode.getNumber(), targetPeriodNode.getNumber(), orgNode.getCurrency(), targetTmplInfo.getString("mergenode.number"));
                        IntrMergeParam param = new IntrMergeParam((Pair<Long, String>)Pair.onePair((Object)modelId, (Object)modelShowNumber), targetTmplId, (Tuple<Long, String, String>)Tuple.create((Object)orgNode.getId(), (Object)orgNode.getNumber(), (Object)orgNode.getLongNumber()), (Pair<Long, String>)Pair.onePair((Object)sceneNode.getId(), (Object)sceneNode.getNumber()), (Pair<Long, String>)Pair.onePair((Object)targetYearNode.getId(), (Object)targetYearNode.getNumber()), (Pair<Long, String>)Pair.onePair((Object)targetPeriodNode.getId(), (Object)targetPeriodNode.getNumber()), (Pair<Long, String>)Pair.onePair((Object)currencyNode.getId(), (Object)currencyNode.getNumber()));
                        param.setModelNumber(modelNumber);
                        param.setSmartMerge(true);
                        IntrMergeHelper.caculateData(param, targetRows);
                        List<DynamicObject> dynDatas = IntrReportHelper.getExtDataDyn(modelShowNumber, orgNode.getNumber(), sceneNode.getNumber(), targetYearNode.getNumber(), targetPeriodNode.getNumber(), currencyNode.getNumber(), targetTmplInfo.getString("mergenode.number"), targetFields, targetRows);
                        SaveServiceHelper.save((DynamicObject[])dynDatas.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable t) {
                        tx.markRollback();
                        log.error("--\u4ece\u5176\u4ed6\u671f\u95f4\u590d\u5236\u51fa\u9519--", t);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%s", (String)"IntrReportHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), t.getMessage()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
    }

    private static int getDistanceDiffence(DynamicObject sourceTmplInfo, DynamicObject targetTmplInfo) {
        if (sourceTmplInfo.getLong("id") == targetTmplInfo.getLong("id")) {
            return 0;
        }
        return SpreadAreaUtil.getRangModel((String)targetTmplInfo.getString("areapoint")).getY_start() - SpreadAreaUtil.getRangModel((String)sourceTmplInfo.getString("areapoint")).getY_start();
    }

    private static boolean checkData(String modelNumber, Map<String, IDNumberTreeNode> effectNodes, String longNumber, Map<String, IntrField> targetFieldMap, List<IntrField> requiedFields, List<String> uniqueFields, Set<String> distinctKey, DynamicObject sourceData, Map<String, IntrTplDimScope> dimScopeMap) {
        String errorMsg = IntrReportHelper.checkIntrData(modelNumber, effectNodes, longNumber, targetFieldMap, requiedFields, sourceData, dimScopeMap);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            log.info(String.format("\u5f53\u524d\u884c\u6570\u636e\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u4e0d\u901a\u8fc7\u7684\u539f\u56e0=%s\uff0c\u5f53\u524d\u6570\u636e=%s", errorMsg, sourceData));
            return false;
        }
        String uniqueKey = IntrReportHelper.getUniqueKey(sourceData, uniqueFields);
        if (!distinctKey.add(uniqueKey)) {
            log.info(String.format("\u5f53\u524d\u884c\u6570\u636e\u552f\u4e00\u952e\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u5f53\u524d\u6570\u636e=%s", sourceData));
            return false;
        }
        return true;
    }

    public static String checkIntrData(String modelNumber, Map<String, IDNumberTreeNode> entityMap, String longNumber, Map<String, IntrField> targetFieldMap, List<IntrField> requiedFields, DynamicObject sourceData, Map<String, IntrTplDimScope> dimScopeMap) {
        if (targetFieldMap == null || targetFieldMap.isEmpty()) {
            return null;
        }
        Collection<IntrField> fields = targetFieldMap.values();
        List dateFields = fields.stream().filter(e -> DataTypeEnum.DATETP.getOIndex().equals(e.getDataType())).collect(Collectors.toList());
        for (IntrField intrField : dateFields) {
            String value = sourceData.getString(intrField.getBoundField());
            if (!StringUtils.isNotBlank((CharSequence)value) || DateTimeUtils.getOADateStr((String)value, null) != null) continue;
            return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s-%2$s-%3$s\u662f\u65e5\u671f\u5b57\u6bb5\uff0c\u5f53\u524d\u503c\u662f%4$s\uff0c\u68c0\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"IntrReportHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), intrField.getName(), intrField.getNumber(), intrField.getBoundField(), value);
        }
        for (IntrField intrField : requiedFields) {
            if (!StringUtils.isBlank((CharSequence)sourceData.getString(intrField.getBoundField()))) continue;
            return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s-%2$s-%3$s\u662f\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"IntrReportHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), intrField.getName(), intrField.getNumber(), intrField.getBoundField());
        }
        List f7Fields = fields.stream().filter(e -> "F7".equals(e.getShowType())).collect(Collectors.toList());
        for (IntrField field : f7Fields) {
            String value = sourceData.getString(field.getBoundField());
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)((String)field.getDimInfo().p2), (String)value);
            if (IntrReportHelper.validataDimScope((Long)field.getDimInfo().p1, dimScopeMap, field.getNumber(), node)) continue;
            return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s-%2$s-%3$s\u662f%4$s\u7ef4\u5ea6\uff0c\u5f53\u524d\u503c\u662f%5$s\uff0c\u68c0\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"IntrReportHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), field.getName(), field.getNumber(), field.getBoundField(), field.getDimInfo().p2, value);
        }
        String string = sourceData.getString(IntrConstant.FIELD_ORG_NUMBER);
        String buyNum = sourceData.getString(IntrConstant.FIELD_IC_NUMBER);
        IDNumberTreeNode sellNode = entityMap.get(string);
        IDNumberTreeNode buyNode = entityMap.get(buyNum);
        if (sellNode == null || buyNode == null || !IntrEntityHelper.checkCommonParentEntity(longNumber, sellNode.getLongNumber(), buyNode.getLongNumber())) {
            return String.format(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u548c\u91c7\u8d2d\u65b9\u6709\u6548\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u9500\u552e\u65b9\uff1a%1$s\uff0c\u91c7\u8d2d\u65b9\uff1a%2$s\uff0c\u5408\u5e76\u8282\u70b9\uff1a%3$s\u3002", (String)"IntrReportHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]), string, buyNum, longNumber);
        }
        if (!targetFieldMap.isEmpty()) {
            Set enumFields = targetFieldMap.values().stream().filter(e -> "eunm".equals(e.getShowType()) && "ext".equals(e.getExtFieldRefType())).collect(Collectors.toSet());
            for (IntrField enumField : enumFields) {
                IntrTplDimScope dimScope;
                Object sourceValue;
                if (!enumField.isRequired() || (sourceValue = sourceData.get(enumField.getBoundField())) == null || (dimScope = dimScopeMap.getOrDefault(enumField.getNumber(), new IntrTplDimScope())).getEnumList() == null || dimScope.getEnumList().isEmpty() || IntrReportHelper.containValues(enumField, dimScope.getEnumList(), sourceValue)) continue;
                return String.format(ResManager.loadKDString((String)"\u679a\u4e3e\u6709\u6548\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5f53\u524d\u679a\u4e3e\u503c\uff1a%1$s\uff0c\u6709\u6548\u679a\u4e3e\u503c\uff1a%2$s\u3002", (String)"IntrReportHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]), sourceValue, dimScope.getEnumList());
            }
        }
        return null;
    }

    private static boolean containValues(IntrField enumField, List<Object> enumList, Object sourceValue) {
        if (DataTypeEnum.DATETP.getOIndex().equals(enumField.getEunmDataType())) {
            for (Object item : enumList) {
                try {
                    if (!DateTimeUtils.parseStrDate((String)item.toString()).equals(DateTimeUtils.parseStrDate((String)sourceValue.toString()))) continue;
                    return true;
                }
                catch (ParseException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
            }
            return false;
        }
        if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(enumField.getEunmDataType())) {
            BigDecimal source = new BigDecimal(sourceValue.toString());
            for (Object item : enumList) {
                if (source.compareTo(new BigDecimal(item.toString())) != 0) continue;
                return true;
            }
            return false;
        }
        return enumList.contains(sourceValue);
    }

    public static boolean validataDimScope(Long dimId, Map<String, IntrTplDimScope> dimScopeMap, String fieldNum, IDNumberTreeNode node) {
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return false;
        }
        if (dimScopeMap.get(fieldNum) == null || dimScopeMap.get(fieldNum).getAllMemberIds() == null) {
            PermissionService permService = PermissionServiceImpl.getInstance(node.getModelId());
            return node.isLeaf() && permService.hasWriteOrReadPerm(dimId, node.getId());
        }
        return dimScopeMap.get(fieldNum).getAllMemberIds().contains(node.getId());
    }

    private static String getUniqueKey(DynamicObject sourceData, List<String> uniqueKeys) {
        ArrayList uks = new ArrayList(16);
        uniqueKeys.forEach(field -> {
            Object value = sourceData.get(field);
            String valueStr = null;
            valueStr = value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toString() : (value == null ? "" : value.toString());
            uks.add(valueStr);
        });
        return String.join((CharSequence)SPLIT_SYMBOL, uks);
    }

    public static Tuple<Long, String, String> getAndInitDimInfo(long modelId, IntrField field) {
        if (field.getDimInfo() != null) {
            return field.getDimInfo();
        }
        if (IntrConstant.FIELD_ORG_NUMBER.equalsIgnoreCase(field.getNumber()) || IntrConstant.FIELD_IC_NUMBER.equalsIgnoreCase(field.getNumber())) {
            DynamicObject dimDyn = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)IntrConstant.FIELD_ORG_NUMBER));
            field.setDimInfo((Tuple<Long, String, String>)Tuple.create((Object)dimDyn.getLong("id"), (Object)dimDyn.getString("number"), (Object)dimDyn.getString("membermodel")));
        }
        return field.getDimInfo();
    }

    public static String getDisplayName(String number, String name, IntrDimDisplayModeEnum mode) {
        if (IntrDimDisplayModeEnum.NUMBERANDNAME == mode) {
            return number + DIM_SEPARATOR + name;
        }
        if (IntrDimDisplayModeEnum.NAME == mode) {
            return name;
        }
        if (IntrDimDisplayModeEnum.NUMBER == mode) {
            return number;
        }
        return number + DIM_SEPARATOR + name;
    }

    public static String getDisplayName(String number, String name, String mode) {
        if (IntrDimDisplayModeEnum.NUMBERANDNAME.value.equals(mode)) {
            return number + DIM_SEPARATOR + name;
        }
        if (IntrDimDisplayModeEnum.NAME.value.equals(mode)) {
            return name;
        }
        if (IntrDimDisplayModeEnum.NUMBER.value.equals(mode)) {
            return number;
        }
        return number + DIM_SEPARATOR + name;
    }

    public static DynamicObjectCollection getFillReocrd(Long modelId, long sceneId, Set<Long> yearIds, Set<Long> periodIds, Set<Long> orgIds, Set<Long> tmplIds) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("scenario", "=", (Object)sceneId);
        qf.add("year", "in", yearIds);
        qf.add("period", "in", periodIds);
        qf.add("entity", "in", QueryMemberDetailsHelper.change2BaseMember(orgIds));
        qf.add("papertemplate", "in", tmplIds);
        return QueryServiceHelper.query((String)"bcm_intrreportentity", (String)"year, period, entity, papertemplate", (QFilter[])qf.toArray());
    }

    public static String getGroupNumByModelNum(long modelId, String modelNum) {
        Set<String> modelNumSet = IntrReportHelper.getGroupNumByModelNum(modelId, Sets.newHashSet((Object[])new String[]{modelNum}));
        return modelNumSet.iterator().next();
    }

    public static Set<String> getGroupNumByModelNum(long modelId, Set<String> modelNumSet) {
        return (Set)ThreadCache.get((Object)("findExtGroupNumBuyModelNum-" + modelId + "-" + String.join((CharSequence)"-", modelNumSet)), () -> {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)modelId);
            qf.add("number", "in", (Object)modelNumSet);
            DynamicObjectCollection groupDoc = QueryServiceHelper.query((String)"bcm_extendsmodel", (String)"id,extendsgroup.number", (QFilter[])qf.toArray());
            if (groupDoc == null || groupDoc.size() <= 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b\u627e\u4e0d\u5230\u6240\u5c5e\u7684\u5206\u7ec4\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"IntrReportHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), modelNumSet));
            }
            return groupDoc.stream().map(e -> e.getString("extendsgroup.number")).collect(Collectors.toSet());
        });
    }

    public static void clearSpread(Long modelId, Long templateId, Long orgId, Long sceneId, Long yearId, Long periodId, Long currencyId) {
        DynamicObject report = IntrReportHelper.getReportInfo(modelId, templateId, orgId, sceneId, yearId, periodId, currencyId);
        if (report != null) {
            report.set("spreadjson", null);
            report.set("data", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
        }
    }

    public static List<IntrField> getUniqueFields(List<IntrField> fields, String templateUsage) {
        return fields.stream().filter(e -> {
            if ("1".equals(templateUsage)) {
                return e.isUnique();
            }
            return e.isJoinKey() || "INTR_001".equals(e.getNumber()) || "INTR_000".equals(e.getNumber());
        }).collect(Collectors.toList());
    }
}

