/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import com.google.common.collect.LinkedHashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Result;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.enumvalue.EnumItemServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.innertrade.model.ExtTemplateDto;
import kd.fi.bcm.business.innertrade.model.IntrTplDimScope;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.innertrade.IntrDimDisplayModeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class IntrTemplateHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, IntrTemplateHelper.class);
    public static final String BASE_INFO = "id,number,name,areapoint,group,seller.id,purchaser.id,mergenode.id,seller.number,purchaser.number,mergenode.number,seller.name,purchaser.name,mergenode.name,usage";

    public static LinkedHashMultimap<Long, Long> queryDispensedTmpls(Long modelId, Set<Long> selectOrgIdSet, Set<Long> tempIds) {
        LinkedHashMultimap listMultimap = LinkedHashMultimap.create();
        if (CollectionUtils.isEmpty(selectOrgIdSet) || CollectionUtils.isEmpty(tempIds)) {
            return listMultimap;
        }
        Set<Long> orgids = QueryMemberDetailsHelper.change2BaseMember(selectOrgIdSet);
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.and(new QFilter("template", "in", tempIds));
        String selectFields = "entity.id, entity.number, template.id, template.number, property.id, property.number, propertyvalue.id, propertyvalue.number, range,isexcept";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)selectFields, (QFilter[])qf.toArray());
        ArrayList<DynamicObject> fitList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> exceptList = new ArrayList<DynamicObject>(16);
        for (DynamicObject dyn : doc) {
            String isexcept = dyn.getString("isexcept");
            if (StringUtils.isBlank((CharSequence)isexcept) || "0".equals(isexcept)) {
                fitList.add(dyn);
                continue;
            }
            exceptList.add(dyn);
        }
        Map<Long, List<MembRangeItem>> exceptItems = IntrTemplateHelper.getMemMembRangeItem(modelId, exceptList);
        LinkedHashMultimap exceptMap = LinkedHashMultimap.create();
        for (Map.Entry entry : exceptItems.entrySet()) {
            for (MembRangeItem exceptItem : (List)entry.getValue()) {
                exceptItem.matchItems(e -> {
                    exceptMap.put(kv.getKey(), e.getId());
                    IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)e.getId()));
                    if (node.isShare()) {
                        exceptMap.put(kv.getKey(), (Object)node.getBaseTreeNode().getId());
                    }
                });
            }
        }
        Map<Long, List<MembRangeItem>> fitItems = IntrTemplateHelper.getMemMembRangeItem(modelId, fitList);
        for (Map.Entry<Long, List<MembRangeItem>> kv : fitItems.entrySet()) {
            HashSet exceptOrgIds = exceptMap.get((Object)kv.getKey());
            if (exceptOrgIds == null) {
                exceptOrgIds = new HashSet(16);
            }
            for (MembRangeItem exceptItem : kv.getValue()) {
                HashSet finalExceptOrgIds = exceptOrgIds;
                exceptItem.matchItems(e -> {
                    Long baseId;
                    IDNumberTreeNode node;
                    if (orgids.contains(e.getId()) && !finalExceptOrgIds.contains(e.getId())) {
                        listMultimap.put((Object)LongUtil.toLong(e.getId()), kv.getKey());
                    }
                    if ((node = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)e.getId()))).isShare() && orgids.contains(baseId = node.getBaseTreeNode().getId()) && !finalExceptOrgIds.contains(baseId)) {
                        listMultimap.put((Object)LongUtil.toLong((Object)baseId), kv.getKey());
                    }
                });
            }
        }
        return listMultimap;
    }

    private static Map<Long, List<MembRangeItem>> getMemMembRangeItem(Long modelId, List<DynamicObject> fitList) {
        HashMap<Long, List<MembRangeItem>> result = new HashMap<Long, List<MembRangeItem>>(16);
        for (DynamicObject d : fitList) {
            String mnumber;
            long mId;
            boolean isCustom;
            if (d.getLong("propertyvalue.id") != 0L) {
                isCustom = true;
                mId = d.getLong("propertyvalue.id");
                mnumber = d.getString("propertyvalue.number");
            } else {
                isCustom = false;
                mId = d.getLong("entity.id");
                mnumber = d.getString("entity.number");
            }
            MembRangeItem rangeItem = new MembRangeItem("bcm_entitymembertree", (Long)mId, mnumber, RangeEnum.getRangeByVal((int)d.getInt("range")), isCustom, (Object)modelId);
            result.computeIfAbsent(d.getLong("template.id"), k -> new ArrayList(16)).add(rangeItem);
        }
        return result;
    }

    public static DynamicObject getTemplateSpread(Long modelId, Long templateId) {
        String selectFileds = "id,areapoint,spreadjson,data";
        QFBuilder qf = new QFBuilder();
        qf.add("id", "=", (Object)templateId);
        qf.add("model", "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)selectFileds, (QFilter[])qf.toArray());
    }

    public static DynamicObject getTemplateInfo(Long modelId, Long templateId) {
        QFBuilder qf = new QFBuilder();
        qf.add("id", "=", (Object)templateId);
        qf.add("model", "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)BASE_INFO, (QFilter[])qf.toArray());
    }

    public static DynamicObject getAllTemplateInfo(Long modelId, Long templateId) {
        String selectFileds = "id,number,name,areapoint,group,seller.id,purchaser.id,mergenode.id,seller.number,purchaser.number,mergenode.number,seller.name,purchaser.name,mergenode.name,usage,spreadjson,data";
        QFBuilder qf = new QFBuilder();
        qf.add("id", "=", (Object)templateId);
        qf.add("model", "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)selectFileds, (QFilter[])qf.toArray());
    }

    public static Map<Long, Long> getRightTplIdByVersioned(Long modelId, Long yearId, Long periodId, Set<Long> templateIds) {
        HashMap<Long, Long> source2Right = new HashMap<Long, Long>(16);
        if (CollectionUtils.isEmpty(templateIds)) {
            return source2Right;
        }
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(periodId);
        String yearNum = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)yearId).getNumber();
        Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
        if (firstDate == null || lastDate == null) {
            return source2Right;
        }
        HashMap group2SourceId = new HashMap();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.and("id", "in", templateIds);
        QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,group", (QFilter[])qfBuilder.toArray()).forEach(e -> group2SourceId.put(e.getLong("group"), e.getLong("id")));
        Map<Long, List<DynamicObject>> templateGroups = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id, group, effectivedate, expiringdate,versionnumber", (QFilter[])new QFBuilder("model", "=", (Object)modelId).and("group", "in", group2SourceId.keySet()).toArray(), (String)"group, versionnumber").stream().collect(Collectors.groupingBy(e -> e.getLong("group")));
        templateGroups.forEach((group, tpls) -> {
            for (DynamicObject t : tpls) {
                Date effectivedate = t.getDate("effectivedate");
                if (effectivedate == null) continue;
                Date expiringdate = t.getDate("expiringdate");
                if (effectivedate.getTime() <= firstDate.getTime() && (expiringdate == null || expiringdate.getTime() >= firstDate.getTime())) {
                    source2Right.put((Long)group2SourceId.get(group), t.getLong("id"));
                    continue;
                }
                if (effectivedate.getTime() < firstDate.getTime() || effectivedate.getTime() > lastDate.getTime()) continue;
                source2Right.put((Long)group2SourceId.get(group), t.getLong("id"));
            }
        });
        return source2Right;
    }

    public static DynamicObject getRightVerionTemplate(Long modelId, Long yearId, Long periodId, Long templateId) {
        return IntrTemplateHelper.getTemplateSpread(modelId, IntrTemplateHelper.getVerionTemplateId(modelId, yearId, periodId, templateId));
    }

    public static DynamicObject getVerionTemplateInfo(Long modelId, Long yearId, Long periodId, Long templateId) {
        return IntrTemplateHelper.getTemplateInfo(modelId, IntrTemplateHelper.getVerionTemplateId(modelId, yearId, periodId, templateId));
    }

    public static Long getVerionTemplateId(Long modelId, Long yearId, Long periodId, Long templateId) {
        DynamicObject tem = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id, group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        DynamicObjectCollection templates = IntrTemplateHelper.getTemplateByGroup(modelId, tem.getLong("group"));
        Set<Long> tmplIds = templates.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        Map<Long, Long> tplIdByVersioned = IntrTemplateHelper.getRightTplIdByVersioned(modelId, yearId, periodId, tmplIds);
        if (tplIdByVersioned == null || tplIdByVersioned.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6709\u6548\u7248\u672c\u7684\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u7684\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"IntrReportHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (tplIdByVersioned.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u6709\u6548\u7248\u672c\u7684\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u7684\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"IntrReportHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return (Long)((Map.Entry)tplIdByVersioned.entrySet().stream().findFirst().get()).getValue();
    }

    public static DynamicObjectCollection getTemplateByGroup(Long modelId, Long group) {
        QFBuilder qf = new QFBuilder();
        qf.add("group", "=", (Object)group);
        qf.add("model", "=", (Object)modelId);
        return QueryServiceHelper.query((String)"bcm_papertemplate", (String)BASE_INFO, (QFilter[])qf.toArray());
    }

    public static DynamicObject getExtTemplate(Long modelId, Long extModelId, Long yearId, Long periodId) {
        QFilter tempQFilter = new QFilter("model", "=", (Object)modelId);
        tempQFilter.and("extmodel", "=", (Object)extModelId);
        Set<Long> refTemplates = QueryServiceHelper.query((String)"bcm_extmodelref", (String)"id,template.id", (QFilter[])tempQFilter.toArray()).stream().map(e -> e.getLong("template.id")).collect(Collectors.toSet());
        Map<Long, Long> id2Right = TemplateUtil.getRightTplIdByVersioned(modelId, yearId, periodId, refTemplates, true);
        if (id2Right == null || id2Right.isEmpty()) {
            return null;
        }
        if (id2Right.size() > 1) {
            log.warn(String.format("\u62d3\u5c55\u7ef4ID\uff1a%s\uff0c\u8d22\u5e74\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u627e\u5230\u591a\u4e2a\u62d3\u5c55\u7ef4\u6a21\u677f\uff0c\u968f\u673a\u53d6\u7b2c\u4e00\u4e2a\u3002", extModelId, yearId, periodId));
        }
        Long tmplId = (Long)((Map.Entry)id2Right.entrySet().stream().findFirst().get()).getValue();
        return QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tmplId)});
    }

    public static void repairTableRow(SpreadManager sm) {
        Sheet sheet = sm.getBook().getSheet(0);
        int maxRowCount = sheet.getMaxRowCount();
        if (maxRowCount < IntrConstant.TMP_INIT_ROW_COUNT) {
            sheet.addRows(IntrConstant.TMP_INIT_ROW_COUNT - maxRowCount);
        }
    }

    public static Map<String, IntrTplDimScope> getDimScope(Long templateId) {
        DynamicObjectCollection mergeFieldList;
        HashMap<String, IntrTplDimScope> result = new HashMap<String, IntrTplDimScope>(16);
        String selectFields = "id,model,dimscope.extendfield.id,dimscope.extendfield.number,dimscope.dimension.id,dimscope.dimension.membermodel,dimscope.dimension.number,dimscope.memberid,dimscope.propertyid,dimscope.scope,dimscope.isfix,dimscope.fixvalueid,dimscope.displaymode";
        DynamicObjectCollection dimScopeDoc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        if (dimScopeDoc != null && !dimScopeDoc.isEmpty()) {
            long modelId = ((DynamicObject)dimScopeDoc.get(0)).getLong("model");
            PermissionService permService = PermissionServiceImpl.getInstance(modelId);
            List dimScopes = dimScopeDoc.stream().filter(e -> e.getLong("dimscope.dimension.id") != 0L).collect(Collectors.toList());
            Map<String, List<DynamicObject>> extfieldScopeMap = dimScopeDoc.stream().filter(e -> e.getLong("dimscope.extendfield.id") != 0L).collect(Collectors.groupingBy(t -> t.getString("dimscope.extendfield.number")));
            for (DynamicObject dynamicObject : dimScopes) {
                String dimModelNum = dynamicObject.getString("dimscope.dimension.membermodel");
                String dimNum = dynamicObject.getString("dimscope.dimension.number");
                if (StringUtils.isBlank((CharSequence)dimNum)) continue;
                IntrTplDimScope intrTplDimScope = (IntrTplDimScope)result.get(dimNum);
                if (intrTplDimScope == null) {
                    intrTplDimScope = new IntrTplDimScope();
                    result.put(dimNum, intrTplDimScope);
                }
                intrTplDimScope.setDisplayMode(IntrDimDisplayModeEnum.getEnumByValue((String)dynamicObject.getString("dimscope.displaymode")));
                if (IntrConstant.FIELD_ORG_NUMBER.equalsIgnoreCase(dimNum) || IntrConstant.FIELD_IC_NUMBER.equalsIgnoreCase(dimNum) || dynamicObject.getLong("dimscope.fixvalueid") == 0L && (long)dynamicObject.getInt("dimscope.scope") == 0L) continue;
                intrTplDimScope.setFix(dynamicObject.getBoolean("dimscope.isfix"));
                Set<Long> dimMemberIds = new HashSet(16);
                if (dynamicObject.getBoolean("dimscope.isfix")) {
                    dimMemberIds.add(dynamicObject.getLong("dimscope.fixvalueid"));
                } else if (dynamicObject.getInt("dimscope.scope") != 0) {
                    String mnumber;
                    long mId;
                    boolean isCustom;
                    if (dynamicObject.getLong("dimscope.propertyid") != 0L) {
                        isCustom = true;
                        mId = dynamicObject.getLong("dimscope.propertyid");
                        IDNumberTreeNode propertyNode = MemberReader.findMemberById((long)modelId, (String)"bcm_definedpropertyvalue", (Long)mId);
                        mnumber = propertyNode.getNumber();
                    } else {
                        isCustom = false;
                        mId = dynamicObject.getLong("dimscope.memberid");
                        IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)dimModelNum, (Long)mId);
                        mnumber = node.getNumber();
                    }
                    HashSet finalMemberIds = new HashSet();
                    new MembRangeItem(dimModelNum, (Long)mId, mnumber, RangeEnum.getRangeByVal((int)dynamicObject.getInt("dimscope.scope")), isCustom, (Object)modelId).matchItems(e -> finalMemberIds.add(e.getId()));
                    dimMemberIds.addAll(finalMemberIds);
                }
                DynamicObject dimDyn = MemberReader.getDimensionDynById((long)MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum));
                dimMemberIds = permService.matchReadOrWritePermMembers(dimDyn.getLong("id"), dimDyn.getString("membermodel"), (Collection<Long>)dimMemberIds);
                Set<Long> memberIds = intrTplDimScope.getMemberIds();
                if (memberIds == null) {
                    memberIds = new HashSet<Long>(16);
                    intrTplDimScope.setMemberIds(memberIds);
                }
                memberIds.addAll(dimMemberIds);
                Set<Long> allMemberIds = intrTplDimScope.getAllMemberIds();
                if (allMemberIds == null) {
                    allMemberIds = new HashSet<Long>(16);
                    intrTplDimScope.setAllMemberIds(allMemberIds);
                }
                for (Long memId : dimMemberIds) {
                    allMemberIds.add(memId);
                    IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)dimModelNum, (Long)memId);
                    if (!node.isShare()) continue;
                    allMemberIds.add(node.getCopyfromId());
                }
            }
            for (Map.Entry entry : extfieldScopeMap.entrySet()) {
                String extendFieldNum = (String)entry.getKey();
                IntrTplDimScope intrTplDimScope = (IntrTplDimScope)result.get(extendFieldNum);
                if (intrTplDimScope == null) {
                    intrTplDimScope = new IntrTplDimScope();
                    result.put(extendFieldNum, intrTplDimScope);
                }
                HashSet<Long> enumIds = new HashSet<Long>(16);
                for (DynamicObject scope : (List)entry.getValue()) {
                    intrTplDimScope.setDisplayMode(IntrDimDisplayModeEnum.getEnumByValue((String)scope.getString("dimscope.displaymode")));
                    intrTplDimScope.setFix(scope.getBoolean("dimscope.isfix"));
                    if (scope.getBoolean("dimscope.isfix")) {
                        enumIds.add(scope.getLong("dimscope.fixvalueid"));
                        continue;
                    }
                    enumIds.add(scope.getLong("dimscope.memberid"));
                }
                DynamicObjectCollection enumCol = EnumItemServiceHelper.queryEnumValueByValueId(enumIds);
                if (enumCol == null || enumCol.isEmpty()) continue;
                intrTplDimScope.setEnumList(enumCol.stream().map(e -> e.getString("enumvalue")).collect(Collectors.toList()));
                intrTplDimScope.setAllMemberIds(enumIds);
                intrTplDimScope.setMemberIds(enumCol.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(mergeFieldList = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,model.id,papertemplatefield.extmodelfield.extfield.id,papertemplatefield.extmodelfield.extfield.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)})))) {
            return result;
        }
        long modelId = ((DynamicObject)mergeFieldList.get(0)).getLong("model.id");
        Map<Long, DynamicObject> fieldMap = mergeFieldList.stream().filter(item -> item.getLong("papertemplatefield.extmodelfield.extfield.id") != 0L).collect(Collectors.toMap(k -> k.getLong("papertemplatefield.extmodelfield.extfield.id"), v -> v, (e1, e2) -> e2));
        Map<Long, MultiF7Results> linkDimMap = ExtDataUtil.getMultiF7ValueByExtMemIds(new ArrayList<Long>(fieldMap.keySet()), modelId);
        if (!linkDimMap.isEmpty()) {
            for (Map.Entry entry : linkDimMap.entrySet()) {
                String fieldNum = fieldMap.get(entry.getKey()).getString("papertemplatefield.extmodelfield.extfield.number");
                result.put(fieldNum, IntrTemplateHelper.explainLinkRange(modelId, (MultiF7Results)entry.getValue(), fieldNum, result));
            }
        }
        return result;
    }

    private static IntrTplDimScope explainLinkRange(long modelId, MultiF7Results res, String fieldNum, Map<String, IntrTplDimScope> result) {
        IntrTplDimScope intrTplDimScope = new IntrTplDimScope();
        IntrTplDimScope oldScope = result.get(fieldNum);
        intrTplDimScope.setDisplayMode(oldScope != null ? oldScope.getDisplayMode() : IntrDimDisplayModeEnum.NUMBERANDNAME);
        if (CollectionUtils.isEmpty(res.getList())) {
            return intrTplDimScope;
        }
        HashSet<Long> memberIds = new HashSet<Long>(16);
        String entityNum = res.getDimDy().getString("membermodel");
        for (MultiF7Result item : res.getList()) {
            MembRangeItem range = new MembRangeItem(entityNum, (Long)item.getId(), item.getNumber(), item.getScope(), item.getPid() != 0L, (Object)modelId);
            range.matchItems(e -> memberIds.add((Long)e.getId()));
        }
        PermissionService permService = PermissionServiceImpl.getInstance(modelId);
        Set<Long> authMemberIds = permService.matchReadOrWritePermMembers(res.getDimDy().getLong("id"), entityNum, memberIds);
        HashSet<Long> allMemberIds = new HashSet<Long>(16);
        for (Long mid : authMemberIds) {
            allMemberIds.add(mid);
            IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)entityNum, (Long)mid);
            if (!node.isShare()) continue;
            allMemberIds.add(node.getCopyfromId());
        }
        intrTplDimScope.setFix(false);
        intrTplDimScope.setMemberIds(authMemberIds);
        intrTplDimScope.setAllMemberIds(allMemberIds);
        return intrTplDimScope;
    }

    public static Long getGroupIdByExtModelId(Long extModelId) {
        DynamicObject groupDyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,extendsgroup.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)extModelId)});
        if (groupDyn != null) {
            return groupDyn.getLong("extendsgroup.id");
        }
        return null;
    }

    public static Set<Long> getGroupTmplIds(Long modelId, Set<Long> tmplIds) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id, group", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("id", "in", tmplIds)});
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("group", "in", doc.stream().map(e -> e.getLong("group")).collect(Collectors.toSet()));
        return QueryServiceHelper.query((String)"bcm_papertemplate", (String)BASE_INFO, (QFilter[])qf.toArray()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public static Map<Long, ExtTemplateDto> queryUsedExtDataModelIds(Long modelId, Long group) {
        HashMap<Long, ExtTemplateDto> result = new HashMap<Long, ExtTemplateDto>(16);
        Set catalogIds = TemplateCatalogEnum.getInnerTemplateCatalogIds((long)modelId);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        qfBuilder.add("templatecatalog", "in", (Object)catalogIds);
        qfBuilder.add("group", "!=", (Object)group);
        DynamicObjectCollection templateList = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number,name,seller,purchaser,mergenode", (QFilter[])qfBuilder.toArray());
        for (DynamicObject template : templateList) {
            if (template.getLong("mergenode") <= 0L) continue;
            result.putIfAbsent(template.getLong("mergenode"), new ExtTemplateDto(template.getLong("id"), template.getString("number"), template.getString("name"), true));
        }
        QFilter tempQFilter = new QFilter("model", "=", (Object)modelId);
        tempQFilter.and("template.usage", "=", (Object)"1");
        tempQFilter.and("template.status", "=", (Object)"1");
        tempQFilter.and("template.isonlyread", "=", (Object)"0");
        DynamicObjectCollection refTemplates = QueryServiceHelper.query((String)"bcm_extmodelref", (String)"id,extmodel.id,template.id,template.number as number,template.name as name", (QFilter[])tempQFilter.toArray());
        for (DynamicObject template : refTemplates) {
            if (template.getLong("extmodel.id") <= 0L) continue;
            result.putIfAbsent(template.getLong("extmodel.id"), new ExtTemplateDto(template.getLong("template.id"), template.getString("number"), template.getString("name"), false));
        }
        return result;
    }
}

