/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.enumvalue.EnumItemServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.innertrade.model.ExtTemplateDto;
import kd.fi.bcm.business.innertrade.model.IntrAdjEntry;
import kd.fi.bcm.business.innertrade.model.IntrAdjRow;
import kd.fi.bcm.business.innertrade.model.IntrDimScope;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrTemplate;
import kd.fi.bcm.business.innertrade.model.IntrTmplFiled;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.papertemplate.ExtDimHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.PaperTmplExpImpHelper;
import kd.fi.bcm.business.papertemplate.PaperTmplImportInfo;
import kd.fi.bcm.business.papertemplate.PaperTmplImportResult;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.papertemplate.PaperTemplateStatusEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class IntrTmplImportExportHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, IntrTmplImportExportHelper.class);
    private static final String BNFORMULA = "bn()";

    public static String exportTmpls(long modelId, Set<Long> tmplIds) throws IOException {
        ArrayList<IntrTemplate> tmpls = new ArrayList<IntrTemplate>(16);
        String select = "id,number,name,versionnumber,description,sequence,versiondescription,spreadtype,spreadjson,data,usage,seller.number,purchaser.number,mergenode.number,areapoint,mfformula";
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("id", "in", tmplIds);
        DynamicObjectCollection tmplDoc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)select, (QFilter[])qf.toArray(), (String)"versionnumber asc");
        if (tmplDoc == null || tmplDoc.isEmpty()) {
            return null;
        }
        String fields = "id,papertemplatefield.formula,papertemplatefield.formulaname,papertemplatefield.formulades,papertemplatefield.executeseq,papertemplatefield.ismerge,papertemplatefield.extmodelfield.extfield.number,papertemplatefield.extmodelfield.isnecessary,papertemplatefield.extmodelfield.uniquecheck,papertemplatefield.dimmodelfield.dimension.number,papertemplatefield.dimmodelfield.isnecessary,papertemplatefield.dimmodelfield.uniquecheck";
        DynamicObjectCollection fieldDoc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)fields, (QFilter[])qf.toArray(), (String)"versionnumber asc");
        Map<Long, List<DynamicObject>> fieldMap = fieldDoc.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        String scopeFields = "id,dimscope.extendfield.number,dimscope.dimension.number,dimscope.memberid,dimscope.propertyid,dimscope.scope,dimscope.isfix,dimscope.fixvalueid,dimscope.displaymode";
        DynamicObjectCollection scopeDoc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)scopeFields, (QFilter[])qf.toArray(), (String)"versionnumber asc");
        Map<Long, List<DynamicObject>> scopeMap = scopeDoc.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        Set adjFields = EntityMetadataCache.getDataEntityType((String)"bcm_adjsetting").getAllFields().keySet();
        Map<Long, List<DynamicObject>> entryMaps = Arrays.stream(BusinessDataServiceHelper.load((String)"bcm_adjsetting", (String)("id" + String.join((CharSequence)",", adjFields)), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("templateid", "in", tmplIds)})).collect(Collectors.groupingBy(e -> e.getLong("templateid")));
        Map<String, String> dimMappedNumMap = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).toArray()).stream().collect(Collectors.toMap(k -> k.getString("fieldmapped"), v -> v.getString("number"), (e1, e2) -> e1));
        for (DynamicObject dyn : tmplDoc) {
            long tmplId = dyn.getLong("id");
            IntrTemplate tmpl = IntrTmplImportExportHelper.convertToTemplate(dyn);
            tmpl.setFiledList(IntrTmplImportExportHelper.convertToIntrField(fieldMap.get(tmplId)));
            tmpl.setDimScopeList(IntrTmplImportExportHelper.convertToDimScope(modelId, scopeMap.get(tmplId)));
            tmpl.setAdjEntrys(IntrTmplImportExportHelper.convertToAdjEntry(modelId, entryMaps.get(tmplId), dimMappedNumMap));
            tmpls.add(tmpl);
        }
        return IntrTmplImportExportHelper.createJsonFile(ObjectSerialUtil.toByteSerialized(tmpls), IntrTmplImportExportHelper.getFileName());
    }

    private static List<IntrAdjEntry> convertToAdjEntry(long modelId, List<DynamicObject> doc, Map<String, String> dimMappedNumMap) {
        ArrayList<IntrAdjEntry> result = new ArrayList<IntrAdjEntry>(16);
        if (CollectionUtils.isEmpty(doc)) {
            return result;
        }
        for (DynamicObject dyn : doc) {
            IntrAdjEntry entry = new IntrAdjEntry();
            entry.setNumber(dyn.getString("number"));
            entry.setName(dyn.get("name"));
            entry.setBussinesstype(dyn.getString("businesstype"));
            entry.setJournaltype(dyn.getString("journaltype"));
            entry.setProcessNum(dyn.getString("process.number"));
            entry.setLinkage(dyn.getString("islinkage"));
            entry.setDescription(dyn.get("description"));
            entry.setStatus(dyn.getString("status"));
            entry.setAdjustCatalogId(dyn.getLong("adjustcatalog.id"));
            DynamicObjectCollection rowDoc = dyn.getDynamicObjectCollection("entryentity");
            ArrayList<IntrAdjRow> rows = new ArrayList<IntrAdjRow>(16);
            for (DynamicObject rowDyn : rowDoc) {
                IntrAdjRow row = new IntrAdjRow();
                row.setAccountNumber(rowDyn.getString("accountdyn.number"));
                row.setAccountClassType(rowDyn.getString("accountclasstype"));
                row.setChangTpyeNumber(rowDyn.getString("changetypedyn.number"));
                row.setChangeTypeClassType(rowDyn.getString("changetypeclasstype"));
                row.setEntity(rowDyn.getString("entity"));
                row.setMycompany(rowDyn.getString("mycompany"));
                row.setIntercompany(rowDyn.getString("opcompany"));
                row.setAudittrailNumber(rowDyn.getString("audittraildyn.number"));
                row.setAudittrailClassType(rowDyn.getString("audittrailclasstype"));
                row.setDatasortNumber(rowDyn.getString("datasortdyn.number"));
                row.setDatasortClassType(rowDyn.getString("datasortclasstype"));
                row.setMultigaapNumber(rowDyn.getString("multigaapdyn.number"));
                row.setMultigaapClassType(rowDyn.getString("multigaapclasstype"));
                row.setUserdefined1Number((Pair<String, String>)Pair.onePair((Object)dimMappedNumMap.get("dim1"), (Object)rowDyn.getString("dim1dyn.number")));
                row.setDim1ClassType(rowDyn.getString("dim1classtype"));
                row.setUserdefined2Number((Pair<String, String>)Pair.onePair((Object)dimMappedNumMap.get("dim2"), (Object)rowDyn.getString("dim2dyn.number")));
                row.setDim2ClassType(rowDyn.getString("dim2classtype"));
                row.setUserdefined3Number((Pair<String, String>)Pair.onePair((Object)dimMappedNumMap.get("dim3"), (Object)rowDyn.getString("dim3dyn.number")));
                row.setDim3ClassType(rowDyn.getString("dim3classtype"));
                row.setUserdefined4Number((Pair<String, String>)Pair.onePair((Object)dimMappedNumMap.get("dim4"), (Object)rowDyn.getString("dim4dyn.number")));
                row.setDim4ClassType(rowDyn.getString("dim4classtype"));
                row.setUserdefined5Number((Pair<String, String>)Pair.onePair((Object)dimMappedNumMap.get("dim5"), (Object)rowDyn.getString("dim5dyn.number")));
                row.setDim5ClassType(rowDyn.getString("dim5classtype"));
                row.setUserdefined6Number((Pair<String, String>)Pair.onePair((Object)dimMappedNumMap.get("dim6"), (Object)rowDyn.getString("dim6dyn.number")));
                row.setDim6ClassType(rowDyn.getString("dim6classtype"));
                row.setDebitNum(IntrTmplImportExportHelper.getExtFieldNumberById(modelId, rowDyn.getString("debit")));
                row.setCreditNum(IntrTmplImportExportHelper.getExtFieldNumberById(modelId, rowDyn.getString("credit")));
                rows.add(row);
            }
            entry.setRowList(rows);
            result.add(entry);
        }
        return result;
    }

    private static String getExtFieldNumberById(long modelId, String extFieldId) {
        if (!NumberUtils.isCreatable((String)extFieldId)) {
            return extFieldId;
        }
        IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)"bcm_structofextend", (Long)LongUtil.toLong((Object)extFieldId));
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return "";
        }
        return node.getNumber();
    }

    private static List<IntrDimScope> convertToDimScope(long modelId, List<DynamicObject> dyns) {
        ArrayList<IntrDimScope> result = new ArrayList<IntrDimScope>(16);
        if (CollectionUtils.isEmpty(dyns)) {
            return result;
        }
        Set<Long> enumValueIds = dyns.stream().map(e -> e.getLong("dimscope.memberid")).collect(Collectors.toSet());
        enumValueIds.addAll(dyns.stream().map(e -> e.getLong("dimscope.fixvalueid")).collect(Collectors.toSet()));
        Map<Long, String> enumIdNameMap = EnumItemServiceHelper.queryEnumValueByValueId(enumValueIds).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("enumvalue"), (e1, e2) -> e1));
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (DynamicObject dyn : dyns) {
            long propertyId;
            IntrDimScope scope = new IntrDimScope();
            String extFieldNum = dyn.getString("dimscope.extendfield.number");
            scope.setExtFieldNum(extFieldNum);
            String dimNum = dyn.getString("dimscope.dimension.number");
            scope.setDimNum(dimNum);
            long memberId = dyn.getLong("dimscope.memberid");
            if (memberId != 0L) {
                if (!StringUtils.isBlank((CharSequence)dimNum)) {
                    scope.setMemberNum(MemberReader.findMemberById((String)modelNum, (String)MemberReader.getEntityNumberByDim((String)modelNum, (String)dimNum), (Long)memberId).getNumber());
                } else if (!StringUtils.isBlank((CharSequence)extFieldNum)) {
                    scope.setMemberNum(enumIdNameMap.get(memberId));
                }
            }
            if ((propertyId = dyn.getLong("dimscope.propertyid")) != 0L) {
                scope.setPropertyNum(MemberReader.findMemberById((String)modelNum, (String)"bcm_definedpropertyvalue", (Long)propertyId).getNumber());
            }
            scope.setScope(dyn.getString("dimscope.scope"));
            scope.setIsfix(dyn.getBoolean("dimscope.isfix"));
            long fixvalueId = dyn.getLong("dimscope.fixvalueid");
            if (scope.getIsfix().booleanValue() && fixvalueId != 0L) {
                if (!StringUtils.isBlank((CharSequence)dimNum)) {
                    scope.setFixvalueNum(MemberReader.findMemberById((String)modelNum, (String)MemberReader.getEntityNumberByDim((String)modelNum, (String)dimNum), (Long)fixvalueId).getNumber());
                } else if (!StringUtils.isBlank((CharSequence)extFieldNum)) {
                    scope.setFixvalueNum(enumIdNameMap.get(fixvalueId));
                }
            }
            scope.setDisplaymode(dyn.getString("dimscope.displaymode"));
            result.add(scope);
        }
        return result;
    }

    private static List<IntrTmplFiled> convertToIntrField(List<DynamicObject> dyns) {
        ArrayList<IntrTmplFiled> result = new ArrayList<IntrTmplFiled>(16);
        if (CollectionUtils.isEmpty(dyns)) {
            return result;
        }
        for (DynamicObject dyn : dyns) {
            IntrTmplFiled field = new IntrTmplFiled();
            String extFieldNum = dyn.getString("papertemplatefield.extmodelfield.extfield.number");
            field.setExtFieldNum(extFieldNum);
            String extDimNum = dyn.getString("papertemplatefield.dimmodelfield.dimension.number");
            field.setDimFieldNum(extDimNum);
            if (!StringUtils.isBlank((CharSequence)extFieldNum)) {
                field.setUnique(dyn.getBoolean("papertemplatefield.extmodelfield.uniquecheck"));
                field.setRequest(dyn.getBoolean("papertemplatefield.extmodelfield.isnecessary"));
            } else if (!StringUtils.isBlank((CharSequence)extDimNum)) {
                field.setUnique(dyn.getBoolean("papertemplatefield.dimmodelfield.uniquecheck"));
                field.setRequest(dyn.getBoolean("papertemplatefield.dimmodelfield.isnecessary"));
            }
            field.setFormula(dyn.getString("papertemplatefield.formula"));
            field.setFormulaname(dyn.getString("papertemplatefield.formulaname"));
            field.setExecuteseq(dyn.getInt("papertemplatefield.executeseq"));
            field.setFormulades(dyn.getString("papertemplatefield.formulades"));
            field.setIsmerge(dyn.getBoolean("papertemplatefield.ismerge"));
            result.add(field);
        }
        return result;
    }

    private static IntrTemplate convertToTemplate(DynamicObject dyn) {
        IntrTemplate tmpl = new IntrTemplate();
        tmpl.setNumber(dyn.getString("number"));
        tmpl.setName(dyn.get("name"));
        BigDecimal versionnumber = dyn.getBigDecimal("versionnumber");
        tmpl.setVersionNumber(versionnumber != null ? versionnumber.setScale(1, RoundingMode.HALF_UP).toPlainString() : "");
        tmpl.setVersiondescriction(dyn.getString("versiondescription"));
        tmpl.setSequence(dyn.getInt("sequence"));
        tmpl.setDescription(dyn.getString("description"));
        tmpl.setUsage(dyn.getString("usage"));
        tmpl.setAreapoint(dyn.getString("areapoint"));
        tmpl.setMergenode(dyn.getString("mergenode.number"));
        tmpl.setMfformula(dyn.getString("mfformula"));
        tmpl.setPurchaser(dyn.getString("purchaser.number"));
        tmpl.setSeller(dyn.getString("seller.number"));
        tmpl.setSpreadJson(dyn.getString("spreadjson"));
        tmpl.setData(dyn.getString("data"));
        return tmpl;
    }

    private static String getFileName() {
        String fileName = ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u62b5\u9500\u6a21\u677f\u5bfc\u51fa", (String)"IntrTmpImportExportHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d%02d", now.getYear(), now.getMonthValue(), now.getDayOfMonth()) + ".json";
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createJsonFile(String jsonString, String fileName) throws IOException {
        try (ByteArrayInputStream inStream = null;){
            inStream = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
    }

    public static PaperTmplImportResult importTmpls(long modelId, Long sceneid, Long catalog, String jsonString, Map<String, String> numberMap) {
        PaperTmplImportResult result = new PaperTmplImportResult();
        List tmpls = new ArrayList(16);
        try {
            tmpls = (List)ObjectSerialUtil.deSerializedBytes((String)jsonString);
        }
        catch (Exception e2) {
            log.error("intr template import error.", (Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvTmplImportExportHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (numberMap != null && !numberMap.isEmpty()) {
            for (IntrTemplate tmpl : tmpls) {
                tmpl.setNumber(numberMap.getOrDefault(String.format("%s_%s", tmpl.getNumber(), tmpl.getVersionNumber()), tmpl.getNumber()));
            }
        }
        ArrayList<PaperTmplImportInfo> successTmpls = new ArrayList<PaperTmplImportInfo>(16);
        ArrayList<PaperTmplImportInfo> needUpdateTmpls = new ArrayList<PaperTmplImportInfo>(16);
        ArrayList<PaperTmplImportInfo> failTmpls = new ArrayList<PaperTmplImportInfo>(16);
        result.setSuccessTmpls(successTmpls);
        result.setNeedUpdateTmpls(needUpdateTmpls);
        result.setFailTmpls(failTmpls);
        HashMap<String, List> successImportMap = new HashMap<String, List>(16);
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        for (IntrTemplate tmpl : tmpls) {
            String failMsg = IntrTmplImportExportHelper.validateTmpl(modelId, modelNum, tmpl);
            if (StringUtils.isNotEmpty((CharSequence)failMsg)) {
                failTmpls.add(new PaperTmplImportInfo(tmpl.getNumber(), tmpl.getLocalName(), tmpl.getVersionNumber(), failMsg));
                continue;
            }
            successTmpls.add(new PaperTmplImportInfo(tmpl.getNumber(), tmpl.getLocalName(), tmpl.getVersionNumber()));
            successImportMap.computeIfAbsent(tmpl.getNumber(), k -> new ArrayList(16)).add(tmpl);
        }
        if (CollectionUtils.isEmpty(successTmpls)) {
            return result;
        }
        Date modelBeginDate = EntityVersioningUtil.getModelBeginDate(modelId);
        Map<String, FourTuple<Integer, Long, Long, Long>> updateTmplVersionMap = PaperTmplExpImpHelper.getTmplMaxVersion(modelId, TemplateCatalogEnum.INNERTRADE, successTmpls.stream().map(PaperTmplImportInfo::getNumber).collect(Collectors.toSet()));
        ArrayList tmplDynList = new ArrayList(16);
        ArrayList adjustDynList = new ArrayList(16);
        ArrayList tmplSceneDynList = new ArrayList(16);
        ArrayList distributionDynList = new ArrayList(16);
        for (Map.Entry kv : successImportMap.entrySet()) {
            List tmplList = (List)kv.getValue();
            if (updateTmplVersionMap.containsKey(kv.getKey()) || tmplList.size() > 1) {
                needUpdateTmpls.addAll(tmplList.stream().map(e -> new PaperTmplImportInfo(e.getNumber(), e.getLocalName(), e.getVersionNumber())).collect(Collectors.toList()));
            }
            Map<String, List<DynamicObject>> saveMap = IntrTmplImportExportHelper.buildSaveDocMap(tmplList, modelId, sceneid, catalog, updateTmplVersionMap.get(kv.getKey()), modelBeginDate);
            tmplDynList.addAll(saveMap.get("tmpl"));
            adjustDynList.addAll(saveMap.get("adjust"));
            tmplSceneDynList.addAll(saveMap.get("tmplScene"));
            distributionDynList.addAll(saveMap.get("distribution"));
        }
        try (TXHandle tx = TX.required((String)"saveInvTemplate");){
            try {
                SaveServiceHelper.save((DynamicObject[])tmplDynList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])adjustDynList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])tmplSceneDynList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])distributionDynList.toArray(new DynamicObject[0]));
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("saveIntrTemplate error", t);
                throw new KDBizException(t, new ErrorCode("", ThrowableHelper.toString((Throwable)t)), new Object[0]);
            }
        }
        return result;
    }

    private static Map<String, List<DynamicObject>> buildSaveDocMap(List<IntrTemplate> tmplList, long modelId, Long sceneid, Long catalogId, FourTuple<Integer, Long, Long, Long> versionGroupId, Date modelBeginDate) {
        ArrayList<DynamicObject> tmplDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> adjustDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> tmplSceneDynList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> distributionDynList = new ArrayList<DynamicObject>(16);
        int version = 0;
        Long groupId = 0L;
        if (versionGroupId != null) {
            version = (Integer)versionGroupId.item1;
            groupId = (Long)versionGroupId.item2;
        }
        if (groupId == 0L) {
            groupId = GlobalIdUtil.genGlobalLongId();
            if (sceneid != null) {
                tmplSceneDynList.add(PaperTmplExpImpHelper.createTmplSceneDyn(modelId, sceneid, groupId, PaperTemplateTypeEnum.INNERTRADE));
            }
        }
        Map<String, String> dimFieldMapped = PaperTmplExpImpHelper.getDimFieldMapped(modelId);
        for (int i = 0; i < tmplList.size(); ++i) {
            ++version;
            IntrTemplate tmpl = tmplList.get(i);
            if (versionGroupId != null || i != 0) {
                modelBeginDate = null;
            }
            Long newCatalodId = versionGroupId != null ? (Long)versionGroupId.item4 : catalogId;
            DynamicObject tmplDyn = IntrTmplImportExportHelper.convertToTmplDyn(tmpl, modelId, sceneid, newCatalodId, version, groupId, modelBeginDate);
            tmplDynList.add(tmplDyn);
            if (versionGroupId != null) {
                distributionDynList.addAll(PaperTmplExpImpHelper.createDistributionDyn(modelId, tmplDyn.getLong("id"), (Long)versionGroupId.item3));
            }
            Long extGroupId = IntrTemplateHelper.getGroupIdByExtModelId(PaperTmplExpImpHelper.getExtModelIdByNum(modelId, tmpl.getMergenode()));
            adjustDynList.addAll(IntrTmplImportExportHelper.convertToEntryDyn(extGroupId, dimFieldMapped, tmpl.getAdjEntrys(), tmplDyn.getLong("id"), modelId, sceneid));
        }
        return MapInitHelper.ofMap((Object)"tmpl", tmplDynList, (Object)"adjust", adjustDynList, (Object)"tmplScene", tmplSceneDynList, (Object)"distribution", distributionDynList);
    }

    private static List<DynamicObject> convertToEntryDyn(Long extGroupId, Map<String, String> dimFieldMapped, List<IntrAdjEntry> adjEntrys, long tmplId, long modelId, Long sceneid) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        Date now = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        for (IntrAdjEntry adj : adjEntrys) {
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjsetting");
            dyn.set("model", (Object)modelId);
            dyn.set("templateid", (Object)tmplId);
            dyn.set("createtime", (Object)now);
            dyn.set("modifytime", (Object)now);
            dyn.set("creator", (Object)userId);
            dyn.set("modifier", (Object)userId);
            dyn.set("scenario", (Object)sceneid);
            dyn.set("status", (Object)adj.getStatus());
            dyn.set("number", (Object)adj.getNumber());
            dyn.set("name", adj.getName());
            dyn.set("businesstype", (Object)adj.getBussinesstype());
            dyn.set("journaltype", (Object)adj.getJournaltype());
            dyn.set("process", (Object)MemberReader.findProcessMemberByNum((String)modelNumber, (String)adj.getProcessNum()).getId());
            dyn.set("islinkage", (Object)adj.getLinkage());
            dyn.set("adjustcatalog", (Object)adj.getAdjustCatalogId());
            dyn.set("description", adj.getDescription());
            if (!CollectionUtils.isEmpty(adj.getRowList())) {
                DynamicObjectCollection doc = dyn.getDynamicObjectCollection("entryentity");
                int seq = 1;
                for (IntrAdjRow row : adj.getRowList()) {
                    DynamicObject rowDyn = new DynamicObject(doc.getDynamicObjectType());
                    rowDyn.set("seq", (Object)seq);
                    if (row.isExtendField(row.getAccountClassType())) {
                        rowDyn.set("accountclasstype", (Object)"bcm_structofextend");
                        rowDyn.set("accountdyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, row.getAccountNumber()));
                    } else {
                        rowDyn.set("accountclasstype", (Object)"bcm_accountmembertree");
                        rowDyn.set("accountdyn", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.ACCOUNT_DIM, row.getAccountNumber()));
                    }
                    if (row.isExtendField(row.getChangeTypeClassType())) {
                        rowDyn.set("changetypeclasstype", (Object)"bcm_structofextend");
                        rowDyn.set("changetypedyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, row.getChangTpyeNumber()));
                    } else {
                        rowDyn.set("changetypeclasstype", (Object)"bcm_changetypemembertree");
                        rowDyn.set("changetypedyn", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.CHANGETYPE_DIM, row.getChangTpyeNumber()));
                    }
                    rowDyn.set("entity", (Object)row.getEntity());
                    rowDyn.set("mycompany", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey(PresetConstant.MYCOMPANY_DIM), row.getMycompany(), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.MYCOMPANY_DIM, "MCNone")));
                    rowDyn.set("opcompany", (Object)row.getIntercompany());
                    if (row.isExtendField(row.getAudittrailClassType())) {
                        rowDyn.set("audittrailclasstype", (Object)"bcm_structofextend");
                        rowDyn.set("audittraildyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, row.getAudittrailNumber()));
                    } else {
                        rowDyn.set("audittrailclasstype", (Object)"bcm_audittrialmembertree");
                        rowDyn.set("audittraildyn", (Object)PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.AUDITTRIAL_DIM, row.getAudittrailNumber()));
                    }
                    if (row.isExtendField(row.getDatasortClassType())) {
                        rowDyn.set("datasortclasstype", (Object)"bcm_structofextend");
                        rowDyn.set("datasortdyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, row.getDatasortNumber()));
                    } else {
                        rowDyn.set("datasortclasstype", (Object)"bcm_datasortmembertree");
                        rowDyn.set("datasortdyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey(PresetConstant.DATASORT_DIM), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.DATASORT_DIM, row.getDatasortNumber()), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.DATASORT_DIM, "Actual")));
                    }
                    if (row.isExtendField(row.getMultigaapClassType())) {
                        rowDyn.set("multigaapclasstype", (Object)"bcm_structofextend");
                        rowDyn.set("multigaapdyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, row.getMultigaapNumber()));
                    } else {
                        rowDyn.set("multigaapclasstype", (Object)"bcm_rulemembertree");
                        rowDyn.set("multigaapdyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey(PresetConstant.RULE_DIM), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.RULE_DIM, row.getMultigaapNumber()), PaperTmplExpImpHelper.getMemberId(modelId, PresetConstant.RULE_DIM, "PRCGAAP")));
                    }
                    if (row.isExtendField(row.getDim1ClassType())) {
                        rowDyn.set("dim1classtype", (Object)"bcm_structofextend");
                        rowDyn.set("dim1dyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, (String)row.getUserdefined1Number().p2));
                    } else {
                        rowDyn.set("dim1classtype", (Object)"bcm_userdefinedmembertree");
                        rowDyn.set("dim1dyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim1"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined1Number().p1, (String)row.getUserdefined1Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim1"), dimFieldMapped.get("dim1") + "None")));
                    }
                    if (row.isExtendField(row.getDim2ClassType())) {
                        rowDyn.set("dim2classtype", (Object)"bcm_structofextend");
                        rowDyn.set("dim2dyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, (String)row.getUserdefined2Number().p2));
                    } else {
                        rowDyn.set("dim2classtype", (Object)"bcm_userdefinedmembertree");
                        rowDyn.set("dim2dyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim2"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined2Number().p1, (String)row.getUserdefined2Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim2"), dimFieldMapped.get("dim2") + "None")));
                    }
                    if (row.isExtendField(row.getDim3ClassType())) {
                        rowDyn.set("dim3classtype", (Object)"bcm_structofextend");
                        rowDyn.set("dim3dyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, (String)row.getUserdefined3Number().p2));
                    } else {
                        rowDyn.set("dim3classtype", (Object)"bcm_userdefinedmembertree");
                        rowDyn.set("dim3dyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim3"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined3Number().p1, (String)row.getUserdefined3Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim3"), dimFieldMapped.get("dim3") + "None")));
                    }
                    if (row.isExtendField(row.getDim4ClassType())) {
                        rowDyn.set("dim4classtype", (Object)"bcm_structofextend");
                        rowDyn.set("dim4dyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, (String)row.getUserdefined4Number().p2));
                    } else {
                        rowDyn.set("dim4classtype", (Object)"bcm_userdefinedmembertree");
                        rowDyn.set("dim4dyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim4"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined4Number().p1, (String)row.getUserdefined4Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim4"), dimFieldMapped.get("dim4") + "None")));
                    }
                    if (row.isExtendField(row.getDim5ClassType())) {
                        rowDyn.set("dim5classtype", (Object)"bcm_structofextend");
                        rowDyn.set("dim5dyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, (String)row.getUserdefined5Number().p2));
                    } else {
                        rowDyn.set("dim5classtype", (Object)"bcm_userdefinedmembertree");
                        rowDyn.set("dim5dyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim5"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined5Number().p1, (String)row.getUserdefined5Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim5"), dimFieldMapped.get("dim5") + "None")));
                    }
                    if (row.isExtendField(row.getDim6ClassType())) {
                        rowDyn.set("dim6classtype", (Object)"bcm_structofextend");
                        rowDyn.set("dim6dyn", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, (String)row.getUserdefined6Number().p2));
                    } else {
                        rowDyn.set("dim6classtype", (Object)"bcm_userdefinedmembertree");
                        rowDyn.set("dim6dyn", PaperTmplExpImpHelper.getOrDeafult(dimFieldMapped.containsKey("dim6"), PaperTmplExpImpHelper.getMemberId(modelId, (String)row.getUserdefined6Number().p1, (String)row.getUserdefined6Number().p2), PaperTmplExpImpHelper.getMemberId(modelId, dimFieldMapped.get("dim6"), dimFieldMapped.get("dim6") + "None")));
                    }
                    rowDyn.set("debit", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, row.getDebitNum()));
                    rowDyn.set("credit", (Object)IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, row.getCreditNum()));
                    doc.add((Object)rowDyn);
                    ++seq;
                }
            }
            result.add(dyn);
        }
        return result;
    }

    private static String getExtFieldIdByNum(long modelId, Long extGroupId, String extFieldNum) {
        if (extGroupId == null) {
            return null;
        }
        if (BNFORMULA.equalsIgnoreCase(extFieldNum)) {
            return extFieldNum;
        }
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)DimEntityNumEnum.EXTENDS.getNumber(), (String)extFieldNum);
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return null;
        }
        IDNumberTreeNode fieldNode = null;
        if (extGroupId.equals(node.getParent().getId())) {
            fieldNode = node;
        } else if (!CollectionUtils.isEmpty((Collection)node.getShareNodes())) {
            for (IDNumberTreeNode shareNode : node.getShareNodes()) {
                if (!extGroupId.equals(shareNode.getParent().getId())) continue;
                fieldNode = shareNode;
                break;
            }
        }
        if (fieldNode != null) {
            return fieldNode.getId().toString();
        }
        return null;
    }

    private static DynamicObject convertToTmplDyn(IntrTemplate tmpl, long modelId, Long sceneid, Long catalogId, int version, Long groupId, Date modelBeginDate) {
        DynamicObject tmplDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_papertemplate");
        tmplDyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        tmplDyn.set("number", (Object)tmpl.getNumber());
        tmplDyn.set("name", tmpl.getName());
        tmplDyn.set("templatetype", (Object)tmpl.getTemplatetype());
        tmplDyn.set("sequence", (Object)tmpl.getSequence());
        tmplDyn.set("versionnumber", (Object)BigDecimal.valueOf(version));
        tmplDyn.set("versiondescription", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u751f\u6210", (String)"InvTmplImportExportHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        tmplDyn.set("spreadjson", (Object)tmpl.getSpreadJson());
        tmplDyn.set("data", (Object)tmpl.getData());
        tmplDyn.set("description", (Object)tmpl.getDescription());
        tmplDyn.set("group", (Object)groupId);
        tmplDyn.set("templatecatalog", (Object)catalogId);
        tmplDyn.set("model", (Object)modelId);
        tmplDyn.set("scenario", (Object)sceneid);
        Long userId = RequestContext.get().getCurrUserId();
        tmplDyn.set("creator", (Object)userId);
        tmplDyn.set("modifier", (Object)userId);
        Date now = new Date();
        tmplDyn.set("createtime", (Object)now);
        tmplDyn.set("modifytime", (Object)now);
        tmplDyn.set("effectivedate", (Object)modelBeginDate);
        tmplDyn.set("status", (Object)PaperTemplateStatusEnum.DISABLE.getStatusValue());
        tmplDyn.set("usage", (Object)tmpl.getUsage());
        tmplDyn.set("seller", (Object)PaperTmplExpImpHelper.getExtModelIdByNum(modelId, tmpl.getSeller()));
        tmplDyn.set("purchaser", (Object)PaperTmplExpImpHelper.getExtModelIdByNum(modelId, tmpl.getPurchaser()));
        Long mergeNodeId = PaperTmplExpImpHelper.getExtModelIdByNum(modelId, tmpl.getMergenode());
        tmplDyn.set("mergenode", (Object)mergeNodeId);
        tmplDyn.set("areapoint", (Object)tmpl.getAreapoint());
        tmplDyn.set("mfformula", (Object)tmpl.getMfformula());
        if (!CollectionUtils.isEmpty(tmpl.getFiledList())) {
            DynamicObjectCollection fieldDoc = tmplDyn.getDynamicObjectCollection("papertemplatefield");
            int seq = 1;
            for (IntrTmplFiled filed : tmpl.getFiledList()) {
                DynamicObject fieldDyn = new DynamicObject(fieldDoc.getDynamicObjectType());
                fieldDyn.set("extmodelid", (Object)mergeNodeId);
                fieldDyn.set("extmodelfield", (Object)IntrTmplImportExportHelper.getExtFieldRefId(mergeNodeId, filed.getExtFieldNum()));
                fieldDyn.set("dimmodelfield", (Object)IntrTmplImportExportHelper.getDimFieldRefId(mergeNodeId, filed.getDimFieldNum()));
                fieldDyn.set("formula", (Object)filed.getFormula());
                fieldDyn.set("formulaname", (Object)filed.getFormulaname());
                fieldDyn.set("executeseq", (Object)filed.getExecuteseq());
                fieldDyn.set("formulades", (Object)filed.getFormulades());
                fieldDyn.set("ismerge", (Object)filed.getIsmerge());
                fieldDyn.set("seq", (Object)seq);
                ++seq;
                fieldDoc.add((Object)fieldDyn);
            }
        }
        if (!CollectionUtils.isEmpty(tmpl.getDimScopeList())) {
            Long extGroupId = IntrTemplateHelper.getGroupIdByExtModelId(PaperTmplExpImpHelper.getExtModelIdByNum(modelId, tmpl.getMergenode()));
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            DynamicObjectCollection scopeDoc = tmplDyn.getDynamicObjectCollection("dimscope");
            for (IntrDimScope scope : tmpl.getDimScopeList()) {
                DynamicObject scopeDyn = new DynamicObject(scopeDoc.getDynamicObjectType());
                if (!StringUtils.isBlank((CharSequence)scope.getExtFieldNum())) {
                    String extFieldId = IntrTmplImportExportHelper.getExtFieldIdByNum(modelId, extGroupId, scope.getExtFieldNum());
                    scopeDyn.set("extendfield", (Object)extFieldId);
                }
                Long dimensionId = 0L;
                if (!StringUtils.isBlank((CharSequence)scope.getDimNum())) {
                    dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)scope.getDimNum());
                    scopeDyn.set("dimension", (Object)dimensionId);
                }
                scopeDyn.set("isfix", (Object)scope.getIsfix());
                if (scope.getIsfix().booleanValue()) {
                    if (!StringUtils.isBlank((CharSequence)scope.getDimNum())) {
                        scopeDyn.set("fixvalueid", (Object)MemberReader.findMemberByNumber((String)modelNumber, (String)scope.getDimNum(), (String)scope.getFixvalueNum()).getId());
                    } else if (!StringUtils.isBlank((CharSequence)scope.getExtFieldNum())) {
                        scopeDyn.set("fixvalueid", (Object)IntrTmplImportExportHelper.getEunmIdByNum(modelId, scope.getExtFieldNum(), scope.getFixvalueNum()));
                    }
                } else {
                    DynamicObject property;
                    if (!StringUtils.isBlank((CharSequence)scope.getMemberNum())) {
                        if (!StringUtils.isBlank((CharSequence)scope.getDimNum())) {
                            scopeDyn.set("memberid", (Object)MemberReader.findMemberByNumber((String)modelNumber, (String)scope.getDimNum(), (String)scope.getMemberNum()).getId());
                        } else if (!StringUtils.isBlank((CharSequence)scope.getExtFieldNum())) {
                            Long eunmId = IntrTmplImportExportHelper.getEunmIdByNum(modelId, scope.getExtFieldNum(), scope.getMemberNum());
                            scopeDyn.set("memberid", (Object)eunmId);
                        }
                    }
                    if (!StringUtils.isBlank((CharSequence)scope.getPropertyNum()) && (property = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("dimension", "=", (Object)dimensionId), new QFilter("number", "=", (Object)scope.getPropertyNum())})) != null) {
                        scopeDyn.set("propertyid", (Object)property.getLong("id"));
                    }
                }
                scopeDyn.set("scope", (Object)scope.getScope());
                scopeDyn.set("displaymode", (Object)scope.getDisplaymode());
                scopeDoc.add((Object)scopeDyn);
            }
        }
        return tmplDyn;
    }

    private static Long getDimFieldRefId(Long mergeNodeId, String dimFieldNum) {
        if (StringUtils.isBlank((CharSequence)dimFieldNum)) {
            return null;
        }
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_extmodeldim", (String)"id", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)mergeNodeId), new QFilter("dimension.number", "=", (Object)dimFieldNum)});
        if (dyn != null) {
            return dyn.getLong("id");
        }
        return null;
    }

    private static Long getExtFieldRefId(Long mergeNodeId, String extFieldNum) {
        if (StringUtils.isBlank((CharSequence)extFieldNum)) {
            return null;
        }
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"id", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)mergeNodeId), new QFilter("extfield.number", "=", (Object)extFieldNum)});
        if (dyn != null) {
            return dyn.getLong("id");
        }
        return null;
    }

    private static String validateTmpl(long modelId, String modelNum, IntrTemplate tmpl) {
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        DynamicObject extMergeModel = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id, number", (QFilter[])new QFilter[]{modelQf, new QFilter("number", "=", (Object)tmpl.getMergenode())});
        if (extMergeModel == null) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%s]\u7684\u62d3\u5c55\u7ef4\u6a21\u578b\u3002", (String)"InvTemplateHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getMergenode());
        }
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,usage,mergenode.id,group", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)tmpl.getNumber()), new QFilter("templatecatalog", "in", PaperTemplateHelper.findTmpCatalogIds(modelId, PaperTemplateTypeEnum.INNERTRADE))});
        Map<Long, ExtTemplateDto> usedExtDataModels = IntrTemplateHelper.queryUsedExtDataModelIds(modelId, dyn != null ? dyn.getLong("group") : 0L);
        if (usedExtDataModels.containsKey(extMergeModel.getLong("id"))) {
            ExtTemplateDto existTmpl = usedExtDataModels.get(extMergeModel.getLong("id"));
            if (existTmpl.isIntr()) {
                return String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b%1$s\u5df2\u88ab\u4ea4\u6613\u62b5\u9500\u5e95\u7a3f\u6a21\u677f%2$s-%3$s\u5f15\u7528\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"IntrTmplImportExportHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getMergenode(), existTmpl.getNumber(), existTmpl.getName());
            }
            return String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b%1$s\u5df2\u88ab\u62a5\u8868\u6a21\u677f%2$s-%3$s\u5f15\u7528\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"IntrTmplImportExportHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getMergenode(), existTmpl.getNumber(), existTmpl.getName());
        }
        if (!StringUtils.isBlank((CharSequence)tmpl.getSeller()) && !QueryServiceHelper.exists((String)"bcm_extendsmodel", (QFilter[])new QFilter[]{modelQf, new QFilter("number", "=", (Object)tmpl.getSeller())})) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%s]\u7684\u62d3\u5c55\u7ef4\u6a21\u578b\u3002", (String)"InvTemplateHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getSeller());
        }
        if (!StringUtils.isBlank((CharSequence)tmpl.getPurchaser()) && !QueryServiceHelper.exists((String)"bcm_extendsmodel", (QFilter[])new QFilter[]{modelQf, new QFilter("number", "=", (Object)tmpl.getPurchaser())})) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%s]\u7684\u62d3\u5c55\u7ef4\u6a21\u578b\u3002", (String)"InvTemplateHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getPurchaser());
        }
        if (dyn != null) {
            Iterator<IntrDimScope> group2;
            if (!tmpl.getUsage().equals(dyn.getString("usage"))) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u7684\u6a21\u677f\u7528\u9014\u4e0e\u7cfb\u7edf\u5df2\u5b58\u5728\u7684\u6a21\u677f\u4e0d\u4e00\u81f4\u3002", (String)"IntrTmplImportExportHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]);
            }
            Long group1 = IntrTemplateHelper.getGroupIdByExtModelId(extMergeModel.getLong("id"));
            if (!Objects.equals(group1, group2 = IntrTemplateHelper.getGroupIdByExtModelId(dyn.getLong("mergenode.id")))) {
                return ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u7684\u62d3\u5c55\u7ef4\u6a21\u578b\u6240\u5c5e\u5206\u7ec4\u4e0e\u7cfb\u7edf\u5df2\u5b58\u5728\u7684\u6a21\u677f\u4e0d\u4e00\u81f4\u3002", (String)"IntrTmplImportExportHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]);
            }
        }
        Map<String, IntrTmplFiled> fieldMap = IntrTmplImportExportHelper.getTmplFileMap(extMergeModel.getLong("id"));
        ExtDimHelper.getTmpFieldByExtModelId(extMergeModel.getLong("id")).stream().collect(Collectors.toMap(IntrField::getNumber, v -> v, (e1, e2) -> e1));
        for (IntrTmplFiled expFiled : tmpl.getFiledList()) {
            String fieldNum = StringUtils.isBlank((CharSequence)expFiled.getDimFieldNum()) ? expFiled.getExtFieldNum() : expFiled.getDimFieldNum();
            IntrTmplFiled intrTmplFiled = fieldMap.get(fieldNum);
            if (intrTmplFiled == null) {
                return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b[%1$s]\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u5b57\u6bb5\u3002", (String)"IntrTmplImportExportHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getMergenode(), fieldNum);
            }
            if (!intrTmplFiled.getUnique().equals(expFiled.getUnique())) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7684\u62d3\u5c55\u7ef4\u6a21\u578b[%1$s]\u4e2d\uff0c\u5b57\u6bb5\u7f16\u7801\u4e3a[%2$s]\u7684\u5b57\u6bb5\uff0c\u662f\u5426\u552f\u4e00\u952e\u7684\u5c5e\u6027\u503c\u4e3a\uff1a%3$s\uff0c\u5bfc\u5165\u7684\u5b57\u6bb5\u5c5e\u6027\u503c\u4e3a\uff1a%4$s\uff0c\u6570\u503c\u4e0d\u4e00\u81f4\u3002", (String)"IntrTmplImportExportHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getMergenode(), fieldNum, intrTmplFiled.getUnique(), expFiled.getUnique());
            }
            if (intrTmplFiled.getRequest().equals(expFiled.getRequest())) continue;
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7684\u62d3\u5c55\u7ef4\u6a21\u578b[%1$s]\u4e2d\uff0c\u5b57\u6bb5\u7f16\u7801\u4e3a[%2$s]\u7684\u5b57\u6bb5\uff0c\u662f\u5426\u5fc5\u586b\u7684\u5c5e\u6027\u503c\u4e3a\uff1a%3$s\uff0c\u5bfc\u5165\u7684\u5b57\u6bb5\u5c5e\u6027\u503c\u4e3a\uff1a%4$s\uff0c\u6570\u503c\u4e0d\u4e00\u81f4\u3002", (String)"IntrTmplImportExportHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getMergenode(), fieldNum, intrTmplFiled.getRequest(), expFiled.getRequest());
        }
        for (IntrDimScope scope : tmpl.getDimScopeList()) {
            Object node;
            Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)scope.getDimNum());
            if (!StringUtils.isBlank((CharSequence)scope.getPropertyNum()) && !QueryServiceHelper.exists((String)"bcm_definedpropertyvalue", (QFilter[])new QFilter[]{modelQf, new QFilter("dimension", "=", (Object)dimensionId), new QFilter("number", "=", (Object)scope.getPropertyNum())})) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u4e3a[%1$s]\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u3002", (String)"IntrTmplImportExportHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), scope.getDimNum(), scope.getPropertyNum());
            }
            String string = scope.getIsfix() != false ? scope.getFixvalueNum() : scope.getMemberNum();
            if (StringUtils.isBlank((CharSequence)string)) continue;
            if (!StringUtils.isBlank((CharSequence)scope.getDimNum()) && IDNumberTreeNode.NotFoundTreeNode == (node = MemberReader.findMemberByNumber((String)modelNum, (String)scope.getDimNum(), (String)string))) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u4e3a[%1$s]\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u6210\u5458\u3002", (String)"IntrTmplImportExportHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), scope.getDimNum(), string);
            }
            if (StringUtils.isBlank((CharSequence)scope.getExtFieldNum())) continue;
            node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)DimEntityNumEnum.EXTENDS.getNumber(), (String)scope.getExtFieldNum());
            if (IDNumberTreeNode.NotFoundTreeNode == node) {
                return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u6a21\u578b[%1$s]\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u5b57\u6bb5\u3002", (String)"IntrTmplImportExportHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), tmpl.getMergenode(), scope.getExtFieldNum());
            }
            Long eunmId = IntrTmplImportExportHelper.getEunmIdByNum(modelId, scope.getExtFieldNum(), string);
            if (eunmId != null) continue;
            return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u5b57\u6bb5[%1$s]\u7684\u679a\u4e3e\u503c\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u679a\u4e3e\u3002", (String)"IntrTmplImportExportHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), scope.getExtFieldNum(), string);
        }
        String notExistProcess = PaperTmplExpImpHelper.getNotExistNumber(modelNum, PresetConstant.PROCESS_DIM, tmpl.getAdjEntrys().stream().map(IntrAdjEntry::getProcessNum).collect(Collectors.toSet()));
        if (!StringUtils.isBlank((CharSequence)notExistProcess)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a[%s]\u7684\u8fc7\u7a0b\u3002", (String)"InvTemplateHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), notExistProcess);
        }
        if (!CollectionUtils.isEmpty(tmpl.getAdjEntrys())) {
            HashMap<String, Set> memberNumMap = new HashMap<String, Set>(16);
            for (IntrAdjEntry intrAdjEntry : tmpl.getAdjEntrys()) {
                for (IntrAdjRow row : intrAdjEntry.getRowList()) {
                    String errorMsg;
                    if (!row.isExtendField(row.getAccountClassType())) {
                        memberNumMap.computeIfAbsent(PresetConstant.ACCOUNT_DIM, k -> new HashSet(16)).add(row.getAccountNumber());
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, row.getAccountNumber(), PresetConstant.ACCOUNT_DIM);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getChangeTypeClassType())) {
                        memberNumMap.computeIfAbsent(PresetConstant.CHANGETYPE_DIM, k -> new HashSet(16)).add(row.getChangTpyeNumber());
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, row.getChangTpyeNumber(), PresetConstant.CHANGETYPE_DIM);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getAudittrailClassType())) {
                        memberNumMap.computeIfAbsent(PresetConstant.AUDITTRIAL_DIM, k -> new HashSet(16)).add(row.getAudittrailNumber());
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, row.getAudittrailNumber(), PresetConstant.AUDITTRIAL_DIM);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getDatasortClassType())) {
                        memberNumMap.computeIfAbsent(PresetConstant.DATASORT_DIM, k -> new HashSet(16)).add(row.getDatasortNumber());
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, row.getDatasortNumber(), PresetConstant.DATASORT_DIM);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getMultigaapClassType())) {
                        memberNumMap.computeIfAbsent(PresetConstant.RULE_DIM, k -> new HashSet(16)).add(row.getMultigaapNumber());
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, row.getMultigaapNumber(), PresetConstant.RULE_DIM);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getDim1ClassType())) {
                        memberNumMap.computeIfAbsent((String)row.getUserdefined1Number().p1, k -> new HashSet(16)).add(row.getUserdefined1Number().p2);
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, (String)row.getUserdefined1Number().p2, (String)row.getUserdefined1Number().p1);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getDim2ClassType())) {
                        memberNumMap.computeIfAbsent((String)row.getUserdefined2Number().p1, k -> new HashSet(16)).add(row.getUserdefined2Number().p2);
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, (String)row.getUserdefined2Number().p2, (String)row.getUserdefined2Number().p1);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getDim3ClassType())) {
                        memberNumMap.computeIfAbsent((String)row.getUserdefined3Number().p1, k -> new HashSet(16)).add(row.getUserdefined3Number().p2);
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, (String)row.getUserdefined3Number().p2, (String)row.getUserdefined3Number().p1);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getDim4ClassType())) {
                        memberNumMap.computeIfAbsent((String)row.getUserdefined4Number().p1, k -> new HashSet(16)).add(row.getUserdefined4Number().p2);
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, (String)row.getUserdefined4Number().p2, (String)row.getUserdefined4Number().p1);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getDim5ClassType())) {
                        memberNumMap.computeIfAbsent((String)row.getUserdefined5Number().p1, k -> new HashSet(16)).add(row.getUserdefined5Number().p2);
                    } else {
                        errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, (String)row.getUserdefined5Number().p2, (String)row.getUserdefined5Number().p1);
                        if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                            return errorMsg;
                        }
                    }
                    if (!row.isExtendField(row.getDim6ClassType())) {
                        memberNumMap.computeIfAbsent((String)row.getUserdefined6Number().p1, k -> new HashSet(16)).add(row.getUserdefined6Number().p2);
                        continue;
                    }
                    errorMsg = IntrTmplImportExportHelper.checkLinkDimField(fieldMap, (String)row.getUserdefined6Number().p2, (String)row.getUserdefined6Number().p1);
                    if (StringUtils.isBlank((CharSequence)errorMsg)) continue;
                    return errorMsg;
                }
            }
            for (Map.Entry entry : memberNumMap.entrySet()) {
                String errorMsg;
                if (entry.getKey() == null || StringUtils.isBlank((CharSequence)(errorMsg = PaperTmplExpImpHelper.getErrorMsg(modelNum, (String)entry.getKey(), (Set)entry.getValue())))) continue;
                return errorMsg;
            }
        }
        return null;
    }

    private static String checkLinkDimField(Map<String, IntrTmplFiled> fieldMap, String extFieldNum, String dimNum) {
        if (!StringUtils.isEmpty((CharSequence)extFieldNum)) {
            IntrTmplFiled tmplFiled = fieldMap.get(extFieldNum);
            if (tmplFiled == null) {
                return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6210\u5458\u7f16\u7801%1$s\u672a\u5173\u8054%2$s\u7ef4\u5ea6\u3002", (String)"AdjSettingBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extFieldNum, dimNum);
            }
            if (!dimNum.toLowerCase(Locale.ENGLISH).equals(tmplFiled.getLinkDimNum())) {
                return String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6210\u5458\u7f16\u7801%1$s\u672a\u5173\u8054%2$s\u7ef4\u5ea6\u3002", (String)"AdjSettingBatchImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), extFieldNum, dimNum);
            }
        }
        return "";
    }

    private static Long getEunmIdByNum(long modelId, String extFieldNum, String memberNum) {
        DynamicObject eunmDyn;
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id, enumitem", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)extFieldNum)});
        if (dyn != null && (eunmDyn = QueryServiceHelper.queryOne((String)"bcm_enumvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("enumitemid", "=", (Object)dyn.getLong("enumitem")), new QFilter("enumvalue", "=", (Object)memberNum)})) != null) {
            return eunmDyn.getLong("id");
        }
        return null;
    }

    private static Map<String, IntrTmplFiled> getTmplFileMap(long extModelId) {
        DynamicObjectCollection dimFielddoc;
        HashMap<String, IntrTmplFiled> result = new HashMap<String, IntrTmplFiled>(16);
        QFilter extModelQFilter = new QFilter("extmodelid", "=", (Object)extModelId);
        DynamicObjectCollection extFielddoc = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield.number,isnecessary,uniquecheck", (QFilter[])new QFilter[]{extModelQFilter});
        if (extFielddoc != null && !extFielddoc.isEmpty()) {
            for (DynamicObject extField : extFielddoc) {
                IntrTmplFiled tmplField = new IntrTmplFiled();
                tmplField.setExtFieldNum(extField.getString("extfield.number"));
                tmplField.setUnique(extField.getBoolean("uniquecheck"));
                tmplField.setRequest(extField.getBoolean("isnecessary"));
                result.put(tmplField.getExtFieldNum(), tmplField);
            }
            DynamicObjectCollection linkDimDyns = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield.number,extfield.entryentityasso.assodim.number", (QFilter[])new QFilter[]{new QFilter("id", "in", extFielddoc.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()))});
            if (linkDimDyns != null && !linkDimDyns.isEmpty()) {
                linkDimDyns.stream().filter(e -> e.get("extfield.entryentityasso.assodim.number") != null).forEach(d -> {
                    String num = d.getString("extfield.number");
                    String dimNum = d.getString("extfield.entryentityasso.assodim.number").toLowerCase(Locale.ENGLISH);
                    IntrTmplFiled tmplFiled = (IntrTmplFiled)result.get(num);
                    if (tmplFiled != null) {
                        tmplFiled.setLinkDimNum(dimNum);
                    }
                });
            }
        }
        if ((dimFielddoc = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension.number,isnecessary,uniquecheck", (QFilter[])new QFilter[]{extModelQFilter})) != null) {
            for (DynamicObject dimField : dimFielddoc) {
                IntrTmplFiled tmplField = new IntrTmplFiled();
                tmplField.setExtFieldNum(dimField.getString("dimension.number"));
                tmplField.setUnique(dimField.getBoolean("uniquecheck"));
                tmplField.setRequest(dimField.getBoolean("isnecessary"));
                result.put(tmplField.getExtFieldNum(), tmplField);
            }
        }
        return result;
    }
}

