/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.innertrade.report;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.enumvalue.EnumItemServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.business.innertrade.model.IntrMergeParam;
import kd.fi.bcm.business.innertrade.model.IntrRow;
import kd.fi.bcm.business.innertrade.model.IntrTable;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtRateTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import org.apache.commons.collections4.CollectionUtils;

public class QueryIntrDataHelper {
    public static final int sellerType = 0;
    public static final int purchaserType = 1;
    public static final int mergenodeType = 2;

    public static IntrTable queryIntrDataConvertName(IntrMergeParam param) {
        IntrTable table = QueryIntrDataHelper.queryIntrDataByParam(param);
        if (table == null || CollectionUtils.isEmpty(table.getRows())) {
            return table;
        }
        for (IntrRow row : table.getRows()) {
            Map<String, Object> item = row.getData();
            for (IntrField field : table.getHead()) {
                if (!"F7".equals(field.getShowType())) continue;
                Object value = item.get(field.getNumber());
                item.put(field.getNumber(), QueryIntrDataHelper.getEntityInfo(param.getModelNumber(), field, value));
            }
        }
        return table;
    }

    private static Pair<Object, String> getEntityInfo(String modelNumber, IntrField field, Object value) {
        if (value == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)((String)field.getDimInfo().p2), (String)value.toString());
        return Pair.onePair((Object)value, (Object)node.getName());
    }

    public static IntrTable queryIntrDataByParam(IntrMergeParam param) {
        IntrTable intrTable = null;
        if (QueryIntrDataHelper.checkParam(param)) {
            String dataModelNum = QueryIntrDataHelper.queryDataModel(param, 2);
            List<IntrField> head = QueryIntrDataHelper.queryMergeFieldsForMerge(param.getTemplateId());
            if (head.size() > 0) {
                String currency = (String)param.getCurrency().p2;
                if (CurrencyEnum.EC.getNumber().equals(param.getCurrency().p2) || CurrencyEnum.DC.getNumber().equals(param.getCurrency().p2)) {
                    currency = OrgCurrencyServiceHelper.getCurrencyDynById((Long)param.getEntity().p1, (Long)param.getYear().p1, (Long)param.getPeriod().p1).getString("number");
                }
                DynamicObjectCollection buses = QueryIntrDataHelper.queryMergeData((String)param.getModel().p2, dataModelNum, (String)param.getEntity().p2, (String)param.getScenario().p2, (String)param.getYear().p2, (String)param.getPeriod().p2, currency);
                intrTable = new IntrTable(head, buses);
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u6709\u8bef\uff1a%s\u3002", (String)"QueryIntrDataService_01", (String)"fi-bcm-business", (Object[])new Object[0]), param));
        }
        return intrTable;
    }

    public static DynamicObjectCollection querySellerOrBuyerData(String modelNum, String dataModelNum, String scenarioNum, String yearNum, String periodNum, String currencyNum, Set<String> orgNums) {
        QFBuilder qb = new QFBuilder();
        qb.add("modelnumber", "=", (Object)modelNum);
        qb.add("datamodel", "=", (Object)dataModelNum);
        qb.add("scenario", "=", (Object)scenarioNum);
        qb.add("year", "=", (Object)yearNum);
        qb.add("period", "=", (Object)periodNum);
        qb.add("currency", "=", (Object)currencyNum);
        qb.add(IntrConstant.FIELD_ORG_NUMBER, "in", orgNums);
        qb.add(IntrConstant.FIELD_IC_NUMBER, "in", orgNums);
        qb.add("extendsgroup", "=", (Object)IntrReportHelper.getGroupNumByModelNum((long)MemberReader.findModelIdByShowNum((String)modelNum), dataModelNum));
        qb.add("process", "in", (Object)IntrConstant.SELLER_BUYER_DATA_PROCESS);
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_extenddata_bus").getAllFields().keySet();
        return QueryServiceHelper.query((String)"bcm_extenddata_bus", (String)("id," + String.join((CharSequence)",", fields)), (QFilter[])qb.toArray());
    }

    public static DynamicObjectCollection queryMergeData(String modelNum, String dataModelNum, String entityNum, String scenarioNum, String yearNum, String periodNum, String currencyNum) {
        return QueryIntrDataHelper.queryMergeData(modelNum, dataModelNum, entityNum, scenarioNum, yearNum, periodNum, currencyNum, null);
    }

    public static DynamicObjectCollection queryMergeData(String modelNum, String dataModelNum, String entityNum, String scenarioNum, String yearNum, String periodNum, String currencyNum, Set<Long> notInIds) {
        QFBuilder qb = new QFBuilder();
        qb.add("modelnumber", "=", (Object)modelNum);
        qb.add("datamodel", "=", (Object)dataModelNum);
        qb.add("org", "=", (Object)entityNum);
        qb.add("scenario", "=", (Object)scenarioNum);
        qb.add("year", "=", (Object)yearNum);
        qb.add("period", "=", (Object)periodNum);
        qb.add("currency", "=", (Object)currencyNum);
        qb.add("extendsgroup", "=", (Object)IntrReportHelper.getGroupNumByModelNum((long)MemberReader.findModelIdByShowNum((String)modelNum), dataModelNum));
        qb.add("process", "=", (Object)"ADJ");
        qb.add("audittrail", "=", (Object)"EntityInput");
        if (!CollectionUtils.isEmpty(notInIds)) {
            qb.add("id", "not in", notInIds);
        }
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_extenddata_bus").getAllFields().keySet();
        return QueryServiceHelper.query((String)"bcm_extenddata_bus", (String)("id," + String.join((CharSequence)",", fields)), (QFilter[])qb.toArray(), (String)"sid asc, id asc");
    }

    public static List<IntrField> querySellerFields(Long templateId) {
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,seller.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        return QueryIntrDataHelper.queryBuyerOrSellerFields(template.getLong("seller.id"));
    }

    public static List<IntrField> queryBuyerFields(Long templateId) {
        DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,purchaser.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        return QueryIntrDataHelper.queryBuyerOrSellerFields(template.getLong("purchaser.id"));
    }

    public static List<IntrField> queryBuyerOrSellerFields(Long extModleId) {
        ArrayList<IntrField> result = new ArrayList<IntrField>(16);
        result.addAll(IntrField.getCommonField());
        if (extModleId == null || extModleId.equals(0L)) {
            return result;
        }
        DynamicObjectCollection extFieldDocs = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id,extfield.id", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)extModleId)});
        Set<Long> extFieldIds = extFieldDocs.stream().map(item -> item.getLong("extfield.id")).collect(Collectors.toSet());
        result.addAll(QueryIntrDataHelper.queryIntrFieldByIds("ext", extFieldIds));
        DynamicObjectCollection dimFieldDocs = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"id,dimension.id", (QFilter[])new QFilter[]{new QFilter("extmodelid", "=", (Object)extModleId)});
        Set<Long> dimFieldIds = dimFieldDocs.stream().map(item -> item.getLong("dimension.id")).collect(Collectors.toSet());
        result.addAll(QueryIntrDataHelper.queryIntrFieldByIds("dim", dimFieldIds));
        return result;
    }

    public static List<IntrField> queryMergeFieldsForCsl(Long templateId) {
        List<IntrField> result = QueryIntrDataHelper.queryMergeFields(templateId);
        for (IntrField intrField : result) {
            if (StringUtils.isBlank((CharSequence)intrField.getFormula())) {
                intrField.setReadOnly(Boolean.FALSE);
                continue;
            }
            intrField.setReadOnly(Boolean.TRUE);
        }
        return result;
    }

    public static List<IntrField> queryMergeFieldsForMerge(Long templateId) {
        List<IntrField> result = QueryIntrDataHelper.queryMergeFields(templateId);
        for (IntrField field : result) {
            if (!field.isJoinKey() && StringUtils.isBlank((CharSequence)field.getFormula()) && !"INTR_000".equals(field.getNumber()) && !"INTR_001".equals(field.getNumber())) continue;
            field.setReadOnly(true);
        }
        return result;
    }

    public static List<IntrField> queryMergeFields(Long templateId) {
        ArrayList<IntrField> result = new ArrayList<IntrField>(16);
        String selectFields = "id,model.id,seller.id,purchaser.id,papertemplatefield.extmodelfield.extfield.id,papertemplatefield.dimmodelfield.dimension.id,papertemplatefield.extmodelfield.isnecessary,papertemplatefield.extmodelfield.uniquecheck,papertemplatefield.dimmodelfield.isnecessary,papertemplatefield.dimmodelfield.uniquecheck,papertemplatefield.formula,papertemplatefield.executeseq,papertemplatefield.ismerge";
        DynamicObjectCollection mergeFieldList = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)}, (String)"papertemplatefield.seq asc");
        if (CollectionUtils.isEmpty((Collection)mergeFieldList)) {
            return result;
        }
        long modelId = ((DynamicObject)mergeFieldList.get(0)).getLong("model.id");
        List<IntrField> commonFields = IntrField.getCommonField();
        commonFields.forEach(e -> IntrReportHelper.getAndInitDimInfo(modelId, e));
        result.addAll(commonFields);
        Set<Long> extFieldIds = mergeFieldList.stream().map(item -> item.getLong("papertemplatefield.extmodelfield.extfield.id")).filter(e -> e != 0L).collect(Collectors.toSet());
        Map<Long, IntrField> extFieldMap = QueryIntrDataHelper.queryIntrFieldByIds("ext", extFieldIds).stream().collect(Collectors.toMap(IntrField::getId, item -> item));
        Set<Long> dimFieldIds = mergeFieldList.stream().map(item -> item.getLong("papertemplatefield.dimmodelfield.dimension.id")).filter(e -> e != 0L).collect(Collectors.toSet());
        Map<Long, IntrField> dimFieldMap = QueryIntrDataHelper.queryIntrFieldByIds("dim", dimFieldIds).stream().collect(Collectors.toMap(IntrField::getId, item -> item));
        for (DynamicObject doc : mergeFieldList) {
            boolean isExtField = Boolean.TRUE;
            IntrField field = extFieldMap.get(doc.getLong("papertemplatefield.extmodelfield.extfield.id"));
            if (field == null) {
                field = dimFieldMap.get(doc.getLong("papertemplatefield.dimmodelfield.dimension.id"));
                isExtField = Boolean.FALSE;
            }
            if (field == null) continue;
            field.setFormula(doc.getString("papertemplatefield.formula"));
            field.setFormulaSeq(doc.getInt("papertemplatefield.executeseq"));
            field.setJoinKey(doc.getBoolean("papertemplatefield.ismerge"));
            if (isExtField) {
                field.setRequired(doc.getBoolean("papertemplatefield.extmodelfield.isnecessary"));
                field.setUnique(doc.getBoolean("papertemplatefield.extmodelfield.uniquecheck"));
            } else {
                field.setRequired(doc.getBoolean("papertemplatefield.dimmodelfield.isnecessary"));
                field.setUnique(doc.getBoolean("papertemplatefield.dimmodelfield.uniquecheck"));
            }
            result.add(field);
        }
        return result;
    }

    public static List<IntrField> queryIntrFieldByIds(String fieldType, Set<Long> fieldIds) {
        ArrayList<IntrField> result;
        block6: {
            String selectFields;
            DynamicObjectCollection fields;
            block5: {
                result = new ArrayList<IntrField>(16);
                if (CollectionUtils.isEmpty(fieldIds)) {
                    return result;
                }
                if (!"ext".equals(fieldType)) break block5;
                String selectFields2 = "id,number,name,fieldmapped,datatype,exchange,enumitem.id,model.id";
                DynamicObjectCollection fields2 = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectFields2, (QFilter[])new QFilter[]{new QFilter("id", "in", fieldIds)});
                if (fields2 == null || fields2.isEmpty()) break block6;
                long modelId = ((DynamicObject)fields2.get(0)).getLong("model.id");
                Map<Long, MultiF7Results> linkDimMap = ExtDataUtil.getMultiF7ValueByExtMemIds(new ArrayList<Long>(fieldIds), modelId);
                for (DynamicObject fieldDyn : fields2) {
                    IntrField field = QueryIntrDataHelper.convertExtField(fieldDyn);
                    MultiF7Results link = linkDimMap.get(field.getId());
                    if (link != null) {
                        field.setShowType("F7");
                        field.setLinkDim(true);
                        DynamicObject dimDy = link.getDimDy();
                        field.setDimInfo((Tuple<Long, String, String>)Tuple.create((Object)dimDy.getLong("id"), (Object)dimDy.getString("number"), (Object)dimDy.getString("membermodel")));
                    }
                    result.add(field);
                }
                break block6;
            }
            if ("dim".equals(fieldType) && (fields = QueryServiceHelper.query((String)"bcm_dimension", (String)(selectFields = "id,number,name,fieldmapped,membermodel"), (QFilter[])new QFilter[]{new QFilter("id", "in", fieldIds)})) != null && !fields.isEmpty()) {
                for (DynamicObject fieldDyn : fields) {
                    if (DimTypesEnum.INTERCOMPANY.getNumber().equals(fieldDyn.getString("number"))) continue;
                    IntrField field = QueryIntrDataHelper.convertDimField(fieldDyn);
                    field.setDimInfo((Tuple<Long, String, String>)Tuple.create((Object)fieldDyn.getLong("id"), (Object)fieldDyn.getString("number"), (Object)fieldDyn.getString("membermodel")));
                    result.add(field);
                }
            }
        }
        return result;
    }

    public static List<IntrField> queryExtFieldByNumbers(Long modelId, Set<String> fieldNums) {
        ArrayList<IntrField> result = new ArrayList<IntrField>(16);
        String selectFields = "id,number,name,fieldmapped,datatype,exchange,enumitem.id";
        DynamicObjectCollection fileds = QueryServiceHelper.query((String)"bcm_structofextend", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("number", "in", fieldNums), new QFilter("model", "=", (Object)modelId)});
        if (fileds != null && !fileds.isEmpty()) {
            for (DynamicObject filed : fileds) {
                result.add(QueryIntrDataHelper.convertExtField(filed));
            }
        }
        return result;
    }

    private static String queryDataModel(IntrMergeParam param, int type) {
        QFilter qFilter = new QFilter("model", "=", param.getModel().p1);
        qFilter.and("id", "=", (Object)param.getTemplateId());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"id,seller.number,purchaser.number,mergenode.number", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            return type == 0 ? dynamicObject.getString("seller.number") : (type == 1 ? dynamicObject.getString("purchaser.number") : dynamicObject.getString("mergenode.number"));
        }
        return null;
    }

    private static IntrField convertExtField(DynamicObject field) {
        DynamicObjectCollection enumItems;
        List<Object> enumList = null;
        String eunmDataType = null;
        if (field.getLong("enumitem.id") != 0L && (enumItems = EnumItemServiceHelper.queryEnumValue(Sets.newHashSet((Object[])new Long[]{field.getLong("enumitem.id")}))) != null && !enumItems.isEmpty()) {
            enumList = enumItems.stream().map(item -> item.get("enumvalue")).collect(Collectors.toList());
            eunmDataType = ((DynamicObject)enumItems.get(0)).getString("datatype");
        }
        IntrField intrField = new IntrField(field.getLong("id"), field.getString("number"), field.getString("name"), "ext", field.getString("fieldmapped"), field.getString("datatype"), enumList, eunmDataType, field.getString("exchange"), enumList == null ? null : "eunm");
        return intrField;
    }

    private static IntrField convertDimField(DynamicObject field) {
        String fieldmapped = field.getString("fieldmapped");
        if (StringUtils.isEmpty((CharSequence)fieldmapped)) {
            fieldmapped = field.getString("number").toLowerCase(Locale.ENGLISH);
        }
        IntrField intrField = new IntrField(field.getLong("id"), field.getString("number"), field.getString("name"), "dim", fieldmapped, DataTypeEnum.TXT.getOIndex(), null, null, ExtRateTypeEnum.NUM.index, "F7");
        return intrField;
    }

    private static boolean checkParam(IntrMergeParam param) {
        return param != null && param.getEntity() != null && param.getCurrency() != null && param.getModel() != null && param.getPeriod() != null && param.getYear() != null && param.getScenario() != null && param.getTemplateId() != null;
    }

    public static DynamicObject queryRowDataByCellValue(IntrMergeParam param, List<Cell> row, Map<String, Integer> fieldIndexMap) {
        block9: {
            if (QueryIntrDataHelper.checkParam(param)) {
                try {
                    String dataModelNum = QueryIntrDataHelper.queryDataModel(param, 2);
                    List<IntrField> heads = QueryIntrDataHelper.queryMergeFieldsForMerge(param.getTemplateId());
                    DynamicObject template = IntrTemplateHelper.getTemplateInfo((Long)param.getModel().p1, param.getTemplateId());
                    List<IntrField> uniqueFileds = IntrReportHelper.getUniqueFields(heads, template.getString("usage"));
                    if (CollectionUtils.isNotEmpty(uniqueFileds)) {
                        String currency = (String)param.getCurrency().p2;
                        if (CurrencyEnum.EC.getNumber().equals(param.getCurrency().p2) || CurrencyEnum.DC.getNumber().equals(param.getCurrency().p2)) {
                            currency = OrgCurrencyServiceHelper.getCurrencyDynById((Long)param.getEntity().p1, (Long)param.getYear().p1, (Long)param.getPeriod().p1).getString("number");
                        }
                        QFBuilder qb = new QFBuilder();
                        qb.add("modelnumber", "=", param.getModel().p2);
                        qb.add("datamodel", "=", (Object)dataModelNum);
                        qb.add("org", "=", param.getEntity().p2);
                        qb.add("scenario", "=", param.getScenario().p2);
                        qb.add("year", "=", param.getYear().p2);
                        qb.add("period", "=", param.getPeriod().p2);
                        qb.add("currency", "=", (Object)currency);
                        qb.add("extendsgroup", "=", (Object)IntrReportHelper.getGroupNumByModelNum((long)((Long)param.getModel().p1), dataModelNum));
                        for (IntrField uniqueFiled : uniqueFileds) {
                            Cell cell = row.get(fieldIndexMap.get(uniqueFiled.getNumber()));
                            if (cell.getValue() == null || !IntrConstant.DB_DIGITAL_DATA_TYPE.contains(uniqueFiled.getDataType()) && StringUtils.isEmpty((CharSequence)cell.getValue().toString())) continue;
                            if ("F7".equals(uniqueFiled.getShowType())) {
                                qb.add(uniqueFiled.getBoundField(), "=", cell.getUserObject("number"));
                                continue;
                            }
                            if (IntrConstant.DB_DIGITAL_DATA_TYPE.contains(uniqueFiled.getDataType()) && cell.getValue() instanceof BigDecimal) {
                                qb.add(uniqueFiled.getBoundField(), "=", cell.getValue());
                                continue;
                            }
                            if (DataTypeEnum.DATETP.getOIndex().equals(uniqueFiled.getDataType())) {
                                qb.add(uniqueFiled.getBoundField(), "=", (Object)DateTimeUtils.parseStrDate((String)cell.getValue().toString()));
                                continue;
                            }
                            qb.add(uniqueFiled.getBoundField(), "=", (Object)cell.getValue().toString());
                        }
                        return QueryServiceHelper.queryOne((String)"bcm_extenddata_bus", (String)"id", (QFilter[])qb.toArray());
                    }
                    break block9;
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s\u3002", (String)"QueryIntrDataService_02", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
                }
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u6709\u8bef\uff1a%s\u3002", (String)"QueryIntrDataService_01", (String)"fi-bcm-business", (Object[])new Object[0]), param));
        }
        return null;
    }

    public static Boolean isExistIntrData(IntrMergeParam param) {
        String currency = (String)param.getCurrency().p2;
        if (CurrencyEnum.EC.getNumber().equals(param.getCurrency().p2) || CurrencyEnum.DC.getNumber().equals(param.getCurrency().p2)) {
            currency = OrgCurrencyServiceHelper.getCurrencyDynById((Long)param.getEntity().p1, (Long)param.getYear().p1, (Long)param.getPeriod().p1).getString("number");
        }
        String dataModelNum = QueryIntrDataHelper.queryDataModel(param, 2);
        QFBuilder qb = new QFBuilder();
        qb.add("modelnumber", "=", param.getModel().p2);
        qb.add("datamodel", "=", (Object)dataModelNum);
        qb.add("org", "=", param.getEntity().p2);
        qb.add("scenario", "=", param.getScenario().p2);
        qb.add("year", "=", param.getYear().p2);
        qb.add("period", "=", param.getPeriod().p2);
        qb.add("currency", "=", (Object)currency);
        qb.add("extendsgroup", "=", (Object)IntrReportHelper.getGroupNumByModelNum((long)((Long)param.getModel().p1), dataModelNum));
        qb.add("process", "=", (Object)"ADJ");
        qb.add("audittrail", "=", (Object)"EntityInput");
        return QueryServiceHelper.exists((String)"bcm_extenddata_bus", (QFilter[])qb.toArray());
    }
}

