/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.fi.bcm.business.integration.IIntegrationService;
import kd.fi.bcm.business.integration.collector.CollectorFactory;
import kd.fi.bcm.business.integration.collector.ICollector;
import kd.fi.bcm.business.integration.converter.ConverterFactory;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.OlapCommandUtil;

public class IntegrationService
implements IIntegrationService {
    private IIntegrationContext ctx;
    private List<ICollector> chain;
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public IntegrationService(IIntegrationContext ctx) {
        this.ctx = ctx;
    }

    public void beforeExecute() {
        this.ctx.setMappingModel(ConverterFactory.getConverter(this.ctx).convert(this.ctx));
        this.chain = new ArrayList<ICollector>();
        this.chain.add(CollectorFactory.getCollector(this.ctx));
    }

    @Override
    public Object execute() {
        this.log.startWatch();
        this.beforeExecute();
        this.log.warn("--beforeExecute--MappingModel:" + this.ctx.getMappingModel());
        Object data = this.doExecute();
        this.log.warn("--doExecute--:" + data);
        this.afterExecute();
        this.log.warn("--afterExecute--");
        return data;
    }

    public void afterExecute() {
    }

    private Object doExecute() {
        switch (this.ctx.getAdapter()) {
            case EASCSL2IERP: {
                return this.executePull();
            }
            case IERP2EASCSL: {
                return this.executePush();
            }
        }
        return null;
    }

    private Object executePull() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.chain.forEach(e -> data.putAll(e.collect()));
        try (TXHandle tx = TX.required();){
            try {
                this.doSaveOlap(this.ctx, data);
            }
            catch (Exception e2) {
                tx.markRollback();
                throw new KDBizException(e2.toString());
            }
        }
        return data;
    }

    private Object executePush() {
        return this.chain.get(0).collect2();
    }

    private void doSaveOlap(IIntegrationContext ctx, Map<String, Object> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        SaveCommandInfo info = new SaveCommandInfo();
        OlapCommandUtil.addSourceMeasure((String)((String)ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.I1);
        info.setMeasures(new String[]{measure});
        info.setDimensions(ctx.getDimAll().toArray(new String[0]));
        CellSet cellSets = new CellSet(ctx.getDimAll().toArray(new String[0]), new String[]{measure});
        data.forEach((k, v) -> cellSets.set(k.split("&"), measure, v));
        OlapServiceHelper.saveData(info, cellSets, (String)ctx.getModel().p2, false);
    }
}

