/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.IntegrationParam;
import kd.fi.bcm.business.integration.IntegrationService;
import kd.fi.bcm.business.integration.converter.SchemeConverter;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.Integration2EasContext;
import kd.fi.bcm.business.integration.model.IntegrationContext;
import kd.fi.bcm.business.integration.model.RelationModel;
import kd.fi.bcm.business.integration.util.IntegrationUtil;
import kd.fi.bcm.business.integration.util.SyncServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.integration.AdapterEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class IntegrationServiceHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(IntegrationServiceHelper.class);

    public static Object execute(Map<String, Object> param) {
        log.startWatch();
        IIntegrationContext ctx = null;
        try {
            ctx = IntegrationServiceHelper.getContext(param);
            IntegrationServiceHelper.executeBefore(ctx);
            Object result = new IntegrationService(ctx).execute();
            IntegrationServiceHelper.executeAfter(ctx);
            log.warn("--execute--");
            return result;
        }
        catch (Throwable e) {
            log.error("--execute--\n" + ThrowableHelper.toString((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object executeAsync(IIntegrationContext ctx) {
        log.startWatch();
        if ("EAS".equals(ctx.getSrcsys().p3) && AdapterEnum.EASGL2IERP == ctx.getAdapter()) {
            HashMap<String, Object> syncParam = new HashMap<String, Object>();
            syncParam.put("schemes", IntegrationServiceHelper.getSyncScheme(ctx));
            syncParam.put("filter", IntegrationServiceHelper.getSyncFilter(ctx));
            List<Map<String, Object>> exeObjects = SyncServiceHelper.copyToDsAsync(syncParam);
            log.warn("--syncParam--:" + syncParam);
            if (exeObjects == null || exeObjects.isEmpty()) throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002", (String)"IntegrationServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            Map<String, Object> copyReturnData = exeObjects.get(exeObjects.size() - 1);
            if (!Boolean.TRUE.equals(copyReturnData.get("success"))) throw new KDBizException(copyReturnData.get("msg").toString());
            String exeNumber = copyReturnData.get("execution_number").toString();
            DynamicObject exeObj = QueryServiceHelper.queryOne((String)"isc_data_copy_execution", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)exeNumber)});
            if (exeObj != null) {
                try {
                    IntegrationServiceHelper.updateExeRec(ctx, exeObj.getLong("id"), JSONUtils.toString(ctx.getParam().getCustomParam()));
                }
                catch (IOException e1) {
                    throw new KDBizException(e1.getMessage());
                }
            }
        }
        log.warn("--executeAsync--");
        return null;
    }

    private static IIntegrationContext getContext(Map<String, Object> param) {
        if (param == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"IntegrationServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (Boolean.TRUE.equals(param.get("isMsCall"))) {
            if (Boolean.TRUE.equals(param.get("success"))) {
                param = IntegrationServiceHelper.loadParam(param);
            } else {
                throw new KDBizException(param.get("msg").toString());
            }
        }
        if (param.get("adapter") == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u53c2\u6570\u201c%s\u201d\u3002", (String)"IntegrationServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), "adapter"));
        }
        switch ((AdapterEnum)param.get("adapter")) {
            case EASGL2IERP: {
                return new IntegrationContext(new IntegrationParam(param));
            }
            case EASCSL2IERP: {
                return new IntegrationContext(new IntegrationParam(param));
            }
            case IERP2EASCSL: {
                return new Integration2EasContext(param);
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u6e90\u7cfb\u7edf\u7c7b\u578b\u4e3a[%s]\u7684\u5b9e\u73b0\u3002", (String)"IntegrationServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), param.get("adapter")));
    }

    private static void executeAfter(IIntegrationContext ctx) {
        Object[] dos;
        if (AdapterEnum.EASGL2IERP != ctx.getParam().getCustomParam().get("adapter")) {
            return;
        }
        String selectFields = "id, collectstatus";
        QFilter[] filters = IntegrationServiceHelper.getRecQFilter(ctx);
        for (DynamicObject dynamicObject : dos = BusinessDataServiceHelper.load((String)"bcm_schemeexecuterec", (String)selectFields, (QFilter[])filters)) {
            dynamicObject.set("collectstatus", (Object)CollectStatusEnum.SUCCESS.getValue());
        }
        if (dos.length > 0) {
            SaveServiceHelper.save((IDataEntityType)dos[0].getDynamicObjectType(), (Object[])dos);
        }
    }

    public static QFilter[] getRecQFilter(IIntegrationContext ctx) {
        QFBuilder filters = new QFBuilder();
        filters.add("model", "=", ctx.getModel().p1);
        filters.add("scheme", "=", ctx.getScheme().p1);
        filters.add("fy", "=", ctx.getYear().p1);
        filters.add("period", "=", ctx.getPeriod().p1);
        filters.add("currency", "=", ctx.getCurrency().p1);
        filters.add("org.number", "in", ctx.getOrgNumbers());
        return filters.toArray();
    }

    private static void executeBefore(IIntegrationContext ctx) {
        if (ctx.getParam().getCustomParam() != null && !Boolean.TRUE.equals(ctx.getParam().getCustomParam().get("isMsCall")) && AdapterEnum.EASGL2IERP == ctx.getParam().getCustomParam().get("adapter")) {
            IntegrationServiceHelper.updateExeRec(ctx, 0L, " ");
        }
    }

    private static void updateExeRec(IIntegrationContext ctx, Long copyexeid, String paramjson) {
        DynamicObject recObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_schemeexecuterec");
        List<Pair<Long, String>> orgs = ctx.getParam().getOrgs();
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        DynamicObject[] existCol = BusinessDataServiceHelper.load((String)"bcm_schemeexecuterec", (String)"id, org.id, org.number, collectstatus, modifydate, modifier, copyexe, paramjson", (QFilter[])IntegrationServiceHelper.getRecQFilter(ctx));
        HashMap<String, DynamicObject> orgIdMap = new HashMap<String, DynamicObject>();
        if (existCol != null) {
            for (DynamicObject e2 : existCol) {
                orgIdMap.put(e2.getString("org.number"), e2);
            }
        }
        orgs.forEach(e -> {
            Date currentDate = IntegrationServiceHelper.getCurrentDate();
            if (orgIdMap.get(e.p2) != null) {
                DynamicObject dynaObj = (DynamicObject)orgIdMap.get(e.p2);
                dynaObj.set("modifier", (Object)RequestContext.get().getUserId());
                dynaObj.set("collectstatus", (Object)CollectStatusEnum.READY.getValue());
                dynaObj.set("copyexe", (Object)copyexeid);
                dynaObj.set("modifydate", (Object)currentDate);
                dynaObj.set("paramjson", (Object)paramjson);
                updateList.add(dynaObj);
            } else {
                DynamicObject dynaObj = new DynamicObject(recObj.getDynamicObjectType());
                dynaObj.set("id", orgIdMap.get(e.p2));
                dynaObj.set("model", ctx.getModel().p1);
                dynaObj.set("scheme", ctx.getScheme().p1);
                dynaObj.set("org", e.p1);
                dynaObj.set("collectstatus", (Object)CollectStatusEnum.READY.getValue());
                dynaObj.set("modifier", (Object)RequestContext.get().getUserId());
                dynaObj.set("modifydate", (Object)currentDate);
                dynaObj.set("scenario", ctx.getScene().p1);
                dynaObj.set("fy", ctx.getYear().p1);
                dynaObj.set("period", ctx.getPeriod().p1);
                dynaObj.set("currency", ctx.getCurrency().p1);
                dynaObj.set("copyexe", (Object)copyexeid);
                dynaObj.set("paramjson", (Object)paramjson);
                insertList.add(dynaObj);
            }
        });
        try (TXHandle tx = TX.required();){
            try {
                if (insertList.size() > 0) {
                    SaveServiceHelper.save((IDataEntityType)recObj.getDynamicObjectType(), (Object[])insertList.toArray(new Object[0]));
                }
                if (updateList.size() > 0 && existCol != null && existCol.length > 0) {
                    SaveServiceHelper.save((IDataEntityType)existCol[0].getDataEntityType(), (Object[])updateList.toArray(new Object[0]));
                }
            }
            catch (Exception e3) {
                tx.markRollback();
                throw new KDBizException(e3.toString());
            }
        }
    }

    public static Object syncBaseData(Map<String, Object> syncParam) {
        if (!syncParam.containsKey("srcsystype")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u6765\u6e90\u7cfb\u7edf\u7c7b\u578b\u53c2\u6570\uff1a%s\u3002", (String)"IntegrationServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), "srcsystype"));
        }
        if ("EAS".equals(syncParam.get("srcsystype"))) {
            if (syncParam.get("schemes") != null) {
                syncParam.put("schemes", syncParam.get("schemes"));
            } else {
                syncParam.put("schemes", SyncServiceHelper.getEASBDCopySchemes());
            }
            SyncServiceHelper.syncToDs(syncParam);
            SyncServiceHelper.syncPreset2Ds(syncParam);
            return null;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u6765\u6e90\u7cfb\u7edf\u7c7b\u578b\u4e3a%s\u7684\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6cd5\u3002", (String)"IntegrationServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), syncParam.get("srcsystype")));
    }

    private static List<String> getSyncScheme(IIntegrationContext ctx) {
        ArrayList<String> schemes = new ArrayList<String>();
        schemes.add("T_DS_ACCOUNTBALANCE");
        schemes.add("T_DS_ASSISTBALANCE");
        return schemes;
    }

    private static Map<String, Object> getSyncFilter(IIntegrationContext ctx) {
        SchemeConverter converter = new SchemeConverter();
        List<RelationModel> relations = converter.queryMemberMapping(ctx);
        if (relations.isEmpty()) {
            return null;
        }
        List<String> orgs = IntegrationUtil.batchQuerySrc(ctx, PresetConstant.ENTITY_DIM, relations);
        if (orgs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u6620\u5c04\u3002", (String)"IntegrationServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("period", IntegrationServiceHelper.getFiscalPeriod(ctx));
        filter.put("orgunit", orgs.size() > 20 ? "*" : orgs);
        return filter;
    }

    private static String getFiscalPeriod(IIntegrationContext ctx) {
        String year = (String)ctx.getYear().p2;
        String period = (String)ctx.getPeriod().p2;
        if (period.startsWith("M_M")) {
            period = period.replace("M_M", "");
        } else if ("Q_Q1".equals(period)) {
            period = "03";
        } else if ("Q_Q2".equals(period) || "HF_HF1".equals(period)) {
            period = "06";
        } else if ("Q_Q3".equals(period)) {
            period = "09";
        } else if ("Q_Q4".equals(period) || "HF_HF2".equals(period)) {
            period = "12";
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u671f\u95f4\u7c7b\u578b\u7684\u91c7\u96c6\uff1a%s\u3002", (String)"IntegrationServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), period));
        }
        return year.substring(2) + period;
    }

    private static Date getCurrentDate() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    private static Map<String, Object> loadParam(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(param);
        String exeNumber = ((DynamicObject)param.get("data")).getString("number");
        if (StringUtils.isEmpty((String)exeNumber)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u8c03\u7528\u96c6\u6210\u63a5\u53e3\uff0c\u53c2\u6570\u201c%s\u201d\u4e2d\u672a\u5b9a\u4e49\u3002", (String)"IntegrationServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), "exeNumber"));
        }
        QFBuilder builder = new QFBuilder();
        builder.add("copyexe.number", "=", (Object)exeNumber);
        DynamicObject dynaObj = QueryServiceHelper.queryOne((String)"bcm_schemeexecuterec", (String)"collectstatus, paramjson", (QFilter[])builder.toArray());
        if (dynaObj != null) {
            CollectStatusEnum status = CollectStatusEnum.getEnum((Integer)dynaObj.getInt("collectstatus"));
            switch (status) {
                case READY: {
                    String p = dynaObj.getString("paramjson");
                    try {
                        Map newP = (Map)JSONUtils.cast((String)p, Map.class);
                        result.putAll(newP);
                        result.put("isMsCall", Boolean.TRUE);
                        result.put("adapter", AdapterEnum.EASGL2IERP);
                        break;
                    }
                    catch (IOException e) {
                        throw new KDBizException(String.format("cast [%s] to Map error", p));
                    }
                }
                case RUNNING: {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u6b63\u5728\u6267\u884c", (String)"IntegrationServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]));
                }
                case SUCCESS: {
                    String p2 = dynaObj.getString("paramjson");
                    try {
                        Map newP = (Map)JSONUtils.cast((String)p2, Map.class);
                        result.putAll(newP);
                        result.put("isMsCall", Boolean.TRUE);
                        result.put("adapter", AdapterEnum.EASGL2IERP);
                        break;
                    }
                    catch (IOException e) {
                        throw new KDBizException(String.format("cast [%s] to Map error", p2));
                    }
                }
                default: {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u6267\u884c\u5931\u8d25", (String)"IntegrationServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]), new Object[0]));
                }
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d:\u65e0\u91c7\u96c6\u72b6\u6001\u4e3a\u201c%2$s\u201d\u7684\u96c6\u6210\u65b9\u6848\u6570\u636e\u91c7\u96c6\u6267\u884c\u8bb0\u5f55\u3002", (String)"IntegrationServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]), IntegrationServiceHelper.class.getName(), CollectStatusEnum.READY.getName()));
        }
        return result;
    }

    public static void writeLog(Map<String, Object> param) {
        List data = (List)param.get("data");
        IntegrationServiceHelper.check(data);
        IntegrationServiceHelper.doWriteLog(data);
    }

    private static void doWriteLog(List<Map<String, String>> data) {
        ArrayList<DynamicObject> waitSaveDyn = new ArrayList<DynamicObject>(data.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
        for (Map<String, String> temp : data) {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_iseventlog");
            newDynamicObject.set("tracecode", (Object)temp.get("tracecode"));
            newDynamicObject.set("name", (Object)temp.get("name"));
            newDynamicObject.set("source", (Object)temp.get("source"));
            newDynamicObject.set("details", (Object)temp.get("details"));
            newDynamicObject.set("result", (Object)temp.get("result"));
            try {
                newDynamicObject.set("starttime", (Object)sdf.parse(temp.get("starttime")));
                newDynamicObject.set("endtime", (Object)sdf.parse(temp.get("endtime")));
            }
            catch (ParseException e) {
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
            waitSaveDyn.add(newDynamicObject);
        }
        if (waitSaveDyn.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])waitSaveDyn.toArray(new DynamicObject[waitSaveDyn.size()]));
        }
    }

    private static void check(List<Map<String, String>> data) {
        if (data == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u65e5\u5fd7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntegrationServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        int index = 1;
        StringBuilder sBuilder = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
        ArrayList<String> field = null;
        for (Map<String, String> temp : data) {
            field = new ArrayList<String>();
            String dataStartError = "";
            String dataEndError = "";
            if (temp.get("tracecode") == null) {
                field.add("tracecode");
            }
            if (temp.get("name") == null) {
                field.add("name");
            }
            if (temp.get("source") == null) {
                field.add("source");
            }
            if (temp.get("details") == null) {
                field.add("details");
            }
            if (temp.get("result") == null) {
                field.add("result");
            }
            if (temp.get("starttime") == null) {
                field.add("starttime");
            } else {
                try {
                    sdf.parse(temp.get("starttime"));
                }
                catch (ParseException e) {
                    dataStartError = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0cstarttime \u65e5\u671f\u683c\u5f0f\u4e0d\u89c4\u8303\uff08yyyy-MM-dd HH:mm:ss.SS\uff09\uff1b", (String)"IntegrationServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), index);
                }
            }
            if (temp.get("endtime") == null) {
                field.add("endtime");
            } else {
                try {
                    sdf.parse(temp.get("endtime"));
                }
                catch (ParseException e) {
                    dataEndError = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0cendtime \u65e5\u671f\u683c\u5f0f\u4e0d\u89c4\u8303\uff08yyyy-MM-dd HH:mm:ss.SS\uff09\uff1b", (String)"IntegrationServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]), index);
                }
            }
            if (field.size() > 0) {
                sBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0c%s \u5b57\u6bb5\u7f3a\u5931\uff1b", (String)"IntegrationServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]), index, field));
            }
            sBuilder.append(dataStartError);
            sBuilder.append(dataEndError);
            ++index;
        }
        if (sBuilder.length() > 0) {
            throw new IllegalArgumentException(sBuilder.toString());
        }
    }

    public static void main(String[] args) {
        HashMap<String, Object> mockData = new HashMap<String, Object>();
        ArrayList dataList = new ArrayList(2);
        for (int i = 0; i < 2; ++i) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("tracecode", "test02" + i);
            dataMap.put("name", "test02" + i);
            dataMap.put("source", "EIP");
            dataMap.put("details", "test02" + i);
            dataMap.put("result", "0");
            dataMap.put("starttime", "2019-01-12 10:11:22.572");
            dataMap.put("endtime", "2019-01-12 10:11:22.576");
            dataList.add(dataMap);
        }
        mockData.put("data", dataList);
        JSONObject.toJSONString(mockData);
        IntegrationServiceHelper.writeLog(mockData);
    }
}

