/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.collector;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.collector.AbstractCollector;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.MappingModel;
import kd.fi.bcm.business.integration.model.RelationModel;
import kd.fi.bcm.business.integration.util.DataTypeCacheInfo;
import kd.fi.bcm.business.integration.util.DataTypeUtil;
import kd.fi.bcm.business.integration.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.integration.PeriodTypeEnum;
import kd.fi.bcm.common.enums.integration.RelationEnum;
import kd.fi.bcm.common.enums.integration.RptSrcTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class SupplierCollector
extends AbstractCollector {
    private IIntegrationContext ctx;
    private BloomFilter<String> dynaRowExistsFilter;
    private WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    private Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private Map<String, Pair<String, Long>> dim2ModelMap = new HashMap<String, Pair<String, Long>>();
    private Set<String> notTransMemberSet = new HashSet<String>();
    private List<Pair<String, String>> notTransDimSort = null;
    private static HashMap<String, DataTypeCacheInfo> dataTypeMap = new HashMap(16);
    private String sequenceDimNum = null;
    private String sequenceMembNum = null;
    private Table<String, String, SquenceCounter> sequenceTable = HashBasedTable.create();

    public SupplierCollector(IIntegrationContext ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    @Override
    public Map<String, Object> collect() {
        return null;
    }

    @Override
    public Object collect2() {
        boolean willBeTransVal;
        ArrayList<Map<String, Object>> table = new ArrayList<Map<String, Object>>();
        this.beforeCollect();
        List<MappingModel> models = this.ctx.getMappingModel();
        if (models.isEmpty()) {
            return null;
        }
        MDResultSet data = this.doQuery(this.ctx);
        this.log.info(String.format("[%s]\u67e5\u8be2\u51fa%d\u6761\u8bb0\u5f55,", this.ctx.getParam().getCustomParam().get("orgIntemapping"), data.getFetchSize()));
        String valueColName = FacTabFieldDefEnum.FIELD_MONEY.getField();
        String floatTxtval = null;
        String DynaItemKey = null;
        String myCompany = null;
        boolean isNumber = true;
        boolean bl = willBeTransVal = this.ctx.getRate().compareTo(BigDecimal.ONE) > 0;
        if (willBeTransVal) {
            this.initNotTransMemberSet();
        }
        if (this.isDynaRpt()) {
            this.initSequenceDim();
        }
        int transFlag = -1;
        for (MappingModel model : models) {
            BigDecimal amount = BigDecimal.ZERO;
            String txt = null;
            data.beforeFirst();
            transFlag = -1;
            while (data.next()) {
                if (Objects.isNull(data.getRow().getOriginalValue(valueColName)) || !this.match(model, data.getRow())) continue;
                isNumber = true;
                String sequenceVal = null;
                if (data.getRow().getOriginalValue(valueColName) instanceof Number) {
                    if (this.ctx.getIsFilterZero() && data.getRow().getBigDecimal(valueColName).compareTo(BigDecimal.ZERO) == 0) continue;
                    amount = model.isMultiValModel() ? data.getRow().getBigDecimal(valueColName) : amount.add(data.getRow().getBigDecimal(valueColName));
                } else {
                    Map<String, String> dim2Members = this.getDim2MembersMap(data.getRow(), this.ctx.getDimAll());
                    DataTypeEnum dataType = DataTypeUtil.getDataTypeThreadCache((Long)this.ctx.getModel().p1, dim2Members, dataTypeMap);
                    if (DataTypeEnum.DATETP == dataType) {
                        try {
                            Date date = DateTimeUtils.parseStrDate((String)data.getRow().getString(valueColName));
                            txt = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
                        }
                        catch (ParseException e) {
                            txt = data.getRow().getString(valueColName);
                        }
                    } else {
                        txt = data.getRow().getString(valueColName);
                    }
                    isNumber = false;
                }
                if (model.getIsfloat() && StringUtils.isNotEmpty((String)model.getfloatTxtItem())) {
                    floatTxtval = data.getRow().getString(model.getfloatTxtItem());
                    model.setTxtvalue(floatTxtval);
                }
                if (model.getIsfloat() && StringUtils.isNotEmpty((String)model.getFloatItem())) {
                    DynaItemKey = data.getRow().getString(model.getFloatItem());
                    model.setDynaItemKey(DynaItemKey);
                }
                if (this.ctx.isInterExch()) {
                    model.setMyCompany(data.getRow().getString("MyCompany"));
                    myCompany = data.getRow().getString("MyCompany");
                }
                if (willBeTransVal && isNumber && transFlag == -1) {
                    transFlag = this.transTypeCheck(data.getRow());
                }
                if (StringUtils.isNotEmpty((String)this.sequenceDimNum)) {
                    sequenceVal = data.getRow().getString(this.sequenceDimNum);
                }
                if (model.isMultiValModel()) {
                    model.addDynaItem(DynaItemKey, isNumber ? (transFlag == 1 ? this.transValue(amount) : amount) : txt, floatTxtval, this.ctx.isInterExch() ? myCompany : null, sequenceVal);
                    continue;
                }
                model.setValue(isNumber ? (transFlag == 1 ? this.transValue(amount) : amount) : txt);
            }
        }
        this.afterCollect();
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>(models.get(0).getMembers().size());
        for (int i = 0; i < models.get(0).getMembers().size(); ++i) {
            dimIndexMap.put((String)models.get((int)0).getMembers().get((int)i).p1, i);
        }
        for (MappingModel model : models) {
            Object value = model.getValue();
            if (value instanceof BigDecimal && this.ctx.getIsFilterZero() && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) continue;
            if (model.getIsfloat()) {
                this.packDynaRptRowInfo(table, model, dimIndexMap);
                continue;
            }
            if (value == null) continue;
            this.packFixedRptRowInfo(table, model, dimIndexMap);
        }
        return table;
    }

    private Map<String, String> getDim2MembersMap(Row row, List<String> allDim) {
        HashMap<String, String> dim2Members = new HashMap<String, String>(allDim.size());
        allDim.forEach(dim -> dim2Members.put((String)dim, row.getString((String)dim)));
        return dim2Members;
    }

    private BigDecimal transValue(Object val) {
        BigDecimal bg = val instanceof BigDecimal ? (BigDecimal)val : new BigDecimal(val.toString());
        return bg.divide(this.ctx.getRate(), this.ctx.getPrecision(), RoundingMode.HALF_UP);
    }

    private int transTypeCheck(Row row) {
        for (Pair<String, String> p : this.notTransDimSort) {
            if (!this.notTransMemberSet.contains((String)p.p1 + ":" + row.getString((String)p.p1))) continue;
            return 0;
        }
        return 1;
    }

    private void initNotTransMemberSet() {
        Map dimMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"number,membermodel", (QFilter[])new QFBuilder().add("membermodel", "=", (Object)"bcm_userdefinedmembertree").add("model", "=", this.ctx.getModel().p1).toArray(), (String)"dseq asc");
        this.notTransDimSort = new ArrayList<Pair<String, String>>();
        this.notTransDimSort.add((Pair<String, String>)Pair.onePair((Object)PresetConstant.SCENE_DIM, (Object)"bcm_scenemembertree"));
        this.notTransDimSort.add((Pair<String, String>)Pair.onePair((Object)PresetConstant.ACCOUNT_DIM, (Object)"bcm_accountmembertree"));
        this.notTransDimSort.add((Pair<String, String>)Pair.onePair((Object)PresetConstant.CHANGETYPE_DIM, (Object)"bcm_changetypemembertree"));
        dimMap.values().forEach(e -> this.notTransDimSort.add((Pair<String, String>)Pair.onePair((Object)e.getString("number"), (Object)e.getString("membermodel"))));
        Object[] dataType = Arrays.asList(DataTypeEnum.DEFAULT.index, DataTypeEnum.CURRENCY.index, DataTypeEnum.UNCURRENCY.index).toArray();
        this.notTransDimSort.forEach(d -> {
            Map members = BusinessDataServiceHelper.loadFromCache((String)((String)d.p2), (String)"number", (QFilter[])new QFBuilder().add("datatype", "not in", (Object)dataType).add("model", "=", this.ctx.getModel().p1).toArray(), (String)"dseq asc");
            members.values().forEach(m -> this.notTransMemberSet.add((String)d.p1 + ":" + m.getString("number")));
        });
    }

    private void packDynaRptRowInfo(List<Map<String, Object>> table, MappingModel model, Map<String, Integer> dimIndexMap) {
        if (model.isMultiValModel()) {
            if (model.getMultiDynaItems() != null) {
                model.getMultiDynaItems().forEach(dItem -> {
                    if (this.ctx.getIsFilterZero() && dItem.getValue() instanceof BigDecimal && ((BigDecimal)dItem.getValue()).compareTo(BigDecimal.ZERO) == 0) {
                        return;
                    }
                    model.setValue(dItem.getValue());
                    model.setDynaItemKey(dItem.getDynaItemKey());
                    model.setTxtvalue(dItem.getFloatTxt());
                    model.setMyCompany(dItem.getMyCompany());
                    model.setSequence(dItem.getSequence());
                    this.doBuiltDynaRecord(table, model, dimIndexMap);
                });
            }
        } else {
            this.doBuiltDynaRecord(table, model, dimIndexMap);
        }
    }

    private void initSequenceDim() {
        boolean isTrue = true;
        boolean isFalse = false;
        DynamicObject sequenceDim = BusinessDataServiceHelper.loadSingle((String)"bcm_userdefinedmembertree", (String)"dimension.number,number", (QFilter[])new QFBuilder().add("model", "=", this.ctx.getModel().p1).add("isleaf", "=", (Object)isFalse).add("isseq", "=", (Object)isTrue).toArray());
        this.sequenceDimNum = sequenceDim == null ? null : sequenceDim.getString("dimension.number");
        this.sequenceMembNum = sequenceDim == null ? null : sequenceDim.getString("number");
    }

    private void doBuiltDynaRecord(List<Map<String, Object>> table, MappingModel model, Map<String, Integer> dimIndexMap) {
        this.packDynaRptRowBodyInfo(table, model, dimIndexMap);
        this.genNewDynaRptFloatTxtRowInfo(table, model, dimIndexMap);
    }

    private void packFixedRptRowInfo(List<Map<String, Object>> table, MappingModel model, Map<String, Integer> dimIndexMap) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.packRowCommonInfo(row, model, dimIndexMap);
        row.put("fdynaitemkey", null);
        row.put("ftext", null);
        row.put("fdatatype", 1);
        row.put("famount", model.getValue());
        row.put("fdynaItemname", null);
        table.add(row);
    }

    private void packRowCommonInfo(Map<String, Object> row, MappingModel model, Map<String, Integer> dimIndexMap) {
        row.put("headpk", GlobalIdUtil.genStringId());
        row.put("fcompany", this.getSrcMember(dimIndexMap, model, "Entity"));
        row.put("fcurrency", this.getSrcMember(dimIndexMap, model, "Currency"));
        row.put("frptitem", this.getSrcMember(dimIndexMap, model, "RptItem"));
        row.put("fyear", this.getSrcMember(dimIndexMap, model, "Year"));
        row.put("fperiod", this.getSrcMember(dimIndexMap, model, "Period"));
        row.put("fperiodtype", PeriodTypeEnum.getEnum((String)this.getSrcMember(dimIndexMap, model, "ReportPeriod")).getValue());
        row.put("frptsrctype", RptSrcTypeEnum.getEnum((String)(dimIndexMap.containsKey("ReportType") ? this.getSrcMember(dimIndexMap, model, "ReportType") : "GROUPCOMMREPORT")).getValue());
        row.put("fdataelement", this.getSrcMember(dimIndexMap, model, "DataElement"));
        row.put("fisInterexch", this.ctx.isInterExch() ? 1 : 0);
        row.put("fownnumber", this.ctx.isInterExch() ? model.getMyCompany() : null);
        row.put("fownname", this.ctx.isInterExch() ? this.getDynamicName(model, "MyCompany", model.getMyCompany(), true, dimIndexMap, null) : null);
    }

    private Map<String, Object> packDynaRptRowCommondBodyInfo(List<Map<String, Object>> table, MappingModel model, Map<String, Integer> dimIndexMap, int datatype) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        this.packRowCommonInfo(row, model, dimIndexMap);
        row.put("fdatatype", datatype);
        boolean hasNotMembMapped2Eas = model.isDontCompare(model.getFloatItem());
        String targMembNum = hasNotMembMapped2Eas ? model.getDynaItemKey() : this.getSrcMember(dimIndexMap, model, model.getRelations().get(model.getFloatItem()).getDim());
        row.put("fdynaitemkey", targMembNum);
        String appendSequence = this.appendSequence(model);
        String targMembNam = this.getDynamicName(model, model.getFloatItem(), model.getDynaItemKey(), hasNotMembMapped2Eas, dimIndexMap, targMembNum) + appendSequence;
        row.put("fdynaitemkey", StringUtils.isNotEmpty((String)appendSequence) ? targMembNam : targMembNum);
        row.put("fdynaitemname", targMembNam);
        return row;
    }

    private String appendSequence(MappingModel model) {
        if (StringUtils.isNotEmpty((String)model.getSequence()) && model.isMatchedAndIsLeaf(this.sequenceDimNum, model.getSequence(), this.sequenceMembNum, this.ctx)) {
            String rowKey = model.getFloatItem() + model.getDynaItemKey();
            SquenceCounter counter = (SquenceCounter)this.sequenceTable.get((Object)rowKey, (Object)model.getSequence());
            if (counter == null) {
                counter = new SquenceCounter();
                if (this.sequenceTable.row((Object)rowKey).size() > 0) {
                    counter.setSequence(this.sequenceTable.row((Object)rowKey).size());
                }
                this.sequenceTable.put((Object)rowKey, (Object)model.getSequence(), (Object)counter);
            }
            return counter.sequence == 0 ? "" : String.format("@%d", counter.sequence);
        }
        return "";
    }

    private String sugerKey(Map<String, Object> row) {
        String key = "" + row.get("fcompany") + row.get("fcurrency") + row.get("frptitem") + row.get("fyear") + row.get("fperiod") + row.get("fperiodtype") + row.get("frptsrctype") + row.get("fdataelement") + row.get("fisInterexch") + row.get("fdynaitemkey") + row.get("fdatatype") + row.get("fownnumber") + row.get("fownname");
        return key;
    }

    private void genNewDynaRptFloatTxtRowInfo(List<Map<String, Object>> table, MappingModel model, Map<String, Integer> dimIndexMap) {
        if (StringUtils.isEmpty((String)model.getfloatTxtItem()) || !(model.getValue() instanceof Number)) {
            return;
        }
        Map<String, Object> row = this.packDynaRptRowCommondBodyInfo(table, model, dimIndexMap, 3);
        if (this.checkDynaRecordExists(row)) {
            return;
        }
        row.put("ftext", this.getDynamicName(model, model.getfloatTxtItem(), model.getTxtvalue(), true, dimIndexMap, null));
        row.put("famount", null);
        table.add(row);
    }

    private void packDynaRptRowBodyInfo(List<Map<String, Object>> table, MappingModel model, Map<String, Integer> dimIndexMap) {
        Map<String, Object> row = this.packDynaRptRowCommondBodyInfo(table, model, dimIndexMap, model.getValue() instanceof Number ? 1 : 3);
        row.put("ftext", model.getValue() instanceof Number ? null : model.getValue());
        row.put("famount", model.getValue() instanceof Number ? model.getValue() : null);
        if (!this.checkDynaRecordExists(row)) {
            table.add(row);
        } else {
            this.log.info(String.format("\u65b9\u6848%s\u5b58\u5728\u91cd\u590d\u8bb0\u5f55%s", this.ctx.getScheme().p2, row.toString()));
        }
    }

    private String getDynamicName(MappingModel model, String srcDimNum, String srcMembNumb, boolean isGetSrc, Map<String, Integer> dimIndexMap, String dimMembNum) {
        try {
            return (String)this.cache.get((Object)(srcDimNum + "|" + srcMembNumb), () -> {
                if (isGetSrc) {
                    if (!this.dim2ModelMap.containsKey(srcDimNum)) {
                        DynamicObject dimDyna = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"membermodel,id", (QFilter[])new QFBuilder().add("model", "=", this.ctx.getModel().p1).add("number", "=", (Object)srcDimNum).toArray());
                        this.dim2ModelMap.put(srcDimNum, (Pair<String, Long>)Pair.onePair((Object)dimDyna.getString("membermodel"), (Object)dimDyna.getLong("id")));
                    }
                    Pair<String, Long> membermodel = this.dim2ModelMap.get(srcDimNum);
                    DynamicObject dyna = QueryServiceHelper.queryOne((String)((String)membermodel.p1), (String)"name", (QFilter[])new QFBuilder().add("dimension", "=", membermodel.p2).add("number", "=", (Object)srcMembNumb).toArray());
                    if (dyna != null) {
                        return dyna.getString("name");
                    }
                } else {
                    DynamicObject dyna;
                    String targDimEntity = model.getRelations().get(srcDimNum).getTargDimEntity();
                    if (StringUtils.isNotEmpty((String)targDimEntity) && (dyna = BusinessDataServiceHelper.loadSingle((String)targDimEntity, (String)"name", (QFilter[])new QFBuilder().add("number", "=", (Object)dimMembNum).toArray())) != null) {
                        return dyna.getString("name");
                    }
                }
                if (isGetSrc) {
                    return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u7684\u6e90\u6210\u5458\u201c%2$s\u201d\u5bf9\u5e94\u540d\u79f0\u672a\u627e\u5230\u3002", (String)"SupplierCollector_0", (String)"fi-bcm-business", (Object[])new Object[0]), srcDimNum, srcMembNumb);
                }
                return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u7ef4\u5ea6\u201c%1$s\u201d\u4e0b\u7684\u76ee\u6807\u6210\u5458\u201c%2$s\u201d\u7684\u540d\u79f0\u3002", (String)"SupplierCollector_1", (String)"fi-bcm-business", (Object[])new Object[0]), srcDimNum, dimMembNum);
            });
        }
        catch (ExecutionException e) {
            if (isGetSrc) {
                return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u7684\u6e90\u6210\u5458\u201c%2$s\u201d\u5bf9\u5e94\u540d\u79f0\u672a\u627e\u5230\u3002", (String)"SupplierCollector_0", (String)"fi-bcm-business", (Object[])new Object[0]), srcDimNum, srcMembNumb);
            }
            return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u7ef4\u5ea6\u201c%1$s\u201d\u4e0b\u7684\u76ee\u6807\u6210\u5458\u201c%2$s\u201d\u7684\u540d\u79f0\u3002", (String)"SupplierCollector_1", (String)"fi-bcm-business", (Object[])new Object[0]), srcDimNum, dimMembNum);
        }
    }

    private boolean checkDynaRecordExists(Map<String, Object> row) {
        String hashStr;
        boolean isExists;
        if (this.dynaRowExistsFilter == null) {
            this.dynaRowExistsFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charset.defaultCharset()), (int)1000000, (double)0.001f);
        }
        if (!(isExists = this.dynaRowExistsFilter.mightContain((Object)(hashStr = "" + row.get("fcompany") + row.get("fcurrency") + row.get("frptitem") + row.get("fyear") + row.get("fperiod") + row.get("fperiodtype") + row.get("frptsrctype") + row.get("fdataelement") + row.get("fisInterexch") + row.get("fdynaitemkey") + row.get("fdynaitemname") + row.get("fdatatype") + row.get("fownnumber") + row.get("fownname") + row.get("ftext") + row.get("famount"))))) {
            this.dynaRowExistsFilter.put((Object)hashStr);
        }
        return isExists;
    }

    private String getSrcMember(Map<String, Integer> dimIndexMap, MappingModel model, String srcDim) {
        return (String)model.getMembers().get((int)dimIndexMap.get((Object)srcDim).intValue()).p2;
    }

    private void log(Row row, Object value) {
    }

    private boolean match(MappingModel model, Row row) {
        for (String d : this.ctx.getDimAll()) {
            if (this.matchDim(model, row, d)) continue;
            return false;
        }
        return true;
    }

    private boolean matchDim(MappingModel model, Row row, String dim) {
        String member = row.getString(dim);
        RelationModel relation = model.getRelations().get(dim);
        if (relation == null) {
            return true;
        }
        List<String> srcMembers = relation.getSrcMembers();
        if (model.getIsfloat() && dim.equals(model.getFloatItem()) && model.isDontCompare(model.getFloatItem())) {
            return model.isMatch(member, this.ctx, true);
        }
        if (model.getIsfloat() && dim.equals(model.getfloatTxtItem()) && model.isDontCompare(model.getfloatTxtItem())) {
            return model.isMatch(member, this.ctx, false);
        }
        if (model.isDontCompare(dim) && this.isDynaRpt() && !model.isleaf(dim, srcMembers.get(0), this.ctx) && !this.ctx.getSrcDefaultDims().contains(dim) || "MyCompany".equals(dim) && model.isDontCompare(dim)) {
            return model.isleaf(dim, row.getString(dim), this.ctx);
        }
        switch (relation.getRelation()) {
            case Equal: {
                if (srcMembers.get(0).equals(member)) break;
                return false;
            }
            case In: {
                if (srcMembers.contains(member)) break;
                return false;
            }
            case Between: {
                String small = srcMembers.get(0);
                String big = srcMembers.get(1);
                if (small.compareTo(big) > 0) {
                    String temp = big;
                    big = small;
                    small = temp;
                }
                if (small.compareTo(member) <= 0 && big.compareTo(member) >= 0) break;
                return false;
            }
            case Like: {
                if (member.indexOf(srcMembers.get(0)) != -1) break;
                return false;
            }
        }
        return true;
    }

    private void beforeCollect() {
    }

    private void afterCollect() {
    }

    private MDResultSet doQuery(IIntegrationContext ctx) {
        SQLBuilder sql = new SQLBuilder((String)ctx.getModel().p2);
        sql.addSelectField(ctx.getDimAll().toArray(new String[0]));
        sql.addMeasures(this.getMeasures());
        this.getScopes().forEach(e -> sql.addFilter((String)e.p1, (String[])e.p2));
        this.log.warn(String.format("\u91c7\u96c6(bizId:%s)\u67e5\u8be2olap sql-->%s", ctx.getParam().getCustomParam().get("orgIntemapping"), sql.toString()));
        return OlapServiceHelper.queryData(sql);
    }

    protected MDResultSet queryInterExchData(SQLBuilder sql) {
        Pair<String[], String[]> orgPair = this.getInsideOrgsAndOutSideOrgs();
        if (orgPair == null) {
            return new MDResultSet();
        }
        this.handleScopes(sql, orgPair);
        MDResultSet rs = OlapServiceHelper.queryData(sql);
        return rs;
    }

    private void handleScopes(SQLBuilder sql, Pair<String[], String[]> orgPair) {
        this.getScopes().forEach(e -> {
            if (((String)e.p1).equals(PresetConstant.ENTITY_DIM)) {
                sql.addFilter((String)e.p1, (String[])orgPair.p1);
            } else if (((String)e.p1).equals(PresetConstant.PROCESS_DIM)) {
                sql.addFilter((String)e.p1, "IRpt");
            } else if (((String)e.p1).equals(PresetConstant.INTERNALCOMPANY_DIM)) {
                sql.addFilter((String)e.p1, "IRpt");
            } else {
                sql.addFilter((String)e.p1, (String[])e.p2);
            }
        });
    }

    private Pair<String[], String[]> getInsideOrgsAndOutSideOrgs() {
        HashSet<String> insideOrgs = new HashSet<String>();
        insideOrgs.add(this.ctx.getOrgNumbers().get(0));
        Set<String> outsideOrgs = this.queryOutSideOrgs(insideOrgs);
        outsideOrgs.addAll(this.queryOutSideOfModelOrgs());
        if (outsideOrgs.isEmpty()) {
            return null;
        }
        return Pair.onePair((Object)insideOrgs.toArray(new String[0]), (Object)outsideOrgs.toArray(new String[0]));
    }

    private Set<String> queryOutSideOrgs(Set<String> insideOrgs) {
        boolean isTrue = true;
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", this.ctx.getModel().p1);
        qf.add("number", "not in", (Object)insideOrgs.toArray());
        qf.add("isleaf", "=", (Object)isTrue);
        qf.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        qf.add("isexchangerate", "=", (Object)0);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number", (QFilter[])qf.toArray());
        HashSet<String> outsideOrgs = new HashSet<String>();
        coll.forEach(e -> outsideOrgs.add(e.getString("number")));
        return outsideOrgs;
    }

    private Set<String> queryOutSideOfModelOrgs() {
        boolean isTrue = true;
        HashSet<String> outsideOrgs = new HashSet<String>();
        DynamicObject dyna = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"longnumber", (QFilter[])new QFBuilder().add("model", "=", this.ctx.getModel().p1).add("number", "=", (Object)"ICOEntity").toArray());
        if (dyna == null) {
            return outsideOrgs;
        }
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", this.ctx.getModel().p1);
        qf.add("isleaf", "=", (Object)isTrue);
        qf.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        qf.add("longnumber", "like", (Object)(dyna.getString("longnumber") + '!'));
        QueryServiceHelper.query((String)"bcm_icmembertree", (String)"number", (QFilter[])qf.toArray()).forEach(d -> outsideOrgs.add(d.getString("number")));
        return outsideOrgs;
    }

    private String[] getMeasures() {
        return new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()};
    }

    private Collection<Pair<String, String[]>> getScopes() {
        HashMap scope = new HashMap();
        HashMap<String, Map> dimScope = new HashMap<String, Map>();
        MappingModel model = this.ctx.getMappingModel().get(0);
        this.ctx.getDimAll().forEach(d -> {
            HashMap combineMap = new HashMap();
            this.ctx.getMappingModel().forEach(m -> {
                if (m != null && m.getRelations() != null) {
                    IntegrationUtil.combineFilter(m.getRelations().get(d), combineMap);
                }
            });
            HashSet<String> containSet = new HashSet<String>();
            containSet.add("MyCompany");
            if (!"MyCompany".equals(d) || "MyCompany".equals(d) && !combineMap.values().contains(containSet)) {
                dimScope.put((String)d, combineMap);
            }
        });
        dimScope.forEach((h, i) -> i.forEach((k, v) -> {
            if (!RelationEnum.Equal.getNumber().equals(k) && !RelationEnum.In.getNumber().equals(k)) {
                if (RelationEnum.Between.getNumber().equals(k)) {
                    QFBuilder qfbuilder = new QFBuilder();
                    v.forEach(m -> {
                        if (m.indexOf(58) > 0) {
                            String[] arr = m.split(String.valueOf(':'));
                            String small = arr[0];
                            String big = arr[1];
                            String temp = null;
                            if (big.compareTo(small) < 0) {
                                temp = big;
                                big = small;
                                small = temp;
                            }
                            qfbuilder.or(new QFilter("number", "<=", (Object)big).and("number", ">=", (Object)small));
                        }
                    });
                    if (qfbuilder.size() > 0) {
                        DynamicObjectCollection col = QueryServiceHelper.query((String)IntegrationUtil.getDimMembEntityNumByDimNum(h), (String)"id, number", (QFilter[])qfbuilder.toArray());
                        col.forEach(e -> v.add(e.getString("number")));
                    }
                } else if (RelationEnum.Like.getNumber().equals(k)) {
                    QFBuilder qfbuilder = new QFBuilder();
                    v.forEach(m -> qfbuilder.or(new QFilter("number", "like", (Object)("%" + m + "%"))));
                    if (qfbuilder.size() > 0) {
                        DynamicObjectCollection col = QueryServiceHelper.query((String)IntegrationUtil.getDimMembEntityNumByDimNum(k), (String)"id, number", (QFilter[])qfbuilder.toArray());
                        col.forEach(e -> v.add(e.getString("number")));
                    }
                }
            }
        }));
        this.ctx.getDimAll().forEach(d -> {
            Map members = (Map)dimScope.get(d);
            HashSet allMembers = new HashSet();
            if (members != null && members.size() > 0) {
                members.values().forEach(e -> e.forEach(m -> allMembers.add(m)));
            }
            if (allMembers.size() > 0) {
                scope.put(d, Pair.onePair((Object)d, (Object)allMembers.toArray(new String[0])));
            } else if (PresetConstant.PROCESS_DIM.equals(d)) {
                scope.put(d, Pair.onePair((Object)d, (Object)new String[]{"IRpt", "CS"}));
            } else {
                String member = this.ctx.getDimShortNumberMapped().get(d) + "None";
                scope.put(d, Pair.onePair((Object)d, (Object)new String[]{member}));
            }
        });
        Iterator it = scope.entrySet().iterator();
        boolean isDynaRpt = this.isDynaRpt();
        boolean isDynaCslRpt = this.isDynaCslRpt();
        this.log.info(String.format("[%s]scope-modify-before[%s],", this.ctx.getParam().getCustomParam().get("orgIntemapping"), scope.values().toString()));
        HashSet<String> sets = new HashSet<String>();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Pair p = (Pair)entry.getValue();
            if (isDynaRpt && (((String[])p.p2).length == 1 && ((String)p.p1).equals(((String[])p.p2)[0]) || model.isDontCompare((String)p.p1) && ((String[])p.p2).length == 1 && !model.isleaf((String)p.p1, ((String[])p.p2)[0], this.ctx) && !this.ctx.getSrcDefaultDims().contains(p.p1)) || isDynaCslRpt && ((String)p.p1).equals("MyCompany") && ((String[])p.p2).length == 1) {
                it.remove();
                continue;
            }
            if (!isDynaRpt || !((String)p.p1).equals(model.getfloatTxtItem()) && !((String)p.p1).equals(model.getFloatItem()) && !model.isDontCompare((String)p.p1) || ((String[])p.p2).length <= 1) continue;
            for (String pNum : (String[])p.p2) {
                Set<String> numbers = model.getLeafMembs((String)p.p1, pNum, this.ctx);
                if (numbers.size() > 0) {
                    sets.addAll(numbers);
                    continue;
                }
                if (!model.isleaf((String)p.p1, pNum, this.ctx)) continue;
                sets.add(pNum);
            }
            if (sets.size() > 0) {
                entry.setValue(Pair.onePair((Object)p.p1, (Object)sets.toArray(new String[0])));
            }
            sets.clear();
        }
        this.log.info(String.format("[%s]scope-modify-after[%s],", this.ctx.getParam().getCustomParam().get("orgIntemapping"), scope.values().toString()));
        return scope.values();
    }

    private boolean isDynaRpt() {
        List ar = (List)this.ctx.getParam().getCustomParam().get("rptType");
        String rptType = (String)ar.get(0);
        return rptType.contains("DYNAMIC");
    }

    private boolean isDynaCslRpt() {
        List ar = (List)this.ctx.getParam().getCustomParam().get("rptType");
        String rptType = (String)ar.get(0);
        return rptType.equals("DYNAMICCSLREPORT");
    }

    protected static class SquenceCounter {
        private int sequence = 0;

        protected SquenceCounter() {
        }

        public void setSequence(int sequence) {
            this.sequence = sequence;
        }
    }
}

