/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.IntegrationConstant;
import kd.fi.bcm.business.integration.converter.IConverter;
import kd.fi.bcm.business.integration.converter.SchemeConverter;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.MappingModel;
import kd.fi.bcm.business.integration.model.RelationModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.integration.EASCslDimTypesEnum;
import kd.fi.bcm.common.enums.integration.RelationEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class Bcm2EasSchemeConverter
implements IConverter {
    @Override
    public List<MappingModel> convert(IIntegrationContext ctx) {
        ArrayList<MappingModel> result = new ArrayList<MappingModel>();
        Long schemeid = (Long)ctx.getScheme().p1;
        List<String> allDims = ctx.getDimAll();
        DynamicObjectCollection tarAndSrcDimMembers = this.getRowByRptItem(ctx);
        tarAndSrcDimMembers = this.getRowByDataelement(ctx, tarAndSrcDimMembers);
        List<RelationModel> dimMemberMappingList = this.queryMemberMapping(ctx);
        Map<String, RelationModel> accountMemberMap = this.queryAccountMemberMapping(schemeid);
        DynamicObjectCollection needHandleTarDims = Bcm2EasSchemeConverter.getNeedTarDims(schemeid);
        DynamicObjectCollection needHandleSrcDims = this.getNeedSrcDims(schemeid);
        List<List<String>> memberFilterCombines = this.getDimsCombine(dimMemberMappingList);
        ArrayList<String> entryentityid = new ArrayList<String>();
        tarAndSrcDimMembers.forEach(e -> entryentityid.add(e.getString("entryentity.id")));
        Map<String, List<RelationModel>> otherMembersFromCom = this.getOtherMemberMappingFromCom(schemeid, entryentityid, needHandleSrcDims);
        Map<String, String> tarMemberNums = this.getTarMemberNumbers(tarAndSrcDimMembers, entryentityid);
        String[] specialNumber = this.getSpecialTarDimNumber(schemeid);
        RelationModel audittrial = null;
        boolean isExistAuditTrailDimension = false;
        if (MemberReader.isExistAuditTrailDimension((String)MemberReader.findModelNumberById((Object)ctx.getModel().p1))) {
            audittrial = this.getAudittrialModel(schemeid);
            isExistAuditTrailDimension = true;
        }
        DynamicObjectCollection ignoreSrcDims = this.getIgnoreSrcDims(schemeid);
        Map<String, List<DynamicObject>> srcDimsofTarDim = SchemeConverter.getSrcDimsOfTarDim(schemeid);
        for (DynamicObject rowObj : tarAndSrcDimMembers) {
            ArrayList<List<Pair<String, String>>> tempResult = new ArrayList<List<Pair<String, String>>>();
            ArrayList<List<Pair<String, String>>> temp = new ArrayList<List<Pair<String, String>>>();
            List<String> dims = IntegrationConstant.PRESET_DIMS;
            for (int i = 0; i < needHandleTarDims.size(); ++i) {
                ArrayList<Pair> list_e;
                if (rowObj.get(dims.get(i + 1)) != null && !rowObj.getString(dims.get(i + 1)).equals("0") && !this.isSpecialMember(tarMemberNums.get(rowObj.getString(dims.get(i + 1))), specialNumber)) {
                    list_e = new ArrayList();
                    list_e.add(Pair.onePair((Object)((DynamicObject)needHandleTarDims.get(i)).getString("entryentity.tagdim.number"), (Object)tarMemberNums.get(rowObj.getString(dims.get(i + 1)))));
                    temp.add(list_e);
                    continue;
                }
                if (rowObj.get(dims.get(i + 1)) != null && !rowObj.getString(dims.get(i + 1)).equals("0") && this.isSpecialMember(tarMemberNums.get(rowObj.getString(dims.get(i + 1))), specialNumber)) {
                    list_e = new ArrayList();
                    QFBuilder qfilter = new QFBuilder();
                    qfilter.add("scheme", "=", (Object)schemeid);
                    qfilter.add("tagdim", "=", (Object)((DynamicObject)needHandleTarDims.get(i)).getString("entryentity.tagdim"));
                    List<DynamicObject> srcDimOfTarDim = srcDimsofTarDim.get(((DynamicObject)needHandleTarDims.get(i)).getString("entryentity.tagdim"));
                    for (DynamicObject db : srcDimOfTarDim) {
                        if (rowObj.get("entryentity.srcdim" + db.getString("entryentity.srctocombine")) == null || rowObj.get("entryentity.srcdim" + db.getString("entryentity.srctocombine")).equals("0")) continue;
                        qfilter.add("srcdim", "=", (Object)db.getString("entryentity.srcdim"));
                        break;
                    }
                    List dataelements = (List)ctx.getParam().getCustomParam().get("dataElementNumbers");
                    boolean isEquals = EASCslDimTypesEnum.DATAELEMENT.getNumber().equals(((DynamicObject)needHandleTarDims.get(i)).getString("entryentity.tagdim.number"));
                    if (isEquals && dataelements != null && !dataelements.isEmpty()) {
                        qfilter.add("entryentity.tagdimmembnumber", "in", (Object)dataelements);
                    }
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_dimmembwelkin", (String)"entryentity.tagdimmembnumber", (QFilter[])qfilter.toArray());
                    for (DynamicObject m : dynamicObjectCollection) {
                        list_e.add(Pair.onePair((Object)((DynamicObject)needHandleTarDims.get(i)).getString("entryentity.tagdim.number"), (Object)m.getString("entryentity.tagdimmembnumber")));
                    }
                    temp.add(list_e);
                    continue;
                }
                list_e = new ArrayList<Pair>();
                list_e.add(Pair.onePair((Object)((DynamicObject)needHandleTarDims.get(i)).getString("entryentity.tagdim.number"), (Object)""));
                temp.add(list_e);
            }
            SchemeConverter.descartes(temp, tempResult, 0, new ArrayList<Pair<String, String>>());
            for (List<String> memberFilterCombine : memberFilterCombines) {
                ArrayList<Pair> tagDimsMember_front = new ArrayList<Pair>();
                int factor = rowObj.getInt("entryentity.plusminus") == 0 ? 1 : -1;
                tagDimsMember_front.add(Pair.onePair((Object)"Entity", (Object)memberFilterCombine.get(0)));
                tagDimsMember_front.add(Pair.onePair((Object)"Currency", (Object)memberFilterCombine.get(1)));
                tagDimsMember_front.add(Pair.onePair((Object)"RptItem", (Object)tarMemberNums.get(rowObj.getString("entryentity.tagdim1"))));
                tagDimsMember_front.add(Pair.onePair((Object)"Year", (Object)memberFilterCombine.get(3)));
                tagDimsMember_front.add(Pair.onePair((Object)"Period", (Object)memberFilterCombine.get(4)));
                tagDimsMember_front.add(Pair.onePair((Object)"ReportPeriod", (Object)memberFilterCombine.get(5)));
                tagDimsMember_front.add(Pair.onePair((Object)"ReportType", (Object)memberFilterCombine.get(2)));
                HashMap<String, RelationModel> oneCombineSrc_front = new HashMap<String, RelationModel>();
                tagDimsMember_front.forEach(tardim_front -> {
                    if (EASCslDimTypesEnum.RPTITEM.getNumber().equals(tardim_front.p1)) {
                        RelationModel accountSrcModel = (RelationModel)accountMemberMap.get(rowObj.getString("entryentity.id"));
                        oneCombineSrc_front.put(accountSrcModel.getSrcDim(), accountSrcModel);
                    } else {
                        for (RelationModel srcModel : dimMemberMappingList) {
                            if (!srcModel.getDim().equals(tardim_front.p1) || !srcModel.getMember().equals(tardim_front.p2)) continue;
                            oneCombineSrc_front.put(srcModel.getSrcDim(), srcModel);
                            break;
                        }
                    }
                });
                if (isExistAuditTrailDimension) {
                    oneCombineSrc_front.put(DimTypesEnum.AUDITTRIAL.getNumber(), audittrial);
                }
                for (DynamicObject dynamicObject : ignoreSrcDims) {
                    for (int i = 0; i < allDims.size(); ++i) {
                        String srcdim = dynamicObject.getString("entryentity.srcdim.number");
                        if (!srcdim.equals(allDims.get(i))) continue;
                        ArrayList<String> defaultItem = new ArrayList<String>();
                        defaultItem.add(dynamicObject.getString("entryentity.defaultitemnumber"));
                        oneCombineSrc_front.put(srcdim, new RelationModel(null, null, srcdim, RelationEnum.Equal, defaultItem));
                    }
                }
                for (List list : tempResult) {
                    ArrayList<Pair<String, String>> members = new ArrayList<Pair<String, String>>();
                    members.addAll(tagDimsMember_front);
                    members.addAll(list);
                    HashMap<String, RelationModel> oneCombineSrc_behind = new HashMap<String, RelationModel>();
                    block8: for (int j = 0; j < needHandleSrcDims.size(); ++j) {
                        boolean isEquals;
                        boolean isSpecialMember = false;
                        int tarcolnum = 0;
                        DynamicObjectCollection tarCols = this.getSrc2TarColumn(schemeid, ((DynamicObject)needHandleSrcDims.get(j)).getInt("entryentity.srctocombine"));
                        for (DynamicObject tarcol : tarCols) {
                            if (rowObj.getString("entryentity.tagdim" + tarcol.getInt("entryentity.tagtocombine")) == null) continue;
                            tarcolnum = tarcol.getInt("entryentity.tagtocombine") - 2;
                            String tarMemberNum = tarMemberNums.get(rowObj.getString("entryentity.tagdim" + tarcol.getInt("entryentity.tagtocombine")));
                            if (!this.isSpecialMember(tarMemberNum, specialNumber)) continue;
                            isSpecialMember = true;
                            break;
                        }
                        boolean isNull = rowObj.getString("entryentity.srcdim" + ((DynamicObject)needHandleSrcDims.get(j)).getString("entryentity.srctocombine")) != null;
                        boolean bl = isEquals = !rowObj.getString("entryentity.srcdim" + ((DynamicObject)needHandleSrcDims.get(j)).getString("entryentity.srctocombine")).equals("0");
                        if (isNull && isEquals && !isSpecialMember) {
                            List<RelationModel> currentRowRelationModel = otherMembersFromCom.get(rowObj.getString("entryentity.id"));
                            Iterator iterator = currentRowRelationModel.iterator();
                            while (iterator.hasNext()) {
                                RelationModel srcModel = (RelationModel)iterator.next();
                                if (!srcModel.getSrcDim().equals(((DynamicObject)needHandleSrcDims.get(j)).getString("entryentity.srcdim.number"))) continue;
                                oneCombineSrc_behind.put(srcModel.getSrcDim(), srcModel);
                                continue block8;
                            }
                            continue;
                        }
                        if (isNull && isEquals && isSpecialMember) {
                            for (RelationModel srcModel : dimMemberMappingList) {
                                if (!srcModel.getMember().equals(((Pair)list.get((int)tarcolnum)).p2)) continue;
                                oneCombineSrc_behind.put(srcModel.getSrcDim(), srcModel);
                                continue block8;
                            }
                            continue;
                        }
                        if (!((DynamicObject)needHandleSrcDims.get(j)).getString("entryentity.srcdim.number").equals(PresetConstant.MYCOMPANY_DIM)) continue;
                        RelationEnum relation = ((RelationModel)oneCombineSrc_front.get(PresetConstant.ENTITY_DIM)).getRelation();
                        List<String> srcMembers = ((RelationModel)oneCombineSrc_front.get(PresetConstant.ENTITY_DIM)).getSrcMembers();
                        RelationModel rm = new RelationModel(null, null, PresetConstant.MYCOMPANY_DIM, relation, srcMembers);
                        oneCombineSrc_behind.put(PresetConstant.MYCOMPANY_DIM, rm);
                    }
                    HashMap<String, RelationModel> oneCombineSrc_all = new HashMap<String, RelationModel>();
                    oneCombineSrc_all.putAll(oneCombineSrc_front);
                    oneCombineSrc_all.putAll(oneCombineSrc_behind);
                    boolean isfloat = rowObj.getBoolean("entryentity.isfloat");
                    String floatItem = rowObj.getString("entryentity.floatitem.number");
                    String textSpread = rowObj.getString("entryentity.textspread.number");
                    MappingModel mappingModel = new MappingModel(0, members, oneCombineSrc_all, factor, isfloat, floatItem, textSpread);
                    result.add(mappingModel);
                }
            }
        }
        return result;
    }

    private Map<String, String> getTarMemberNumbers(DynamicObjectCollection tarAndSrcDimMembers, List<String> entryentityid) {
        HashSet<String> tarMemberIds = new HashSet<String>();
        for (DynamicObject oneRow : tarAndSrcDimMembers) {
            for (String tardim : IntegrationConstant.PRESET_DIMS) {
                if ("0".equals(oneRow.getString(tardim))) continue;
                tarMemberIds.add(oneRow.getString(tardim));
            }
        }
        QFilter tarMemberIdsQF = new QFilter("tagdimmemb", "in", tarMemberIds);
        QFilter entryidsQF = new QFilter("dimmembentry", "in", entryentityid);
        DynamicObjectCollection tarMembers = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)"tagdimmemb, tagdimmembnumber", (QFilter[])new QFilter[]{tarMemberIdsQF, entryidsQF});
        HashMap<String, String> tarMemberNums = new HashMap<String, String>();
        for (DynamicObject tarMember : tarMembers) {
            tarMemberNums.put(tarMember.getString("tagdimmemb"), tarMember.getString("tagdimmembnumber"));
        }
        return tarMemberNums;
    }

    private DynamicObjectCollection getRowByRptItem(IIntegrationContext ctx) {
        DynamicObjectCollection tarAndSrcDimMembers;
        QFBuilder qb = new QFBuilder();
        qb.add("scheme", "=", ctx.getScheme().p1);
        List rptitems = (List)ctx.getParam().getCustomParam().get("rptItemNumbers");
        if (rptitems != null && !rptitems.isEmpty()) {
            QFilter qfb = new QFilter("number", "in", (Object)rptitems);
            DynamicObjectCollection rptItems = QueryServiceHelper.query((String)"ds_rptitem", (String)"id", (QFilter[])new QFilter[]{qfb});
            ArrayList rptitemids = new ArrayList();
            rptItems.forEach(rptitem -> rptitemids.add(rptitem.getString("id")));
            qb.add("entryentity.tagdim1", "in", rptitemids);
        }
        if ((tarAndSrcDimMembers = QueryServiceHelper.query((String)"bcm_dimcombwelkin", (String)this.getSelector(), (QFilter[])qb.toArray())).size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u62a5\u8868\u9879\u76ee\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return tarAndSrcDimMembers;
    }

    private DynamicObjectCollection getRowByDataelement(IIntegrationContext ctx, DynamicObjectCollection tarAndSrcDimMembers) {
        List dataelements = (List)ctx.getParam().getCustomParam().get("dataElementNumbers");
        DynamicObjectCollection needRows = new DynamicObjectCollection();
        if (dataelements != null && !dataelements.isEmpty()) {
            int num = this.getNumByTarNumber((Long)ctx.getScheme().p1, EASCslDimTypesEnum.DATAELEMENT.getNumber());
            QFilter specialnumber = new QFilter("tagdimmembnumber", "=", (Object)(EASCslDimTypesEnum.DATAELEMENT.getNumber() + "DefaultAll"));
            ArrayList entryids = new ArrayList();
            tarAndSrcDimMembers.forEach(t -> entryids.add(t.getString("entryentity.id")));
            QFilter entryidqf = new QFilter("dimmembentry", "in", entryids);
            DynamicObjectCollection specialObjs = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)"dimmembentry, tagdimmemb", (QFilter[])new QFilter[]{specialnumber, entryidqf});
            HashMap entrytotag = new HashMap();
            specialObjs.forEach(s -> entrytotag.put(s.getString("dimmembentry"), s.getString("tagdimmemb")));
            QFilter qfb = new QFilter("number", "in", (Object)dataelements);
            DynamicObjectCollection dataElements = QueryServiceHelper.query((String)"ds_dataelement", (String)"id", (QFilter[])new QFilter[]{qfb});
            ArrayList dataelementids = new ArrayList();
            dataElements.forEach(dataelement -> dataelementids.add(dataelement.getString("id")));
            block0: for (DynamicObject tar : tarAndSrcDimMembers) {
                for (String dataelementid : dataelementids) {
                    if (!dataelementid.equals(tar.getString("entryentity.tagdim" + num)) && (entrytotag.size() <= 0 || !((String)entrytotag.get(tar.getString("entryentity.id"))).equals(tar.getString("entryentity.tagdim" + num)))) continue;
                    needRows.add((Object)tar);
                    continue block0;
                }
            }
            if (needRows.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u53d6\u6570\u7c7b\u578b\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            return needRows;
        }
        return tarAndSrcDimMembers;
    }

    private int getNumByTarNumber(Long schemeId, String number) {
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeId);
        QFilter tarFilter = new QFilter("entryentity.tagdim.number", "=", (Object)number);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_dimmappingwelkin", (String)"entryentity.tagtocombine", (QFilter[])new QFilter[]{schemeIdFilter, tarFilter});
        return dyn.getInt("entryentity.tagtocombine");
    }

    private List<List<String>> getDimsCombine(List<RelationModel> relations) {
        ArrayList orgs = new ArrayList();
        ArrayList currencies = new ArrayList();
        ArrayList rptTypes = new ArrayList();
        ArrayList years = new ArrayList();
        ArrayList periods = new ArrayList();
        ArrayList reportPeriods = new ArrayList();
        relations.forEach(e -> {
            if ("Entity".equals(e.getDim())) {
                orgs.add(e.getMember());
            }
            if ("Currency".equals(e.getDim())) {
                currencies.add(e.getMember());
            }
            if ("ReportType".equals(e.getDim())) {
                rptTypes.add(e.getMember());
            }
            if ("Year".equals(e.getDim())) {
                years.add(e.getMember());
            }
            if ("Period".equals(e.getDim())) {
                periods.add(e.getMember());
            }
            if ("ReportPeriod".equals(e.getDim())) {
                reportPeriods.add(e.getMember());
            }
        });
        if (orgs.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u7ec4\u7ec7\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (currencies.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u5e01\u79cd\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (rptTypes.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u62a5\u8868\u7c7b\u578b\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_4", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (years.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u8d22\u5e74\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_5", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (periods.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u6709\u6548\u7684\u671f\u95f4\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (reportPeriods.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u62a5\u8868\u5468\u671f\u53c2\u6570\u3002", (String)"Bcm2EasSchemeConverter_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        ArrayList<List<String>> tempaResult = new ArrayList<List<String>>();
        ArrayList<List<String>> tempa = new ArrayList<List<String>>();
        tempa.add(orgs);
        tempa.add(currencies);
        tempa.add(rptTypes);
        tempa.add(years);
        tempa.add(periods);
        tempa.add(reportPeriods);
        SchemeConverter.descartesString(tempa, tempaResult, 0, new ArrayList<String>());
        return tempaResult;
    }

    private DynamicObjectCollection getSrc2TarColumn(Long schemeid, int srccol) {
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeid);
        QFilter srccolFilter = new QFilter("entryentity.srctocombine", "=", (Object)srccol);
        DynamicObjectCollection dimmappings = QueryServiceHelper.query((String)"bcm_dimmappingwelkin", (String)"entryentity.tagtocombine", (QFilter[])new QFilter[]{schemeIdFilter, srccolFilter});
        return dimmappings;
    }

    private RelationModel getAudittrialModel(Long schemeid) {
        QFilter qfScheme = new QFilter("scheme", "=", (Object)schemeid);
        QFilter qfAudit = new QFilter("entryentity.srcdim.number", "=", (Object)DimTypesEnum.AUDITTRIAL.getNumber());
        DynamicObject audittrial = QueryServiceHelper.queryOne((String)"bcm_dimmappingwelkin", (String)"entryentity.srcdim.number, entryentity.defaultitemnumber", (QFilter[])new QFilter[]{qfScheme, qfAudit});
        ArrayList<String> defaultItem = new ArrayList<String>();
        defaultItem.add(audittrial.getString("entryentity.defaultitemnumber"));
        RelationModel rmAudittrial = new RelationModel(null, null, audittrial.getString("entryentity.srcdim.number"), RelationEnum.Equal, defaultItem);
        return rmAudittrial;
    }

    public static DynamicObjectCollection getNeedTarDims(Long schemeid) {
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeid);
        QFilter dimFilter = new QFilter("entryentity.tagtocombine", ">", (Object)1);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimmappingwelkin", (String)"entryentity.tagtocombine, entryentity.tagdim, entryentity.tagdim.number", (QFilter[])new QFilter[]{schemeIdFilter, dimFilter}, (String)"entryentity.tagtocombine");
        DynamicObjectCollection distinctDoc = new DynamicObjectCollection();
        HashSet set = new HashSet();
        doc.forEach(e -> {
            String key = e.getString("entryentity.tagtocombine") + "&" + e.getString("entryentity.tagdim");
            if (set.add(key)) {
                distinctDoc.add(e);
            }
        });
        return distinctDoc;
    }

    private DynamicObjectCollection getIgnoreSrcDims(Long schemeid) {
        ArrayList SRC_NUMBER = Lists.newArrayList((Object[])new String[]{"Entity", "Account", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail", "ChangeType"});
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeid);
        QFilter tarqf = new QFilter("entryentity.tagdim", "=", (Object)0L);
        QFilter srcqf = new QFilter("entryentity.srcdim.number", "not in", (Object)SRC_NUMBER);
        DynamicObjectCollection notHaveSrcDims = QueryServiceHelper.query((String)"bcm_dimmappingwelkin", (String)"entryentity.srcdim.number, entryentity.defaultitemnumber", (QFilter[])new QFilter[]{schemeIdFilter, srcqf, tarqf});
        return notHaveSrcDims;
    }

    private Map<String, List<RelationModel>> getOtherMemberMappingFromCom(Long schemeid, List<String> entryentityid, DynamicObjectCollection needHandleSrcDims) {
        HashMap<String, List<RelationModel>> dim2memberMappingMap = new HashMap<String, List<RelationModel>>();
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)schemeid);
        QFilter rowFilter = new QFilter("entryentity.id", "in", entryentityid);
        DynamicObjectCollection docc = QueryServiceHelper.query((String)"bcm_dimcombwelkin", (String)"entryentity.id, entryentity.plusminus, entryentity.tagdim2, entryentity.tagdim3, entryentity.tagdim4, entryentity.tagdim5, entryentity.tagdim6, entryentity.tagdim7, entryentity.tagdim8, entryentity.tagdim9, entryentity.tagdim10 ", (QFilter[])new QFilter[]{schemeFilter, rowFilter});
        for (DynamicObject doc : docc) {
            QFilter entryidQF = new QFilter("dimmembentry", "=", (Object)doc.getString("entryentity.id"));
            QFilter srcdimnumberQF = null;
            ArrayList<RelationModel> dim2memberMappinglist = new ArrayList<RelationModel>();
            for (int i = 0; i < needHandleSrcDims.size(); ++i) {
                srcdimnumberQF = new QFilter("srcdimnumber", "=", (Object)((DynamicObject)needHandleSrcDims.get(i)).getString("entryentity.srcdim.number"));
                DynamicObjectCollection srcMembers = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)"srcdimmembnumber, tagdimmembnumber, relation, srcdimnumber, tardimnumber", (QFilter[])new QFilter[]{entryidQF, srcdimnumberQF});
                if (srcMembers.isEmpty()) continue;
                RelationEnum relation = RelationEnum.getEnum((Integer)((DynamicObject)srcMembers.get(0)).getInt("relation"));
                List<String> values = srcMembers.stream().map(e -> e.getString("srcdimmembnumber")).collect(Collectors.toList());
                if (((DynamicObject)srcMembers.get(0)).getString("srcdimnumber") == null) continue;
                dim2memberMappinglist.add(new RelationModel(((DynamicObject)srcMembers.get(0)).getString("tardimnumber"), ((DynamicObject)srcMembers.get(0)).getString("tagdimmembnumber"), ((DynamicObject)srcMembers.get(0)).getString("srcdimnumber"), relation, values));
            }
            dim2memberMappingMap.put(doc.getString("entryentity.id"), dim2memberMappinglist);
        }
        return dim2memberMappingMap;
    }

    private List<RelationModel> queryMemberMapping(IIntegrationContext ctx) {
        ArrayList<RelationModel> result = new ArrayList<RelationModel>();
        QFilter schemefilter = new QFilter("scheme", "=", ctx.getScheme().p1);
        QFilter dimfilter = new QFilter("tagdim.number", "!=", (Object)PresetConstant.INTERNALCOMPANY_DIM);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimmembwelkin", (String)"tagdim.number,tagdim.entitynumber, srcdim.number, entryentity.id, entryentity.tagdimmembnumber", (QFilter[])new QFilter[]{schemefilter, dimfilter});
        HashSet<String> map = new HashSet<String>();
        StringBuilder key = new StringBuilder();
        for (DynamicObject dyn : doc) {
            key.setLength(0);
            QFBuilder qfbuilder = new QFBuilder();
            qfbuilder.add("dimmembentry", "=", (Object)dyn.getString("entryentity.id"));
            this.buildFilter(ctx, qfbuilder, dyn.getString("tagdim.number"));
            DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)"srcdimmembnumber, relation", (QFilter[])qfbuilder.toArray());
            key.append(dyn.getString("entryentity.tagdimmembnumber")).append(dyn.getString("srcdim.number")).append(dyn.getString("tagdim.entitynumber"));
            if (members != null) {
                for (DynamicObject d : members) {
                    key.append(d.getString("srcdimmembnumber"));
                }
            }
            if (map.contains(key.toString())) continue;
            map.add(key.toString());
            if (members == null || members.size() <= 0) continue;
            RelationEnum relation = RelationEnum.getEnum((Integer)((DynamicObject)members.get(0)).getInt("relation"));
            List<String> values = members.stream().map(e -> e.getString("srcdimmembnumber")).collect(Collectors.toList());
            RelationModel relamodel = new RelationModel(dyn.getString("tagdim.number"), dyn.getString("entryentity.tagdimmembnumber"), dyn.getString("srcdim.number"), relation, values);
            relamodel.setTargDimEntity(dyn.getString("tagdim.entitynumber"));
            result.add(relamodel);
        }
        return result;
    }

    private void buildFilter(IIntegrationContext ctx, QFBuilder qfbuilder, String tarDim) {
        List reportTypes;
        if ("Entity".equals(tarDim)) {
            List<String> orgs = ctx.getOrgNumbers();
            if (orgs != null && !orgs.isEmpty()) {
                qfbuilder.add("tagdimmembnumber", "in", orgs);
            }
        } else if ("Year".equals(tarDim)) {
            String year = (String)ctx.getYear().p2;
            if (!StringUtils.isEmpty((String)year)) {
                qfbuilder.add("tagdimmembnumber", "=", (Object)year);
            }
        } else if ("Period".equals(tarDim)) {
            String period = (String)ctx.getPeriod().p2;
            if (!StringUtils.isEmpty((String)period)) {
                qfbuilder.add("tagdimmembnumber", "=", (Object)period);
            }
        } else if ("Currency".equals(tarDim)) {
            List currencies = (List)ctx.getParam().getCustomParam().get("currencyNumbers");
            if (currencies != null && !currencies.isEmpty()) {
                qfbuilder.add("tagdimmembnumber", "in", (Object)currencies);
            }
        } else if ("ReportPeriod".equals(tarDim)) {
            String scene = (String)ctx.getScene().p2;
            if (!StringUtils.isEmpty((String)scene)) {
                qfbuilder.add("tagdimmembnumber", "=", (Object)scene);
            }
        } else if ("DataElement".equals(tarDim)) {
            List dataelements = (List)ctx.getParam().getCustomParam().get("dataElementNumbers");
            if (dataelements != null && !dataelements.isEmpty()) {
                qfbuilder.add("tagdimmembnumber", "in", (Object)dataelements);
            }
        } else if ("ReportType".equals(tarDim) && (reportTypes = (List)ctx.getParam().getCustomParam().get("rptType")) != null && !reportTypes.isEmpty()) {
            qfbuilder.add("tagdimmembnumber", "in", (Object)reportTypes);
        }
    }

    private Map<String, RelationModel> queryAccountMemberMapping(Long schemeid) {
        HashMap<String, RelationModel> accountMemberMap = new HashMap<String, RelationModel>();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimcombwelkin", (String)"entryentity.id, entryentity.plusminus, entryentity.tagdim1", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)schemeid)});
        DynamicObject accountDimNumberMapping = this.getAccountDimNumber(schemeid);
        for (DynamicObject dyn : doc) {
            QFilter entryidQF = new QFilter("dimmembentry", "=", (Object)dyn.getString("entryentity.id"));
            QFilter dimQF = new QFilter("tagdimmemb", "=", (Object)dyn.getString("entryentity.tagdim1"));
            DynamicObjectCollection srcMembers = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)"srcdimmembnumber, tagdimmembnumber, relation", (QFilter[])new QFilter[]{entryidQF, dimQF});
            RelationEnum relation = RelationEnum.getEnum((Integer)((DynamicObject)srcMembers.get(0)).getInt("relation"));
            List<String> values = srcMembers.stream().map(e -> e.getString("srcdimmembnumber")).collect(Collectors.toList());
            accountMemberMap.put(dyn.getString("entryentity.id"), new RelationModel(accountDimNumberMapping.getString("entryentity.tagdim.number"), ((DynamicObject)srcMembers.get(0)).getString("tagdimmembnumber"), accountDimNumberMapping.getString("entryentity.srcdim.number"), relation, values));
        }
        return accountMemberMap;
    }

    private DynamicObject getAccountDimNumber(Long schemeid) {
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeid);
        QFilter dimFilter = new QFilter("entryentity.tagdim.number", "=", (Object)"RptItem");
        DynamicObject dimmappings = QueryServiceHelper.queryOne((String)"bcm_dimmappingwelkin", (String)"entryentity.tagdim.number, entryentity.srcdim.number", (QFilter[])new QFilter[]{schemeIdFilter, dimFilter});
        return dimmappings;
    }

    private DynamicObjectCollection getNeedSrcDims(Long schemeid) {
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeid);
        QFilter dimFilter = new QFilter("entryentity.srctocombine", ">", (Object)1);
        DynamicObjectCollection dimmappings = QueryServiceHelper.query((String)"bcm_dimmappingwelkin", (String)"entryentity.srctocombine, entryentity.srcdim, entryentity.srcdim.number", (QFilter[])new QFilter[]{schemeIdFilter, dimFilter}, (String)"entryentity.srctocombine");
        DynamicObjectCollection distinctDoc = new DynamicObjectCollection();
        HashSet set = new HashSet();
        dimmappings.forEach(e -> {
            String key = e.getString("entryentity.srctocombine") + "&" + e.getString("entryentity.srcdim");
            if (set.add(key)) {
                distinctDoc.add(e);
            }
        });
        return distinctDoc;
    }

    private String[] getSpecialTarDimNumber(Long schemeid) {
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeid);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimmappingwelkin", (String)"entryentity.tagdim.number", (QFilter[])new QFilter[]{schemeIdFilter});
        HashSet set = new HashSet();
        doc.forEach(e -> {
            if (e.getString("entryentity.tagdim.number") != null) {
                set.add(e.getString("entryentity.tagdim.number") + "DefaultAll");
            }
        });
        return set.toArray(new String[0]);
    }

    private boolean isSpecialMember(String memberNumber, String[] specialNumber) {
        return Arrays.asList(specialNumber).contains(memberNumber);
    }

    private String getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("entryentity.id");
        selector.add("entryentity.relation");
        selector.add("entryentity.plusminus");
        selector.add("entryentity.isfloat");
        selector.add("entryentity.floatitem.number");
        selector.add("entryentity.textspread.number");
        IntegrationConstant.SRC_PRESET_DIMS.forEach(e -> selector.add((String)e));
        IntegrationConstant.PRESET_DIMS.forEach(e -> selector.add((String)e));
        return String.join((CharSequence)",", selector);
    }
}

