/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.converter.IConverter;
import kd.fi.bcm.business.integration.model.IIntegrationContext;
import kd.fi.bcm.business.integration.model.MappingModel;
import kd.fi.bcm.business.integration.model.RelationModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.integration.RelationEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class SchemeConverter
implements IConverter {
    public List<RelationModel> queryMemberMapping(IIntegrationContext ctx) {
        ArrayList<RelationModel> result = new ArrayList<RelationModel>();
        QFilter schemefilter = new QFilter("scheme", "=", ctx.getScheme().p1);
        QFilter dimfilter = new QFilter("tagdim.number", "!=", (Object)PresetConstant.INTERNALCOMPANY_DIM);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimmembermapping", (String)"tagdim.number, srcdim.number, entryentity.id, entryentity.tagdimmembnumber, entryentity.periodnumber", (QFilter[])new QFilter[]{schemefilter, dimfilter});
        boolean haveCorrectYearPeriod = false;
        for (DynamicObject dyn : doc) {
            QFBuilder qfbuilder = new QFBuilder();
            qfbuilder.add("dimmembentry", "=", (Object)dyn.getString("entryentity.id"));
            this.buildFilter(ctx, qfbuilder, dyn.getString("tagdim.number"));
            DynamicObjectCollection srcMembers = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)"srcdimmembnumber, relation", (QFilter[])qfbuilder.toArray());
            if (srcMembers == null || srcMembers.size() <= 0) continue;
            RelationEnum relation = RelationEnum.getEnum((Integer)((DynamicObject)srcMembers.get(0)).getInt("relation"));
            ArrayList<String> values = new ArrayList();
            String pnumber = dyn.getString("entryentity.periodnumber");
            if (StringUtils.isEmpty((String)pnumber)) {
                values = srcMembers.stream().map(e -> e.getString("srcdimmembnumber")).collect(Collectors.toList());
            } else if (dyn.getString("entryentity.periodnumber").equals(ctx.getPeriod().p2) && dyn.getString("entryentity.tagdimmembnumber").equals(ctx.getYear().p2)) {
                values.add(((DynamicObject)srcMembers.get(0)).getString("srcdimmembnumber"));
                haveCorrectYearPeriod = true;
            } else if (!dyn.getString("entryentity.periodnumber").equals(ctx.getPeriod().p2) || !dyn.getString("entryentity.tagdimmembnumber").equals(ctx.getYear().p2)) continue;
            result.add(new RelationModel(dyn.getString("tagdim.number"), dyn.getString("entryentity.tagdimmembnumber"), dyn.getString("srcdim.number"), relation, values));
        }
        if (!haveCorrectYearPeriod) {
            throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u96c6\u65f6\u7f3a\u5c11\u6709\u6548\u7684\u8d22\u5e74\u671f\u95f4\u53c2\u6570\u3002", (String)"SchemeConverter_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return result;
    }

    private void buildFilter(IIntegrationContext ctx, QFBuilder qfbuilder, String tarDim) {
        String currency;
        if (PresetConstant.ENTITY_DIM.equals(tarDim)) {
            List<String> orgs = ctx.getOrgNumbers();
            if (orgs != null && !orgs.isEmpty()) {
                qfbuilder.add("tagdimmembnumber", "in", orgs);
            }
        } else if (PresetConstant.CURRENCY_DIM.equals(tarDim) && !StringUtils.isEmpty((String)(currency = (String)ctx.getCurrency().p2))) {
            qfbuilder.add("tagdimmembnumber", "=", (Object)currency);
        }
    }

    public static Map<String, List<DynamicObject>> getSrcDimsOfTarDim(Long schemeid) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>();
        QFilter schemeIdFilter = new QFilter("scheme", "=", (Object)schemeid);
        DynamicObjectCollection dimmappings = QueryServiceHelper.query((String)"bcm_dimmapping", (String)"entryentity.srctocombine, entryentity.srcdim, entryentity.srcdim.number, entryentity.tagdim", (QFilter[])new QFilter[]{schemeIdFilter});
        for (DynamicObject dyn : dimmappings) {
            List<Object> list = new ArrayList<DynamicObject>();
            if (map.containsKey(dyn.getString("entryentity.tagdim"))) {
                list = (List)map.get(dyn.getString("entryentity.tagdim"));
            }
            list.add(dyn);
            map.put(dyn.getString("entryentity.tagdim"), list);
        }
        return map;
    }

    public static List<RelationModel> queryICMemberMapping(IIntegrationContext ctx) {
        ArrayList<RelationModel> result = new ArrayList<RelationModel>();
        QFilter schemefilter = new QFilter("scheme", "=", ctx.getScheme().p1);
        QFilter dimfilter = new QFilter("tagdim.number", "=", (Object)PresetConstant.INTERNALCOMPANY_DIM);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_dimmembermapping", (String)"tagdim.number, srcdim.number, entryentity.id, entryentity.tagdimmembnumber", (QFilter[])new QFilter[]{schemefilter, dimfilter});
        ArrayList<String> entryentityids = new ArrayList<String>();
        for (DynamicObject dy : doc) {
            entryentityids.add(dy.getString("entryentity.id"));
        }
        QFilter qf = new QFilter("dimmembentry", "in", entryentityids);
        DynamicObjectCollection srcMembers = QueryServiceHelper.query((String)"bcm_srcdimmembentry", (String)"dimmembentry, srcdimmembnumber, relation", (QFilter[])new QFilter[]{qf});
        HashMap map = new HashMap();
        for (DynamicObject d : srcMembers) {
            List<Object> list = new ArrayList<DynamicObject>();
            if (map.containsKey(d.getString("dimmembentry"))) {
                list = (List)map.get(d.getString("dimmembentry"));
            }
            if (!list.contains(d)) {
                list.add(d);
            }
            map.put(d.getString("dimmembentry"), list);
        }
        for (DynamicObject dyn : doc) {
            List srcMemberss = (List)map.get(dyn.getString("entryentity.id"));
            if (srcMemberss == null || srcMemberss.size() <= 0) continue;
            RelationEnum relation = RelationEnum.getEnum((Integer)((DynamicObject)srcMemberss.get(0)).getInt("relation"));
            List<String> values = srcMemberss.stream().map(e -> e.getString("srcdimmembnumber")).collect(Collectors.toList());
            result.add(new RelationModel(dyn.getString("tagdim.number"), dyn.getString("entryentity.tagdimmembnumber"), dyn.getString("srcdim.number"), relation, values));
        }
        return result;
    }

    public static void descartes(List<List<Pair<String, String>>> dimvalue, List<List<Pair<String, String>>> result, int layer, List<Pair<String, String>> curList) {
        block7: {
            block6: {
                if (layer >= dimvalue.size() - 1) break block6;
                if (dimvalue.get(layer).size() == 0) {
                    SchemeConverter.descartes(dimvalue, result, layer + 1, curList);
                } else {
                    for (int i = 0; i < dimvalue.get(layer).size(); ++i) {
                        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>(curList);
                        list.add(dimvalue.get(layer).get(i));
                        SchemeConverter.descartes(dimvalue, result, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimvalue.size() - 1) break block7;
            if (dimvalue.get(layer).size() == 0) {
                result.add(curList);
            } else {
                for (int i = 0; i < dimvalue.get(layer).size(); ++i) {
                    ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>(curList);
                    list.add(dimvalue.get(layer).get(i));
                    result.add(list);
                }
            }
        }
    }

    public static void descartesString(List<List<String>> dimvalue, List<List<String>> result, int layer, List<String> curList) {
        block7: {
            block6: {
                if (layer >= dimvalue.size() - 1) break block6;
                if (dimvalue.get(layer).size() == 0) {
                    SchemeConverter.descartesString(dimvalue, result, layer + 1, curList);
                } else {
                    for (int i = 0; i < dimvalue.get(layer).size(); ++i) {
                        ArrayList<String> list = new ArrayList<String>(curList);
                        list.add(dimvalue.get(layer).get(i));
                        SchemeConverter.descartesString(dimvalue, result, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimvalue.size() - 1) break block7;
            if (dimvalue.get(layer).size() == 0) {
                result.add(curList);
            } else {
                for (int i = 0; i < dimvalue.get(layer).size(); ++i) {
                    ArrayList<String> list = new ArrayList<String>(curList);
                    list.add(dimvalue.get(layer).get(i));
                    result.add(list);
                }
            }
        }
    }

    @Override
    public List<MappingModel> convert(IIntegrationContext ctx) {
        return null;
    }
}

