/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIDeriveRuleContext;
import kd.fi.bcm.business.integration.di.model.DIDeriveRule;
import kd.fi.bcm.business.integration.di.service.DIDeriveRuleETLService;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.common.enums.integration.di.DiConditionEnum;
import kd.fi.bcm.common.enums.integration.di.DiDeriveRuleFieldTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class DiDeriveRuleHelper {
    public static boolean filter(DIDeriveRule rule, Object value) {
        if (rule.getConditionEnum() != null) {
            if (rule.getConditionEnum().isNonCondValue()) {
                if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC || rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                    return value == null && rule.getConditionEnum() == DiConditionEnum.NULL;
                }
                return StringUtils.isEmpty((CharSequence)((String)value)) && rule.getConditionEnum() == DiConditionEnum.NULL;
            }
            if (value == null) {
                return false;
            }
            switch (rule.getConditionEnum()) {
                case LT: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        return ((BigDecimal)value).compareTo((BigDecimal)rule.getConditionValue()) < 0;
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        return ((Long)value).compareTo((Long)rule.getConditionValue()) < 0;
                    }
                    return ((String)value).compareTo((String)rule.getConditionValue()) < 0;
                }
                case GT: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        return ((BigDecimal)value).compareTo((BigDecimal)rule.getConditionValue()) > 0;
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        return ((Long)value).compareTo((Long)rule.getConditionValue()) > 0;
                    }
                    return value.toString().compareTo((String)rule.getConditionValue()) > 0;
                }
                case GTE: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        return ((BigDecimal)value).compareTo((BigDecimal)rule.getConditionValue()) >= 0;
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        return ((Long)value).compareTo((Long)rule.getConditionValue()) >= 0;
                    }
                    return value.toString().compareTo((String)rule.getConditionValue()) >= 0;
                }
                case LTE: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        return ((BigDecimal)value).compareTo((BigDecimal)rule.getConditionValue()) <= 0;
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        return ((Long)value).compareTo((Long)rule.getConditionValue()) <= 0;
                    }
                    return value.toString().compareTo((String)rule.getConditionValue()) <= 0;
                }
                case IN: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        List conditionValues = (List)rule.getConditionValue();
                        return conditionValues.stream().anyMatch(e -> ("" + e.longValue()).equals(value));
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        List conditionValues = (List)rule.getConditionValue();
                        return conditionValues.stream().anyMatch(e -> e.equals(value));
                    }
                    List conditionValues = (List)rule.getConditionValue();
                    return conditionValues.stream().anyMatch(e -> e.equals(value));
                }
                case LIKE: {
                    return value.toString().contains((String)rule.getConditionValue());
                }
                case LLIKE: {
                    return value.toString().startsWith((String)rule.getConditionValue());
                }
                case RLIKE: {
                    return value.toString().endsWith((String)rule.getConditionValue());
                }
                case NOT_LIKE: {
                    return !value.toString().contains((String)rule.getConditionValue());
                }
                case EQUALS: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        BigDecimal conditionValue = (BigDecimal)rule.getConditionValue();
                        return conditionValue.equals(value);
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        Long conditionValue = (Long)rule.getConditionValue();
                        return conditionValue.equals(value);
                    }
                    String conditionValue = (String)rule.getConditionValue();
                    return conditionValue.equals(value.toString());
                }
                case NOT_IN: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        List conditionValues = (List)rule.getConditionValue();
                        return conditionValues.stream().noneMatch(e -> ("" + e.longValue()).equals(value));
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        List conditionValues = (List)rule.getConditionValue();
                        return conditionValues.stream().noneMatch(e -> e.equals(value));
                    }
                    List conditionValues = (List)rule.getConditionValue();
                    return conditionValues.stream().noneMatch(e -> e.equals(value));
                }
                case BETWEEN: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        List conditionValues = (List)rule.getConditionValue();
                        int start = ((BigDecimal)value).compareTo((BigDecimal)conditionValues.get(0));
                        int end = ((BigDecimal)value).compareTo((BigDecimal)conditionValues.get(1));
                        return start >= 0 && end <= 0;
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        List conditionValues = (List)rule.getConditionValue();
                        int start = ((Long)value).compareTo((Long)conditionValues.get(0));
                        int end = ((Long)value).compareTo((Long)conditionValues.get(1));
                        return start >= 0 && end <= 0;
                    }
                    List conditionValues = (List)rule.getConditionValue();
                    int start = ((String)value).compareTo((String)conditionValues.get(0));
                    int end = ((String)value).compareTo((String)conditionValues.get(1));
                    return start >= 0 && end <= 0;
                }
                case NOT_EQUALS: {
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        BigDecimal conditionValue = (BigDecimal)rule.getConditionValue();
                        return !conditionValue.equals(value);
                    }
                    if (rule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        Long conditionValue = (Long)rule.getConditionValue();
                        return !conditionValue.equals(value);
                    }
                    String conditionValue = (String)rule.getConditionValue();
                    return !conditionValue.equals(value.toString());
                }
            }
            return false;
        }
        return true;
    }

    public static int generateDeriveRuleData(long schemeId, long executeId, String tableName) {
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId).and("status", "=", (Object)"1");
        DynamicObject[] docs = BusinessDataServiceHelper.load((String)"di_deriverule", (String)"id,name,number,entryentity.basefield,entryentity.coderule,entryentity.conditontype,entryentity.conditonvalue,entryentity.coderulevalue,entryentity.fieldtype", (QFilter[])qf.toArray());
        int sum = 0;
        if (docs != null && docs.length > 0) {
            DynamicObject scheme = QueryServiceHelper.queryOne((String)"bcm_isscheme", (String)"sourceobj,datasrctype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
            boolean needTableFieldPrefix = scheme.getLong("sourceobj") != 0L && DIDataSrcTypeEnum.InServiceObj.getValue().equals(scheme.getString("datasrctype"));
            for (DynamicObject doc : docs) {
                DIDeriveRuleContext context = new DIDeriveRuleContext(doc, needTableFieldPrefix);
                context.setExecuteId(executeId);
                context.setTableName(tableName);
                DIDeriveRuleETLService service = new DIDeriveRuleETLService(context);
                sum += service.excute();
            }
        }
        return sum;
    }
}

