/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.ctx;

import java.util.List;
import java.util.Set;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowSrc;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;

public class DICompare {
    private DICompare() {
    }

    public static boolean isMatch(DIMappedRowSrc compareRow, String compareStr) {
        MapScopeEnum scope = compareRow.getScope();
        if (MapScopeEnum.EQUALS == scope) {
            return DICompare.compareEquals(compareRow.getValue(), compareStr);
        }
        if (MapScopeEnum.INCLUDE == scope) {
            return DICompare.compareInclude(compareRow.getInValue(), compareStr);
        }
        if (MapScopeEnum.LIKE == scope) {
            return DICompare.compareLike(compareRow.getValue(), compareStr);
        }
        if (MapScopeEnum.RANGE == scope) {
            return DICompare.compareBetween(compareRow.getValue(), compareStr);
        }
        if (MapScopeEnum.NOT_EQUALS == scope) {
            return !DICompare.compareEquals(compareRow.getValue(), compareStr);
        }
        if (MapScopeEnum.NOT_INCLUDE == scope) {
            return !DICompare.compareInclude(compareRow.getInValue(), compareStr);
        }
        if (MapScopeEnum.NOT_LIKE == scope) {
            return !DICompare.compareLike(compareRow.getValue(), compareStr);
        }
        if (MapScopeEnum.NOT_RANGE == scope) {
            return !DICompare.compareBetween(compareRow.getValue(), compareStr);
        }
        return false;
    }

    public static boolean compareInclude(Set<String> inValue, String compareStr) {
        return inValue.contains(compareStr);
    }

    public static boolean compareBetween(List<String> values, String compareStr) {
        String small = values.get(0);
        String big = values.get(1);
        if (big.compareTo(small) > 0) {
            return big.compareTo(compareStr) >= 0 && small.compareTo(compareStr) <= 0;
        }
        return small.compareTo(compareStr) >= 0 && big.compareTo(compareStr) <= 0;
    }

    private static boolean compareLike(List<String> values, String compareStr) {
        String valueStr = values.get(0);
        if (valueStr.startsWith("%") && valueStr.endsWith("%")) {
            return compareStr.contains(valueStr.substring(1, valueStr.length() - 1));
        }
        if (valueStr.startsWith("%")) {
            return compareStr.endsWith(valueStr.substring(1));
        }
        if (valueStr.endsWith("%")) {
            return compareStr.startsWith(valueStr.substring(0, valueStr.length() - 1));
        }
        return false;
    }

    public static boolean compareLike(String valueStr, String compareStr) {
        if (valueStr.startsWith("%") && valueStr.endsWith("%")) {
            return compareStr.contains(valueStr.substring(1, valueStr.length() - 1));
        }
        if (valueStr.startsWith("%")) {
            return compareStr.endsWith(valueStr.substring(1));
        }
        if (valueStr.endsWith("%")) {
            return compareStr.startsWith(valueStr.substring(0, valueStr.length() - 1));
        }
        return false;
    }

    private static boolean compareEquals(List<String> values, String compareStr) {
        return values.contains(compareStr);
    }
}

