/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.ctx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.ctx.DIMappedBuilder;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRow;
import kd.fi.bcm.business.integration.di.service.AbstractDIIntegrateService;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;

public class DIIntegrateContext
implements DIIIntegrateContext {
    private Pair<Long, String> model;
    private Pair<Long, String> scheme;
    private IntegrateProductEnum srcProduct;
    private Pair<Long, String> scene;
    private Pair<Long, String> currency;
    private Pair<Long, String> fy;
    private Pair<Long, String> period;
    private Pair<Long, String> org;
    private Map<String, Object> customParams;
    private Map<String, Object> mappingMap;
    private ValueList valueList;
    Class<? extends AbstractDIIntegrateService> serviceClass;

    public DIIntegrateContext(Pair<Long, String> model, Pair<Long, String> scheme, Pair<Long, String> currency, Pair<Long, String> scene, Pair<Long, String> fy, Pair<Long, String> period, Pair<Long, String> org, Class<? extends AbstractDIIntegrateService> serviceClass) {
        this.model = model;
        this.currency = currency;
        this.scene = scene;
        this.scheme = scheme;
        this.fy = fy;
        this.period = period;
        this.org = org;
        this.serviceClass = serviceClass;
        this.initEnv();
    }

    private void initEnv() {
        this.customParams = new HashMap<String, Object>();
    }

    @Override
    public Pair<Long, String> getSchema() {
        return this.scheme;
    }

    @Override
    public Pair<Long, String> getCurrency() {
        return this.currency;
    }

    @Override
    public Pair<Long, String> getScene() {
        return this.scene;
    }

    @Override
    public Pair<Long, String> getFy() {
        return this.fy;
    }

    @Override
    public Pair<Long, String> getPeriod() {
        return this.period;
    }

    @Override
    public Pair<Long, String> getOrg() {
        return this.org;
    }

    @Override
    public Pair<Long, String> getModel() {
        return this.model;
    }

    @Override
    public <T> T getCustomParam(String key) {
        return (T)this.customParams.get(key);
    }

    @Override
    public <T> void putCustomParam(String key, T val) {
        this.customParams.put(key, val);
    }

    @Override
    public ValueList getValueList() {
        return this.valueList == null ? new ValueList() : this.valueList;
    }

    @Override
    public void setValueList(ValueList values) {
        this.valueList = values;
    }

    public void setOrg(Pair<Long, String> org) {
        this.org = org;
    }

    public void setCurrency(Pair<Long, String> currency) {
        this.currency = currency;
    }

    private Map<String, Object> getMappingMap() {
        if (this.mappingMap == null) {
            this.mappingMap = new DIMappedBuilder().getAllMapping(this.model, this.scheme);
        }
        return this.mappingMap;
    }

    @Override
    public Map<String, List<String>> getDefMapping() {
        return (Map)this.getMappingMap().get("defMapping");
    }

    @Override
    public List<DIMappedRow> getCombineMapping() {
        return ((Map)this.getMappingMap().get("allMapping")).get("CombMapping") == null ? new ArrayList<DIMappedRow>(1) : (List)((Map)this.getMappingMap().get("allMapping")).get("CombMapping");
    }

    @Override
    public List<DIMappedRow> getSpecialCombMapping() {
        return ((Map)this.getMappingMap().get("allMapping")).get("SpecialCombMapping") == null ? new ArrayList<DIMappedRow>(1) : (List)((Map)this.getMappingMap().get("allMapping")).get("SpecialCombMapping");
    }

    @Override
    public Set<String> getAllSrcDim() {
        return (Set)this.getMappingMap().get("allSrcDim");
    }

    @Override
    public Set<String> getAllTarDim() {
        return (Set)this.getMappingMap().get("allTarDim");
    }

    @Override
    public Map<String, String> getSingleDimMapExtend() {
        return (Map)this.getMappingMap().get("singleDimMapExtend");
    }

    @Override
    public Set<String> getTarDimFromComb() {
        return (Set)this.getMappingMap().get("tarDimFromComb");
    }

    @Override
    public List<DIMappedRow> getSimpleMappingByKey(String key) {
        return (List)((Map)this.getMappingMap().get("allMapping")).get(key);
    }

    @Override
    public Map<Integer, Object> getSimpleMappingIndexByKey(String key) {
        return (Map)((Map)this.getMappingMap().get("mappingIndex")).get(key);
    }

    @Override
    public Map<Long, String> getDimIndexByKey(String key) {
        return (Map)((Map)this.getMappingMap().get("dimIndex")).get(key);
    }

    @Override
    public void clearCombineMapping() {
        ((Map)this.getMappingMap().get("allMapping")).put("CombMapping", null);
    }

    @Override
    public void clearSimpleMapping(String key) {
        ((Map)this.getMappingMap().get("allMapping")).put(key, null);
    }

    @Override
    public void clearSimpleMapping() {
        Map allMapping = (Map)this.getMappingMap().get("allMapping");
        for (Map.Entry map : allMapping.entrySet()) {
            if ("CombMapping".equals(map.getKey())) continue;
            allMapping.remove(map.getKey());
        }
    }

    @Override
    public void clearAllMapping() {
        this.mappingMap = null;
    }

    @Override
    public IntegrateProductEnum getSrcProduct() {
        if (this.srcProduct == null) {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)this.scheme.p1, (String)"bcm_isscheme", (String)"issrc.number");
            this.srcProduct = IntegrateProductEnum.getEnumByNumber((String)dyn.getString("issrc.number"));
        }
        return this.srcProduct;
    }

    @Override
    public Class<? extends AbstractDIIntegrateService> getServiceClass() {
        return this.serviceClass;
    }
}

