/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.ctx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRow;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowSrc;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowTar;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class DIMappedBuilder {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(DIMappedBuilder.class);
    private boolean isNotUseIndexCode = ConfigServiceHelper.getGlobalBoolParam("IntegrationUserIndexcode");

    public Map<String, Object> getAllMapping(Pair<Long, String> model, Pair<Long, String> scheme) {
        return (Map)GlobalCacheServiceHelper.getOrLoadNodeFixKey((String)((String)model.p2 + "|" + (String)scheme.p2 + "|combine"), () -> this.getAllMapping((Long)scheme.p1));
    }

    private Map<String, Object> getAllMapping(Long schemeId) {
        HashMap<String, Object> mappingMap = new HashMap<String, Object>();
        HashMap<String, Map<Integer, Map<Long, Object>>> mappingIndex = new HashMap<String, Map<Integer, Map<Long, Object>>>();
        HashMap<String, Map<Long, String>> dimIndex = new HashMap<String, Map<Long, String>>();
        HashMap<String, List<String>> defMap = new HashMap<String, List<String>>(16);
        HashMap<String, List<DIMappedRow>> allMapping = new HashMap<String, List<DIMappedRow>>(16);
        HashSet<String> allSrcDim = new HashSet<String>(16);
        HashSet<String> allTarDim = new HashSet<String>(16);
        HashSet<String> tarDimFromComb = new HashSet<String>(16);
        HashMap<String, String> singleDimMapExtend = new HashMap<String, String>(16);
        mappingMap.put("defMapping", defMap);
        mappingMap.put("allMapping", allMapping);
        mappingMap.put("mappingIndex", mappingIndex);
        mappingMap.put("dimIndex", dimIndex);
        mappingMap.put("allSrcDim", allSrcDim);
        mappingMap.put("allTarDim", allTarDim);
        mappingMap.put("tarDimFromComb", tarDimFromComb);
        mappingMap.put("singleDimMapExtend", singleDimMapExtend);
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObject[] dimMapping = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, number, tagdimension, tagdimtype, srcdimension, srcdimtype, mappedtype, targetmemnum, tagmemb,datatype, inheritancescheme", (QFilter[])new QFilter[]{schemeQf}, (String)"mappedtype,priority");
        int mappedType = 0;
        for (DynamicObject dyna : dimMapping) {
            mappedType = dyna.getInt("mappedtype");
            if (mappedType == 2) {
                this.getTarDefMapping(defMap, dyna);
            } else if (mappedType == 4 || mappedType == 5 || mappedType == 6) {
                this.getCombineMapping(dyna, schemeId, null, mappedType, allMapping, mappingIndex);
                this.handleInherit(dyna, mappedType, allMapping, mappingIndex);
            }
            if (StringUtils.isNotEmpty((CharSequence)dyna.getString("datatype"))) {
                this.addSingleDimMapExtend(singleDimMapExtend, dyna.getString("number"));
            }
            String number = dyna.getString("number");
            this.addAllTarDim(allTarDim, number);
            this.addAllSrcDim(allSrcDim, number);
            this.addDimIndex(dimIndex, number, dyna.getLong("id"), mappedType);
            if (mappedType != 4) continue;
            this.addAllTarDim(tarDimFromComb, number);
        }
        return mappingMap;
    }

    private void handleInherit(DynamicObject dyna, int mappedType, Map<String, List<DIMappedRow>> allMapping, Map<String, Map<Integer, Map<Long, Object>>> mappingIndex) {
        QFilter numberQf;
        DynamicObject inheritancescheme = dyna.getDynamicObject("inheritancescheme");
        if (inheritancescheme == null) {
            return;
        }
        String number = dyna.getString("number");
        Long inheritSchemeId = inheritancescheme.getLong("id");
        QFilter schemeQf = new QFilter("scheme", "=", (Object)inheritSchemeId);
        DynamicObject[] dimMapping = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id, number, tagdimension, tagdimtype, srcdimension, srcdimtype, mappedtype, targetmemnum, tagmemb,datatype", (QFilter[])new QFilter[]{schemeQf, numberQf = new QFilter("number", "=", (Object)number)}, (String)"mappedtype,priority");
        if (dimMapping == null || dimMapping.length == 0) {
            return;
        }
        this.getCombineMapping(dimMapping[0], inheritSchemeId, dyna.getLong("id"), mappedType, allMapping, mappingIndex);
    }

    private void addDimIndex(Map<String, Map<Long, String>> dimIndex, String number, long id, int mappedType) {
        String[] split = number.split("-");
        if (split.length < 2) {
            return;
        }
        String dimKey = "CombMapping";
        if (mappedType == 5) {
            dimKey = split[0];
        }
        Map map = dimIndex.computeIfAbsent(dimKey, e -> new HashMap());
        map.put(id, split[1].split(",")[0]);
    }

    private void addSingleDimMapExtend(Map<String, String> singleDimMapExtend, String number) {
        String[] dimMappingArr = number.split("-");
        if (dimMappingArr.length > 1) {
            singleDimMapExtend.put(dimMappingArr[0], dimMappingArr[1]);
        }
    }

    private void addAllSrcDim(Set<String> allSrcDim, String number) {
        String[] dimMappingArr = number.split("-");
        if (dimMappingArr.length > 1) {
            String[] dimNumberArr;
            for (String str : dimNumberArr = dimMappingArr[1].split(",")) {
                allSrcDim.add(str);
            }
        }
    }

    private void addAllTarDim(Set<String> allTarDim, String number) {
        String[] dimMappingArr = number.split("-");
        if (dimMappingArr.length > 0) {
            String[] dimNumberArr;
            for (String str : dimNumberArr = dimMappingArr[0].split(",")) {
                allTarDim.add(str);
            }
        }
    }

    private void getCombineMapping(DynamicObject dyna, Long schemeId, Long indexDimmapId, int mappedType, Map<String, List<DIMappedRow>> allMapping, Map<String, Map<Integer, Map<Long, Object>>> mappingIndex) {
        HashMap<Long, String> tarInfoMap = new HashMap<Long, String>(16);
        Map<Long, String> srcInfoMap = this.getSrcInfoMap(schemeId);
        Long dimmapid = dyna.getLong("id");
        QFilter schemeQf = new QFilter("dimmapid", "=", (Object)dimmapid);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isgroupmap", (String)"id,srctype,order,weight,computeoprt,tardimension,tarmembnumber,scope,srcdimension,srcmembnumber", (QFilter[])new QFilter[]{schemeQf}, (String)"level,order,isgroupsrcmapentry.seq");
        DynamicObjectCollection isgroupsrcmapentry = null;
        DynamicObjectCollection isgrouptargmapentry = null;
        Pair<List<DIMappedRow>, Map<Integer, Map<Long, Object>>> mappedInfo = this.getMappedRow(dyna, allMapping, mappingIndex, mappedType);
        List mappedRow = (List)mappedInfo.p1;
        Map indexMap = (Map)mappedInfo.p2;
        String indexKey = this.getIndexKey(dyna);
        Long groupMapId = 0L;
        DIMappedRow mr = null;
        ArrayList<DIMappedRowSrc> srcMappedRow = null;
        ArrayList<DIMappedRowTar> tarMappedRow = null;
        DIMappedRowSrc mrs = null;
        DIMappedRowTar mrt = null;
        HashMap<String, DIMappedRowSrc> srcDimNumberMap = new HashMap<String, DIMappedRowSrc>();
        HashMap<String, Map<String, Object>> betweenMarkMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> inMarkMap = new HashMap<String, Map<String, Object>>();
        HashSet<String> checkIndexKeySet = new HashSet<String>(16);
        String srcDimNumber = null;
        String srcmembnumber = null;
        for (DynamicObject obj : load) {
            srcDimNumberMap.clear();
            betweenMarkMap.clear();
            inMarkMap.clear();
            checkIndexKeySet.clear();
            groupMapId = obj.getLong("id");
            mr = new DIMappedRow();
            mr.setId(groupMapId);
            mr.setOrder(obj.getInt("order"));
            mr.setNegate("-1".equals(obj.getString("computeoprt")));
            mr.setWeight(Double.valueOf(StringUtils.isEmpty((CharSequence)obj.getString("weight")) ? "1" : obj.getString("weight")));
            mappedRow.add(mr);
            srcMappedRow = new ArrayList<DIMappedRowSrc>();
            tarMappedRow = new ArrayList<DIMappedRowTar>();
            mr.setSrcMappedRow(srcMappedRow);
            mr.setTarMappedRow(tarMappedRow);
            isgroupsrcmapentry = obj.getDynamicObjectCollection("isgroupsrcmapentry");
            for (DynamicObject srcObj : isgroupsrcmapentry) {
                srcDimNumber = srcInfoMap.get(srcObj.getLong("srcdimension"));
                checkIndexKeySet.add(srcDimNumber);
                int scope = srcObj.getInt("scope");
                if (!srcDimNumberMap.containsKey(srcDimNumber)) {
                    mrs = new DIMappedRowSrc();
                    srcMappedRow.add(mrs);
                    mrs.setScope(MapScopeEnum.getEnumByindex((int)scope));
                    mrs.setKey(srcDimNumber);
                    srcDimNumberMap.put(srcDimNumber, mrs);
                }
                srcmembnumber = srcObj.getString("srcmembnumber");
                ((DIMappedRowSrc)srcDimNumberMap.get(srcDimNumber)).addValue(srcmembnumber);
                if (MapScopeEnum.INCLUDE == MapScopeEnum.getEnumByindex((int)scope) || MapScopeEnum.NOT_INCLUDE == MapScopeEnum.getEnumByindex((int)scope)) {
                    ((DIMappedRowSrc)srcDimNumberMap.get(srcDimNumber)).addInValue(srcmembnumber);
                }
                if (this.isNotUseIndexCode) continue;
                this.addIndexMap(indexKey, srcDimNumber, indexMap, scope, srcmembnumber, groupMapId, indexDimmapId == null ? dimmapid : indexDimmapId, betweenMarkMap, inMarkMap);
            }
            if (!this.isNotUseIndexCode) {
                this.addIndexMapWhenEmpty(checkIndexKeySet.contains(indexKey), indexMap, indexDimmapId == null ? dimmapid : indexDimmapId, groupMapId);
            }
            isgrouptargmapentry = obj.getDynamicObjectCollection("isgrouptargmapentry");
            for (DynamicObject tarObj : isgrouptargmapentry) {
                mrt = new DIMappedRowTar();
                mrt.setKey(this.getTarKey(tarInfoMap, tarObj.getLong("tardimension")));
                mrt.setValue(tarObj.getString("tarmembnumber"));
                tarMappedRow.add(mrt);
            }
        }
    }

    private void addIndexMapWhenEmpty(boolean contains, Map<Integer, Map<Long, Object>> indexMap, Long dimmapid, Long groupMapId) {
        if (!contains) {
            Map keyMap = indexMap.computeIfAbsent(1, e -> new HashMap());
            Map dimmapMap = (Map)keyMap.computeIfAbsent(dimmapid, e -> new HashMap());
            Set valueSet = dimmapMap.computeIfAbsent("*", e -> new HashSet());
            valueSet.add(groupMapId);
        }
    }

    private void addIndexMap(String indexKey, String srcDimNumber, Map<Integer, Map<Long, Object>> indexMap, int scope, String srcmembnumber, Long groupMapId, Long dimmapid, Map<String, Map<String, Object>> betweenMarkMap, Map<String, Map<String, Object>> inMarkMap) {
        if (indexKey.equals(srcDimNumber)) {
            if (scope == 1 || scope == 4) {
                Map keyMap = indexMap.computeIfAbsent(1, e -> new HashMap());
                Map dimmapMap = (Map)keyMap.computeIfAbsent(dimmapid, e -> new HashMap());
                Set valueSet = dimmapMap.computeIfAbsent(srcmembnumber, e -> new HashSet());
                valueSet.add(groupMapId);
            } else if (scope == 5) {
                Map keyMap = indexMap.computeIfAbsent(5, e -> new HashMap());
                List dimmapList = (List)keyMap.computeIfAbsent(dimmapid, e -> new ArrayList());
                HashMap<String, Object> dimmap = new HashMap<String, Object>();
                dimmap.put("key", srcmembnumber);
                dimmap.put("value", groupMapId);
                dimmapList.add(dimmap);
            } else if (scope == 3 || scope == 7) {
                Map keyMap = indexMap.computeIfAbsent(scope, e -> new HashMap());
                List dimmapList = (List)keyMap.computeIfAbsent(dimmapid, e -> new ArrayList());
                HashMap<String, Object> dimmap = new HashMap<String, Object>();
                dimmap.put("key", srcmembnumber);
                dimmap.put("value", groupMapId);
                dimmapList.add(dimmap);
            } else if (scope == 2 || scope == 6) {
                Map keyMap = indexMap.computeIfAbsent(scope, e -> new HashMap());
                List dimmapList = (List)keyMap.computeIfAbsent(dimmapid, e -> new ArrayList());
                Map<String, Object> dimmap = betweenMarkMap.get(srcDimNumber);
                if (dimmap == null) {
                    dimmap = new HashMap<String, Object>();
                    ArrayList<String> betweenList = new ArrayList<String>(2);
                    betweenList.add(srcmembnumber);
                    dimmap.put("key", betweenList);
                    dimmap.put("value", groupMapId);
                    betweenMarkMap.put(srcDimNumber, dimmap);
                    dimmapList.add(dimmap);
                } else {
                    List betweenList = (List)dimmap.get("key");
                    betweenList.add(srcmembnumber);
                }
            } else if (scope == 8) {
                Map keyMap = indexMap.computeIfAbsent(8, e -> new HashMap());
                List dimmapList = (List)keyMap.computeIfAbsent(dimmapid, e -> new ArrayList());
                Map<String, Object> dimmap = inMarkMap.get(srcDimNumber);
                if (dimmap == null) {
                    dimmap = new HashMap<String, Object>();
                    HashSet<String> inSet = new HashSet<String>();
                    inSet.add(srcmembnumber);
                    dimmap.put("key", inSet);
                    dimmap.put("value", groupMapId);
                    inMarkMap.put(srcDimNumber, dimmap);
                    dimmapList.add(dimmap);
                } else {
                    Set inSet = (Set)dimmap.get("key");
                    inSet.add(srcmembnumber);
                }
            }
        }
    }

    private String getIndexKey(DynamicObject dyna) {
        String number = dyna.getString("number");
        String[] split = number.split("-");
        if (split.length < 2) {
            return null;
        }
        return number.split("-")[1].split(",")[0];
    }

    private String getTarKey(Map<Long, String> tarInfoMap, Long id) {
        if (!tarInfoMap.containsKey(id)) {
            String number = MemberReader.getDimensionNumById((long)id);
            tarInfoMap.put(id, number);
        }
        return tarInfoMap.get(id);
    }

    private Pair<List<DIMappedRow>, Map<Integer, Map<Long, Object>>> getMappedRow(DynamicObject dyna, Map<String, List<DIMappedRow>> allMapping, Map<String, Map<Integer, Map<Long, Object>>> mappingIndex, int mappedType) {
        if (mappedType == 4) {
            return Pair.onePair((Object)allMapping.computeIfAbsent("CombMapping", e -> new ArrayList()), (Object)mappingIndex.computeIfAbsent("CombMapping", e -> new HashMap()));
        }
        if (mappedType == 5) {
            return this.getMappedRowByTarNumber(dyna, allMapping, mappingIndex);
        }
        if (mappedType == 6) {
            return Pair.onePair((Object)allMapping.computeIfAbsent("SpecialCombMapping", e -> new ArrayList()), (Object)mappingIndex.computeIfAbsent("SpecialCombMapping", e -> new HashMap()));
        }
        return Pair.onePair(new ArrayList(), new HashMap());
    }

    private Pair<List<DIMappedRow>, Map<Integer, Map<Long, Object>>> getMappedRowByTarNumber(DynamicObject dyna, Map<String, List<DIMappedRow>> allMapping, Map<String, Map<Integer, Map<Long, Object>>> mappingIndex) {
        DynamicObjectCollection objs = dyna.getDynamicObjectCollection("isdimmaptargentry");
        if (objs != null && objs.size() > 0) {
            String key = ((DynamicObject)objs.get(0)).getDynamicObject("tagdimension").getString("number");
            return Pair.onePair((Object)allMapping.computeIfAbsent(key, e -> new ArrayList()), (Object)mappingIndex.computeIfAbsent(key, e -> new HashMap()));
        }
        return null;
    }

    private Map<Long, String> getSrcInfoMap(Long schemeId) {
        HashMap<Long, String> srcInfoMap = new HashMap<Long, String>();
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"id,number", (QFilter[])new QFilter[]{schemeQf});
        for (DynamicObject obj : query) {
            srcInfoMap.put(obj.getLong("id"), obj.getString("number"));
        }
        return srcInfoMap;
    }

    private void getTarDefMapping(Map<String, List<String>> defMap, DynamicObject dimMapping) {
        DynamicObjectCollection dimMappingItem = dimMapping.getDynamicObjectCollection("isdimmaptargentry");
        for (DynamicObject item : dimMappingItem) {
            List defList = defMap.computeIfAbsent(item.getString("tagdimension.number"), e -> new ArrayList());
            DynamicObjectCollection itemValue = item.getDynamicObjectCollection("isdimmaptargdefval");
            for (DynamicObject itemObj : itemValue) {
                defList.add(itemObj.getString("targetmemnum"));
            }
        }
    }
}

