/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.model;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.common.enums.integration.di.DIRuleEnum;
import kd.fi.bcm.common.enums.integration.di.DiConditionEnum;
import kd.fi.bcm.common.enums.integration.di.DiDeriveRuleFieldTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class DIDeriveRule {
    public static final String MULIT_VALUE_SPLIT = ",";
    private String fieldName;
    private DiDeriveRuleFieldTypeEnum fieldTypeEnum;
    private DiConditionEnum conditionEnum;
    private Object conditionValue;
    private DIRuleEnum codeRuleEnum;
    private String codeRuleValue;

    public static List<DIDeriveRule> transform(DynamicObjectCollection rule, String prefix) {
        return rule.stream().map(e -> {
            DIDeriveRule diDeriveRule = new DIDeriveRule();
            diDeriveRule.setFieldName(prefix + e.getString("basefield.number"));
            diDeriveRule.setCodeRuleEnum(DIRuleEnum.getEnumByCode((String)e.getString("coderule")));
            diDeriveRule.setConditionEnum(DiConditionEnum.getEnumByCode((String)e.getString("conditontype")));
            diDeriveRule.setCodeRuleValue(e.getString("coderulevalue"));
            diDeriveRule.setFieldTypeEnum(DiDeriveRuleFieldTypeEnum.getEnumByCode((String)e.getString("fieldtype")));
            if (diDeriveRule.getConditionEnum() != null) {
                if (diDeriveRule.getConditionEnum().isSingleCondValue()) {
                    if (diDeriveRule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        diDeriveRule.setConditionValue(new BigDecimal(e.getString("conditonvalue")));
                    } else if (diDeriveRule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        diDeriveRule.setConditionValue(Long.parseLong(e.getString("conditonvalue")));
                    } else {
                        diDeriveRule.setConditionValue(e.getString("conditonvalue"));
                    }
                } else if (diDeriveRule.getConditionEnum().isMultiCondValue()) {
                    String[] conditonvalues = e.getString("conditonvalue").split(MULIT_VALUE_SPLIT);
                    if (diDeriveRule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.NUMBERIC) {
                        diDeriveRule.setConditionValue(Arrays.stream(conditonvalues).filter(a -> StringUtils.isNotEmpty((CharSequence)a)).map(a -> new BigDecimal((String)a)).collect(Collectors.toList()));
                    } else if (diDeriveRule.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.INT) {
                        diDeriveRule.setConditionValue(Arrays.stream(conditonvalues).filter(a -> StringUtils.isNotEmpty((CharSequence)a)).map(a -> Long.parseLong(a)).collect(Collectors.toList()));
                    } else {
                        diDeriveRule.setConditionValue(Arrays.stream(conditonvalues).collect(Collectors.toList()));
                    }
                }
            }
            return diDeriveRule;
        }).collect(Collectors.toList());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName.toLowerCase(Locale.ENGLISH);
    }

    public DiDeriveRuleFieldTypeEnum getFieldTypeEnum() {
        return this.fieldTypeEnum;
    }

    public void setFieldTypeEnum(DiDeriveRuleFieldTypeEnum fieldTypeEnum) {
        this.fieldTypeEnum = fieldTypeEnum;
    }

    public DiConditionEnum getConditionEnum() {
        return this.conditionEnum;
    }

    public void setConditionEnum(DiConditionEnum conditionEnum) {
        this.conditionEnum = conditionEnum;
    }

    public Object getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(Object conditionValue) {
        this.conditionValue = conditionValue;
    }

    public DIRuleEnum getCodeRuleEnum() {
        return this.codeRuleEnum;
    }

    public void setCodeRuleEnum(DIRuleEnum codeRuleEnum) {
        this.codeRuleEnum = codeRuleEnum;
    }

    public String getCodeRuleValue() {
        return this.codeRuleValue;
    }

    public void setCodeRuleValue(String codeRuleValue) {
        this.codeRuleValue = codeRuleValue;
    }
}

