/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.mq.consumer;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.fi.bcm.business.allinone.service.thread.IRunner;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.integration.di.ctx.DIIntegrateContext;
import kd.fi.bcm.business.integration.di.service.DIIntegrationService;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IConsumer;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class DIIntegrationBatConsumer
implements IConsumer {
    private static final Log LOG = LogFactory.getLog(DIIntegrationBatConsumer.class);

    public void onMessage(MQMessage message, String messageId, boolean resend, MessageAcker acker) {
        Map messageBody = message.getSendMessage();
        String mqMapStr = (String)messageBody.get("mqMap");
        LOG.info("DIIntegrationBatConsumer consume message: " + messageId + " mqMap: " + mqMapStr);
        Map mqMap = (Map)ObjectSerialUtil.deSerializedBytes((String)mqMapStr);
        Map contentMap = (Map)mqMap.get("contentMap");
        DIIntegrateContext context = new DIIntegrateContext((Pair<Long, String>)Pair.onePair((Object)((Long)contentMap.get("modelId")), (Object)((String)contentMap.get("modelName"))), (Pair<Long, String>)Pair.onePair((Object)((Long)contentMap.get("schemeId")), (Object)((String)contentMap.get("schemeName"))), (Pair<Long, String>)Pair.onePair((Object)((Long)contentMap.get("currencyId")), (Object)((String)contentMap.get("currencyName"))), (Pair<Long, String>)Pair.onePair((Object)((Long)contentMap.get("sceneId")), (Object)((String)contentMap.get("sceneName"))), (Pair<Long, String>)Pair.onePair((Object)((Long)contentMap.get("fyId")), (Object)((String)contentMap.get("fyName"))), (Pair<Long, String>)Pair.onePair((Object)((Long)contentMap.get("periodId")), (Object)((String)contentMap.get("periodName"))), (Pair<Long, String>)Pair.onePair((Object)((Long)contentMap.get("orgId")), (Object)((String)contentMap.get("orgName"))), null);
        Map paramMap = (Map)mqMap.get("paramMap");
        context.putCustomParam("singlemetric", paramMap.get("singlemetric"));
        context.putCustomParam("textfield", paramMap.get("textfield"));
        context.putCustomParam("executeId", paramMap.get("executeId"));
        while (this.checkIsTooMuch()) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                LOG.error("DIIntegrationBatConsumer consume error", (Throwable)e);
            }
        }
        IRunner runner = () -> new DIIntegrationService(context).dohand((Integer)paramMap.get("offset"), (String)paramMap.get("mark"), (Integer)paramMap.get("batchNumber"));
        ThreadPoolService.runInIntegrateBatThread(runner);
    }

    private boolean checkIsTooMuch() {
        String configSize = ConfigServiceHelper.getStringParamNoModel("IntegrationLineSize");
        if (StringUtils.isEmpty((CharSequence)configSize) || Integer.parseInt(configSize) < 0) {
            return false;
        }
        ThreadPoolExecutor integrateTreadPool = ThreadPoolService.getTreadPoolByName("bcm_Integrate-detail_bat");
        return integrateTreadPool.getPoolSize() > Integer.parseInt(configSize);
    }
}

