/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.mq.consumer;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.integration.di.service.DIIntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IConsumer;
import kd.fi.bcm.common.util.ObjectSerialUtil;

public class DIIntegrationConsumer
implements IConsumer {
    private static final Log LOG = LogFactory.getLog(DIIntegrationConsumer.class);

    public void onMessage(MQMessage message, String messageId, boolean resend, MessageAcker acker) {
        Map messageBody = message.getSendMessage();
        String intEntityStr = (String)messageBody.get("intEntity");
        LOG.info("DataTraceFrom consume message: " + messageId + " intEntity: " + intEntityStr);
        IntegrateEntity intEntity = (IntegrateEntity)ObjectSerialUtil.deSerializedBytes((String)intEntityStr);
        while (this.checkIsTooMuch()) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                LOG.error("DataTraceFrom consume error", (Throwable)e);
            }
        }
        DIIntegrateDispatcher2.submitTaskConsume(intEntity);
    }

    private boolean checkIsTooMuch() {
        String configSize = ConfigServiceHelper.getStringParamNoModel("IntegrationLineSize");
        if (StringUtils.isEmpty((CharSequence)configSize) || Integer.parseInt(configSize) < 0) {
            return false;
        }
        ThreadPoolExecutor integrateTreadPool = ThreadPoolService.getTreadPoolByName("bcm_Integrate-detail");
        return integrateTreadPool.getPoolSize() > Integer.parseInt(configSize);
    }
}

