/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.output;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.cache.MemberReader;

public abstract class AbstractDIOutput
implements IOutput {
    protected DIIIntegrateContext _ctx;
    protected List<String> dimNumbers;
    private Map<String, Integer> dimIndexMap;
    protected static final String LOCK_DIM = "lockDim";

    public AbstractDIOutput(DIIIntegrateContext ctx) {
        this._ctx = ctx;
    }

    @Override
    public void output() {
        this.beforeOutput();
        this.doOutput();
        this.afterOutput();
    }

    protected void beforeOutput() {
        this.dimNumbers = new ArrayList(MemberReader.getDimensionShortNumber2NumberMap((String)((String)this._ctx.getModel().p2)).values());
        this.dimIndexMap = new HashMap<String, Integer>(this.dimNumbers.size());
        for (int i = 0; i < this.dimNumbers.size(); ++i) {
            this.dimIndexMap.put(this.dimNumbers.get(i), i);
        }
        this._ctx.putCustomParam(LOCK_DIM, IntegrationUtil.getLockDim((Long)this._ctx.getModel().p1));
    }

    protected abstract void doOutput();

    protected void afterOutput() {
    }

    protected int getDimIndex(String number) {
        return this.dimIndexMap.get(number);
    }

    protected Set<String> getAutoCvts(String orgNum, String scenarioNum, String yearNum, String periodNum) {
        return (Set)ThreadCache.get((Object)(orgNum + "|" + scenarioNum + "|" + yearNum + "|" + periodNum), () -> {
            Set<String> currencys = ConvertServiceHelper.getAutoPCByOrgNum((String)this._ctx.getModel().p2, orgNum, scenarioNum, yearNum, periodNum);
            String orgEC = MemberReader.findEntityMemberByNum((String)((String)this._ctx.getModel().p2), (String)orgNum).getCurrency();
            currencys.remove(orgEC);
            return currencys;
        });
    }
}

