/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.output;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.output.AbstractDIOutput;
import kd.fi.bcm.business.integrationnew.model.value.IValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.integration.ISImpModeEnum;
import kd.fi.bcm.common.enums.integration.di.DIOlapDescEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class DIExtendIntegrateOutPut
extends AbstractDIOutput {
    private String extendDataEntity = "bcm_extenddata";
    private ExtendsModel extendsModel;
    private List<String> fixDims;
    private boolean isMerge = false;
    private List<Object[]> errorValues;
    private List<String> idNews;
    private String modelNumber;
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIExtendIntegrateOutPut.class);

    public DIExtendIntegrateOutPut(DIIIntegrateContext ctx) {
        super(ctx);
    }

    @Override
    protected void beforeOutput() {
        super.beforeOutput();
        this.extendsModel = (ExtendsModel)this._ctx.getCustomParam("extendModel");
        if (ExtendDimGroupType.TRANSACTION.getIndex().equals(this.extendsModel.getExtendsGroupType())) {
            this.extendDataEntity = "bcm_extenddata_bus";
        }
        this.fixDims = Lists.newArrayList((Object[])new String[]{"Entity", "Scenario", "Year", "Period", "Currency", "Process"});
        this.isMerge = this.checkMerge();
        this.errorValues = new ArrayList<Object[]>(10);
        this.idNews = new ArrayList<String>(10);
        this.modelNumber = MemberReader.findModelSNumberById((Object)this._ctx.getModel().p1);
    }

    private Collection<Pair<List<String>, List<Map<String, Object>>>> groupDataWithFixDim(ValueList valueList) {
        HashMap<String, Pair> data = new HashMap<String, Pair>(16);
        for (IValueItem valueItem : valueList.getValueList()) {
            List collect = this.fixDims.stream().map(e -> (String)valueItem.getProperty((String)e)).collect(Collectors.toList());
            String key = String.join((CharSequence)"|", collect);
            ((List)data.computeIfAbsent(key, (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$groupDataWithFixDim$1(java.util.List java.lang.String ), (Ljava/lang/String;)Lkd/fi/bcm/common/Pair;)(collect)).p2).add(((ValueItem)valueItem).getProperties());
        }
        return data.values();
    }

    @Override
    protected void doOutput() {
        ValueList valueList = this._ctx.getValueList();
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        log.startWatch();
        StringBuilder logMsg = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.saveData(sw, logMsg, valueList);
                String outputSpend = this._ctx.getCustomParam("spendTimeMessage") == null ? "" : (String)this._ctx.getCustomParam("spendTimeMessage");
                this._ctx.putCustomParam("spendTimeMessage", logMsg.append(outputSpend).toString());
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
            if (!this.errorValues.isEmpty()) {
                this._ctx.putCustomParam("complete", "complete");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f\uff0c\u5b58\u5728\u9519\u8bef\u6570\u636e\uff1a%s\u3002", (String)"DIExtendIntegrateOutPut_1", (String)"fi-bcm-business", (Object[])new Object[0]), JSON.toJSONString(this.errorValues)));
            }
        }
        sw.stop();
    }

    private Map<String, String> getTrgDefValues() {
        HashMap<String, String> trgDefValues = new HashMap<String, String>(3);
        this._ctx.getDefMapping().forEach((dimNumber, members) -> {
            if ("AuditTrail".equals(dimNumber) || "Scenario".equals(dimNumber)) {
                trgDefValues.put((String)dimNumber, (String)members.get(0));
            }
        });
        return trgDefValues;
    }

    private void saveData(StopWatch sw, StringBuilder logMsg, ValueList resultSet) {
        Map<String, String> trgDefValues = this.getTrgDefValues();
        Set<String> uniqueKeySet = this.checkUnique();
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u8f93\u51fa\u9884\u5904\u7406\u8017\u65f6:", (String)"DIExtendIntegrateOutPut_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        log.info(String.format("XExtendOutPut-[%s] processed data size:%s", this._ctx.getSchema().p2, resultSet.getValueList().size()));
        Collection<Pair<List<String>, List<Map<String, Object>>>> datas = this.groupDataWithFixDim(resultSet);
        Map<String, String> userDefDim2Mapped = DimensionServiceHelper.getUserDefineDimensionNameAndMapByModel(this._ctx.getModel().p1, false);
        Map<String, String> extField2Mapped = this.extendsModel.getExtFieldEntry().stream().collect(Collectors.toMap(e -> e.getExtField().getNumber(), v -> v.getExtField().getMapped()));
        block0: for (Pair<List<String>, List<Map<String, Object>>> pair : datas) {
            HashMap<String, String> fixDim = new HashMap<String, String>(8);
            List datalist = (List)pair.p2;
            for (int i = 0; i < this.fixDims.size(); ++i) {
                String value = (String)((List)pair.p1).get(i);
                if ("Currency".equals(this.fixDims.get(i)) && ("EC".equals(value) || "DC".equals(value))) {
                    value = MemberReader.findEntityMemberByNum((String)((String)this._ctx.getModel().p2), (String)((String)this._ctx.getOrg().p2)).getCurrency();
                    Set<String> autoCvts = this.getAutoCvts((String)((List)pair.p1).get(0), (String)((List)pair.p1).get(1), (String)((List)pair.p1).get(2), (String)((List)pair.p1).get(3));
                    if (autoCvts.contains(value)) {
                        datalist.forEach(e -> this.idNews.add(e.get("idnew").toString()));
                        continue block0;
                    }
                }
                fixDim.put(this.fixDims.get(i), value);
            }
            fixDim.putAll(trgDefValues);
            this.removeOldData(uniqueKeySet, userDefDim2Mapped, extField2Mapped, fixDim, datalist);
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u6e05\u6570\u8017\u65f6[%s]:", (String)"DIExtendIntegrateOutPut_3", (String)"fi-bcm-business", (Object[])new Object[]{((Object)fixDim).toString()}));
            this.saveEDInfo(fixDim, datalist, extField2Mapped);
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u4fdd\u5b58\u62d3\u5c55\u6570\u636e\u8017\u65f6[%s]:", (String)"DIExtendIntegrateOutPut_4", (String)"fi-bcm-business", (Object[])new Object[]{((Object)fixDim).toString()}));
        }
        if (!this.idNews.isEmpty()) {
            String sql = String.format("update %s set folapstatus=?,fmsg=? where fidnew in(%s)", this._ctx.getCustomParam("convertTable").toString(), String.join((CharSequence)",", this.idNews));
            DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{"0", DIOlapDescEnum.EXTEND_UNIQUE.getIndex()});
        }
    }

    private void saveEDInfo(Map<String, String> fixDim, List<Map<String, Object>> datalist, Map<String, String> extField2Mapped) {
        EDSaveComInfo eci = new EDSaveComInfo(this.modelNumber, this.extendsModel.getExtendsGroupNumber(), this.extendsModel.getNumber());
        eci.setIgnoreuniquevalue(true);
        eci.setFixDim(fixDim);
        List<String> cols = extField2Mapped.keySet().stream().collect(Collectors.toList());
        eci.setCols(cols.toArray(new String[0]));
        List<String> dims = this._ctx.getAllTarDim().stream().filter(key -> !fixDim.containsKey(key) && !extField2Mapped.containsKey(key)).collect(Collectors.toList());
        eci.setDims(dims.toArray(new String[0]));
        for (Map<String, Object> data : datalist) {
            String[] dimDatas = (String[])dims.stream().map(data::get).toArray(String[]::new);
            Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromDiCtx(this._ctx);
            String lockDim = (String)this._ctx.getCustomParam("lockDim");
            boolean islock = IntegrationUtil.checkLock(eci.getDims(), dimDatas, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, fixDim.get(DimTypesEnum.CURRENCY.getNumber()));
            if (islock) continue;
            eci.addValue(cols.stream().map(data::get).toArray(), dimDatas);
        }
        ExtDataServiceHelper.saveData(eci);
        log.info(String.format("DIExtendIntegrateOutPut.scheme %s ,save:\n%s", this._ctx.getSchema().p2, fixDim.toString()));
        this.collectErrorValues(eci, datalist);
        Integer count = (Integer)this._ctx.getCustomParam("InsertOlapCount");
        this._ctx.putCustomParam("InsertOlapCount", (count == null ? 0 : count) + eci.getValue().size());
    }

    private void collectErrorValues(EDSaveComInfo eci, List<Map<String, Object>> datalist) {
        if (!eci.getErrorvalues().isEmpty()) {
            eci.getErrorvalues().stream().forEach(e -> {
                this.errorValues.add((Object[])e);
                block0: for (Map data : datalist) {
                    int i;
                    for (i = 0; i < eci.getCols().length; ++i) {
                        if (!this.ismatch(e[i], data.get(eci.getCols()[i]))) continue block0;
                    }
                    for (i = 0; i < eci.getDims().length; ++i) {
                        if (!this.ismatch(e[i + eci.getCols().length], data.get(eci.getDims()[i]))) continue block0;
                    }
                    this.idNews.add(data.get("idnew").toString());
                    break;
                }
            });
        }
    }

    private boolean ismatch(Object v, Object v1) {
        if (v == v1) {
            return true;
        }
        if (v == null || v1 == null) {
            return false;
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).compareTo((BigDecimal)v1) == 0;
        }
        return v.toString().equals(v1.toString());
    }

    private void removeOldData(Set<String> uniqueKeySet, Map<String, String> userDefDim2Mapped, Map<String, String> extField2Mapped, Map<String, String> fixDim, List<Map<String, Object>> datas) {
        List<Long> cantDeleteIds;
        QFilter qf = new QFilter("modelnumber", "=", (Object)this.modelNumber);
        qf.and("datamodel", "=", (Object)this.extendsModel.getNumber());
        fixDim.forEach((dimNum, v) -> {
            if ("Process".equals(dimNum) && "EIRpt".equals(v)) {
                qf.and(dimNum.toLowerCase(Locale.ENGLISH), "=", (Object)"IRpt");
            } else {
                qf.and(dimNum.toLowerCase(Locale.ENGLISH), "=", v);
                if ("Entity".equals(dimNum)) {
                    qf.and("org", "=", v);
                }
            }
        });
        if (this.isMerge) {
            this.getUniqueAttrMap(uniqueKeySet, datas).forEach((fieldNumber, v) -> qf.and(this.turnAttr((String)fieldNumber, userDefDim2Mapped, extField2Mapped), "in", v));
        }
        if (!CollectionUtil.isEmpty(cantDeleteIds = this.getCantDeleteIds(userDefDim2Mapped, qf, fixDim.get(DimTypesEnum.CURRENCY.getNumber())))) {
            qf.and("id", "not in", cantDeleteIds);
        }
        DeleteServiceHelper.delete((String)this.extendDataEntity, (QFilter[])new QFilter[]{qf});
        String clearDataScope = (String)this._ctx.getCustomParam("clearDataScope");
        if (StringUtils.isEmpty((CharSequence)clearDataScope)) {
            clearDataScope = ResManager.loadKDString((String)"\u6e05\u6570\u8303\u56f4\uff1a", (String)"DIExtendIntegrateOutPut_5", (String)"fi-bcm-business", (Object[])new Object[0]);
        }
        this._ctx.putCustomParam("clearDataScope", clearDataScope + ",[" + qf.toString() + "]");
    }

    private List<Long> getCantDeleteIds(Map<String, String> userDefDim2Mapped, QFilter qf, String currency) {
        DynamicObject[] load;
        ArrayList<Long> cantDeleteIds = new ArrayList<Long>(16);
        String lockDim = (String)this._ctx.getCustomParam("lockDim");
        if (lockDim == null) {
            return cantDeleteIds;
        }
        Pair<String, String> addField = this.getAddField(lockDim, userDefDim2Mapped);
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)this.extendDataEntity, (String)((String)addField.p1), (QFilter[])qf.toArray())) {
            this.getCantDeleteIds(lockDim, cantDeleteIds, dynamicObject, (String)addField.p2, currency);
        }
        return cantDeleteIds;
    }

    private void getCantDeleteIds(String lockDim, List<Long> cantDeleteIds, DynamicObject dynamicObject, String tableField, String currency) {
        Map<String, String> warnRpt;
        String lockDimNum = dynamicObject.getString(tableField);
        boolean isLock = IntegrationUtil.checkLock(lockDim, lockDimNum, warnRpt = IntegrationUtil.getWarnRptFromDiCtx(this._ctx), (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, currency);
        if (isLock) {
            cantDeleteIds.add(dynamicObject.getLong("id"));
        }
    }

    private Pair<String, String> getAddField(String lockDim, Map<String, String> userDefDim2Mapped) {
        String tableField = userDefDim2Mapped.get(lockDim) == null ? lockDim.toLowerCase() : userDefDim2Mapped.get(lockDim);
        String addField = tableField + ",id,";
        return Pair.onePair((Object)addField, (Object)tableField);
    }

    private String turnAttr(String str, Map<String, String> userDefDim2Mapped, Map<String, String> extField2Mapped) {
        if (userDefDim2Mapped.containsKey(str)) {
            return userDefDim2Mapped.get(str);
        }
        if (extField2Mapped.containsKey(str)) {
            return extField2Mapped.get(str);
        }
        return str.toLowerCase(Locale.ENGLISH);
    }

    private boolean checkMerge() {
        QFilter qf = new QFilter("scheme", "=", this._ctx.getSchema().p1);
        qf.and("importmode", "=", (Object)ISImpModeEnum.MERGEIMPORT.getCode());
        DynamicObject importModeObj = QueryServiceHelper.queryOne((String)"bcm_isimportmode", (String)"id", (QFilter[])qf.toArray());
        return importModeObj != null;
    }

    private Map<String, List<Object>> getUniqueAttrMap(Set<String> uniqueKeySet, Collection<Map<String, Object>> datas) {
        HashMap<String, List<Object>> uniqueAttrMap = new HashMap<String, List<Object>>();
        for (Map<String, Object> map : datas) {
            uniqueKeySet.forEach(unique -> uniqueAttrMap.computeIfAbsent((String)unique, e -> new ArrayList()).add(map.get(unique)));
        }
        return uniqueAttrMap;
    }

    private Set<String> checkUnique() {
        HashSet<String> uniqueKeySet = new HashSet<String>();
        for (FieldEntry entry : this.extendsModel.getFieldEntry()) {
            if (!entry.getUniqueCheck() || !this._ctx.getAllTarDim().contains(entry.getNumber())) continue;
            uniqueKeySet.add(entry.getNumber());
        }
        return uniqueKeySet;
    }

    private void appendSpendTimeMessage(StopWatch sw, StringBuilder sb, String message) {
        sw.split();
        sb.append(message).append(sw.toSplitString()).append(';');
        sw.reset();
        sw.start();
    }

    private static /* synthetic */ Pair lambda$groupDataWithFixDim$1(List collect, String k) {
        return Pair.onePair((Object)collect, new ArrayList(10));
    }
}

