/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.output;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.integration.di.ctx.DIContextParam;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.output.AbstractDIOutput;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.service.DataTrace2FromService;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DataTraceSourceEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.integration.di.DIOlapDescEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.lang3.time.StopWatch;

public class DIIntegrateOutPut
extends AbstractDIOutput {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIIntegrateOutPut.class);
    private DataTrace2FromService dataTraceService;
    private boolean isOpenTrace = ConfigServiceHelper.getGlobalBoolParam(ConfigEnum.IS_OPEN_DATATRACE.getNumber());
    private static final List<String> specialDim4Clear = Arrays.asList(DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.YEAR.getNumber(), DimEntityNumEnum.PERIOD.getNumber(), DimEntityNumEnum.ENTITY.getNumber(), DimEntityNumEnum.CURRENCY.getNumber(), DimEntityNumEnum.PROCESS.getNumber());

    public DIIntegrateOutPut(DIIIntegrateContext ctx) {
        super(ctx);
        this.dataTraceService = new DataTrace2FromService((Long)ctx.getModel().p1, GlobalIdUtil.genGlobalLongId());
    }

    @Override
    public void doOutput() {
        ValueList valueList = this._ctx.getValueList();
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        log.startWatch();
        String message = (String)this._ctx.getCustomParam("spendTimeMessage");
        StringBuilder logMsg = new StringBuilder(StringUtils.isEmpty((String)message) ? "" : message);
        StopWatch sw = new StopWatch();
        sw.start();
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        CellSet cellSets = new CellSet(this.dimNumbers.toArray(new String[0]), new String[]{measure});
        SaveCommandInfo info = new SaveCommandInfo();
        info.setMeasures(new String[]{measure});
        OlapCommandUtil.addSourceMeasure((String)((String)this._ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.I1);
        info.setDimensions(this.dimNumbers);
        HashMap convertCurrMap = new HashMap(16);
        HashSet<String> specialKeys = new HashSet<String>(16);
        ArrayList unSaveIds = new ArrayList(10);
        valueList.getValueList().forEach(valueItem -> {
            Set<String> currencys;
            String key;
            String[] allDims = new String[this.dimNumbers.size()];
            Map<String, Object> properties = ((ValueItem)valueItem).getProperties();
            String org = (String)properties.get("Entity");
            String scenario = (String)properties.get("Scenario");
            String year = (String)properties.get("Year");
            String period = (String)properties.get("Period");
            String currency = (String)properties.get("Currency");
            String myCompany = (String)properties.get("MyCompany");
            long idnew = (Long)properties.remove("idnew");
            if (CurrencyEnum.EC.getNumber().equals(currency) || CurrencyEnum.DC.getNumber().equals(currency)) {
                currency = MemberReader.findEntityMemberByNum((String)((String)this._ctx.getModel().p2), (String)((String)this._ctx.getOrg().p2)).getCurrency();
                properties.put("Currency", currency);
            }
            if (convertCurrMap.containsKey(key = org + "|" + scenario + "|" + year + "|" + period)) {
                currencys = (Set<String>)convertCurrMap.get(key);
            } else {
                currencys = ConvertServiceHelper.getAutoPCByOrgNum((String)this._ctx.getModel().p2, org, scenario, year, period);
                String orgDC = MemberReader.findEntityMemberByNum((String)((String)this._ctx.getModel().p2), (String)org).getCurrency();
                currencys.remove(orgDC);
                convertCurrMap.put(key, currencys);
            }
            if (currencys.contains(currency)) {
                unSaveIds.add(String.valueOf(idnew));
                return;
            }
            if ("$ECur".equals(myCompany)) {
                properties.put("MyCompany", org);
            }
            HashMap<String, String> dimensions = new HashMap<String, String>(properties.size());
            properties.forEach((k, v) -> {
                int index = this.getDimIndex((String)k);
                allDims[index] = (String)v;
                dimensions.put((String)k, (String)v);
            });
            this.getSpecialKey(allDims, specialKeys);
            Map<String, String> warnRpt = IntegrationUtil.getWarnRptFromDiCtx(this._ctx);
            String lockDim = (String)this._ctx.getCustomParam("lockDim");
            boolean islock = IntegrationUtil.checkLock(info, this.dimNumbers, allDims, lockDim, warnRpt, (Long)this._ctx.getModel().p1, (String)this._ctx.getScene().p2, (String)this._ctx.getOrg().p2, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2, (String)this._ctx.getCurrency().p2);
            if (!islock) {
                cellSets.set(allDims, measure, valueItem.getValue());
            }
            this.buildDataTraceInfo(idnew, dimensions, valueItem.getValue());
        });
        int insertOlapCount = 0;
        try (TXHandle tx = TX.required();){
            try {
                insertOlapCount = cellSets.getCount();
                if (this._ctx.getCustomParam(DIContextParam.NOT_NEED_CLEARDATA) == null || !((Boolean)this._ctx.getCustomParam(DIContextParam.NOT_NEED_CLEARDATA)).booleanValue()) {
                    this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u8f93\u51fa\u9884\u5904\u7406\u8017\u65f6:", (String)"DIIntegrateOutPut_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                    List<Map<String, String>> specialDimMembers = this.getSpecialDimMembers(specialKeys);
                    String clearDataScope = DIIntegrationUtil.clearDataByImportMode(this._ctx.getModel(), this._ctx.getSchema(), specialDimMembers);
                    this._ctx.putCustomParam("clearDataScope", clearDataScope);
                    this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u6e05\u6570\u8017\u65f6:", (String)"DIIntegrateOutPut_1", (String)"fi-bcm-business", (Object[])new Object[0]));
                    log.info(String.format("scheme %s ,clearDataScope:\n%s", this._ctx.getSchema().p2, clearDataScope));
                }
                OlapServiceHelper.saveData(info, cellSets, (String)this._ctx.getModel().p2, true, false);
                if (this._ctx.getCustomParam(DIContextParam.NOT_NEED_CLEARDATA) == null || !((Boolean)this._ctx.getCustomParam(DIContextParam.NOT_NEED_CLEARDATA)).booleanValue()) {
                    this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u4fdd\u5b58\u591a\u7ef4\u8017\u65f6:", (String)"DIIntegrateOutPut_2", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                sw.stop();
                if (this.isOpenTrace) {
                    this.dataTraceService.saveCellDataPremanent();
                }
                this._ctx.putCustomParam("spendTimeMessage", logMsg.toString());
                if (!unSaveIds.isEmpty()) {
                    Pair<Boolean, Pair<String, String>> levelTable = DIIntegrationUtil.getLevelTable((Long)this._ctx.getSchema().p1, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2);
                    if (((Boolean)levelTable.p1).booleanValue()) {
                        String sql = String.format("update %1$s set folapstatus = '0',fmsg ='%2$s' where fidnew in (%3$s)", ((Pair)levelTable.p2).p2, DIOlapDescEnum.CONVERT_ERROR.getIndex(), String.join((CharSequence)",", unSaveIds));
                        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql);
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
        try {
            log.info(String.format("Debug Info - cellSets:\n%s", cellSets.toString()));
            this._ctx.putCustomParam("InsertOlapCount", this._ctx.getCustomParam("InsertOlapCount") == null ? insertOlapCount : (Integer)this._ctx.getCustomParam("InsertOlapCount") + insertOlapCount);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    private void appendSpendTimeMessage(StopWatch sw, StringBuilder sb, String message) {
        sw.split();
        sb.append(message).append(sw.toSplitString()).append(';');
        sw.reset();
        sw.start();
    }

    private void getSpecialKey(String[] allDims, Set<String> specialKeys) {
        StringBuilder sb = new StringBuilder();
        specialDim4Clear.forEach(dim -> sb.append(allDims[this.getDimIndex((String)dim)]).append(","));
        specialKeys.add(sb.substring(0, sb.length() - 1));
    }

    private List<Map<String, String>> getSpecialDimMembers(Set<String> specialKeys) {
        ArrayList<Map<String, String>> specialDimMembers = new ArrayList<Map<String, String>>(10);
        specialKeys.forEach(s -> {
            HashMap<String, String> oneMap = new HashMap<String, String>(16);
            String[] members = s.split(",");
            for (int i = 0; i < specialDim4Clear.size(); ++i) {
                oneMap.put(specialDim4Clear.get(i), members[i]);
            }
            specialDimMembers.add(oneMap);
        });
        return specialDimMembers;
    }

    private void buildDataTraceInfo(long id, Map<String, String> dimension, Object value) {
        if (!this.isOpenTrace || value == null) {
            return;
        }
        DataTraceFrom dataTraceFrom = new DataTraceFrom();
        String m = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : value.toString();
        dataTraceFrom.setM(m);
        dataTraceFrom.setF(DataTraceSourceEnum.DI_OUTPUT.getCode());
        JSONObject objJson = new JSONObject();
        objJson.put("id", (Object)id);
        objJson.put("table", this._ctx.getCustomParam("convertTable"));
        objJson.put("scheme", this._ctx.getSchema().p1);
        objJson.put("currency", this._ctx.getCurrency().p1);
        objJson.put("executeId", this._ctx.getCustomParam("executeId"));
        dataTraceFrom.setD(objJson.toString());
        this.dataTraceService.saveCellDataTemp(dimension, dataTraceFrom, 1);
    }
}

