/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.integration.di.DiDeriveRuleHelper;
import kd.fi.bcm.business.integration.di.model.CellFilterInfo;
import kd.fi.bcm.business.integration.di.model.DimMappingFilter;
import kd.fi.bcm.business.integration.di.provider.IDIImportDataService;
import kd.fi.bcm.business.integration.di.service.DIServiceFlowService;
import kd.fi.bcm.business.integration.di.util.DIImportDataUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.CollectionUtil;

public class DIBcmExtImportDataService
implements IDIImportDataService {
    private static final Log log = LogFactory.getLog(DIBcmExtImportDataService.class);
    private static final String ALL = "*";

    @Override
    public Map<String, Object> importData(long schemeId, Long executeId, Long modelId, long scenarioId, Long yearId, Long periodId, Long currencyId, Long orgId, String serviceParam) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
        Pair<Boolean, Pair<String, String>> levelTable = this.getLevelTable(modelId, schemeId, yearId, periodId);
        String importTable = (String)((Pair)levelTable.p2).p1;
        Map<String, List<DimMappingFilter>> filterMap = DIImportDataUtil.getParamMap(scheme, modelId, scenarioId, yearId, periodId, currencyId, orgId);
        List<String> baseList = this.getBaseList(schemeId);
        DynamicObject modelconfig = scheme.getDynamicObject("modelconfig");
        String showNum = modelconfig.getString("modelnum");
        Long srcModelId = MemberReader.findModelIdByShowNum((String)showNum);
        String srcextmodel = scheme.getString("srcextmodel");
        String modelNum = MemberReader.findModelNumberById((Object)srcModelId);
        Pair<List<Map<String, Object>>, Map<String, String>> filters = this.getOlapFilter(filterMap);
        List<String> allDims = DimensionServiceHelper.getDimensionNumListByModel(srcModelId);
        DIServiceFlowService service = new DIServiceFlowService(scheme, filterMap, serviceParam);
        String spendTime = service.callServiceFlow();
        this.deleteByExecuteId(importTable, executeId);
        this.deleteByExecuteId((String)((Pair)levelTable.p2).p2, executeId);
        this.deleteMappingDataByExeId(executeId, yearNum, periodNum);
        this.saveImportTable(showNum, srcModelId, filters, allDims, executeId, importTable, baseList, srcextmodel);
        int importCount = this.getImportCount(importTable, executeId);
        Long start = System.currentTimeMillis();
        int deriveCount = DiDeriveRuleHelper.generateDeriveRuleData(schemeId, executeId, importTable);
        Long end = System.currentTimeMillis() - start;
        String extendsTime = ResManager.loadKDString((String)"\u6570\u636e\u62d3\u5c55\u8017\u65f6:%s;", (String)"XExtendIntegrationService_5", (String)"fi-bcm-business", (Object[])new Object[]{end});
        spendTime = spendTime + extendsTime;
        return this.getResult(importCount, deriveCount, JSONObject.toJSONString(filters), spendTime);
    }

    private void saveImportTable(String showNum, Long srcModelId, Pair<List<Map<String, Object>>, Map<String, String>> filters, List<String> allDims, Long executeId, String importTable, List<String> fieldList, String srcextmodel) {
        DynamicObject srcextmodelObj = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)srcModelId), new QFilter("number", "=", (Object)srcextmodel)});
        ExtendsModel extendsmodel = new ExtendsModel(srcextmodelObj.getLong("id"));
        String srcTable = this.getSrcTable(extendsmodel.getExtendsGroupType());
        Map<String, String> fieldMapped = this.getFieldMapped(srcModelId);
        for (Map filter : (List)filters.p1) {
            String sql = this.getDataSql(fieldList, srcTable, importTable, fieldMapped, executeId, filter, (Map)filters.p2, showNum, srcextmodel);
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql);
        }
    }

    private String getDataSql(List<String> fieldList, String srcTable, String importTable, Map<String, String> fieldMapped, Long executeId, Map<String, Object> filter, Map<String, String> schemeparam, String showNum, String srcextmodel) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(importTable);
        sql.append("(");
        sql.append("fid,");
        for (String field : fieldList) {
            sql.append("f").append(field).append(",");
        }
        sql.append("fexecuteid");
        sql.append(") select ");
        sql.append("fid,");
        for (String field : fieldList) {
            field = this.getField(field, fieldMapped);
            sql.append("f").append(field).append(",");
        }
        sql.append(executeId);
        sql.append(" from ").append(srcTable);
        sql.append(" where fmodelnumber = '").append(showNum).append("'");
        sql.append(" and fdatamodel = '").append(srcextmodel).append("'");
        sql.append(" and fentity = '").append(filter.get(DimTypesEnum.ENTITY.getNumber())).append("'");
        sql.append(" and fyear = '").append(filter.get(DimTypesEnum.YEAR.getNumber())).append("'");
        sql.append(" and fperiod = '").append(filter.get(DimTypesEnum.PERIOD.getNumber())).append("'");
        if (filter.get(DimTypesEnum.CURRENCY.getNumber()) != null) {
            sql.append(" and fcurrency = '").append(filter.get(DimTypesEnum.CURRENCY.getNumber())).append("'");
        }
        this.setSchemeparam(schemeparam, fieldMapped, sql);
        sql.append(";");
        return sql.toString();
    }

    private void setSchemeparam(Map<String, String> schemeparam, Map<String, String> fieldMapped, StringBuilder sql) {
        for (Map.Entry<String, String> map : schemeparam.entrySet()) {
            String field = fieldMapped.get(map.getKey().toLowerCase());
            if (field == null) {
                field = "scenario".equalsIgnoreCase(map.getKey()) ? "scene" : map.getKey().toLowerCase();
            }
            if ((field = "f" + field).startsWith("fnumext")) {
                sql.append(" and ").append(field).append(" = ").append(map.getValue()).append(" ");
                continue;
            }
            sql.append(" and ").append(field).append(" = '").append(map.getValue()).append("'");
        }
    }

    private String getField(String field, Map<String, String> fieldMapped) {
        String string = field = fieldMapped.get(field = field.substring(1)) != null ? fieldMapped.get(field) : field;
        if (field.equals("scenario")) {
            field = "scene";
        }
        return field;
    }

    private String getSrcTable(String extendsGroupType) {
        String srcTable = "t_bcm_extenddata";
        if ("2".equals(extendsGroupType)) {
            srcTable = "t_bcm_extenddata_bus";
        } else if ("3".equals(extendsGroupType)) {
            srcTable = "t_bcm_extenddata_inv";
        }
        return srcTable;
    }

    private Map<String, String> getFieldMapped(Long modelId) {
        DynamicObjectCollection extModel = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number,fieldmapped, datatype,enumitem.datatype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        DynamicObjectCollection userDefined = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,fieldmapped", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("issysdimension", "=", (Object)"0")});
        HashMap<String, String> fieldMapped = new HashMap<String, String>(16);
        for (DynamicObject object : extModel) {
            fieldMapped.put(object.getString("number").toLowerCase(), object.getString("fieldmapped"));
        }
        for (DynamicObject object : userDefined) {
            fieldMapped.put(object.getString("number").toLowerCase(), object.getString("fieldmapped"));
        }
        return fieldMapped;
    }

    private Pair<Boolean, Pair<String, String>> getLevelTable(Long modelId, long schemeId, Long yearId, Long periodId) {
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
        return DIIntegrationUtil.getLevelTable(schemeId, yearNum, periodNum);
    }

    private Pair<List<Map<String, Object>>, Map<String, String>> getOlapFilter(Map<String, List<DimMappingFilter>> filterMap) {
        Pair<String, List<Object>> currencyParams;
        Pair<String, List<Object>> orgParams = this.getMemberParam(DimTypesEnum.ENTITY.getNumber(), filterMap, true);
        Pair<String, List<Object>> fyParams = this.getMemberParam(DimTypesEnum.YEAR.getNumber(), filterMap, true);
        Pair<String, List<Object>> periodParams = this.getMemberParam(DimTypesEnum.PERIOD.getNumber(), filterMap, true);
        List<Map<String, Object>> paraMapList = this.getParaMapList(orgParams, fyParams, periodParams);
        Pair<String, List<Object>> scenParams = this.getMemberParam(DimTypesEnum.SCENARIO.getNumber(), filterMap, false);
        if (scenParams != null) {
            paraMapList = this.getParaMapList(paraMapList, scenParams);
        }
        if ((currencyParams = this.getMemberParam(DimTypesEnum.CURRENCY.getNumber(), filterMap, false)) != null) {
            paraMapList = this.getParaMapList(paraMapList, currencyParams);
        }
        Map<String, String> schemeparam = this.getSchemeParam(filterMap);
        return Pair.onePair(paraMapList, schemeparam);
    }

    private Map<String, String> getSchemeParam(Map<String, List<DimMappingFilter>> filterMap) {
        List<DimMappingFilter> schemeparam = filterMap.get("schemeparam");
        HashMap<String, String> resMap = new HashMap<String, String>(16);
        if (schemeparam != null) {
            for (DimMappingFilter dmf : schemeparam) {
                List<CellFilterInfo> cellInfo = dmf.getCellInfo();
                if (CollectionUtil.isEmpty(cellInfo)) continue;
                resMap.put(cellInfo.get(0).getSrcDim(), cellInfo.get(0).getMember());
            }
        }
        return resMap;
    }

    private List<Map<String, Object>> getParaMapList(List<Map<String, Object>> paraMapList, Pair<String, List<Object>> scenParams) {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        HashMap<Object, Object> resMap = null;
        for (Map<String, Object> map : paraMapList) {
            for (Object scen : (List)scenParams.p2) {
                resMap = new HashMap<Object, Object>();
                resMap.putAll(map);
                resMap.put(scenParams.p1, scen);
                resList.add(resMap);
            }
        }
        return resList;
    }

    private List<Map<String, Object>> getParaMapList(Pair<String, List<Object>> orgParams, Pair<String, List<Object>> fyParams, Pair<String, List<Object>> periodParams) {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        HashMap resMap = null;
        for (Object org : (List)orgParams.p2) {
            for (Object fy : (List)fyParams.p2) {
                for (Object period : (List)periodParams.p2) {
                    resMap = new HashMap();
                    resMap.put(orgParams.p1, org);
                    resMap.put(fyParams.p1, fy);
                    resMap.put(periodParams.p1, period);
                    resList.add(resMap);
                }
            }
        }
        return resList;
    }

    private Pair<String, List<Object>> getMemberParam(String number, Map<String, List<DimMappingFilter>> filterMap, boolean must) {
        ArrayList<Object> resList = new ArrayList<Object>();
        List<DimMappingFilter> list = filterMap.get(number);
        if (list == null) {
            if (must) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5c11\u5fc5\u8981\u6620\u5c04\u3002", (String)"DIBcmImportDataService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
            }
            return null;
        }
        for (DimMappingFilter dimMappingFilter : list) {
            List<CellFilterInfo> cellInfo = dimMappingFilter.getCellInfo();
            if (cellInfo == null) {
                if (must) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5c11\u5fc5\u8981\u6620\u5c04\u3002", (String)"DIBcmImportDataService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
                }
                return null;
            }
            for (CellFilterInfo cellFilterInfo : cellInfo) {
                if (1 != cellFilterInfo.getType() && 4 != cellFilterInfo.getType()) continue;
                resList.addAll(cellFilterInfo.getSqlParam());
            }
        }
        if (resList.size() == 0 && must) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5c11\u5fc5\u8981\u6620\u5c04\u3002", (String)"DIBcmImportDataService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        }
        return Pair.onePair((Object)number, resList);
    }

    private List<String> getBaseList(long schemeId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"number", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
        ArrayList<String> baseList = new ArrayList<String>();
        for (DynamicObject dynamicObject : query) {
            baseList.add(dynamicObject.getString("number"));
        }
        return baseList;
    }

    private Map<String, Object> getResult(int importCount, int deriveCount, String filter, String spendTime) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", true);
        result.put("import_count", importCount);
        result.put("derive_count", deriveCount);
        result.put("total_count", importCount + deriveCount);
        StringBuilder msg = new StringBuilder();
        result.put("msg", msg.append(" ").append(filter).append(spendTime).toString());
        return result;
    }

    private int getImportCount(String importTable, Long executeId) {
        int importCount = 0;
        String queryData = "select count(*) as num from " + importTable + " where fexecuteid = " + executeId;
        DataSet allCount = DB.queryDataSet((String)"midImportData", (DBRoute)BCMConstant.DBROUTE, (String)queryData);
        if (allCount != null) {
            String count = allCount.next().getString("num");
            importCount = Integer.parseInt(count);
        }
        return importCount;
    }

    private void deleteByExecuteId(String tableName, Long executeId) {
        Object[] paramObjs = new Object[]{executeId};
        String sb = "delete from " + tableName + " where fexecuteid = ?";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sb, (Object[])paramObjs);
    }

    public void deleteMappingDataByExeId(Long executeId, String yearNum, String periodNum) {
        Object[] paramObjs = new Object[]{executeId, yearNum, periodNum};
        String deleteSql = "delete from t_di_mappingtrace where fexeid = ? and fyearnum = ? and fperiodnum = ?";
        DB.execute((DBRoute)new DBRoute("bcm"), (String)deleteSql, (Object[])paramObjs);
    }
}

