/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.provider;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.integration.di.DiDeriveRuleHelper;
import kd.fi.bcm.business.integration.di.model.CellFilterInfo;
import kd.fi.bcm.business.integration.di.model.DimMappingFilter;
import kd.fi.bcm.business.integration.di.provider.IDIImportDataService;
import kd.fi.bcm.business.integration.di.service.DIServiceFlowService;
import kd.fi.bcm.business.integration.di.util.DIImportDataUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.enums.integration.MapScopeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import org.apache.commons.lang3.StringUtils;

public class DIBcmImportDataService
implements IDIImportDataService {
    private static final Log log = LogFactory.getLog(DIBcmImportDataService.class);
    private static final String ALL = "*";

    @Override
    public Map<String, Object> importData(long schemeId, Long executeId, Long modelId, long scenarioId, Long yearId, Long periodId, Long currencyId, Long orgId, String serviceParam) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
        Pair<Boolean, Pair<String, String>> levelTable = this.getLevelTable(modelId, schemeId, yearId, periodId);
        String importTable = (String)((Pair)levelTable.p2).p1;
        Map<String, List<DimMappingFilter>> filterMap = DIImportDataUtil.getParamMap(scheme, modelId, scenarioId, yearId, periodId, currencyId, orgId);
        Pair<List<String>, List<String>> fieldPair = this.getFieldList(schemeId, scheme.getString("singlemetric"), scheme.getString("textfield"));
        DynamicObject modelconfig = scheme.getDynamicObject("modelconfig");
        String showNum = modelconfig.getString("modelnum");
        Long srcModelId = MemberReader.findModelIdByShowNum((String)showNum);
        String modelNum = MemberReader.findModelNumberById((Object)srcModelId);
        List<Map<String, Object>> filters = this.getOlapFilter(filterMap);
        filters = this.addOtherFilters(filters, schemeId, srcModelId);
        List<String> allDims = DimensionServiceHelper.getDimensionNumListByModel(srcModelId);
        allDims = this.orderAllDims(allDims, (List)fieldPair.p2);
        DIServiceFlowService service = new DIServiceFlowService(scheme, filterMap, serviceParam);
        String spendTime = service.callServiceFlow();
        this.deleteByExecuteId(importTable, executeId);
        this.deleteByExecuteId((String)((Pair)levelTable.p2).p2, executeId);
        this.deleteMappingDataByExeId(executeId, yearNum, periodNum);
        HashMap<String, Set<String>> notExistMemberMap = new HashMap<String, Set<String>>(8);
        this.saveImportTable(modelNum, filters, allDims, executeId, importTable, (List)fieldPair.p1, notExistMemberMap);
        int importCount = this.getImportCount(importTable, executeId);
        Long start = System.currentTimeMillis();
        int deriveCount = DiDeriveRuleHelper.generateDeriveRuleData(schemeId, executeId, importTable);
        Long end = System.currentTimeMillis() - start;
        String extendsTime = ResManager.loadKDString((String)"\u6570\u636e\u62d3\u5c55\u8017\u65f6:%s;", (String)"XExtendIntegrationService_5", (String)"fi-bcm-business", (Object[])new Object[]{end});
        spendTime = spendTime + extendsTime;
        if (notExistMemberMap.size() > 0) {
            spendTime = spendTime + String.format(ResManager.loadKDString((String)"\u6210\u5458\u6620\u5c04\u4e2d\u6e90\u7ef4\u5ea6\u4e0d\u5b58\u5728\u7684\u6210\u5458\u5217\u8868\u4e3a:%s", (String)"DIBcmImportDataService_1", (String)"fi-bcm-business", (Object[])new Object[0]), JSONObject.toJSONString(notExistMemberMap));
        }
        StringBuilder msg = new StringBuilder();
        return this.getResult(importCount, deriveCount, msg, JSONObject.toJSONString(filters), spendTime);
    }

    private List<Map<String, Object>> addOtherFilters(List<Map<String, Object>> filters, long schemeId, long srcModelId) {
        Set<String> otherDims = this.otherDimSet(filters, schemeId, srcModelId);
        HashMap<String, String> otherMap = new HashMap<String, String>(otherDims.size());
        for (String dim : otherDims) {
            otherMap.put(dim, null);
        }
        Map<String, List<DimMappingFilter>> filterMap = DIImportDataUtil.getOtherDimFilter(schemeId, otherMap, srcModelId);
        filters = this.getOtherOlapFilter(filters, filterMap, otherDims);
        return filters;
    }

    private Set<String> otherDimSet(List<Map<String, Object>> filters, long schemeId, long srcModelId) {
        HashSet<String> otherDimSet = new HashSet<String>(8);
        DynamicObject[] allDimMap = this.getAllDimMap(schemeId);
        Map<String, String> lowercaseMap = DIImportDataUtil.getLowerCaseMap(srcModelId);
        for (DynamicObject dynamicObject : allDimMap) {
            DynamicObjectCollection srcEntrys = dynamicObject.getDynamicObjectCollection("isdimmapsrcentry");
            String srcDim = DIIntegrationUtil.getBaseEntListNumberById(((DynamicObject)srcEntrys.get(0)).getLong("srcdimension_id"));
            if (!lowercaseMap.containsKey(srcDim)) continue;
            otherDimSet.add(lowercaseMap.get(srcDim));
        }
        for (Map map : filters) {
            map.forEach((k, v) -> otherDimSet.remove(k));
        }
        return otherDimSet;
    }

    private List<Map<String, Object>> getOtherOlapFilter(List<Map<String, Object>> paraMapList, Map<String, List<DimMappingFilter>> filterMap, Set<String> otherDims) {
        for (String dim : otherDims) {
            Pair<String, List<Object>> params = this.getOtherMemberParam(dim, filterMap);
            if (params == null) continue;
            for (Map<String, Object> map : paraMapList) {
                if (map.containsKey(params.p1)) continue;
                map.put((String)params.p1, params.p2);
            }
        }
        return paraMapList;
    }

    private Pair<String, List<Object>> getOtherMemberParam(String number, Map<String, List<DimMappingFilter>> filterMap) {
        ArrayList<Object> resList = new ArrayList<Object>();
        List<DimMappingFilter> list = filterMap.get(number);
        if (list == null) {
            return null;
        }
        for (DimMappingFilter dimMappingFilter : list) {
            List<CellFilterInfo> cellInfo = dimMappingFilter.getCellInfo();
            if (cellInfo == null) {
                return null;
            }
            for (CellFilterInfo cellFilterInfo : cellInfo) {
                if (MapScopeEnum.EQUALS.getIndexNum() == cellFilterInfo.getType() || MapScopeEnum.INCLUDE.getIndexNum() == cellFilterInfo.getType()) {
                    resList.addAll(cellFilterInfo.getSqlParam());
                    continue;
                }
                resList.add(ALL);
            }
        }
        if (resList.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5c11\u5fc5\u8981\u6620\u5c04\u3002", (String)"DIBcmImportDataService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        }
        return Pair.onePair((Object)number, resList);
    }

    private DynamicObject[] getAllDimMap(long schemeId) {
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        qf.and("mappedtype", "=", (Object)DimMappTypeEnum.SIMPLE.getCode());
        return BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id,isdimmaptargentry.tagdimension,isdimmapsrcentry.srcdimension", (QFilter[])new QFilter[]{qf});
    }

    private List<String> orderAllDims(List<String> allDims, List<String> baseList) {
        HashMap<String, String> dimMap = new HashMap<String, String>(16);
        for (String str : allDims) {
            dimMap.put(str.toLowerCase(), str);
        }
        ArrayList<String> resList = new ArrayList<String>(16);
        for (String str : baseList) {
            resList.add((String)dimMap.get(str));
        }
        return resList;
    }

    private void saveImportTable(String modelNum, List<Map<String, Object>> filters, List<String> allDims, Long executeId, String importTable, List<String> fieldList, Map<String, Set<String>> notExistMemberMap) {
        for (Map<String, Object> filter : filters) {
            MDResultSet mdresult = DIBcmImportDataService.queryOlap(modelNum, allDims, filter, notExistMemberMap);
            ArrayList<Object[]> obParams = new ArrayList<Object[]>(16);
            while (mdresult.next()) {
                Object[] objects = this.getOjects(mdresult, allDims, executeId);
                obParams.add(objects);
            }
            this.insertData(obParams, fieldList, importTable);
        }
    }

    private Object[] getOjects(MDResultSet mdresult, List<String> allDims, Long executeId) {
        Object[] objects = new Object[allDims.size() + 5];
        objects[0] = GlobalIdUtil.genGlobalLongId();
        objects[1] = executeId;
        for (int i = 0; i < allDims.size(); ++i) {
            objects[i + 2] = mdresult.getString(allDims.get(i));
        }
        Object originalValue = mdresult.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
        if (originalValue instanceof String) {
            objects[allDims.size() + 2] = new BigDecimal(0);
            objects[allDims.size() + 3] = originalValue;
        } else {
            objects[allDims.size() + 2] = new BigDecimal(originalValue + "");
            objects[allDims.size() + 3] = " ";
        }
        objects[allDims.size() + 4] = "0";
        return objects;
    }

    private Pair<Boolean, Pair<String, String>> getLevelTable(Long modelId, long schemeId, Long yearId, Long periodId) {
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
        return DIIntegrationUtil.getLevelTable(schemeId, yearNum, periodNum);
    }

    private List<Map<String, Object>> getOlapFilter(Map<String, List<DimMappingFilter>> filterMap) {
        Pair<String, List<Object>> currencyParams;
        Pair<String, List<Object>> orgParams = this.getMemberParam(DimTypesEnum.ENTITY.getNumber(), filterMap, true);
        Pair<String, List<Object>> fyParams = this.getMemberParam(DimTypesEnum.YEAR.getNumber(), filterMap, true);
        Pair<String, List<Object>> periodParams = this.getMemberParam(DimTypesEnum.PERIOD.getNumber(), filterMap, true);
        List<Map<String, Object>> paraMapList = this.getParaMapList(orgParams, fyParams, periodParams);
        Pair<String, List<Object>> scenParams = this.getMemberParam(DimTypesEnum.SCENARIO.getNumber(), filterMap, false);
        if (scenParams != null) {
            paraMapList = this.getParaMapList(paraMapList, scenParams);
        }
        if ((currencyParams = this.getMemberParam(DimTypesEnum.CURRENCY.getNumber(), filterMap, false)) != null) {
            paraMapList = this.getParaMapList(paraMapList, currencyParams);
        }
        return paraMapList;
    }

    private List<Map<String, Object>> getParaMapList(List<Map<String, Object>> paraMapList, Pair<String, List<Object>> scenParams) {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        HashMap<Object, Object> resMap = null;
        for (Map<String, Object> map : paraMapList) {
            for (Object scen : (List)scenParams.p2) {
                resMap = new HashMap<Object, Object>();
                resMap.putAll(map);
                resMap.put(scenParams.p1, scen);
                resList.add(resMap);
            }
        }
        return resList;
    }

    private List<Map<String, Object>> getParaMapList(Pair<String, List<Object>> orgParams, Pair<String, List<Object>> fyParams, Pair<String, List<Object>> periodParams) {
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
        HashMap resMap = null;
        for (Object org : (List)orgParams.p2) {
            for (Object fy : (List)fyParams.p2) {
                for (Object period : (List)periodParams.p2) {
                    resMap = new HashMap();
                    resMap.put(orgParams.p1, org);
                    resMap.put(fyParams.p1, fy);
                    resMap.put(periodParams.p1, period);
                    resList.add(resMap);
                }
            }
        }
        return resList;
    }

    private Pair<String, List<Object>> getMemberParam(String number, Map<String, List<DimMappingFilter>> filterMap, boolean must) {
        ArrayList<Object> resList = new ArrayList<Object>();
        List<DimMappingFilter> list = filterMap.get(number);
        if (list == null) {
            if (must) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5c11\u5fc5\u8981\u6620\u5c04\u3002", (String)"DIBcmImportDataService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
            }
            return null;
        }
        for (DimMappingFilter dimMappingFilter : list) {
            List<CellFilterInfo> cellInfo = dimMappingFilter.getCellInfo();
            if (cellInfo == null) {
                if (must) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5c11\u5fc5\u8981\u6620\u5c04\u3002", (String)"DIBcmImportDataService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
                }
                return null;
            }
            for (CellFilterInfo cellFilterInfo : cellInfo) {
                if (1 != cellFilterInfo.getType() && 4 != cellFilterInfo.getType()) continue;
                resList.addAll(cellFilterInfo.getSqlParam());
            }
        }
        if (resList.size() == 0 && must) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5c11\u5fc5\u8981\u6620\u5c04\u3002", (String)"DIBcmImportDataService_0", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        }
        return Pair.onePair((Object)number, resList);
    }

    private Pair<List<String>, List<String>> getFieldList(long schemeId, String singlemetric, String textfield) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isbaseentlist", (String)"number", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
        ArrayList<String> baseList = new ArrayList<String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("fid");
        fieldList.add("fexecuteid");
        for (DynamicObject dynamicObject : query) {
            baseList.add(dynamicObject.getString("number"));
            fieldList.add("f" + dynamicObject.getString("number"));
        }
        fieldList.add("f" + singlemetric);
        fieldList.add("f" + textfield);
        fieldList.add("fdatafrom");
        return Pair.onePair(fieldList, baseList);
    }

    private void insertData(List<Object[]> obParams, List<String> fieldList, String table) {
        if (obParams.isEmpty()) {
            return;
        }
        String fields = StringUtils.join((Object[])fieldList.toArray(), (String)",");
        StringBuilder fieldsInx = new StringBuilder();
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            String commaCont = i == size - 1 ? "" : ",";
            fieldsInx.append("?").append(commaCont);
        }
        String insertSql = "insert into " + table + "(" + fields + ") values(" + fieldsInx + ")";
        BatchProcessHelper.batchConsume(obParams, (int)50000, dataFromTempList -> DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, (List)dataFromTempList));
    }

    private static MDResultSet queryOlap(String modelNum, List<String> allDims, Map<String, Object> filter, Map<String, Set<String>> notExistMemberMap) {
        SQLBuilder sql = new SQLBuilder(modelNum);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sql.addSelectField(allDims.toArray(new String[0]));
        filter.forEach((k, v) -> {
            HashSet<String> set = new HashSet<String>();
            if (v instanceof String) {
                if (ALL.equals(v)) {
                    DIBcmImportDataService.getParaValueSetByNum(set, modelNum, k, true);
                }
                set.add((String)v);
            } else if (v instanceof Collection) {
                if (((Collection)v).contains(ALL)) {
                    DIBcmImportDataService.getParaValueSetByNum(set, modelNum, k, true);
                }
                set.addAll((Collection)v);
            }
            set.remove(ALL);
            if (set.size() > 0) {
                Set<String> notExistMemberSet = DIBcmImportDataService.checkMemberIsExistOlap(k, set, modelNum);
                if (notExistMemberSet.size() > 0) {
                    notExistMemberMap.computeIfAbsent((String)k, key -> new HashSet()).addAll(notExistMemberSet);
                    set.removeAll(notExistMemberSet);
                }
                if (set.size() > 0) {
                    sql.addFilter((String)k, set.toArray(new String[0]));
                }
            }
        });
        ErrorLogServiceHelper.saveErrorLog(MemberReader.findModelIdByNum((String)modelNum), "queryOlap", modelNum + ":" + sql.toString());
        return OlapServiceHelper.queryData(sql);
    }

    private static Set<String> checkMemberIsExistOlap(String dimensionNum, Set<String> memberNumset, String modelNum) {
        String[] array = new String[memberNumset.size()];
        memberNumset.toArray(array);
        Set<String> notExistMemberSet = OlapServiceHelper.batCheckMemberIsExistOlap(dimensionNum, array, modelNum);
        if (notExistMemberSet.size() > 0) {
            return notExistMemberSet;
        }
        return Collections.emptySet();
    }

    private static void getParaValueSetByNum(Set<String> paraValueSet, String modelNumber, String dimNumber, boolean onlyLeaf) {
        Collection allNodeByDimNum = MemberReader.getAllNodeByDimNum((String)dimNumber, (String)modelNumber);
        for (IDNumberTreeNode treeNode : allNodeByDimNum) {
            if (onlyLeaf) {
                if (!treeNode.isLeaf()) continue;
                paraValueSet.add(treeNode.getNumber());
                continue;
            }
            paraValueSet.add(treeNode.getNumber());
        }
    }

    private Map<String, Object> getResult(int importCount, int deriveCount, StringBuilder msg, String filter, String spendTime) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", true);
        result.put("import_count", importCount);
        result.put("derive_count", deriveCount);
        result.put("total_count", importCount + deriveCount);
        result.put("msg", msg.append(" ").append(filter).append(spendTime).toString());
        return result;
    }

    private int getImportCount(String importTable, Long executeId) {
        int importCount = 0;
        String queryData = "select count(*) as num from " + importTable + " where fexecuteid = " + executeId;
        DataSet allCount = DB.queryDataSet((String)"midImportData", (DBRoute)BCMConstant.DBROUTE, (String)queryData);
        if (allCount != null) {
            String count = allCount.next().getString("num");
            importCount = Integer.parseInt(count);
        }
        return importCount;
    }

    private void deleteByExecuteId(String tableName, Long executeId) {
        Object[] paramObjs = new Object[]{executeId};
        String sb = "delete from " + tableName + " where fexecuteid = ?";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sb, (Object[])paramObjs);
    }

    public void deleteMappingDataByExeId(Long executeId, String yearNum, String periodNum) {
        Object[] paramObjs = new Object[]{executeId, yearNum, periodNum};
        String deleteSql = "delete from t_di_mappingtrace where fexeid = ? and fyearnum = ? and fperiodnum = ?";
        DB.execute((DBRoute)new DBRoute("bcm"), (String)deleteSql, (Object[])paramObjs);
    }
}

