/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.provider;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.provider.AbstractDIDataProvider;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class DIExtendDataProvider
extends AbstractDIDataProvider {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DIExtendDataProvider.class);
    private String table_number;
    private Long executeId;

    public DIExtendDataProvider(DIIIntegrateContext ctx) {
        super(ctx);
        Pair<Boolean, Pair<String, String>> levelTable = DIIntegrationUtil.getLevelTable((Long)this._ctx.getSchema().p1, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2);
        if (!((Boolean)levelTable.p1).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bfc\u5165\u8868", (String)"DIDataProvider_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.table_number = (String)((Pair)levelTable.p2).p1;
        this.executeId = (Long)this._ctx.getCustomParam("executeId");
        log.info("DIExtendDataProvider--table_number:" + this.table_number);
    }

    @Override
    protected IDataSet<IRow> doLoadData() {
        String sql = this.getSql();
        return this.buildResultSet(sql);
    }

    private String getSql() {
        HashSet<String> needSelects = new HashSet<String>(16);
        Set<String> srcFields = this._ctx.getAllSrcDim();
        needSelects.addAll(srcFields);
        StringBuilder selector = new StringBuilder();
        needSelects.forEach(s -> selector.append("f").append(s.toLowerCase()).append(","));
        List primaryKeys = DB.getPrimaryKeys((DBRoute)BCMConstant.DBROUTE, (String)this.table_number);
        primaryKeys.remove("fexecuteid");
        this._ctx.putCustomParam("primaryKey", ((String)primaryKeys.get(0)).substring(1));
        selector.append((String)primaryKeys.get(0));
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append((CharSequence)selector).append(" FROM ").append(this.table_number);
        sql.append(" WHERE ").append("fexecuteid").append(" = ").append(this.executeId);
        sql.append(";");
        return sql.toString();
    }

    private StdMdDataSet buildResultSet(String sql) {
        StdMdDataSet rowSet = new StdMdDataSet();
        try (DataSet dataSet = DB.queryDataSet((String)this.table_number, (DBRoute)BCMConstant.DBROUTE, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                StdMdRow mdRow = new StdMdRow();
                for (Field field : dataSet.getRowMeta().getFields()) {
                    Object v = row.get(field.getName());
                    if (v == null || !StringUtils.isNotEmpty((String)v.toString())) continue;
                    mdRow.put(field.getName().substring(1), v);
                }
                rowSet.addRow(mdRow);
            }
        }
        return rowSet;
    }

    @Override
    protected DataSet doLoadDataSet() {
        return null;
    }
}

