/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.provider;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.DiDeriveRuleHelper;
import kd.fi.bcm.business.integration.di.model.CellFilterInfo;
import kd.fi.bcm.business.integration.di.model.DimMappingFilter;
import kd.fi.bcm.business.integration.di.provider.IDIImportDataService;
import kd.fi.bcm.business.integration.di.service.DIServiceFlowService;
import kd.fi.bcm.business.integration.di.util.DIImportDataUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class DIImportDataService
implements IDIImportDataService {
    private static final Log log = LogFactory.getLog(DIImportDataService.class);
    private static final String PRE_PARAM = "param_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> importData(long schemeId, Long executeId, Long modelId, long scenarioId, Long yearId, Long periodId, Long currencyId, Long orgId, String serviceParam) {
        Map result;
        StringBuilder filterSb = new StringBuilder();
        DynamicObject route = this.queryTableRoute(modelId, schemeId, yearId, periodId);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        DynamicObject dataCopy = route.getDynamicObject("iscdatacopy");
        this.updateIscDataCopy(dataCopy.getLong("id"));
        DynamicObject trigger = this.createTrigger(schemeId, dataCopy);
        Map<String, List<DimMappingFilter>> filterMap = DIImportDataUtil.getParamMap(scheme, modelId, scenarioId, yearId, periodId, currencyId, orgId);
        long triggerId = trigger.getLong("id");
        DynamicObjectCollection params = trigger.getDynamicObjectCollection("params_entryentity");
        this.buildTriggerParams(params, filterMap);
        DynamicObjectCollection filters = trigger.getDynamicObjectCollection("filter_entries");
        this.buildTriggerFilters(filters, filterMap, filterSb);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trigger});
        try {
            Map<String, Object> filtersParam = this.getFiltersParam(filterMap, executeId);
            filterSb.append(filtersParam);
            DIServiceFlowService service = new DIServiceFlowService(scheme, filterMap, serviceParam);
            String spendTime = service.callServiceFlow();
            filterSb.append("\n").append(spendTime);
            String tableName = route.getString("imptable");
            this.deleteByExecuteId(tableName, executeId);
            log.info("filtersParam is:" + JSON.toJSONString(filtersParam));
            result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncExecute", (Object[])new Object[]{trigger.getString("number"), filtersParam});
            log.info("filtersParam is res :" + JSON.toJSONString((Object)result));
            boolean success = (Boolean)result.get("success");
            int deriveCount = 0;
            int importCount = 0;
            int totalCount = 0;
            if (success) {
                totalCount = importCount = ((Integer)result.get("total_count")).intValue();
                deriveCount = DiDeriveRuleHelper.generateDeriveRuleData(schemeId, executeId, tableName);
                totalCount += deriveCount;
                this.deleteByExecuteId(route.getString("comptable"), executeId);
                this.deleteMappingDataByExeId(executeId);
                result.put("msg", filterSb.toString());
            }
            result.put("import_count", importCount);
            result.put("derive_count", deriveCount);
            result.put("total_count", totalCount);
        }
        finally {
            this.deleteTrigger(triggerId);
        }
        return result;
    }

    private Map<String, Object> getFiltersParam(Map<String, List<DimMappingFilter>> filterMap, Long executeId) {
        HashMap<String, Object> filtersParam = new HashMap<String, Object>(16);
        filterMap.forEach((k, v) -> v.forEach(dimMappingFilter -> dimMappingFilter.getCellInfo().forEach(f -> {
            if (f.getType() == 2 || f.getType() == 6) {
                filtersParam.put((String)f.getParamKeyPair().p1, f.getMemberPair().p1);
                filtersParam.put((String)f.getParamKeyPair().p2, f.getMemberPair().p2);
            } else {
                String value = f.getMember();
                if (f.getType() == 4 || f.getType() == 8) {
                    value = "[" + value + "]";
                }
                filtersParam.put(f.getParamKey(), value);
            }
        })));
        filtersParam.put("executeid", executeId);
        return filtersParam;
    }

    private void buildTriggerFilters(DynamicObjectCollection filters, Map<String, List<DimMappingFilter>> filterMap, StringBuilder filterSb) {
        filters.clear();
        int i = 0;
        for (Map.Entry<String, List<DimMappingFilter>> entry : filterMap.entrySet()) {
            List<DimMappingFilter> oneTargetFilters;
            if ("schemeparam".equals(entry.getKey()) || (oneTargetFilters = entry.getValue()).isEmpty()) continue;
            int dimMapCount = 0;
            for (DimMappingFilter dimMapFilter : oneTargetFilters) {
                int count = 0;
                for (CellFilterInfo cellFilter : dimMapFilter.getCellInfo()) {
                    DynamicObject filter = filters.addNew();
                    if (cellFilter.getType() == 2 || cellFilter.getType() == 6) {
                        filter.set("seq", (Object)i++);
                        filter.set("filter_column", (Object)cellFilter.getSrcDim());
                        filter.set("filter_compare", cellFilter.getSymbolPair().p1);
                        filter.set("filter_value_var", cellFilter.getParamKeyPair().p1);
                        if (count == 0) {
                            if (dimMapCount == 0 && oneTargetFilters.size() > 1) {
                                filter.set("filter_left_bracket", (Object)"((");
                            } else {
                                filter.set("filter_left_bracket", (Object)"(");
                            }
                        }
                        filter.set("filter_link", (Object)(cellFilter.getType() == 2 ? "AND" : "OR"));
                        this.buildFilterSb(filter, filterSb);
                        filter = filters.addNew();
                        filter.set("seq", (Object)i++);
                        filter.set("filter_column", (Object)cellFilter.getSrcDim());
                        filter.set("filter_compare", cellFilter.getSymbolPair().p2);
                        filter.set("filter_value_var", cellFilter.getParamKeyPair().p2);
                    } else {
                        if (count == 0) {
                            if (dimMapCount == 0 && oneTargetFilters.size() > 1) {
                                filter.set("filter_left_bracket", (Object)"((");
                            } else {
                                filter.set("filter_left_bracket", (Object)"(");
                            }
                        }
                        filter.set("seq", (Object)i++);
                        filter.set("filter_column", (Object)cellFilter.getSrcDim());
                        filter.set("filter_compare", (Object)cellFilter.getSymbol());
                        filter.set("filter_value_var", (Object)cellFilter.getParamKey());
                    }
                    if (count == dimMapFilter.getCellInfo().size() - 1) {
                        if (dimMapCount == oneTargetFilters.size() - 1 && oneTargetFilters.size() != 1) {
                            filter.set("filter_right_bracket", (Object)"))");
                        } else {
                            filter.set("filter_right_bracket", (Object)")");
                        }
                    }
                    if (count != dimMapFilter.getCellInfo().size() - 1 || dimMapCount != oneTargetFilters.size() - 1) {
                        filter.set("filter_link", (Object)"OR");
                    }
                    this.buildFilterSb(filter, filterSb);
                    ++count;
                }
                ++dimMapCount;
            }
        }
    }

    private void buildFilterSb(DynamicObject filter, StringBuilder filterSb) {
        if (filter.get("filter_left_bracket") != null) {
            filterSb.append(filter.get("filter_left_bracket"));
        }
        filterSb.append(filter.get("filter_column")).append(" ").append(filter.get("filter_compare")).append(" ").append(filter.get("filter_value_var")).append(" ");
        if (filter.get("filter_right_bracket") != null) {
            filterSb.append(filter.get("filter_right_bracket"));
        }
        if (filter.get("filter_link") != null) {
            filterSb.append(filter.get("filter_link"));
        }
        filterSb.append("\n");
    }

    private void buildTriggerParams(DynamicObjectCollection params, Map<String, List<DimMappingFilter>> filterMap) {
        params.clear();
        int i = 0;
        for (Map.Entry<String, List<DimMappingFilter>> entry : filterMap.entrySet()) {
            if ("schemeparam".equals(entry.getKey())) continue;
            for (DimMappingFilter filter : entry.getValue()) {
                List<CellFilterInfo> cellFilterInfos = filter.getCellInfo();
                for (CellFilterInfo cellFilter : cellFilterInfos) {
                    DynamicObject param;
                    if (cellFilter.getType() == 2 || cellFilter.getType() == 6) {
                        param = params.addNew();
                        param.set("seq", (Object)i++);
                        param.set("params_name", cellFilter.getParamKeyPair().p1);
                        param.set("params_data_type", (Object)"string");
                        param = params.addNew();
                        param.set("seq", (Object)i++);
                        param.set("params_name", cellFilter.getParamKeyPair().p2);
                        param.set("params_data_type", (Object)"string");
                        continue;
                    }
                    param = params.addNew();
                    param.set("seq", (Object)i++);
                    param.set("params_name", (Object)cellFilter.getParamKey());
                    param.set("params_data_type", (Object)"string");
                }
            }
        }
        DynamicObject param = params.addNew();
        param.set("seq", (Object)i);
        param.set("params_name", (Object)"executeid");
        param.set("params_label", (Object)"executeid");
        param.set("params_data_type", (Object)"string");
    }

    private void deleteByExecuteId(String tableName, Long executeId) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ").append(tableName);
        sb.append(" where fexecuteid = ?");
        Object[] paramObjs = new Object[]{executeId};
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sb.toString(), (Object[])paramObjs);
    }

    public void deleteMappingDataByExeId(Long executeId) {
        String deleteSql = "delete from t_di_mappingtrace where fexeid = " + executeId;
        DB.execute((DBRoute)new DBRoute("bcm"), (String)deleteSql);
    }

    private DynamicObject queryTableRoute(long modelId, long schemeId, long yearId, long periodId) {
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
        QFBuilder builder = new QFBuilder("scheme", "=", (Object)schemeId);
        builder.add("year", "=", (Object)yearNum);
        builder.add("period", "=", (Object)periodNum);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"di_tableroute", (QFilter[])builder.toArray());
    }

    private void updateIscDataCopy(Long dataCopyId) {
        DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)dataCopyId, (String)"isc_data_copy");
        DynamicObjectCollection items = dataCopy.getDynamicObjectCollection("mapping_entries");
        for (DynamicObject item : items) {
            if (!"fdatafrom".equals(item.getString("mapping_tar_column"))) continue;
            return;
        }
        MainEntityType mainEntity = (MainEntityType)dataCopy.getDataEntityType();
        EntityType entryType = (EntityType)mainEntity.getAllEntities().get("mapping_entries");
        DynamicObject datafrom = new DynamicObject((DynamicObjectType)entryType);
        datafrom.set("mapping_tar_column", (Object)"fdatafrom");
        datafrom.set("candidate_key", (Object)false);
        datafrom.set("fixed_value", (Object)Character.valueOf('0'));
        items.add((Object)datafrom);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataCopy});
    }

    private DynamicObject createTrigger(long schemeId, DynamicObject dataCopy) {
        DynamicObject tr = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy_trigger");
        long id = GlobalIdUtil.genGlobalLongId();
        tr.set("id", (Object)id);
        tr.set("trigger_type", (Object)"manual");
        tr.set("data_copy", (Object)dataCopy);
        tr.set("number", (Object)(id + "@bcm"));
        tr.set("name", (Object)String.format(ResManager.loadResFormat((String)"\u5408\u5e76\u96c6\u6210-%s", (String)"DIDataHandleService_1", (String)"fi-bcm-business", (Object[])new Object[0]), schemeId));
        tr.set("trace_all", (Object)Boolean.FALSE);
        tr.set("enable", (Object)1);
        tr.set("creator", (Object)RequestContext.get().getCurrUserId());
        tr.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        tr.set("status", (Object)"C");
        return tr;
    }

    private void deleteTrigger(long triggerId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)triggerId);
        DeleteServiceHelper.delete((String)"isc_data_copy_trigger", (QFilter[])qfBuilder.toArray());
    }
}

