/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.integration.di.DiDeriveRuleHelper;
import kd.fi.bcm.business.integration.di.model.CellFilterInfo;
import kd.fi.bcm.business.integration.di.model.DimMappingFilter;
import kd.fi.bcm.business.integration.di.provider.IDIImportDataService;
import kd.fi.bcm.business.integration.di.service.DIServiceFlowService;
import kd.fi.bcm.business.integration.di.util.DIImportDataUtil;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.fel.common.StringUtils;

public class DIMidImportDataService
implements IDIImportDataService {
    private static final Log log = LogFactory.getLog(DIMidImportDataService.class);

    @Override
    public Map<String, Object> importData(long schemeId, Long executeId, Long modelId, long scenarioId, Long yearId, Long periodId, Long currencyId, Long orgId, String serviceParam) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        Map<String, List<DimMappingFilter>> filterMap = DIImportDataUtil.getParamMap(scheme, modelId, scenarioId, yearId, periodId, currencyId, orgId);
        DIServiceFlowService service = new DIServiceFlowService(scheme, filterMap, serviceParam);
        String spendTime = service.callServiceFlow();
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
        Pair<Boolean, Pair<String, String>> levelTable = DIIntegrationUtil.getLevelTable(schemeId, yearNum, periodNum);
        String importTable = (String)((Pair)levelTable.p2).p1;
        String srcTable = scheme.getString("extendstable");
        Pair<String, String> srcFyAndPeriod = this.getSrcFyAndPeriod(filterMap);
        srcTable = DIIntegrationUtil.getExtendsTable(srcTable, (String)srcFyAndPeriod.p1, (String)srcFyAndPeriod.p2);
        List fields = DB.getFieldInfo((DBRoute)BCMConstant.DBROUTE, (String)srcTable);
        StringBuilder srcTemp = new StringBuilder(executeId.toString()).append(",").append("'0',");
        StringBuilder impTemp = new StringBuilder("fexecuteid,fdatafrom,");
        for (FieldInfo field : fields) {
            srcTemp.append(field.getFieldName()).append(",");
            impTemp.append("f").append(field.getFieldName()).append(",");
        }
        String srcColumns = srcTemp.substring(0, srcTemp.length() - 1);
        String importColumns = impTemp.substring(0, impTemp.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(importTable).append("(").append(importColumns).append(") select ").append(srcColumns).append(" from ").append(srcTable).append(" where ");
        StringBuilder filter = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>(10);
        int targetDimCount = 0;
        for (Map.Entry<String, List<DimMappingFilter>> entry : filterMap.entrySet()) {
            List<DimMappingFilter> oneTargetFilters = entry.getValue();
            if ("schemeparam".equals(entry.getKey())) {
                for (DimMappingFilter dimMappingFilter : oneTargetFilters) {
                    for (CellFilterInfo cellFilter : dimMappingFilter.getCellInfo()) {
                        if (StringUtils.isEmpty((CharSequence)cellFilter.getSrcDim())) continue;
                        filter.append("(");
                        filter.append(cellFilter.getSrcDim()).append(cellFilter.getSql());
                        filter.append(")");
                        filter.append(" and ");
                        params.addAll(cellFilter.getSqlParam());
                    }
                }
                if (targetDimCount == filterMap.size() - 1 && " and ".equals(filter.substring(filter.length() - 5, filter.length()))) {
                    filter.delete(filter.length() - 5, filter.length());
                }
                ++targetDimCount;
                continue;
            }
            if (oneTargetFilters.isEmpty()) {
                ++targetDimCount;
                continue;
            }
            int dimMapCount = 0;
            filter.append("(");
            for (DimMappingFilter dimMapFilter3 : oneTargetFilters) {
                int count = 0;
                for (CellFilterInfo cellFilter : dimMapFilter3.getCellInfo()) {
                    filter.append(cellFilter.getSrcDim()).append(cellFilter.getSql());
                    params.addAll(cellFilter.getSqlParam());
                    if (count != dimMapFilter3.getCellInfo().size() - 1) {
                        filter.append(" or ");
                    }
                    ++count;
                }
                if (dimMapCount != oneTargetFilters.size() - 1) {
                    filter.append(" or ");
                }
                ++dimMapCount;
            }
            filter.append(")");
            if (targetDimCount != filterMap.size() - 1) {
                filter.append(" and ");
            }
            ++targetDimCount;
        }
        sql.append((CharSequence)filter);
        this.deleteByExecuteId(importTable, executeId);
        this.deleteByExecuteId((String)((Pair)levelTable.p2).p2, executeId);
        this.deleteMappingDataByExeId(executeId, yearNum, periodNum);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sql.toString().toLowerCase(Locale.ENGLISH), (Object[])params.toArray());
        int importCount = 0;
        String queryData = "select count(*) as num from " + importTable + " where fexecuteid = " + executeId;
        DataSet allCount = DB.queryDataSet((String)"midImportData", (DBRoute)BCMConstant.DBROUTE, (String)queryData);
        if (allCount != null) {
            String count = allCount.next().getString("num");
            importCount = Integer.parseInt(count);
        }
        Long start = System.currentTimeMillis();
        int n = DiDeriveRuleHelper.generateDeriveRuleData(schemeId, executeId, importTable);
        Long end = System.currentTimeMillis() - start;
        String extendsTime = ResManager.loadKDString((String)"\u6570\u636e\u62d3\u5c55\u8017\u65f6:%s;", (String)"XExtendIntegrationService_5", (String)"fi-bcm-business", (Object[])new Object[]{end});
        spendTime = spendTime + extendsTime;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", true);
        result.put("import_count", importCount);
        result.put("derive_count", n);
        result.put("total_count", importCount + n);
        result.put("msg", filter.append(" ").append(params).append(spendTime).toString());
        return result;
    }

    private void deleteByExecuteId(String tableName, Long executeId) {
        Object[] paramObjs = new Object[]{executeId};
        String sb = "delete from " + tableName + " where fexecuteid = ?";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sb, (Object[])paramObjs);
    }

    public void deleteMappingDataByExeId(Long executeId, String yearNum, String periodNum) {
        Object[] paramObjs = new Object[]{executeId, yearNum, periodNum};
        String deleteSql = "delete from t_di_mappingtrace where fexeid = ? and fyearnum = ? and fperiodnum = ?";
        DB.execute((DBRoute)new DBRoute("bcm"), (String)deleteSql, (Object[])paramObjs);
    }

    private Pair<String, String> getSrcFyAndPeriod(Map<String, List<DimMappingFilter>> filterMap) {
        CellFilterInfo cellFilter;
        Iterator<CellFilterInfo> iterator;
        List<DimMappingFilter> yearFilter = filterMap.get("Year");
        List<DimMappingFilter> periodFilter = filterMap.get("Period");
        String srcYear = null;
        String srcPeriod = null;
        if (yearFilter != null) {
            for (DimMappingFilter dimMapFilter : yearFilter) {
                iterator = dimMapFilter.getCellInfo().iterator();
                if (!iterator.hasNext()) continue;
                cellFilter = iterator.next();
                srcYear = cellFilter.getMember();
                break;
            }
        }
        if (periodFilter != null) {
            for (DimMappingFilter dimMapFilter : periodFilter) {
                iterator = dimMapFilter.getCellInfo().iterator();
                if (!iterator.hasNext()) continue;
                cellFilter = iterator.next();
                srcPeriod = cellFilter.getMember();
                break;
            }
        }
        log.info("DIImportDataService getSrcFyAndPeriod: " + srcYear + "#" + srcPeriod);
        return Pair.onePair(srcYear, srcPeriod);
    }
}

