/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.service.IDIDataQueryService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.spread.common.util.StringUtil;

public abstract class AbstractDIDataQueryService
implements IDIDataQueryService {
    protected String getOlapColumnName(Map<String, String> lableMap, String curStep, String columnName) {
        String columnRealName = lableMap.get(columnName);
        if (columnRealName == null) {
            columnRealName = columnName;
        }
        if ("step3".equals(curStep)) {
            String[] split = columnRealName.split("_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < split.length - 1; ++i) {
                sb.append(split[i]).append("_");
            }
            sb.append(ResManager.loadKDString((String)"\u5165\u5e93", (String)"IDIDataQueryService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            if (split.length > 1) {
                columnRealName = sb.toString();
            }
        }
        return columnRealName;
    }

    protected DynamicObject getScheme(Long executeId) {
        QFilter qf = new QFilter("id", "=", (Object)executeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_isschemeexecuterec", (String)"scheme.id", (QFilter[])new QFilter[]{qf});
        if (query.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\u3002", (String)"IDIDataQueryService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Long schemeId = ((DynamicObject)query.get(0)).getLong("scheme.id");
        return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
    }

    protected Pair<List<String>, List<String>> getFieldListByDimMapping(List<String> columnNames, long schemeId) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection dimMapping = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, number", (QFilter[])new QFilter[]{schemeQf}, (String)"sequence");
        ArrayList<String> srcFieldList = new ArrayList<String>(16);
        ArrayList<String> tarFieldList = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : dimMapping) {
            String[] split1;
            String[] split0;
            String number = dynamicObject.getString("number");
            if (StringUtil.isEmptyString((String)number)) continue;
            String[] split = number.split("-");
            for (String str : split0 = split[0].split(",")) {
                str = str.toLowerCase();
                if (columnNames.contains("f" + str) && !tarFieldList.contains("f" + str)) {
                    tarFieldList.add("f" + str);
                    continue;
                }
                if (!columnNames.contains("f" + str + "_t") || tarFieldList.contains("f" + str + "_t")) continue;
                tarFieldList.add("f" + str + "_t");
            }
            if (split.length <= 1) continue;
            for (String str : split1 = split[1].split(",")) {
                str = str.toLowerCase();
                if (columnNames.contains("f" + str) && !srcFieldList.contains("f" + str)) {
                    srcFieldList.add("f" + str);
                    continue;
                }
                if (!columnNames.contains("f" + str + "_s") || srcFieldList.contains("f" + str + "_s")) continue;
                srcFieldList.add("f" + str + "_s");
            }
        }
        return Pair.onePair(srcFieldList, tarFieldList);
    }

    protected List<String> getColumnNames(String tableName) {
        List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)tableName);
        return columnNames.stream().map(String::toLowerCase).collect(Collectors.toList());
    }
}

