/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.provider.IDIDataProvider;
import kd.fi.bcm.business.integrationnew.exception.InValidateParamIntegrateException;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public abstract class AbstractDIIntegrateService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractDIIntegrateService.class);
    protected IDIDataProvider<IDataSet<IRow>> _provider;
    protected IOutput _output;
    protected DIIIntegrateContext _ctx;

    public AbstractDIIntegrateService(Long executeId, DIIIntegrateContext ctx) {
        this._ctx = ctx;
    }

    public AbstractDIIntegrateService(DIIIntegrateContext ctx) {
        this._ctx = ctx;
        this._provider = this.getDataProvider();
        this._output = this.getOutput();
    }

    protected void beforeExecute() {
        this.check();
    }

    public void execute() {
        this.beforeExecute();
        IDataSet<IRow> ds = this._provider.loadData();
        ds.forEach(row -> this.match((IRow)row));
        this._output.output();
        this.afterExecute();
    }

    protected void afterExecute() {
    }

    protected void match(IRow row) {
    }

    public void setDataProvider(IDIDataProvider<IDataSet<IRow>> provider) {
        this._provider = provider;
    }

    public void setOutput(IOutput output) {
        this._output = output;
    }

    protected abstract IDIDataProvider<IDataSet<IRow>> getDataProvider();

    protected abstract IOutput getOutput();

    protected void check() {
        if (this._provider == null) {
            throw new InValidateParamIntegrateException("integrate provider is null");
        }
        if (this._output == null) {
            throw new InValidateParamIntegrateException("integrate output is null");
        }
    }

    public void appendSpendTimeMessage(StopWatch sw, StringBuilder sb, String message) {
        sw.split();
        sb.append(message).append(sw.toSplitString()).append(';');
        sw.reset();
        sw.start();
    }

    public void writeMappingTable(List<Map<String, Object>> rows, Long executeId) {
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)rows.size());
        List<String> fields = Arrays.asList("id", "exeid", "matchdataid", "mappingid", "yearnum", "periodnum");
        ArrayList<Object[]> obParams = new ArrayList<Object[]>(rows.size());
        Recorder index = new Recorder((Object)0);
        rows.forEach(row -> {
            StringBuilder sbMappingId = new StringBuilder();
            if (row.get("mappingid") == null) {
                return;
            }
            ((Iterable)row.remove("mappingid")).forEach(mappingId -> sbMappingId.append(mappingId.toString()).append(";"));
            ArrayList<Object> l = new ArrayList<Object>(fields.size());
            l.add(ids[(Integer)index.getRecord()]);
            l.add(executeId);
            l.add(row.get("idnew"));
            l.add(sbMappingId.substring(0, sbMappingId.length() - 1));
            l.add(this._ctx.getFy().p2);
            l.add(this._ctx.getPeriod().p2);
            obParams.add(l.toArray());
            index.setRecord((Object)((Integer)index.getRecord() + 1));
        });
        ArrayList<String> insertFields = new ArrayList<String>(fields.size());
        fields.forEach(f -> insertFields.add("f" + f));
        this.insertData(obParams, insertFields, "t_di_mappingtrace");
    }

    protected void writeFilterLog2Ctx(Map<String, Object> result) {
        boolean success = (Boolean)result.get("success");
        if (!success) {
            String log = "import failed" + result.get("msg") + "\n";
            throw new KDBizException(log);
        }
        String log = String.format(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a%s\n", (String)"AbstractDIIntegrateService_0", (String)"fi-bcm-business", (Object[])new Object[0]), result.get("msg"));
        this._ctx.putCustomParam("spendTimeMessage", log);
    }

    public void deleteConvertDataByExeId(Long executeId, String convertTable) {
        boolean flag = DB.exitsTable((DBRoute)DBRoute.of((String)"bcm"), (String)convertTable);
        if (flag) {
            String deleteSql = "delete from " + convertTable + " where fexecuteid = " + executeId;
            DB.execute((DBRoute)new DBRoute("bcm"), (String)deleteSql);
            log.info("\u8f6c\u6362\u8868\u96c6\u6210\u6267\u884c\u8bb0\u5f55" + executeId + "\u76f8\u5173\u6570\u636e\u6e05\u9664\u6210\u529f! DBRoute:bcm table:" + convertTable);
        }
    }

    public void deleteMappingDataByExeId(Long executeId) {
        String deleteSql = "delete from t_di_mappingtrace where fexeid = " + executeId;
        DB.execute((DBRoute)new DBRoute("bcm"), (String)deleteSql);
        log.info("\u6620\u5c04\u8868\u96c6\u6210\u6267\u884c\u8bb0\u5f55" + executeId + "\u76f8\u5173\u6570\u636e\u6e05\u9664\u6210\u529f! DBRoute:bcm table: t_di_mappingtrace");
    }

    public void insertData(List<Object[]> obParams, List<String> fieldList, String table) {
        if (obParams.isEmpty()) {
            return;
        }
        String fields = StringUtils.join((Object[])fieldList.toArray(), (String)",");
        StringBuilder fieldsInx = new StringBuilder();
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            String commaCont = i == size - 1 ? "" : ",";
            fieldsInx.append("?").append(commaCont);
        }
        String insertSql = "insert into " + table + "(" + fields + ") values(" + fieldsInx + ")";
        BatchProcessHelper.batchConsume(obParams, (int)50000, dataFromTempList -> DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, (List)dataFromTempList));
    }

    public void setIDnew(List<Map<String, Object>> rows) {
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            rows.get(i).put("idnew", ids[i]);
        }
    }
}

