/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.service.IDIDataHandleService;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.DimMappTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;

public abstract class DIAbstractDataHandleService
implements IDIDataHandleService {
    protected static final Log log = LogFactory.getLog(DIAbstractDataHandleService.class);
    protected static final String FILED_SOURCE = "_s";
    protected static final String FILED_TARGET = "_t";
    protected static final String FILED_SUM = "_sum";
    protected static final String VARCHAR_100 = "varchar(100)";
    protected static final String VARCHAR_200 = "varchar(200)";
    protected static final String VARCHAR_1800 = "varchar(1800)";
    protected static final String NVARCHAR_2000 = "nvarchar(2000)";
    protected static final String BIGINT = "bigint";
    protected static final String DATETIME = "datetime";
    protected static final String DECIMAL = "decimal(34,15)";
    protected static final String INT = "int8";
    protected static final String TIMESTAMP = "timestamp";
    protected static final String CHAR = "char(1)";
    protected DynamicObject scheme;
    protected String modelNum;
    protected Set<String> extendMembers = new HashSet<String>(16);
    protected String impTablePkType;

    @Override
    public void createPlan(long schemeId, long yearId, long periodId) {
        this.scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_isscheme");
        long modelId = this.scheme.getLong("model.id");
        this.modelNum = MemberReader.findModelNumberById((Object)modelId);
        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)yearId).getNumber();
        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)periodId).getNumber();
        try (DLock lock = DLock.create((String)("createPlan." + schemeId));){
            try {
                lock.lock();
                Pair<Boolean, Pair<String, String>> levelTable = DIIntegrationUtil.getLevelTable(schemeId, yearNum, periodNum);
                if (!((Boolean)levelTable.p1).booleanValue()) {
                    this.doCreate((Pair<String, String>)((Pair)levelTable.p2), this.scheme, yearNum, periodNum);
                }
                lock.unlock();
            }
            catch (Exception e) {
                ErrorLogServiceHelper.saveErrorLog(modelId, "createPlan", this.scheme.getString("number") + "|" + yearNum + periodNum + e.getMessage());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8868\u5931\u8d25\uff1a%s", (String)"DIDataHandleService_15", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected abstract void doCreate(Pair<String, String> var1, DynamicObject var2, String var3, String var4);

    protected String buildPkSql(String table, String pk) {
        return "if not exists (select 1 from ksql_indexes where ksql_indname = 'pk_" + table + "') alter  table " + table + " add constraint pk_" + table + " primary key(" + pk + ");";
    }

    protected void appendCreate(StringBuilder sb, String tableName) {
        sb.append(" create table ").append(tableName).append(" (");
    }

    protected void buildSql(StringBuilder sb, String filed, String filedType) {
        if (!(StringUtils.isEmpty((CharSequence)filed) || "f_s".equals(filed) || "f_sum_s".equals(filed))) {
            sb.append(" ").append(filed).append(" ").append(filedType).append(",");
        }
    }

    protected void dropTable(String tableName) {
        DIIntegrationUtil.dropTable(tableName);
    }

    protected void createIndex(String importTable, String compareTable) {
        String importIndexDdl = "if not exists (select 1 from ksql_indexes where ksql_indname = 'idx_" + importTable + "') create index idx_" + importTable + " on " + importTable + " (fexecuteid)";
        String compareIndexDdl = "if not exists (select 1 from ksql_indexes where ksql_indname = 'idx_" + compareTable + "') create index idx_" + compareTable + " on " + compareTable + " (fexecuteid)";
        String compareIndexDdl2 = "if not exists (select 1 from ksql_indexes where ksql_indname = 'idx_" + compareTable + "traceid') create index idx_" + compareTable + "traceid on " + compareTable + " (ftraceid)";
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)importIndexDdl);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)compareIndexDdl);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)compareIndexDdl2);
    }

    protected void createIndexByApply(Long schemeId, String importTable, String compareTable) {
        try {
            QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
            QFilter typeQf = new QFilter("tabletype", "in", (Object)new String[]{"1", "2"});
            DynamicObjectCollection query = QueryServiceHelper.query((String)"di_tableindexapply", (String)"tabletype, indexfields", (QFilter[])new QFilter[]{schemeQf, typeQf});
            for (int i = 0; i < query.size(); ++i) {
                String tableName = importTable;
                String indexfields = ((DynamicObject)query.get(i)).getString("indexfields");
                if ("2".equals(((DynamicObject)query.get(i)).getString("tabletype"))) {
                    tableName = compareTable;
                }
                String indexDdl = "if not exists (select 1 from ksql_indexes where ksql_indname = 'idx_" + tableName + "_" + i + "') create index idx_" + tableName + "_" + i + " on " + tableName + " (" + indexfields + ")";
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)indexDdl);
            }
        }
        catch (Throwable e) {
            log.error("createIndexByApply error:" + schemeId + "," + importTable + "," + compareTable, e);
        }
    }

    protected String transformFileType(String dataType) {
        String[] split;
        if (StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"decimal(19,0)")) {
            dataType = BIGINT;
        } else if (StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"decimal(10,0)")) {
            dataType = BIGINT;
        } else if (StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"varchar")) {
            dataType = VARCHAR_200;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"date")) {
            dataType = DATETIME;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"decimal")) {
            dataType = DECIMAL;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"numeric")) {
            dataType = DECIMAL;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"character varying")) {
            dataType = VARCHAR_200;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"timestamp without time zone")) {
            dataType = TIMESTAMP;
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)dataType, (CharSequence)"int")) {
            dataType = BIGINT;
        } else if (dataType != null && dataType.toLowerCase(Locale.ENGLISH).startsWith("decimal") && (split = dataType.split(",")).length > 1) {
            String replace = split[1].replace(")", "");
            dataType = "0".equals(replace.trim()) ? BIGINT : DECIMAL;
        }
        return dataType;
    }

    protected void addTableLabelObj(List<DynamicObject> objectList, Long schemeId, String tableName, String propName, String propLabel) {
        DynamicObject dc = BusinessDataServiceHelper.newDynamicObject((String)"di_tablelabel");
        dc.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dc.set("tablename", (Object)tableName);
        dc.set("attrname", (Object)propName);
        dc.set("attrlabel", (Object)(propLabel == null ? propName : propLabel));
        dc.set("scheme", (Object)schemeId);
        dc.set("creator", (Object)RequestContext.get().getCurrUserId());
        dc.set("createtime", (Object)new Date());
        dc.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dc.set("modifytime", (Object)new Date());
        objectList.add(dc);
    }

    protected Pair<String, String> getCopyTableDdl(String tableName, String singlemetric, String metricType, String textfield, String textType, Pair<Set<String>, Collection<String>> mappingDim) {
        StringBuilder sbCompare = new StringBuilder();
        this.appendCreate(sbCompare, tableName);
        this.buildSql(sbCompare, "fidnew", BIGINT);
        for (String srcDim : (Set)mappingDim.p1) {
            this.buildSql(sbCompare, "f" + srcDim + FILED_SOURCE, VARCHAR_100);
        }
        for (String targetDim : (Collection)mappingDim.p2) {
            this.buildSql(sbCompare, "f" + targetDim + FILED_TARGET, VARCHAR_100);
        }
        this.buildSql(sbCompare, "f" + singlemetric + FILED_SOURCE, metricType);
        if (StringUtils.isNotEmpty((CharSequence)textfield)) {
            this.buildSql(sbCompare, "f" + textfield + FILED_SOURCE, textType);
        }
        this.buildSql(sbCompare, "f" + singlemetric + FILED_SUM + FILED_SOURCE, metricType);
        if (StringUtils.isNotEmpty((CharSequence)textfield)) {
            this.buildSql(sbCompare, "f" + textfield + FILED_SUM + FILED_SOURCE, textType);
        }
        this.buildSql(sbCompare, "ftraceid", BIGINT);
        this.buildSql(sbCompare, "fexecuteid", BIGINT);
        this.buildSql(sbCompare, "fimpid", this.impTablePkType);
        this.buildSql(sbCompare, "fmsg", NVARCHAR_2000);
        this.buildSql(sbCompare, "fmatchingstatus", CHAR);
        this.buildSql(sbCompare, "folapstatus", CHAR);
        sbCompare.setCharAt(sbCompare.length() - 1, ')');
        sbCompare.append(";");
        String pkSql = this.buildPkSql(tableName, "fidnew");
        return Pair.onePair((Object)sbCompare.toString(), (Object)pkSql);
    }

    protected Pair<Set<String>, Collection<String>> getMappingDim(long id, long modelId) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)id);
        QFilter typeQf = new QFilter("mappedtype", "in", (Object)new String[]{DimMappTypeEnum.COMBO.getCode(), DimMappTypeEnum.SIMPLE.getCode(), DimMappTypeEnum.SPECIAL.getCode()});
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"number,name,mappedtype,isdimmaptargentry.tagdimension,isdimmapsrcentry.srcdimension", (QFilter[])new QFilter[]{schemeQf, typeQf}, (String)"mappedtype asc");
        HashSet<String> srcDim = new HashSet<String>(16);
        for (DynamicObject dynamicObject : load) {
            if (DimMappTypeEnum.SIMPLE.getCode().equals(dynamicObject.getString("mappedtype"))) {
                this.fillDimMap(dynamicObject.getString("number"), srcDim);
                continue;
            }
            if (DimMappTypeEnum.COMBO.getCode().equals(dynamicObject.getString("mappedtype"))) {
                this.fillDimMap(dynamicObject.getDynamicObjectCollection("isdimmapsrcentry"), srcDim);
                continue;
            }
            if (!DimMappTypeEnum.SPECIAL.getCode().equals(dynamicObject.getString("mappedtype")) || !DIIntegrationUtil.getSpecialMappingStatus(id).booleanValue()) continue;
            this.fillDimMap(dynamicObject.getDynamicObjectCollection("isdimmapsrcentry"), srcDim);
        }
        Map dimMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
        return Pair.onePair(srcDim, dimMap.values());
    }

    private void fillDimMap(DynamicObjectCollection isdimmapsrcentry, Set<String> srcDim) {
        DynamicObject[] bases;
        HashSet<Long> srcdimensionIdSet = new HashSet<Long>();
        for (DynamicObject targentry : isdimmapsrcentry) {
            srcdimensionIdSet.add(targentry.getLong("srcdimension_id"));
        }
        for (DynamicObject dim : bases = BusinessDataServiceHelper.load((String)"bcm_isbaseentlist", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", srcdimensionIdSet)})) {
            srcDim.add(dim.getString("number").toLowerCase());
        }
    }

    private void fillDimMap(String number, Set<String> srcDim) {
        String[] srcNumbers;
        String[] numbers = number.split("-");
        for (String srcNumber : srcNumbers = numbers[1].split(",")) {
            srcDim.add(srcNumber.toLowerCase());
        }
    }

    protected void fillDimMap(String number, Set<String> srcDim, Set<String> targetDim, Map<String, String> dimNumMap) {
        String[] numbers = number.split("-");
        String target = numbers[0];
        if (dimNumMap.containsValue(target)) {
            String[] srcNumbers;
            for (String srcNumber : srcNumbers = numbers[1].split(",")) {
                srcDim.add(srcNumber.toLowerCase());
            }
            targetDim.add(target);
        } else {
            this.extendMembers.add(target);
        }
    }
}

