/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.service.DIExtendDim4ModelIntegrateService;
import kd.fi.bcm.business.integration.di.service.DIExtendDim4SchemeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.integration.di.DIDataSrcTypeEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class DIBaseEntAutoCreateService {
    private long schemeId;

    public DIBaseEntAutoCreateService(long schemeId) {
        this.schemeId = schemeId;
    }

    public void excute() {
        QFilter qFilter = new QFilter("scheme", "=", (Object)this.schemeId);
        if (QueryServiceHelper.exists((String)"bcm_isbaseentlist", (QFilter[])qFilter.toArray())) {
            return;
        }
        DynamicObject query = BusinessDataServiceHelper.loadSingle((Object)this.schemeId, (String)"bcm_isscheme");
        if (query != null) {
            String dataSrcType = query.getString("datasrctype");
            String extendstable = query.getString("extendstable");
            if (query.getDynamicObject("extendsmodel") != null && DIDataSrcTypeEnum.CurSysTable.getValue().equals(dataSrcType) && StringUtils.isNotEmpty((CharSequence)extendstable) && new DIExtendDim4SchemeService(query).excute()) {
                return;
            }
            if (query.getDynamicObject("extendsmodel") != null && DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType) && new DIExtendDim4ModelIntegrateService(query).excute()) {
                return;
            }
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            if (query.get("sourceobj") != null && DIDataSrcTypeEnum.InServiceObj.getValue().equals(dataSrcType)) {
                long srcObj = query.getLong("sourceobj.id");
                DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)srcObj, (String)"isc_metadata_schema", (String)"group,prop_entryentity.prop_name,prop_entryentity.prop_label");
                DynamicObjectCollection prop_entryentity = src.getDynamicObjectCollection("prop_entryentity");
                prop_entryentity.forEach(p -> list.add(this.createDy(p.getString("prop_name").toLowerCase(Locale.ENGLISH), p.getString("prop_label").toLowerCase(Locale.ENGLISH))));
            } else if (DIDataSrcTypeEnum.CurSysTable.getValue().equals(dataSrcType)) {
                if (StringUtils.isNotEmpty((CharSequence)extendstable) && DB.getTables((DBRoute)BCMConstant.DBROUTE).stream().anyMatch(e -> e.equalsIgnoreCase(extendstable) || e.equalsIgnoreCase(extendstable + "$0"))) {
                    List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)extendstable.toLowerCase(Locale.ENGLISH));
                    columnNames.forEach(e -> list.add(this.createDy(e.toLowerCase(Locale.ENGLISH), e.toLowerCase(Locale.ENGLISH))));
                }
            } else if (DIDataSrcTypeEnum.ModelAdptor.getValue().equals(dataSrcType)) {
                this.getModelAdptorBaseList(list, query.getDynamicObject("modelconfig"));
            } else if (DIDataSrcTypeEnum.EASReportPush.getValue().equals(dataSrcType)) {
                this.getEASReportPushBaseList(list, this.schemeId);
            }
            if (!list.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
        }
    }

    private void getModelAdptorBaseList(List<DynamicObject> list, DynamicObject dynamicObject) {
        String number = dynamicObject.getString("modelnum");
        Long modelId = MemberReader.findModelIdByShowNum((String)number);
        Map dimMap = MemberReader.getDimNumberMapNameById((long)modelId);
        for (Map.Entry map : dimMap.entrySet()) {
            list.add(this.createDy(((String)map.getKey()).toLowerCase(), (String)map.getValue()));
        }
    }

    private void getEASReportPushBaseList(List<DynamicObject> list, long schemeId) {
        String[][] preData = this.initPreData();
        boolean isTrue = true;
        for (int i = 0; i < preData.length; ++i) {
            String[] row = preData[i];
            DynamicObject basedataList = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
            basedataList.set("number", (Object)row[0]);
            basedataList.set("name", (Object)new LocaleString(row[1]));
            basedataList.set("entitynumber", (Object)row[2]);
            basedataList.set("scheme", (Object)schemeId);
            basedataList.set("issys", (Object)isTrue);
            basedataList.set("creator", (Object)RequestContext.get().getUserId());
            basedataList.set("createtime", (Object)new Date());
            list.add(basedataList);
        }
    }

    private String[][] initPreData() {
        return new String[][]{{"Entity", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"IProduct_1", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_orgunit"}, {"ReportItem", ResManager.loadKDString((String)"\u62a5\u8868\u9879\u76ee", (String)"IProduct_9", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_rptitem"}, {"Reportperiod", ResManager.loadKDString((String)"\u62a5\u8868\u5468\u671f", (String)"IProduct_10", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_reportperiod"}, {"Year", ResManager.loadKDString((String)"\u5e74\u5ea6", (String)"IProduct_3", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_fiscalyear"}, {"Period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"IProduct_4", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_fiscalperiod"}, {"ReportType", ResManager.loadKDString((String)"\u62a5\u8868\u7c7b\u578b", (String)"IProduct_11", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_reporttype"}, {"Currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"IProduct_5", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_currency"}, {"DataElement", ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b", (String)"IProduct_6", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_dataelement"}, {"Customer", ResManager.loadKDString((String)"\u5ba2\u6237", (String)"IProduct_12", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_customer"}, {"Supplier", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"IProduct_13", (String)"fi-bcm-business", (Object[])new Object[0]), "ds_supplier"}};
    }

    private DynamicObject createDy(String number, String name) {
        DynamicObject newDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_isbaseentlist"));
        newDy.set("number", (Object)number);
        newDy.set("name", (Object)name);
        newDy.set("scheme", (Object)this.schemeId);
        newDy.set("issys", (Object)Boolean.TRUE);
        newDy.set("entitynumber", null);
        newDy.set("creator", (Object)RequestContext.get().getUserId());
        newDy.set("createtime", (Object)TimeServiceHelper.now());
        return newDy;
    }
}

