/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integration.di.service.DIAbstractDataHandleService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class DIDataHandleService
extends DIAbstractDataHandleService {
    @Override
    protected void doCreate(Pair<String, String> table, DynamicObject scheme, String yearNum, String periodNum) {
        long schemeId = scheme.getLong("id");
        DynamicObject route = BusinessDataServiceHelper.newDynamicObject((String)"di_tableroute");
        String importTable = (String)table.p1;
        String compTable = (String)table.p2;
        int index = importTable.lastIndexOf("_");
        int order = Integer.parseInt(importTable.substring(index + 1));
        Long srcId = scheme.getLong("sourceobj_id");
        Long tarDsId = scheme.getLong("targetsys_id");
        DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)srcId, (String)"isc_metadata_schema");
        this.createTargetTable(scheme, src, importTable, compTable);
        DynamicObject iscDs = BusinessDataServiceHelper.loadSingle((Object)tarDsId, (String)"isc_data_source");
        Long tarId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncMetaData", (Object[])new Object[]{iscDs.getString("number"), "TABLE", importTable + "@bcm"});
        DynamicObject tar = BusinessDataServiceHelper.loadSingle((Object)tarId, (String)"isc_metadata_schema");
        DynamicObject dataCopy = this.createDataCopy(schemeId + "_" + order, src, tar);
        route.set("order", (Object)order);
        route.set("scheme", (Object)schemeId);
        route.set("year", (Object)yearNum);
        route.set("period", (Object)periodNum);
        route.set("imptable", (Object)importTable);
        route.set("comptable", (Object)compTable);
        route.set("targetobj", (Object)tarId);
        route.set("iscdatacopy", (Object)dataCopy.getLong("id"));
        route.set("createtime", (Object)TimeServiceHelper.now());
        route.set("creator", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{route});
    }

    private DynamicObject createDataCopy(String number, DynamicObject src, DynamicObject tar) {
        DynamicObject dc = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy");
        dc.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dc.set("source_schema", (Object)src);
        dc.set("data_source", src.get("group"));
        dc.set("target_schema", (Object)tar);
        dc.set("data_target", tar.get("group"));
        dc.set("mode", (Object)"BreakOnError");
        dc.set("number", (Object)(number + "@bcm"));
        dc.set("name", (Object)String.format(ResManager.loadResFormat((String)"\u5408\u5e76\u96c6\u6210-%s", (String)"DIDataHandleService_1", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        dc.set("proxy_user", (Object)"#{creator}");
        dc.set("creator", (Object)RequestContext.get().getCurrUserId());
        dc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        dc.set("mapping_script", (Object)"tar.fexecuteid=params.executeid;");
        dc.set("mapping_script_tag", (Object)"tar.fexecuteid=params.executeid;");
        MainEntityType mainEntity = (MainEntityType)dc.getDataEntityType();
        EntityType entryType = (EntityType)mainEntity.getAllEntities().get("mapping_entries");
        DynamicObjectCollection items = dc.getDynamicObjectCollection("mapping_entries");
        DynamicObjectCollection properties = src.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject prop : properties) {
            DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
            item.set("mapping_tar_column", (Object)("f" + prop.getString("prop_name")));
            boolean isPrimaryKey = prop.getBoolean("is_primary_key");
            item.set("candidate_key", (Object)isPrimaryKey);
            item.set("mapping_src_column", (Object)prop.getString("prop_name"));
            items.add((Object)item);
        }
        DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
        item.set("mapping_tar_column", (Object)"fexecuteid");
        item.set("candidate_key", (Object)true);
        item.set("fixed_value", (Object)100);
        items.add((Object)item);
        DynamicObject datafrom = new DynamicObject((DynamicObjectType)entryType);
        datafrom.set("mapping_tar_column", (Object)"fdatafrom");
        datafrom.set("candidate_key", (Object)false);
        datafrom.set("fixed_value", (Object)Character.valueOf('0'));
        items.add((Object)datafrom);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dc});
        return dc;
    }

    private void createTargetTable(DynamicObject scheme, DynamicObject src, String importTable, String compareTable) {
        try (TXHandle tx = TX.required();){
            this.dropTable(importTable);
            this.dropTable(compareTable);
            DeleteServiceHelper.delete((String)"di_tablelabel", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)scheme.getLong("id"))});
            this.createTable(src, importTable, compareTable, scheme);
        }
    }

    private void createTable(DynamicObject src, String importTable, String compareTable, DynamicObject scheme) {
        long schemeId = scheme.getLong("id");
        long modelId = scheme.getLong("model.id");
        String singlemetric = scheme.getString("singlemetric");
        String textfield = scheme.getString("textfield");
        Pair<Set<String>, Collection<String>> mappingDim = this.getMappingDim(schemeId, modelId);
        DynamicObjectCollection properties = src.getDynamicObjectCollection("prop_entryentity");
        if (properties == null || properties.size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u96c6\u6210\u5bf9\u8c61\u3002", (String)"DIDataHandleService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Pair<Pair<String, String>, List<DynamicObject>> ddlPair = this.getImportTableDdl(schemeId, importTable, properties);
        String metricType = this.getMetricType(properties, singlemetric, "decimal(34,15)");
        String textType = this.getMetricType(properties, textfield, "varchar(1800)");
        Pair<String, String> ddlCompare = this.getCopyTableDdl(compareTable, singlemetric, metricType, textfield, textType, mappingDim);
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)((Pair)ddlPair.p1).p1).toLowerCase(Locale.ENGLISH));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)((Pair)ddlPair.p1).p2).toLowerCase(Locale.ENGLISH));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)ddlCompare.p1).toLowerCase(Locale.ENGLISH));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)((String)ddlCompare.p2).toLowerCase(Locale.ENGLISH));
        SaveServiceHelper.save((DynamicObject[])((List)ddlPair.p2).toArray(new DynamicObject[0]));
        this.createIndex(importTable, compareTable);
        this.createIndexByApply(schemeId, importTable, compareTable);
    }

    private String getMetricType(DynamicObjectCollection properties, String singlemetric, String metricType) {
        for (DynamicObject prop : properties) {
            if (!singlemetric.equals(prop.getString("prop_name"))) continue;
            metricType = this.transformFileType(prop.getString("data_type"));
            break;
        }
        return metricType;
    }

    private Pair<Pair<String, String>, List<DynamicObject>> getImportTableDdl(Long schemeId, String tableName, DynamicObjectCollection properties) {
        StringBuilder sb = new StringBuilder();
        this.appendCreate(sb, tableName);
        this.buildSql(sb, "fexecuteid", "bigint");
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(10);
        HashSet<String> primaryKey = new HashSet<String>();
        for (DynamicObject prop : properties) {
            if (prop.getString("prop_name").length() > 22) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u96c6\u6210\u6e90\u5bf9\u8c61\u6216\u8868\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720", (String)"DIExecuteDetailPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.addTableLabelObj(objectList, schemeId, tableName, "f" + prop.getString("prop_name"), prop.getString("prop_label"));
            String fPropName = "f" + prop.getString("prop_name");
            String dataType = prop.getString("data_type");
            boolean isPrimaryKey = prop.getBoolean("is_primary_key");
            if (isPrimaryKey) {
                primaryKey.add(fPropName);
                this.impTablePkType = this.transformFileType(dataType);
            }
            this.buildSql(sb, fPropName, this.transformFileType(dataType));
        }
        primaryKey.add("fexecuteid");
        String pksql = this.buildPkSql(tableName, String.join((CharSequence)",", primaryKey));
        this.buildSql(sb, "fdatafrom", "char(1)");
        sb.setCharAt(sb.length() - 1, ')');
        sb.append(";");
        return Pair.onePair((Object)Pair.onePair((Object)sb.toString(), (Object)pksql), objectList);
    }
}

