/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.integration.di.ctx.DIDeriveRuleContext;
import kd.fi.bcm.business.integration.di.model.DIDeriveRule;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.integration.di.DIRuleEnum;
import kd.fi.bcm.common.enums.integration.di.DiConditionEnum;
import kd.fi.bcm.common.enums.integration.di.DiDeriveRuleFieldTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections4.CollectionUtils;

public class DIDeriveRuleETLService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DIDeriveRuleETLService.class);
    private DIDeriveRuleContext _ctx;
    private List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);

    public DIDeriveRuleETLService(DIDeriveRuleContext ctx) {
        this._ctx = ctx;
    }

    private Pair<String, List<Object>> getSql() {
        ArrayList params = new ArrayList(10);
        StringJoiner sj = new StringJoiner(" ", "", ";");
        List columnNames = DB.getColumnNames((DBRoute)BCMConstant.DBROUTE, (String)this._ctx.getTableName());
        List collect = this._ctx.getDiDeriveRuleList().stream().filter(e -> !columnNames.stream().anyMatch(n -> n.equalsIgnoreCase(e.getFieldName()))).map(DIDeriveRule::getFieldName).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d3e\u751f\u89c4\u5219\u5b57\u6bb5\u8bbe\u7f6e[%s]\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u539f\u56e0\u3002", (String)"DIDeriveRuleETLService_1", (String)"fi-bcm-business", (Object[])new Object[0]), collect));
        }
        sj.add("/*dialect*/ select").add(String.join((CharSequence)",", columnNames)).add("from").add(this._ctx.getTableName()).add("where").add("fexecuteid =").add(this._ctx.getExecuteId().toString()).add(" and fdatafrom='0'");
        this._ctx.getDiDeriveRuleList().forEach(e -> {
            if (e.getConditionEnum() != null) {
                sj.add("and");
                if ((e.getConditionEnum() == DiConditionEnum.NOT_NULL || e.getConditionEnum() == DiConditionEnum.NULL) && e.getFieldTypeEnum() == DiDeriveRuleFieldTypeEnum.STRING) {
                    String sign = e.getConditionEnum() == DiConditionEnum.NOT_NULL ? "!=" : "=";
                    sj.add("(").add(e.getFieldName());
                    sj.add(e.getConditionEnum().getSign());
                    sj.add("and").add(e.getFieldName()).add(sign).add("''");
                    sj.add("and").add(e.getFieldName()).add(sign).add("' '");
                    sj.add(")");
                } else if (DiConditionEnum.NOT_IN == e.getConditionEnum() || DiConditionEnum.IN == e.getConditionEnum()) {
                    sj.add(e.getFieldName());
                    List conditionValue = (List)e.getConditionValue();
                    StringJoiner sb = new StringJoiner(",");
                    conditionValue.forEach(a -> sb.add("?"));
                    sj.add(String.format(e.getConditionEnum().getSign(), sb.toString()));
                    params.addAll(conditionValue);
                } else {
                    sj.add(e.getFieldName());
                    sj.add(e.getConditionEnum().getSign());
                    if (DiConditionEnum.BETWEEN == e.getConditionEnum()) {
                        List conditionValue = (List)e.getConditionValue();
                        params.add(conditionValue.get(0));
                        params.add(conditionValue.get(1));
                    } else if (DiConditionEnum.NOT_LIKE == e.getConditionEnum() || DiConditionEnum.LIKE == e.getConditionEnum()) {
                        params.add("%" + e.getConditionValue() + "%");
                    } else if (DiConditionEnum.RLIKE == e.getConditionEnum()) {
                        params.add("%" + e.getConditionValue());
                    } else if (DiConditionEnum.LLIKE == e.getConditionEnum()) {
                        params.add(e.getConditionValue() + "%");
                    } else {
                        params.add(e.getConditionValue());
                    }
                }
            }
        });
        return Pair.onePair((Object)sj.toString(), params);
    }

    private void extract() {
        if (CollectionUtils.isEmpty(this._ctx.getDiDeriveRuleList())) {
            return;
        }
        Pair<String, List<Object>> sql = this.getSql();
        log.info("DIDeriveRuleETLService--query sql:" + (String)sql.p1);
        log.info("DIDeriveRuleETLService--query param:" + sql.p2);
        try (DataSet dataSet = DB.queryDataSet((String)this._ctx.getTableName(), (DBRoute)BCMConstant.DBROUTE, (String)((String)sql.p1), (Object[])((List)sql.p2).toArray(new Object[0]));){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                for (Field field : dataSet.getRowMeta().getFields()) {
                    Object v = row.get(field.getName());
                    dataMap.put(field.getName(), v);
                }
                this.dataList.add(dataMap);
            }
        }
        catch (Exception e) {
            log.error(String.format("di_dervieRule query fail[%s %s]", this._ctx.getNumber(), this._ctx.getName()), (Throwable)e);
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        log.info("DIDeriveRuleETLService--query count:" + this.dataList.size());
    }

    private void transform() {
        if (!this.dataList.isEmpty()) {
            List<DIDeriveRule> rule = this._ctx.getDiDeriveRuleList().stream().filter(e -> e.getCodeRuleEnum() != null).collect(Collectors.toList());
            log.info("DIDeriveRuleETLService--transform");
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)this.dataList.size());
            for (int i = 0; i < this.dataList.size(); ++i) {
                Map<String, Object> dataMap = this.dataList.get(i);
                rule.forEach(e -> {
                    Object t = dataMap.get(e.getFieldName());
                    if (e.getCodeRuleEnum() == DIRuleEnum.SUFFIX) {
                        dataMap.put(e.getFieldName(), (t == null ? "" : t.toString()) + e.getCodeRuleValue());
                    } else {
                        dataMap.put(e.getFieldName(), e.getCodeRuleValue() + (t == null ? "" : t.toString()));
                    }
                });
                dataMap.put("fdatafrom", "1");
                dataMap.put("ffid", ids[i]);
            }
        }
    }

    private void save() {
        if (!this.dataList.isEmpty()) {
            List<String> keys = this.dataList.get(0).keySet().stream().collect(Collectors.toList());
            StringBuilder insertSql = new StringBuilder("/*dialect*/ insert into ");
            insertSql.append(this._ctx.getTableName()).append(" (").append(String.join((CharSequence)",", keys)).append(") values");
            StringJoiner sj = new StringJoiner(",", "", ";");
            Consumer<String> consumer = e -> {
                String excuteSql = insertSql.toString().concat((String)e);
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)excuteSql);
                log.info("DIDeriveRuleETLService--save:" + excuteSql);
            };
            try (TXHandle txHandle = TX.required();){
                try {
                    for (int i = 0; i < this.dataList.size(); ++i) {
                        if (0 == i % 2000 && i != 0) {
                            consumer.accept(sj.toString());
                            sj = new StringJoiner(",", "", ";");
                        }
                        Map<String, Object> dataMap = this.dataList.get(i);
                        StringJoiner v = new StringJoiner(",", "(", ")");
                        keys.forEach(k -> {
                            Object o = dataMap.get(k);
                            if (o == null) {
                                v.add("null");
                            } else if (o instanceof String) {
                                v.add("'" + o + "'");
                            } else if (o instanceof BigDecimal) {
                                v.add(((BigDecimal)o).stripTrailingZeros().toPlainString());
                            } else if (o instanceof Number) {
                                v.add(o.toString());
                            } else {
                                v.add("'" + o.toString() + "'");
                            }
                        });
                        sj.add(v.toString());
                        dataMap.clear();
                    }
                    consumer.accept(sj.toString());
                }
                catch (Exception e2) {
                    txHandle.markRollback();
                    log.error(String.format("di_dervieRule save fail[%s %s]", this._ctx.getNumber(), this._ctx.getName()), (Throwable)e2);
                    throw new KDBizException(ThrowableHelper.toString((Exception)e2));
                }
            }
        }
    }

    public int excute() {
        log.info(String.format("DIDeriveRuleETLService--start[%s,%s]", this._ctx.getNumber(), this._ctx.getNumber()));
        this.extract();
        this.transform();
        this.save();
        log.info(String.format("DIDeriveRuleETLService--end[%s,%s]", this._ctx.getNumber(), this._ctx.getNumber()));
        return this.dataList.size();
    }
}

