/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.di.service.AbstractDIDataQueryService;
import kd.fi.bcm.business.integration.di.service.DIExtendDim4SchemeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class DIExDataQueryService
extends AbstractDIDataQueryService {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIExDataQueryService.class);

    @Override
    public String buildDataSql(String curStep, String extendsTable, String extendsTableCp, Long executeId, String otherFilter) {
        if ("step1".equals(curStep)) {
            return this.getDataSqlStep1(extendsTable, executeId, otherFilter);
        }
        if ("step2".equals(curStep)) {
            return this.getDataSqlStep2(extendsTable, extendsTableCp, executeId, otherFilter);
        }
        if ("step3".equals(curStep)) {
            return this.getDataSqlStep3(extendsTableCp, executeId, otherFilter);
        }
        return null;
    }

    private String getDataSqlStep3(String tableName, Long executeId, String otherFilter) {
        List<String> columnNames = this.getColumnNamesStep3(executeId, tableName);
        return this.getDataSql(columnNames, tableName, executeId, otherFilter);
    }

    private String getDataSqlStep2(String extendsTable, String extendsTableCp, Long executeId, String otherFilter) {
        DynamicObject scheme = this.getScheme(executeId);
        DIExtendDim4SchemeService dss = new DIExtendDim4SchemeService(scheme);
        Set<String> fieldNumber2Name = dss.getFieldNumber2Name_DT_ID().keySet();
        fieldNumber2Name = fieldNumber2Name.stream().map(String::toLowerCase).collect(Collectors.toSet());
        List<Map<String, String>> fieldList = this.getFieldList(fieldNumber2Name, scheme.getLong("id"));
        List<String> columnNames = this.getCpColumnNames(extendsTableCp);
        List primaryKeys = DB.getPrimaryKeys((DBRoute)BCMConstant.DBROUTE, (String)extendsTable);
        primaryKeys.remove("fexecuteid");
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        for (String string : columnNames) {
            sb.append("a.").append(string).append(",");
        }
        for (Map map : fieldList) {
            sb.append("b.f").append((String)map.get("key")).append(" as __").append((String)map.get("key")).append("__").append((String)map.get("value")).append(",");
        }
        sb.append("a.").append("fmatchingstatus").append(",");
        sb.append("a.").append("fmsg");
        sb.append(" from ").append(extendsTableCp).append(" a left join ").append(extendsTable).append(" b");
        sb.append(" on a.fimpid = b.").append((String)primaryKeys.get(0));
        sb.append(" where a.fexecuteid = ").append(executeId);
        sb.append(" and b.fexecuteid = ").append(executeId);
        if (otherFilter != null) {
            sb.append(" ").append(otherFilter);
        }
        return sb.toString();
    }

    private List<String> getCpColumnNames(String extendsTableCp) {
        List<String> columnNames = this.getColumnNames(extendsTableCp);
        ArrayList<String> newColumnNames = new ArrayList<String>();
        Set<String> hideSet = this.getHideSet();
        for (String str : columnNames) {
            if (str.endsWith("_sum") || hideSet.contains(str)) continue;
            newColumnNames.add(str);
        }
        return newColumnNames;
    }

    private Set<String> getHideSet() {
        HashSet<String> hideSet = new HashSet<String>();
        hideSet.add("ftraceid");
        hideSet.add("fmsg");
        hideSet.add("fmatchingstatus");
        return hideSet;
    }

    private List<Map<String, String>> getFieldList(Set<String> fieldNumber2Name, Long schemeId) {
        QFilter schemeQf = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection dimMapping = QueryServiceHelper.query((String)"bcm_isdimmap", (String)"id, number", (QFilter[])new QFilter[]{schemeQf});
        ArrayList<Map<String, String>> fieldList = new ArrayList<Map<String, String>>(16);
        HashMap<String, String> fieldMap = null;
        block0: for (DynamicObject dynamicObject : dimMapping) {
            for (String preKey : fieldNumber2Name) {
                String number = dynamicObject.getString("number").toLowerCase();
                if (!number.startsWith(preKey)) continue;
                fieldMap = new HashMap<String, String>();
                fieldMap.put("key", number.split("-")[1].toLowerCase());
                fieldMap.put("value", number.split("-")[0].toLowerCase());
                fieldList.add(fieldMap);
                continue block0;
            }
        }
        return fieldList;
    }

    private String getDataSqlStep1(String tableName, Long executeId, String otherFilter) {
        List<String> columnNames = this.getColumnNamesStep1(executeId, tableName);
        return this.getDataSql(columnNames, tableName, executeId, otherFilter);
    }

    private String getDataSql(List<String> columnNames, String tableName, Long executeId, String otherFilter) {
        String attrStr = String.join((CharSequence)",", columnNames);
        String sql = "select " + attrStr + " from " + tableName + " where fexecuteid = " + executeId;
        if (StringUtils.isNotEmpty((CharSequence)otherFilter)) {
            sql = sql + otherFilter;
        }
        return sql;
    }

    @Override
    public DataSet queryData(String sql, Object[] params, String curStep) {
        return DB.queryDataSet((String)"DI", (DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])params);
    }

    @Override
    public List<String> getColumnNames(String curStep, Long executeId, String tableName) {
        if ("step1".equals(curStep)) {
            return this.getColumnNamesStep1(executeId, tableName);
        }
        if ("step2".equals(curStep)) {
            return this.getColumnNamesStep2(executeId, tableName);
        }
        if ("step3".equals(curStep)) {
            return this.getColumnNamesStep3(executeId, tableName);
        }
        return null;
    }

    private List<String> getColumnNamesStep3(Long executeId, String tableName) {
        List<String> columnNames = this.getColumnNames(tableName);
        ArrayList<String> newColumnNames = new ArrayList<String>();
        newColumnNames.add("fidnew");
        for (String str : columnNames) {
            if (str.endsWith("_s") || "fidnew".equals(str)) continue;
            newColumnNames.add(str);
        }
        newColumnNames.remove("fexecuteid");
        newColumnNames.remove("fimpid");
        newColumnNames.remove("ftraceid");
        newColumnNames.remove("fmatchingstatus");
        return newColumnNames;
    }

    private List<String> getColumnNamesStep2(Long executeId, String tableName) {
        DynamicObject scheme = this.getScheme(executeId);
        DIExtendDim4SchemeService dss = new DIExtendDim4SchemeService(scheme);
        Set<String> fieldNumber2Name = dss.getFieldNumber2Name_DT_ID().keySet();
        fieldNumber2Name = fieldNumber2Name.stream().map(String::toLowerCase).collect(Collectors.toSet());
        List<Map<String, String>> fieldList = this.getFieldList(fieldNumber2Name, scheme.getLong("id"));
        ArrayList<String> newColumnNames = new ArrayList<String>();
        newColumnNames.add("fmatchingstatus");
        List<String> columnNames = this.getCpColumnNames(tableName);
        for (Map<String, String> str : fieldList) {
            columnNames.add("__" + str.get("key") + "__" + str.get("value"));
        }
        columnNames.add("fmsg");
        columnNames.remove("fexecuteid");
        columnNames.remove("fimpid");
        columnNames.remove("folapstatus");
        columnNames.remove("fidnew");
        newColumnNames.addAll(columnNames);
        newColumnNames.add("fidnew");
        return newColumnNames;
    }

    private List<String> getColumnNamesStep1(Long executeId, String tableName) {
        List columnNames = this.getColumnNames(tableName);
        DynamicObject scheme = this.getScheme(executeId);
        columnNames = (List)this.getFieldListByDimMapping(columnNames, (long)scheme.getLong((String)"id")).p1;
        columnNames.add("fdatafrom");
        return columnNames;
    }
}

