/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class DIExtendDim4SchemeService {
    private static final List<String> fixedDimension = Arrays.asList("Entity", "Year", "Period", "Scenario", "Process", "Currency", "AuditTrail");
    Map<String, String> dimNumber2Name = new LinkedHashMap<String, String>();
    Map<String, Tuple<String, String, Long>> fieldNumber2Name_DT_ID = new LinkedHashMap<String, Tuple<String, String, Long>>();
    DynamicObject schemeDy;
    long extendModelId;

    public DIExtendDim4SchemeService(DynamicObject schemeDy) {
        this.schemeDy = schemeDy;
        this.extendModelId = schemeDy.getLong("extendsmodel.id");
    }

    public boolean excute() {
        this.initExtendFieldData();
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            String table = this.schemeDy.getString("extendstable");
            if (DB.exitsTable((DBRoute)new DBRoute("bcm"), (String)table) || DB.exitsTable((DBRoute)BCMConstant.DBROUTE, (String)(table + "$map"))) {
                boolean bl = false;
                return bl;
            }
            this.createTable();
            this.createBaseEntryList();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected void initExtendFieldData() {
        BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodeldim", (String)"id,dimension.number,dimension.name", (QFilter[])new QFilter("extmodelid", "=", (Object)this.extendModelId).toArray(), (String)"sequence").values().forEach(f -> this.dimNumber2Name.put(f.getString("dimension.number"), f.getString("dimension.name")));
        BusinessDataServiceHelper.loadFromCache((String)"bcm_extmodelfield", (String)"id,extfield.number,extfield.name,extfield.datatype, extfield.id", (QFilter[])new QFilter("extmodelid", "=", (Object)this.extendModelId).toArray(), (String)"sequence").values().forEach(f -> this.fieldNumber2Name_DT_ID.put(f.getString("extfield.number"), (Tuple<String, String, Long>)Tuple.create((Object)f.getString("extfield.name"), (Object)f.getString("extfield.datatype"), (Object)f.getLong("extfield.id"))));
        ArrayList<Object> enumFields = new ArrayList<Object>(4);
        for (Tuple<String, String, Long> entry : this.fieldNumber2Name_DT_ID.values()) {
            if (!((String)entry.p2).equals(DataTypeEnum.ENUMTP.getOIndex())) continue;
            enumFields.add(entry.p3);
        }
        if (enumFields.isEmpty()) {
            return;
        }
        BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"number, enumitem", (QFilter[])new QFilter("id", "in", enumFields).toArray()).values().forEach(e -> {
            DynamicObject enumitem = e.getDynamicObject("enumitem");
            String field = e.getString("number");
            Tuple<String, String, Long> tuple = this.fieldNumber2Name_DT_ID.get(field);
            if (enumitem != null) {
                this.fieldNumber2Name_DT_ID.put(field, (Tuple<String, String, Long>)Tuple.create((Object)tuple.p1, (Object)enumitem.getString("datatype"), (Object)tuple.p3));
            } else {
                this.fieldNumber2Name_DT_ID.put(field, (Tuple<String, String, Long>)Tuple.create((Object)tuple.p1, (Object)DataTypeEnum.TXT.getOIndex(), (Object)tuple.p3));
            }
        });
    }

    private void createTable() {
        String table = this.schemeDy.getString("extendstable");
        String cont = "VARCHAR(50) ";
        String textCont = "VARCHAR(200) ";
        String fMoneyCont = "decimal(23,10) ";
        String dateCont = "DATETIME";
        StringBuilder sbDDL = new StringBuilder();
        sbDDL.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append(table).append("')   CREATE TABLE ").append(table).append(" (fid BIGINT DEFAULT 0 NOT NULL,");
        for (String string : fixedDimension) {
            sbDDL.append(this.changeNumber(string)).append(" ").append(cont).append(",");
        }
        for (String string : this.dimNumber2Name.keySet()) {
            sbDDL.append(this.changeNumber(string)).append(" ").append(cont).append(",");
        }
        for (Map.Entry entry : this.fieldNumber2Name_DT_ID.entrySet()) {
            String fileId = (String)entry.getKey();
            String dataType = (String)((Tuple)entry.getValue()).p2;
            if (dataType.equals(DataTypeEnum.TXT.getOIndex())) {
                sbDDL.append(this.changeNumber(fileId)).append(" ").append(textCont).append(",");
                continue;
            }
            if (dataType.equals(DataTypeEnum.CURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || dataType.equals(DataTypeEnum.PROPORTION.getOIndex()) || dataType.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                sbDDL.append(this.changeNumber(fileId)).append(" ").append(fMoneyCont).append(",");
                continue;
            }
            if (!dataType.equals(DataTypeEnum.DATETP.getOIndex())) continue;
            sbDDL.append(this.changeNumber(fileId)).append(" ").append(dateCont).append(",");
        }
        DB.execute((DBRoute)new DBRoute("bcm"), (String)(sbDDL.substring(0, sbDDL.length() - 1).toLowerCase() + ");"));
        DB.execute((DBRoute)new DBRoute("bcm"), (String)("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'PK_" + table + "') ALTER  TABLE " + table + " ADD CONSTRAINT PK_" + table + " PRIMARY KEY( fid );").toLowerCase());
        DB.execute((DBRoute)new DBRoute("bcm"), (String)("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_" + table + "') CREATE INDEX IDX_" + table + " ON " + table + " ( fentity,fyear,fperiod,fcurrency );").toLowerCase());
    }

    protected void createBaseEntryList() {
        DynamicObject baseEntry;
        boolean isFalse = false;
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<String> allDim = new ArrayList<String>(fixedDimension.size());
        allDim.addAll(fixedDimension);
        allDim.addAll(this.dimNumber2Name.keySet());
        for (String string : allDim) {
            baseEntry = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
            baseEntry.set("number", (Object)this.changeNumber(string));
            String name = DimEntityNumEnum.getNameByNumber((String)string);
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = this.dimNumber2Name.get(string);
            }
            baseEntry.set("name", (Object)name);
            baseEntry.set("entitynumber", (Object)DimEntityNumEnum.getEntieyNumByNumber((String)string));
            baseEntry.set("scheme", this.schemeDy.get("id"));
            baseEntry.set("issys", (Object)isFalse);
            baseEntry.set("creator", (Object)currUserId);
            baseEntry.set("createtime", (Object)date);
            dyList.add(baseEntry);
        }
        for (Map.Entry entry : this.fieldNumber2Name_DT_ID.entrySet()) {
            baseEntry = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isbaseentlist");
            baseEntry.set("number", (Object)this.changeNumber((String)entry.getKey()));
            baseEntry.set("name", ((Tuple)entry.getValue()).p1);
            baseEntry.set("entitynumber", (Object)"bcm_structofextend");
            baseEntry.set("scheme", this.schemeDy.get("id"));
            baseEntry.set("issys", (Object)isFalse);
            baseEntry.set("creator", (Object)currUserId);
            baseEntry.set("createtime", (Object)date);
            dyList.add(baseEntry);
        }
        SaveServiceHelper.save((DynamicObject[])dyList.toArray(new DynamicObject[0]));
    }

    public String changeNumber(String number) {
        return "f" + number.toLowerCase(Locale.ENGLISH);
    }

    public Map<String, String> getDimNumber2Name() {
        if (this.dimNumber2Name.isEmpty()) {
            this.initExtendFieldData();
        }
        return this.dimNumber2Name;
    }

    public Map<String, Tuple<String, String, Long>> getFieldNumber2Name_DT_ID() {
        if (this.fieldNumber2Name_DT_ID.isEmpty()) {
            this.initExtendFieldData();
        }
        return this.fieldNumber2Name_DT_ID;
    }
}

