/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.integration.di.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataLockServiceHelper;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.model.FieldEntry;
import kd.fi.bcm.business.integration.di.ctx.DICompare;
import kd.fi.bcm.business.integration.di.ctx.DIContextParam;
import kd.fi.bcm.business.integration.di.ctx.DIIIntegrateContext;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRow;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowSrc;
import kd.fi.bcm.business.integration.di.ctx.DIMappedRowTar;
import kd.fi.bcm.business.integration.di.output.DIExtendIntegrateOutPut;
import kd.fi.bcm.business.integration.di.provider.DIExtendDataProvider;
import kd.fi.bcm.business.integration.di.provider.DIImportDataFactory;
import kd.fi.bcm.business.integration.di.provider.IDIDataProvider;
import kd.fi.bcm.business.integration.di.service.AbstractDIIntegrateService;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.model.dataset.IDataSet;
import kd.fi.bcm.business.integrationnew.model.dataset.IRow;
import kd.fi.bcm.business.integrationnew.model.value.ValueItem;
import kd.fi.bcm.business.integrationnew.model.value.ValueList;
import kd.fi.bcm.business.integrationnew.output.IOutput;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdDataSet;
import kd.fi.bcm.business.integrationnew.provider.standard2my.StdMdRow;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.integration.di.DIOperationEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class DIExtendIntegrationService
extends AbstractDIIntegrateService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, DIExtendIntegrationService.class);
    private static final String DATA_SET = "databaseset";
    private static final String ALL = "*";
    private static final String IGNORE = "IGNORE";
    private static final String S_SUFFIX = "_s";
    private static final String T_SUFFIX = "_t";
    private static final String FILED_SUM = "_sum";
    private static final List<String> notNeedMatch = Arrays.asList(DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.YEAR.getNumber(), DimEntityNumEnum.PERIOD.getNumber());
    private DIOperationEnum operation;
    private Long executeId;
    private String impTable;
    private String convertTable;
    private String primaryKey;
    List<String> allDim;
    Map<Object, IRow> dsMap;
    private Set<String> allTarFields;
    private List<String> handleDims;
    private List<String> extendFields;
    private Map<String, String> singleDimMapExtend;
    private Set<String> isNumericalValue;
    private Set<String> isDateValue;
    private ExtendsModel extendsModel;
    private static final int MAX_BATCH_QUERYNUMS = 10000;

    public DIExtendIntegrationService(DIIIntegrateContext ctx) {
        super(ctx);
        Pair<Boolean, Pair<String, String>> levelTable = DIIntegrationUtil.getLevelTable((Long)this._ctx.getSchema().p1, (String)this._ctx.getFy().p2, (String)this._ctx.getPeriod().p2);
        if (((Boolean)levelTable.p1).booleanValue()) {
            this.impTable = (String)((Pair)levelTable.p2).p1;
            this.convertTable = (String)((Pair)levelTable.p2).p2;
            if (this._ctx.getCustomParam("convertTable") == null) {
                this._ctx.putCustomParam("convertTable", this.convertTable);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8f6c\u6362\u8868", (String)"DIIntegrationService_12", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        this.operation = this._ctx.getCustomParam("operation") == null ? DIOperationEnum.OpExecuteAll : (DIOperationEnum)this._ctx.getCustomParam("operation");
        this.executeId = (Long)this._ctx.getCustomParam("executeId");
        this.allDim = DimensionServiceHelper.getAllDim((Long)this._ctx.getModel().p1);
        this.allTarFields = this._ctx.getAllTarDim();
        this.singleDimMapExtend = this._ctx.getSingleDimMapExtend();
        this.handleDims = this.allDim.stream().filter(this.allTarFields::contains).collect(Collectors.toList());
        this.extendFields = this.allTarFields.stream().filter(f -> !this.handleDims.contains(f)).collect(Collectors.toList());
        Long extendModelId = BusinessDataServiceHelper.loadSingle((Object)ctx.getSchema().p1, (String)"bcm_isscheme", (String)"extendsmodel.id").getLong("extendsmodel.id");
        this.extendsModel = new ExtendsModel(extendModelId);
        this._ctx.putCustomParam("extendModel", this.extendsModel);
        Pair<Set<String>, Set<String>> attrType = this.getIsNumericalValue();
        this.isNumericalValue = (Set)attrType.p1;
        this.isDateValue = (Set)attrType.p2;
    }

    @Override
    public void execute() {
        log.startWatch();
        StringBuilder logMsg = new StringBuilder();
        StopWatch sw = new StopWatch();
        sw.start();
        this.checkExtModelLockStatus();
        if (this.operation == DIOperationEnum.OpExport) {
            this.exportOnly();
            log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5bfc\u51fa\u8017\u65f6", (String)"DIIntegrationService_0", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
            this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u5bfc\u51fa\u8017\u65f6:", (String)"DIIntegrationService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            sw.stop();
            return;
        }
        this.beforeExecute();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u9884\u5904\u7406\u8017\u65f6", (String)"DIIntegrationService_2", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u9884\u5904\u7406\u8017\u65f6:", (String)"DIIntegrationService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        IDataSet ds = (IDataSet)this._provider.loadData();
        this.primaryKey = (String)this._ctx.getCustomParam("primaryKey");
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%1$s]\u67e5\u8be2\u6570\u636e\u8017\u65f6,\u6e90\u6570\u636e\u6761\u6570\u4e3a%2$s", (String)"DIIntegrationService_4", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2, ((StdMdDataSet)ds).getSize()));
        logMsg.append(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a:%s", (String)"DIIntegrationService_5", (String)"fi-bcm-business", (Object[])new Object[0]), ((StdMdDataSet)ds).getSize()));
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8017\u65f6:", (String)"DIIntegrationService_6", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.dsMap = ((StdMdDataSet)ds).getRows().stream().collect(Collectors.toMap(r -> r.get(this.primaryKey), r -> r));
        ds = null;
        this.dsMap.forEach((k, row) -> this.match((IRow)row));
        log.info(String.format("DIExtendIntegrationService.countNotMatchNum: %s", this._ctx.getCustomParam("countNotMatchNum") == null ? "0" : this._ctx.getCustomParam("countNotMatchNum").toString()));
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5339\u914d\u8fc7\u7a0b\u8017\u65f6", (String)"DIIntegrationService_7", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u5339\u914d\u8fc7\u7a0b\u8017\u65f6:", (String)"DIIntegrationService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        this.writeTables();
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u5199\u5165\u53cd\u5dee\u8868\u8017\u65f6", (String)"DIIntegrationService_9", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.appendSpendTimeMessage(sw, logMsg, ResManager.loadKDString((String)"\u5199\u5165\u6821\u9a8c\u8868\u8017\u65f6:", (String)"DIIntegrationService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        if (this.operation == DIOperationEnum.OpExecuteAll) {
            this._output.output();
        }
        log.info(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848[%s]\u8f93\u51faolap\u8017\u65f6", (String)"DIIntegrationService_11", (String)"fi-bcm-business", (Object[])new Object[0]), this._ctx.getSchema().p2));
        this.afterExecute();
        sw.stop();
        String outputSpend = this._ctx.getCustomParam("spendTimeMessage") == null ? "" : (String)this._ctx.getCustomParam("spendTimeMessage");
        this._ctx.putCustomParam("spendTimeMessage", logMsg.append(outputSpend).toString());
    }

    private void writeTables() {
        if (this.operation == DIOperationEnum.OpExport) {
            return;
        }
        List rows = (List)this._ctx.getCustomParam(DATA_SET);
        if (ObjectUtils.isEmpty((Object)rows)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                this.setIDnew(rows);
                if (!ConfigServiceHelper.getGlobalBoolParam("di_notWriteMappingTrace")) {
                    this.writeMappingTable(rows, this.executeId);
                }
                this.writeCheckTable(rows);
            }
            catch (Throwable t) {
                tx.markRollback();
                log.error("--doExecute--:\n" + ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)t, (int)30));
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)t, (int)30));
            }
        }
    }

    @Override
    public void match(IRow row) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>(16);
        targetMap.put("matchingstatus", true);
        for (String dim : this.handleDims) {
            if (notNeedMatch.contains(dim)) {
                targetMap.put(dim.toLowerCase() + T_SUFFIX, null);
            }
            if (targetMap.containsKey(dim.toLowerCase() + T_SUFFIX) || this._ctx.getSimpleMappingByKey(dim) == null) continue;
            for (DIMappedRow simpleRow : this._ctx.getSimpleMappingByKey(dim)) {
                if (this.matchRow(row, simpleRow, targetMap)) break;
            }
        }
        for (String dim : this.handleDims) {
            if (targetMap.containsKey(dim.toLowerCase() + T_SUFFIX)) continue;
            if (ObjectUtils.isEmpty(this._ctx.getDefMapping().get(dim))) {
                targetMap.put("matchingstatus", false);
                continue;
            }
            String tarMem = this._ctx.getDefMapping().get(dim).get(0);
            if (dim.equals(DimTypesEnum.PROCESS.getNumber()) && DimTypesEnum.PROCESS.getNumber().equals(tarMem)) {
                String orgNum = (String)targetMap.get(DimTypesEnum.ENTITY.getNumber().toLowerCase() + T_SUFFIX);
                tarMem = MemberReader.findEntityMemberByNum((String)((String)this._ctx.getModel().p2), (String)orgNum).isLeaf() ? "EIRpt" : "CSTE";
            }
            targetMap.put(dim.toLowerCase() + T_SUFFIX, tarMem);
        }
        this.repairTarget(targetMap);
        this.extendFields.forEach(f -> {
            if (this.isNumericalValue.contains(f)) {
                targetMap.put(f.toLowerCase() + FILED_SUM, this.getNumericalValue((String)f, row.get(this.singleDimMapExtend.get(f))));
            } else if (this.isDateValue.contains(f)) {
                targetMap.put(f.toLowerCase() + FILED_SUM, this.getDateValue((String)f, row.get(this.singleDimMapExtend.get(f))));
            } else {
                targetMap.put(f.toLowerCase() + FILED_SUM, row.get(this.singleDimMapExtend.get(f)));
            }
        });
        targetMap.put("impid", row.get(this.primaryKey));
        this.setDataSet4Check(targetMap);
        if (!((Boolean)targetMap.get("matchingstatus")).booleanValue()) {
            this.countNotMatchNum();
        }
    }

    private Date getDateValue(String fieldNumber, Object fieldVaule) {
        if (fieldVaule == null) {
            return null;
        }
        try {
            return (Date)fieldVaule;
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u6e90\u5b57\u6bb5[%s]\u7684\u503c\u4e0d\u662f\u65e5\u671f\u7c7b\u578b\uff0c\u8bf7\u4e0e\u62d3\u5c55\u6210\u5458\u7684\u6570\u636e\u7c7b\u578b\u4e00\u81f4\uff0c\u6216\u8005\u4fee\u6539\u62d3\u5c55\u6210\u5458\u7684\u6570\u636e\u7c7b\u578b\u3002", (String)"XExtendOutPut_1", (String)"fi-bcm-business", (Object[])new Object[0]), fieldNumber));
        }
    }

    private void repairTarget(Map<String, Object> targetMap) {
        targetMap.put(SysDimensionEnum.Scenario.getNumber().toLowerCase() + T_SUFFIX, this._ctx.getScene().p2);
        targetMap.put(SysDimensionEnum.Year.getNumber().toLowerCase() + T_SUFFIX, this._ctx.getFy().p2);
        targetMap.put(SysDimensionEnum.Period.getNumber().toLowerCase() + T_SUFFIX, this._ctx.getPeriod().p2);
    }

    private boolean matchRow(IRow r, DIMappedRow mappedRow, Map<String, Object> targetMap) {
        String starTar = "";
        for (DIMappedRowSrc dIMappedRowSrc : mappedRow.getSrcMappedRow()) {
            String v;
            String srcKey = dIMappedRowSrc.getKey();
            String string = v = r.get(srcKey) == null ? "" : r.get(srcKey).toString();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)v)) {
                v = ALL;
            }
            if (!ALL.equals(dIMappedRowSrc.getValue().get(0)) && !ALL.equals(v)) {
                if (DICompare.isMatch(dIMappedRowSrc, v)) continue;
                return false;
            }
            if (!ALL.equals(dIMappedRowSrc.getValue().get(0)) && ALL.equals(v)) {
                return false;
            }
            starTar = ALL.equals(v) ? "" : v;
        }
        Long mappingId = 0L;
        for (DIMappedRowTar tar : mappedRow.getTarMappedRow()) {
            String dimNum = tar.getKey();
            String tarLowerNum = dimNum.toLowerCase() + T_SUFFIX;
            if (targetMap.get(tarLowerNum) != null) continue;
            mappingId = mappedRow.getId();
            String value = tar.getValue();
            if (ALL.equals(value)) {
                IDNumberTreeNode m = MemberReader.findMemberByIgnorCaseNumber((String)((String)this._ctx.getModel().p2), (String)dimNum, (String)starTar);
                targetMap.put(tarLowerNum, m == null ? "" : m.getNumber());
                if (m != null) continue;
                String msg = (String)targetMap.getOrDefault("msg", "");
                targetMap.put("msg", (msg = msg + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6210\u5458\u3002", (String)"DIIntegrationService_16", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum, starTar)).length() > 2000 ? msg.substring(0, 2000) : msg);
                continue;
            }
            targetMap.put(tarLowerNum, value);
        }
        if (mappingId != 0L) {
            Set set = targetMap.getOrDefault("mappingid", new HashSet());
            set.add(mappingId);
            targetMap.put("mappingid", set);
        }
        return true;
    }

    private void setDataSet4Check(Map<String, Object> targetMap) {
        List<Map<String, Object>> rows = this._ctx.getCustomParam(DATA_SET) == null ? new ArrayList(10) : (List)this._ctx.getCustomParam(DATA_SET);
        rows.add(targetMap);
        this._ctx.putCustomParam(DATA_SET, rows);
    }

    @Override
    protected void beforeExecute() {
        super.beforeExecute();
        if (DIOperationEnum.OpExecuteAll == this.operation) {
            Map<String, Object> result = DIImportDataFactory.getImportDataService(this._ctx.getSrcProduct().getNumber()).importData((Long)this._ctx.getSchema().p1, this.executeId, (Long)this._ctx.getModel().p1, (Long)this._ctx.getScene().p1, (Long)this._ctx.getFy().p1, (Long)this._ctx.getPeriod().p1, (Long)this._ctx.getCurrency().p1, (Long)this._ctx.getOrg().p1, (String)this._ctx.getCustomParam(DIContextParam.SERVICE_PARAM));
            this.writeFilterLog2Ctx(result);
        }
        this.deleteConvertDataByExeId(this.executeId, this.convertTable);
        this.deleteMappingDataByExeId(this.executeId);
    }

    @Override
    protected void afterExecute() {
        this.releaseSpace();
    }

    private void checkExtModelLockStatus() {
        DynamicObjectCollection lockedData;
        HashSet org = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getOrg().p1});
        HashSet scenario = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getScene().p1});
        HashSet fy = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getFy().p1});
        HashSet period = Sets.newHashSet((Object[])new Long[]{(Long)this._ctx.getPeriod().p1});
        HashSet<Long> currency = new HashSet<Long>(16);
        if ((Long)this._ctx.getCurrency().p1 != 0L) {
            IDNumberTreeNode node = MemberReader.findCurrencyMemberById((String)((String)this._ctx.getModel().p2), (Long)((Long)this._ctx.getCurrency().p1));
            switch (node.getNumber()) {
                case "DC": 
                case "EC": {
                    IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)((String)this._ctx.getModel().p2), (Long)((Long)this._ctx.getOrg().p1));
                    String currencyNum = orgNode.getCurrency();
                    IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberByNum((String)((String)this._ctx.getModel().p2), (String)currencyNum);
                    currency.add(currencyNode.getId());
                    break;
                }
                default: {
                    currency.add((Long)this._ctx.getCurrency().p1);
                }
            }
        }
        if ((lockedData = ExtDataLockServiceHelper.isLocked((long)((Long)this._ctx.getModel().p1), this.extendsModel.getId(), org, scenario, fy, period, currency)).isEmpty()) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u5df2\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u6267\u884c\u96c6\u6210", (String)"DIIntegrationService_21", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    private void releaseSpace() {
        this._ctx.putCustomParam(DATA_SET, null);
        this._ctx.putCustomParam("extendModel", null);
        this._ctx.clearAllMapping();
        this._ctx.setValueList(null);
    }

    private void writeCheckTable(List<Map<String, Object>> rows) {
        ArrayList<String> fields = new ArrayList<String>(20);
        this.handleDims.forEach(dim -> fields.add(dim.toLowerCase() + T_SUFFIX));
        this.extendFields.forEach(f -> fields.add(f.toLowerCase() + FILED_SUM));
        fields.add("idnew");
        fields.add("impid");
        fields.add("matchingstatus");
        fields.add("msg");
        fields.add("executeid");
        fields.add("traceid");
        fields.add("olapstatus");
        int idx_olap = fields.size() - 1;
        ArrayList<String> allSrcFields = new ArrayList<String>(this._ctx.getAllSrcDim());
        List allSrcDims4Table = allSrcFields.stream().filter(d -> !this.singleDimMapExtend.containsValue(d)).map(String::toLowerCase).collect(Collectors.toList());
        ArrayList<Object[]> obParams = new ArrayList<Object[]>(rows.size());
        Recorder need = new Recorder((Object)true);
        rows.forEach(r -> {
            r.put("executeid", this.executeId);
            ArrayList<String> l = new ArrayList<String>(fields.size() * 2);
            fields.forEach(f -> {
                if (f.equalsIgnoreCase("traceid") || f.equalsIgnoreCase("olapstatus")) {
                    l.add(null);
                } else if (f.endsWith(FILED_SUM)) {
                    l.add((String)r.get(f));
                } else {
                    Object obj = r.get(f);
                    if ((ObjectUtils.isEmpty(obj) || IGNORE.equalsIgnoreCase(obj.toString())) && f.endsWith(T_SUFFIX) || "matchingstatus".equals(f) && !((Boolean)obj).booleanValue()) {
                        need.setRecord((Object)false);
                    }
                    l.add((String)obj);
                }
            });
            if (((Boolean)need.getRecord()).booleanValue()) {
                l.set(idx_olap, "1");
            } else {
                l.set(idx_olap, "0");
                need.setRecord((Object)true);
            }
            allSrcDims4Table.forEach(f -> l.add((String)this.dsMap.get(r.get("impid")).get((String)f)));
            this.dsMap.remove(r.get("impid"));
            obParams.add(l.toArray());
        });
        fields.addAll(allSrcDims4Table.stream().map(dim -> dim + S_SUFFIX).collect(Collectors.toList()));
        if (obParams.size() > 0 && this.operation == DIOperationEnum.OpExecuteAll) {
            this.handleSums(obParams, fields, idx_olap);
        }
        ArrayList<String> insertFields = new ArrayList<String>(fields.size());
        fields.forEach(f -> insertFields.add("f" + f));
        this.insertData(obParams, insertFields, this.convertTable);
    }

    private void exportOnly() {
        ArrayList<String> fields = new ArrayList<String>(20);
        this.handleDims.forEach(dim -> fields.add(dim.toLowerCase() + T_SUFFIX));
        this.extendFields.forEach(f -> fields.add(f.toLowerCase() + FILED_SUM));
        fields.add("idnew");
        fields.add("traceid");
        fields.add("impid");
        fields.add("olapstatus");
        int idx_olap = fields.size() - 1;
        int idx_impid = fields.size() - 2;
        String sql = this.getSql4OnlyExport(fields, this.executeId);
        StdMdDataSet ds = this.queryCheckTable4Export(this.convertTable, sql);
        ArrayList<Object[]> obParams = new ArrayList<Object[]>(10);
        ArrayList<Object[]> obParamsSum = new ArrayList<Object[]>(10);
        ArrayList<Object> impids = new ArrayList<Object>(10);
        ds.forEach(r -> {
            ArrayList l = new ArrayList(fields.size());
            if (r.get("idnew").equals(r.get("traceid"))) {
                fields.forEach(f -> {
                    if (f.endsWith(FILED_SUM) || f.equals("traceid")) {
                        l.add(null);
                    } else {
                        l.add(r.get((String)f));
                    }
                });
                impids.add(r.get("impid"));
                obParamsSum.add(l.toArray());
            } else {
                fields.forEach(f -> l.add(f.equals("traceid") ? null : (Object)r.get((String)f)));
                obParams.add(l.toArray());
            }
        });
        if (impids.size() > 0) {
            this.repairSumRows(obParams, obParamsSum, impids, fields, idx_impid);
        }
        try (TXHandle tx = TX.required();){
            try {
                this.handleSums(obParams, fields, idx_olap);
                Pair<List<Object[]>, List<String>> updateParamsPair = this.handleUpdateParams(obParams, fields);
                this.updateData((List)updateParamsPair.p1, (List)updateParamsPair.p2, this.convertTable);
            }
            catch (Throwable e) {
                if ("complete".equals(this._ctx.getCustomParam("complete"))) {
                    throw new KDBizException(e.getMessage());
                }
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
        this._output.output();
    }

    private void repairSumRows(List<Object[]> obParams, List<Object[]> obParamsSum, List<Object> impids, List<String> fields, int idx_impid) {
        List primaryKeys = DB.getPrimaryKeys((DBRoute)BCMConstant.DBROUTE, (String)this.impTable);
        primaryKeys.remove("fexecuteid");
        String pk = (String)primaryKeys.get(0);
        String pkField = pk.substring(1);
        List partition = Lists.partition(impids, (int)10000);
        StdMdDataSet rowSet = new StdMdDataSet();
        for (List list : partition) {
            String sql4Impid = this.getSql4Impid(pk, list);
            rowSet.addAll(this.queryCheckTable4Export(this.impTable, sql4Impid).getRows());
        }
        Map<Object, IRow> collect = rowSet.getRows().stream().collect(Collectors.toMap(r -> r.get(pkField), r -> r));
        HashMap<String, Integer> metricIndex = new HashMap<String, Integer>(10);
        for (int i = 0; i < fields.size(); ++i) {
            String f = fields.get(i);
            if (!f.endsWith(FILED_SUM)) continue;
            metricIndex.put(f.replace(FILED_SUM, ""), i);
        }
        obParamsSum.forEach(params -> {
            IRow iRow = (IRow)collect.get(params[idx_impid]);
            this.extendFields.forEach(f -> {
                params[((Integer)metricIndex.get((Object)f.toLowerCase())).intValue()] = iRow.get(this.singleDimMapExtend.get(f));
            });
        });
        obParams.addAll(obParamsSum);
    }

    private String getSql4Impid(String pk, List<Object> ids) {
        StringBuilder sql = new StringBuilder();
        StringBuilder selector = new StringBuilder();
        this.singleDimMapExtend.values().forEach(d -> selector.append("f").append((String)d).append(","));
        selector.append(pk);
        sql.append("SELECT ").append((CharSequence)selector);
        sql.append(" FROM ").append(this.impTable);
        sql.append(" WHERE ").append("fexecuteid").append(" = ").append(this.executeId);
        sql.append(" AND ").append(pk).append(" in (").append(ids.stream().map(String::valueOf).collect(Collectors.joining(","))).append(")").append(";");
        return sql.toString();
    }

    private String getSql4OnlyExport(List<String> fields, Long executeId) {
        StringBuilder sql = new StringBuilder();
        StringBuilder selector = new StringBuilder();
        fields.forEach(d -> selector.append("f").append((String)d).append(","));
        sql.append("SELECT ").append(selector.substring(0, selector.length() - 1));
        sql.append(" FROM ").append(this.convertTable);
        sql.append(" WHERE ").append("fexecuteid").append(" = ").append(executeId).append(" AND ").append("folapstatus = '1' ");
        sql.append(";");
        return sql.toString();
    }

    private StdMdDataSet queryCheckTable4Export(String table, String sql) {
        StdMdDataSet rowSet = new StdMdDataSet();
        try (DataSet dataSet = DB.queryDataSet((String)table, (DBRoute)BCMConstant.DBROUTE, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                StdMdRow mdRow = new StdMdRow();
                for (Field field : dataSet.getRowMeta().getFields()) {
                    Object v = row.get(field.getName());
                    if (v == null || !kd.bos.util.StringUtils.isNotEmpty((String)v.toString())) continue;
                    mdRow.put(field.getName().substring(1), v);
                }
                rowSet.addRow(mdRow);
            }
        }
        return rowSet;
    }

    private Pair<List<Object[]>, List<String>> handleUpdateParams(List<Object[]> obParams, List<String> fields) {
        ArrayList<String> reFields = new ArrayList<String>(10);
        this.extendFields.forEach(f -> reFields.add(f.toLowerCase() + FILED_SUM));
        reFields.add("traceid");
        reFields.add("olapstatus");
        reFields.add("idnew");
        ArrayList reParams = new ArrayList(10);
        obParams.forEach(params -> {
            ArrayList l = new ArrayList(reFields.size());
            reFields.forEach(ref -> {
                for (int i = 0; i < fields.size(); ++i) {
                    if (!ref.equals(fields.get(i))) continue;
                    l.add(params[i]);
                }
            });
            reParams.add(l.toArray());
        });
        reFields.forEach(f -> {
            f = "f" + f;
        });
        return Pair.onePair(reParams, reFields);
    }

    private void updateData(List<Object[]> obParams, List<String> fieldList, String table) {
        if (obParams.isEmpty()) {
            return;
        }
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(table).append(" set ");
        StringBuilder sqlParam = new StringBuilder();
        fieldList.forEach(f -> {
            if (!("f" + f).equalsIgnoreCase("fidnew")) {
                sqlParam.append("f").append((String)f).append("=").append("?").append(",");
            } else {
                sqlParam.delete(sqlParam.length() - 1, sqlParam.length()).append(" where ").append("f").append((String)f).append("=").append("?");
            }
        });
        updateSql.append((CharSequence)sqlParam);
        DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql.toString(), obParams);
    }

    private void countNotMatchNum() {
        this._ctx.putCustomParam("countNotMatchNum", this._ctx.getCustomParam("countNotMatchNum") == null ? 1 : (Integer)this._ctx.getCustomParam("countNotMatchNum") + 1);
    }

    @Override
    protected IDIDataProvider<IDataSet<IRow>> getDataProvider() {
        return new DIExtendDataProvider(this._ctx);
    }

    @Override
    protected IOutput getOutput() {
        return new DIExtendIntegrateOutPut(this._ctx);
    }

    private void handleSums(List<Object[]> obParams, List<String> fields, int idx_olap) {
        HashMap<String, Integer> metricIndex = new HashMap<String, Integer>(10);
        HashMap<String, Integer> tarDimIndex = new HashMap<String, Integer>(10);
        HashMap<String, Integer> otherIndex = new HashMap<String, Integer>(10);
        for (int i = 0; i < fields.size(); ++i) {
            String f = fields.get(i);
            if (f.endsWith(T_SUFFIX)) {
                tarDimIndex.put(f.replace(T_SUFFIX, ""), i);
                continue;
            }
            if (f.equalsIgnoreCase("idnew") || f.equalsIgnoreCase("traceid")) {
                otherIndex.put(f, i);
                continue;
            }
            if (!f.endsWith(FILED_SUM)) continue;
            metricIndex.put(f.replace(FILED_SUM, ""), i);
        }
        LinkedHashMap<String, Integer> allTarIndex = new LinkedHashMap<String, Integer>(10);
        HashMap<String, Integer> trueMetricIndex = new HashMap<String, Integer>(metricIndex.size());
        this.handleDims.forEach(t -> {
            Integer cfr_ignored_0 = (Integer)allTarIndex.put((String)t, (Integer)tarDimIndex.get(t.toLowerCase()));
        });
        this.extendFields.forEach(e -> {
            allTarIndex.put((String)e, (Integer)metricIndex.get(e.toLowerCase()));
            trueMetricIndex.put((String)e, (Integer)metricIndex.get(e.toLowerCase()));
        });
        HashMap<String, Boolean> field2IsNecessary = new HashMap<String, Boolean>(2);
        Boolean isUnique = this.checkUnique(field2IsNecessary);
        this.resetDatasStatusByExtend(obParams, allTarIndex, idx_olap, field2IsNecessary);
        if (isUnique.booleanValue()) {
            this.getUniQueDatas(obParams, allTarIndex, trueMetricIndex, otherIndex, idx_olap);
        } else {
            this.setTraceId(obParams, otherIndex, idx_olap);
        }
        this.buildValueList(obParams, allTarIndex, otherIndex, idx_olap);
    }

    private void buildValueList(List<Object[]> obParams, Map<String, Integer> allTarIndex, Map<String, Integer> otherIndex, int idx_olap) {
        ValueList values = this._ctx.getValueList();
        obParams.forEach(params -> {
            if (params[idx_olap].equals("1") && params[(Integer)otherIndex.get("traceid")] == params[(Integer)otherIndex.get("idnew")]) {
                ValueItem valueItem = new ValueItem();
                allTarIndex.forEach((k, v) -> valueItem.setProperty((String)k, params[v]));
                valueItem.setProperty("idnew", params[(Integer)otherIndex.get("idnew")]);
                values.addValue(valueItem);
                this._ctx.setValueList(values);
            }
        });
    }

    private void setTraceId(List<Object[]> obParams, Map<String, Integer> otherIndex, int idx_olap) {
        obParams.forEach(params -> {
            if (!params[idx_olap].equals("1")) {
                return;
            }
            params[((Integer)otherIndex.get((Object)"traceid")).intValue()] = params[(Integer)otherIndex.get("idnew")];
        });
    }

    private Boolean checkUnique(Map<String, Boolean> field2IsNecessary) {
        Boolean isUnique = Boolean.FALSE;
        for (FieldEntry entry : this.extendsModel.getFieldEntry()) {
            field2IsNecessary.put(entry.getNumber(), entry.getIsNecessary());
            if (!entry.getUniqueCheck()) continue;
            isUnique = Boolean.TRUE;
        }
        return isUnique;
    }

    private Pair<Set<String>, Set<String>> getIsNumericalValue() {
        HashMap<String, String> fieldNumber2DataType = new HashMap<String, String>(4);
        this.extendsModel.getExtFieldEntry().forEach(e -> fieldNumber2DataType.put(e.getExtField().getNumber(), e.getExtField().getDataType()));
        ArrayList enumFields = new ArrayList(4);
        for (Map.Entry entry : fieldNumber2DataType.entrySet()) {
            if (!((String)entry.getValue()).equals(DataTypeEnum.ENUMTP.getOIndex())) continue;
            enumFields.add(entry.getKey());
        }
        if (!enumFields.isEmpty()) {
            QFilter qf_enumFieldDataType = new QFilter("model", "=", this._ctx.getModel().p1);
            qf_enumFieldDataType.and("number", "in", enumFields);
            BusinessDataServiceHelper.loadFromCache((String)"bcm_structofextend", (String)"number, enumitem", (QFilter[])qf_enumFieldDataType.toArray()).values().forEach(e -> {
                DynamicObject enumitem = e.getDynamicObject("enumitem");
                String field = e.getString("number");
                if (enumitem != null) {
                    fieldNumber2DataType.put(field, enumitem.getString("datatype"));
                } else {
                    fieldNumber2DataType.put(field, DataTypeEnum.TXT.getOIndex());
                }
            });
        }
        HashSet isNumericalValue = new HashSet(4);
        HashSet isDateValue = new HashSet(4);
        fieldNumber2DataType.forEach((k, v) -> {
            if (v.equals(DataTypeEnum.CURRENCY.getOIndex()) || v.equals(DataTypeEnum.UNCURRENCY.getOIndex()) || v.equals(DataTypeEnum.PROPORTION.getOIndex()) || v.equals(DataTypeEnum.DEFAULT.getOIndex())) {
                isNumericalValue.add(k);
            } else if (v.equals(DataTypeEnum.DATETP.getOIndex())) {
                isDateValue.add(k);
            }
        });
        return Pair.onePair(isNumericalValue, isDateValue);
    }

    private void resetDatasStatusByExtend(List<Object[]> obParams, Map<String, Integer> allTarIndex, int idx_olap, Map<String, Boolean> field2IsNecessary) {
        obParams.forEach(params -> {
            if (!params[idx_olap].equals("1")) {
                return;
            }
            for (Map.Entry entry : field2IsNecessary.entrySet()) {
                String fieldNumber = (String)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue() && allTarIndex.get(fieldNumber) == null) continue;
                int index = (Integer)allTarIndex.get(fieldNumber);
                Object fieldVaule = params[index];
                if (!((Boolean)entry.getValue()).booleanValue() || fieldVaule != null && !StringUtils.isBlank((CharSequence)fieldVaule.toString())) continue;
                params[idx_olap] = "0";
                break;
            }
        });
    }

    private BigDecimal getNumericalValue(String fieldNumber, Object fieldVaule) {
        if (fieldVaule == null) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(fieldVaule.toString());
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u6e90\u5b57\u6bb5\u201c%s\u201d\u7684\u503c\u4e0d\u662f\u6570\u503c\u7c7b\u578b\uff0c\u8bf7\u4e0e\u62d3\u5c55\u6210\u5458\u7684\u6570\u636e\u7c7b\u578b\u4fdd\u6301\u4e00\u81f4\uff0c\u6216\u4fee\u6539\u62d3\u5c55\u6210\u5458\u7684\u6570\u636e\u7c7b\u578b\u3002", (String)"XExtendOutPut_0", (String)"fi-bcm-business", (Object[])new Object[0]), fieldNumber));
        }
    }

    private void getUniQueDatas(List<Object[]> obParams, Map<String, Integer> allTarIndex, Map<String, Integer> metricIndex, Map<String, Integer> otherIndex, int idx_olap) {
        HashMap uniqueKey2Value = new HashMap(4);
        obParams.forEach(params -> {
            if (!params[idx_olap].equals("1")) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            allTarIndex.forEach((tar, idx) -> {
                if (!this.isNumericalValue.contains(tar)) {
                    sb.append(params[idx]).append(",");
                }
            });
            String uniqueKey = sb.toString();
            if (uniqueKey2Value.containsKey(uniqueKey)) {
                Object[] sumRow = (Object[])uniqueKey2Value.get(uniqueKey);
                metricIndex.forEach((tar, idx) -> {
                    if (this.isNumericalValue.contains(tar)) {
                        sumRow[idx.intValue()] = ((BigDecimal)sumRow[idx]).add((BigDecimal)params[idx]);
                    }
                });
                params[((Integer)otherIndex.get((Object)"traceid")).intValue()] = sumRow[(Integer)otherIndex.get("traceid")];
            } else {
                params[((Integer)otherIndex.get((Object)"traceid")).intValue()] = params[(Integer)otherIndex.get("idnew")];
                uniqueKey2Value.put(uniqueKey, params);
            }
        });
    }
}

